/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ComponentPlaceholder;
import docking.DefaultActionContext;
import docking.DockingWindowManager;
import docking.Tool;
import docking.WindowPosition;
import docking.action.ActionContextProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.ToolBarData;
import generic.theme.Gui;
import generic.theme.ThemeEvent;
import generic.theme.ThemeListener;
import generic.theme.ThemeManager;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.UniversalIdGenerator;
import ghidra.util.exception.AssertException;
import help.HelpDescriptor;
import help.HelpService;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import utilities.util.reflection.ReflectionUtilities;

public abstract class ComponentProvider
implements HelpDescriptor,
ActionContextProvider {
    private static final String TRANSIENT_PROVIDER_TOOLBAR_WARNING_MESSAGE = "Transient providers are not added to the toolbar";
    private static final String TRANSIENT_PROVIDER_KEY_BINDING_WARNING_MESSAGE = "Transient providers cannot have key bindings";
    public static final String DEFAULT_WINDOW_GROUP = "Default";
    private static final String TOOLBAR_GROUP = "View";
    private static Map<String, String> oldOwnerMap = new HashMap<String, String>();
    private static Map<String, String> oldNameMap = new HashMap<String, String>();
    protected Tool dockingTool;
    private String name;
    private final String owner;
    private String title;
    private String subTitle;
    private String tabText;
    private Set<DockingActionIf> actionSet = new LinkedHashSet<DockingActionIf>();
    private boolean addToolbarAction;
    private boolean isTransient;
    private KeyBindingData defaultKeyBindingData;
    private Icon icon;
    private String windowMenuGroup;
    private String group = "Default";
    private WindowPosition defaultWindowPosition = WindowPosition.WINDOW;
    private WindowPosition defaultIntraGroupPosition = WindowPosition.STACK;
    private DockingAction showProviderAction;
    private HelpLocation helpLocation;
    private final Class<?> contextType;
    private long instanceID = UniversalIdGenerator.nextID().getValue();
    private boolean instanceIDHasBeenInitialized;
    private String inceptionInformation;
    private String registeredFontId;
    private ThemeListener themeListener = this::themeChanged;

    public ComponentProvider(Tool tool, String name, String owner) {
        this(tool, name, owner, null);
    }

    public ComponentProvider(Tool tool, String name, String owner, Class<?> contextType) {
        this.dockingTool = tool;
        this.name = name;
        this.owner = owner;
        this.title = name;
        this.contextType = contextType;
        this.recordInception();
        Gui.addThemeListener((ThemeListener)this.themeListener);
    }

    DockingActionIf getShowProviderAction() {
        this.createShowProviderAction();
        return this.showProviderAction;
    }

    private void createShowProviderAction() {
        if (this.showProviderAction != null) {
            return;
        }
        if (this.addToolbarAction) {
            Objects.requireNonNull(this.icon, "The provider's icon cannot be null when requesting the provider's action appear in the toolbar");
        }
        boolean supportsKeyBindings = !this.isTransient;
        this.showProviderAction = new ShowProviderAction(supportsKeyBindings);
    }

    private void themeChanged(ThemeEvent e) {
        if (!e.isLookAndFeelChanged()) {
            return;
        }
        if (this.isVisible()) {
            return;
        }
        JComponent component = this.getComponent();
        if (component != null) {
            SwingUtilities.updateComponentTreeUI(component);
        }
    }

    public abstract JComponent getComponent();

    protected void initializeInstanceID(long newID) {
        if (this.instanceIDHasBeenInitialized && newID != this.instanceID) {
            throw new AssertException("Cannot initialize the instanceID more than once");
        }
        this.instanceIDHasBeenInitialized = true;
        this.instanceID = newID;
    }

    public final long getInstanceID() {
        return this.instanceID;
    }

    public void requestFocus() {
        JComponent component = this.getComponent();
        if (component == null) {
            return;
        }
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = kfm.getFocusOwner();
        if (focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, component)) {
            return;
        }
        component.requestFocus();
    }

    public boolean isFocusedProvider() {
        DockingWindowManager dwm = DockingWindowManager.getInstance(this.getComponent());
        if (dwm == null) {
            return false;
        }
        ComponentPlaceholder placeholder = dwm.getFocusedComponent();
        return placeholder != null && placeholder.getProvider() == this;
    }

    public void addToTool() {
        if (this.isInTool()) {
            throw new IllegalStateException("Component already added: " + this.name);
        }
        this.dockingTool.addComponentProvider(this, false);
        for (DockingActionIf action : this.actionSet) {
            this.dockingTool.addLocalAction(this, action);
        }
        if (this.subTitle != null) {
            this.setSubTitle(this.subTitle);
        }
    }

    public void removeFromTool() {
        this.dockingTool.removeAction(this.showProviderAction);
        this.dockingTool.removeComponentProvider(this);
    }

    public void addLocalAction(DockingActionIf action) {
        if (this.actionSet.contains(action)) {
            return;
        }
        this.actionSet.add(action);
        if (this.isInTool()) {
            this.dockingTool.addLocalAction(this, action);
        }
    }

    protected void removeLocalAction(DockingAction action) {
        this.actionSet.remove(action);
        if (this.isInTool()) {
            this.dockingTool.removeLocalAction(this, action);
        }
    }

    protected void removeAllLocalActions() {
        if (this.isInTool()) {
            this.actionSet.forEach(action -> this.dockingTool.removeLocalAction(this, (DockingActionIf)action));
        }
        this.actionSet.clear();
    }

    public void setVisible(boolean visible) {
        if (visible && !this.isInTool()) {
            this.addToTool();
        }
        this.dockingTool.showComponentProvider(this, visible);
    }

    public void toFront() {
        this.dockingTool.toFront(this);
    }

    public boolean isInTool() {
        if (this.dockingTool == null) {
            return false;
        }
        DockingWindowManager manager = this.dockingTool.getWindowManager();
        if (manager == null) {
            return false;
        }
        return manager.containsProvider(this);
    }

    public Class<?> getContextType() {
        return this.contextType;
    }

    public boolean isVisible() {
        return this.dockingTool.isVisible(this);
    }

    public boolean isActive() {
        return this.dockingTool.isActive(this);
    }

    public void closeComponent() {
        if (this.isTransient) {
            this.removeFromTool();
            Gui.removeThemeListener((ThemeListener)this.themeListener);
        } else {
            this.setVisible(false);
        }
    }

    public void componentActivated() {
    }

    public void componentDeactived() {
    }

    public void componentHidden() {
    }

    public void componentShown() {
    }

    @Override
    public ActionContext getActionContext(MouseEvent event) {
        Component c = this.getComponent();
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusedComponent = kfm.getFocusOwner();
        if (focusedComponent != null && SwingUtilities.isDescendingFrom(focusedComponent, c)) {
            c = focusedComponent;
        }
        return this.createContext(c, null);
    }

    protected ActionContext createContext() {
        return new DefaultActionContext(this);
    }

    protected ActionContext createContext(Object contextObject) {
        return new DefaultActionContext(this).setContextObject(contextObject);
    }

    protected ActionContext createContext(Component sourceComponent, Object contextObject) {
        return new DefaultActionContext(this, sourceComponent).setContextObject(contextObject);
    }

    public void contextChanged() {
        this.dockingTool.contextChanged(this);
    }

    public HelpLocation getHelpLocation() {
        return this.helpLocation;
    }

    public void setHelpLocation(HelpLocation helpLocation) {
        this.helpLocation = helpLocation;
        HelpService helpService = DockingWindowManager.getHelpService();
        helpService.registerHelp((Object)this, helpLocation);
        if (this.showProviderAction != null) {
            this.showProviderAction.setHelpLocation(helpLocation);
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.isInTool()) {
            this.dockingTool.updateTitle(this);
        }
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
        if (this.isInTool()) {
            this.dockingTool.updateTitle(this);
        }
    }

    public void setTabText(String tabText) {
        this.tabText = tabText;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public String getTabText() {
        return this.tabText;
    }

    protected void setKeyBinding(KeyBindingData kbData) {
        if (this.isInTool()) {
            throw new IllegalStateException("Cannot set the default key binding after the provider is added to the tool");
        }
        this.defaultKeyBindingData = kbData;
        if (this.isTransient && kbData != null) {
            Msg.error((Object)this, (Object)TRANSIENT_PROVIDER_KEY_BINDING_WARNING_MESSAGE, (Throwable)ReflectionUtilities.createJavaFilteredThrowable());
            this.defaultKeyBindingData = null;
        }
    }

    protected void setIcon(Icon icon) {
        this.icon = icon;
        if (!this.isInTool()) {
            return;
        }
        if (this.addToolbarAction && this.showProviderAction != null) {
            Objects.requireNonNull(icon, "Icon cannot be set to null when using a toolbar action");
            this.showProviderAction.setToolBarData(new ToolBarData(icon));
        }
        this.dockingTool.getWindowManager().setIcon(this, icon);
    }

    protected void addToToolbar() {
        this.addToolbarAction = true;
        if (this.isTransient) {
            Msg.error((Object)this, (Object)TRANSIENT_PROVIDER_TOOLBAR_WARNING_MESSAGE, (Throwable)ReflectionUtilities.createJavaFilteredThrowable());
            this.addToolbarAction = false;
        }
    }

    public String getWindowSubMenuName() {
        return this.windowMenuGroup;
    }

    public boolean isTransient() {
        return this.isTransient || this.isSnapshot();
    }

    public boolean canBeParent() {
        return true;
    }

    public boolean isSnapshot() {
        return false;
    }

    protected void setTransient() {
        this.isTransient = true;
        if (this.isInTool()) {
            throw new IllegalStateException("A component provider cannot be marked as 'transient' after it is added to the tool");
        }
        if (this.addToolbarAction) {
            this.addToolbarAction = false;
            Msg.error((Object)this, (Object)TRANSIENT_PROVIDER_TOOLBAR_WARNING_MESSAGE, (Throwable)ReflectionUtilities.createJavaFilteredThrowable());
        }
        if (this.defaultKeyBindingData != null) {
            this.defaultKeyBindingData = null;
            Msg.error((Object)this, (Object)TRANSIENT_PROVIDER_KEY_BINDING_WARNING_MESSAGE, (Throwable)ReflectionUtilities.createJavaFilteredThrowable());
        }
    }

    protected void setWindowMenuGroup(String group) {
        this.windowMenuGroup = group;
    }

    public WindowPosition getDefaultWindowPosition() {
        return this.defaultWindowPosition;
    }

    protected void setDefaultWindowPosition(WindowPosition windowPosition) {
        this.defaultWindowPosition = windowPosition;
    }

    public WindowPosition getIntraGroupPosition() {
        return this.defaultIntraGroupPosition;
    }

    public void setIntraGroupPosition(WindowPosition position) {
        this.defaultIntraGroupPosition = position;
    }

    public String getWindowGroup() {
        return this.group;
    }

    protected void setWindowGroup(String group) {
        this.group = group;
    }

    public String getHelpInfo() {
        return "   PROVIDER: " + this.getName() + "\n";
    }

    public Object getHelpObject() {
        return this;
    }

    public Tool getTool() {
        return this.dockingTool;
    }

    public void adjustFontSize(boolean bigger) {
        if (this.registeredFontId == null) {
            return;
        }
        Font font = Gui.getFont((String)this.registeredFontId);
        if (font == null) {
            return;
        }
        int size = font.getSize();
        size = bigger ? ++size : Math.max(size - 1, 3);
        ThemeManager.getInstance().setFont(this.registeredFontId, font.deriveFont((float)size));
    }

    public void resetFontSize() {
        if (this.registeredFontId == null) {
            return;
        }
        ThemeManager.getInstance().restoreFont(this.registeredFontId);
    }

    protected void registerAdjustableFontId(String fontId) {
        this.registeredFontId = fontId;
    }

    public String toString() {
        return this.name + " - " + this.getTitle() + " - " + this.getSubTitle();
    }

    private void recordInception() {
        if (!SystemUtilities.isInDevelopmentMode()) {
            this.inceptionInformation = "";
            return;
        }
        this.inceptionInformation = this.getInceptionFromTheFirstClassThatIsNotUs();
    }

    private String getInceptionFromTheFirstClassThatIsNotUs() {
        Throwable t = ReflectionUtilities.createThrowableWithStackOlderThan((Class[])new Class[]{this.getClass()});
        StackTraceElement[] trace = t.getStackTrace();
        String classInfo = trace[0].toString();
        return classInfo;
    }

    public static String getMappedOwner(String oldOwner, String oldName) {
        String key = ComponentProvider.getKey(oldOwner, oldName);
        return oldOwnerMap.get(key);
    }

    public static String getMappedName(String oldOwner, String oldName) {
        String key = ComponentProvider.getKey(oldOwner, oldName);
        return oldNameMap.get(key);
    }

    public static void registerProviderNameOwnerChange(String oldName, String oldOwner, String newName, String newOwner) {
        String key = ComponentProvider.getKey(oldOwner, oldName);
        oldOwnerMap.put(key, newOwner);
        oldNameMap.put(key, newName);
    }

    private static String getKey(String oldOwner, String oldName) {
        return "owner=" + oldOwner + "name=" + oldName;
    }

    private class ShowProviderAction
    extends DockingAction {
        ShowProviderAction(boolean supportsKeyBindings) {
            super(ComponentProvider.this.name, ComponentProvider.this.owner, supportsKeyBindings ? KeyBindingType.SHARED : KeyBindingType.UNSUPPORTED);
            if (ComponentProvider.this.addToolbarAction) {
                this.setToolBarData(new ToolBarData(ComponentProvider.this.icon, ComponentProvider.TOOLBAR_GROUP));
            }
            if (supportsKeyBindings && ComponentProvider.this.defaultKeyBindingData != null) {
                this.setKeyBindingData(ComponentProvider.this.defaultKeyBindingData);
            }
            this.setDescription("Display " + ComponentProvider.this.name);
            HelpLocation providerHelp = ComponentProvider.this.getHelpLocation();
            if (providerHelp != null) {
                this.setHelpLocation(providerHelp);
            }
        }

        @Override
        public void actionPerformed(ActionContext context) {
            DockingWindowManager myDwm = DockingWindowManager.getInstance(ComponentProvider.this.getComponent());
            if (myDwm == null) {
                ComponentProvider.this.dockingTool.showComponentProvider(ComponentProvider.this, true);
                return;
            }
            myDwm.showComponent(ComponentProvider.this, true, true);
        }

        @Override
        protected String getInceptionFromTheFirstClassThatIsNotUsOrABuilder() {
            return ComponentProvider.this.inceptionInformation;
        }
    }
}

