/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.utils.hname.win;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Win32Exception;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.network.utils.IpAddressUtils;
import org.netbeans.core.network.utils.NativeException;
import org.netbeans.core.network.utils.hname.win.Winsock2Lib;

public class HostnameUtilsWin {
    private static final Logger LOGGER = Logger.getLogger(HostnameUtilsWin.class.getName());

    public static String getComputerName() throws NativeException {
        try {
            return Kernel32Util.getComputerName();
        }
        catch (Win32Exception ex) {
            LOGGER.log(Level.FINE, "Kernel32.GetComputerName error : {0}", ex.getHR().intValue());
            String env = System.getenv("COMPUTERNAME");
            if (env != null) {
                return env;
            }
            throw new NativeException(ex.getHR().intValue(), "error calling 'GetComputerName()' function");
        }
    }

    public static String getHostName(boolean noQualify) throws NativeException {
        byte[] buf = new byte[256];
        int returnCode = Winsock2Lib.INSTANCE.gethostname(buf, buf.length);
        if (returnCode == 0) {
            String result = Native.toString((byte[])buf);
            if (noQualify) {
                return IpAddressUtils.removeDomain(result);
            }
            return result;
        }
        throw new NativeException(returnCode, "error calling 'gethostname()' function");
    }
}

