/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import org.gephi.utils.HTMLEscape;
import org.gephi.utils.TempDirUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ChartsUtils {
    public static String getStatisticsReportHTML(String dataName, BigDecimal[] statistics, JFreeChart boxPlot, JFreeChart scatterPlot, JFreeChart histogram, Dimension boxPlotDimension, Dimension scatterPlotDimension, Dimension histogramDimension) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(NbBundle.getMessage(ChartsUtils.class, (String)"ChartsUtils.report.header", (Object)HTMLEscape.stringToHTMLString((String)dataName)));
        sb.append("<hr>");
        if (statistics != null) {
            sb.append("<ul>");
            ChartsUtils.writeStatistic(sb, "ChartsUtils.report.average", statistics[0]);
            ChartsUtils.writeStatistic(sb, "ChartsUtils.report.Q1", statistics[1]);
            ChartsUtils.writeStatistic(sb, "ChartsUtils.report.median", statistics[2]);
            ChartsUtils.writeStatistic(sb, "ChartsUtils.report.Q3", statistics[3]);
            ChartsUtils.writeStatistic(sb, "ChartsUtils.report.IQR", statistics[4]);
            ChartsUtils.writeStatistic(sb, "ChartsUtils.report.sum", statistics[5]);
            ChartsUtils.writeStatistic(sb, "ChartsUtils.report.min", statistics[6]);
            ChartsUtils.writeStatistic(sb, "ChartsUtils.report.max", statistics[7]);
            sb.append("</ul>");
            try {
                if (boxPlot != null) {
                    sb.append("<hr>");
                    ChartsUtils.writeBoxPlot(sb, boxPlot, boxPlotDimension);
                }
                if (scatterPlot != null) {
                    sb.append("<hr>");
                    ChartsUtils.writeScatterPlot(sb, scatterPlot, scatterPlotDimension);
                }
                if (histogram != null) {
                    sb.append("<hr>");
                    ChartsUtils.writeHistogram(sb, histogram, histogramDimension);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            sb.append(ChartsUtils.getMessage("ChartsUtils.report.empty"));
        }
        sb.append("</html>");
        return sb.toString();
    }

    public static JFreeChart buildBoxPlot(Number[] numbers, String dataName) {
        if (numbers == null || numbers.length == 0) {
            return null;
        }
        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();
        ArrayList<Number> list = new ArrayList<Number>();
        list.addAll(Arrays.asList(numbers));
        String valuesString = ChartsUtils.getMessage("ChartsUtils.report.box-plot.values");
        dataset.add(list, (Comparable)((Object)valuesString), (Comparable)((Object)""));
        BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
        renderer.setMeanVisible(false);
        renderer.setFillBox(false);
        renderer.setMaximumBarWidth(0.5);
        CategoryAxis xAxis = new CategoryAxis(dataName);
        NumberAxis yAxis = new NumberAxis(ChartsUtils.getMessage("ChartsUtils.report.box-plot.values-range"));
        yAxis.setAutoRangeIncludesZero(false);
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new BoxAndWhiskerToolTipGenerator());
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)renderer);
        plot.setRenderer((CategoryItemRenderer)renderer);
        JFreeChart boxPlot = new JFreeChart(ChartsUtils.getMessage("ChartsUtils.report.box-plot.title"), (Plot)plot);
        return boxPlot;
    }

    public static JFreeChart buildScatterPlot(Number[] numbers, String dataName, boolean useLines, boolean useLinearRegression) {
        if (numbers == null || numbers.length == 0) {
            return null;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries series = new XYSeries((Comparable)((Object)dataName));
        for (int i = 0; i < numbers.length; ++i) {
            series.add((double)i, numbers[i]);
        }
        dataset.addSeries(series);
        JFreeChart scatterPlot = ChartsUtils.buildScatterPlot(dataset, ChartsUtils.getMessage("ChartsUtils.report.scatter-plot.title"), ChartsUtils.getMessage("ChartsUtils.report.scatter-plot.xLabel"), dataName, useLines, useLinearRegression);
        return scatterPlot;
    }

    public static JFreeChart buildScatterPlot(XYSeriesCollection data, String title, String xLabel, String yLabel, boolean useLines, boolean useLinearRegression) {
        JFreeChart scatterPlot = ChartFactory.createXYLineChart((String)title, (String)xLabel, (String)yLabel, (XYDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)scatterPlot.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.GRAY);
        plot.setRangeGridlinePaint((Paint)Color.GRAY);
        ChartsUtils.setScatterPlotLinesEnabled(scatterPlot, useLines);
        ChartsUtils.setScatterPlotLinearRegressionEnabled(scatterPlot, useLinearRegression);
        return scatterPlot;
    }

    public static JFreeChart buildHistogram(Number[] numbers, String dataName, int divisions) {
        if (numbers == null || numbers.length == 0) {
            return null;
        }
        HistogramDataset dataset = new HistogramDataset();
        dataset.setType(HistogramType.FREQUENCY);
        double[] doubleNumbers = new double[numbers.length];
        for (int i = 0; i < doubleNumbers.length; ++i) {
            doubleNumbers[i] = numbers[i].doubleValue();
        }
        dataset.addSeries((Comparable)((Object)dataName), doubleNumbers, divisions > 0 ? divisions : 10);
        JFreeChart histogram = ChartFactory.createHistogram((String)ChartsUtils.getMessage("ChartsUtils.report.histogram.title"), (String)dataName, (String)ChartsUtils.getMessage("ChartsUtils.report.histogram.yLabel"), (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        return histogram;
    }

    public static void setScatterPlotLinesEnabled(JFreeChart scatterPlot, boolean enabled) {
        XYPlot plot = (XYPlot)scatterPlot.getPlot();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        if (enabled) {
            renderer.setSeriesLinesVisible(0, true);
            renderer.setSeriesShapesVisible(0, false);
        } else {
            renderer.setSeriesLinesVisible(0, false);
            renderer.setSeriesShapesVisible(0, true);
            renderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0));
        }
        renderer.setSeriesPaint(0, (Paint)Color.RED);
        plot.setRenderer(0, (XYItemRenderer)renderer);
    }

    public static void setScatterPlotLinearRegressionEnabled(JFreeChart scatterPlot, boolean enabled) {
        XYPlot plot = (XYPlot)scatterPlot.getPlot();
        if (enabled) {
            StandardXYItemRenderer regressionRenderer = new StandardXYItemRenderer();
            regressionRenderer.setBaseSeriesVisibleInLegend(false);
            plot.setDataset(1, ChartsUtils.regress((XYSeriesCollection)plot.getDataset(0)));
            plot.setRenderer(1, (XYItemRenderer)regressionRenderer);
        } else {
            plot.setDataset(1, null);
        }
    }

    private static XYDataset regress(XYSeriesCollection data) {
        double xMin = Double.MAX_VALUE;
        double xMax = 0.0;
        for (int i = 0; i < data.getSeriesCount(); ++i) {
            XYSeries ser = data.getSeries(i);
            for (int j = 0; j < ser.getItemCount(); ++j) {
                double x = ser.getX(j).doubleValue();
                if (x < xMin) {
                    xMin = x;
                }
                if (!(x > xMax)) continue;
                xMax = x;
            }
        }
        XYSeriesCollection coll = new XYSeriesCollection();
        for (int i = 0; i < data.getSeriesCount(); ++i) {
            XYSeries ser = data.getSeries(i);
            int n = ser.getItemCount();
            double sx = 0.0;
            double sy = 0.0;
            double sxx = 0.0;
            double sxy = 0.0;
            double syy = 0.0;
            for (int j = 0; j < n; ++j) {
                double x = ser.getX(j).doubleValue();
                double y = ser.getY(j).doubleValue();
                sx += x;
                sy += y;
                sxx += x * x;
                sxy += x * y;
                syy += y * y;
            }
            double b = ((double)n * sxy - sx * sy) / ((double)n * sxx - sx * sx);
            double a = sy / (double)n - b * sx / (double)n;
            XYSeries regr = new XYSeries(ser.getKey());
            regr.add(xMin, a + b * xMin);
            regr.add(xMax, a + b * xMax);
            coll.addSeries(regr);
        }
        return coll;
    }

    private static void writeStatistic(StringBuilder sb, String resName, BigDecimal number) {
        sb.append("<li>");
        sb.append(ChartsUtils.getMessage(resName));
        sb.append(": ");
        sb.append(number);
        sb.append("</li>");
    }

    private static void writeBoxPlot(StringBuilder sb, JFreeChart boxPlot, Dimension dimension) throws IOException {
        if (dimension == null) {
            dimension = new Dimension(300, 500);
        }
        ChartsUtils.writeChart(sb, boxPlot, dimension, "box-plot.png");
    }

    private static void writeScatterPlot(StringBuilder sb, JFreeChart scatterPlot, Dimension dimension) throws IOException {
        if (dimension == null) {
            dimension = new Dimension(600, 400);
        }
        ChartsUtils.writeChart(sb, scatterPlot, dimension, "scatter-plot.png");
    }

    private static void writeHistogram(StringBuilder sb, JFreeChart histogram, Dimension dimension) throws IOException {
        if (dimension == null) {
            dimension = new Dimension(600, 400);
        }
        ChartsUtils.writeChart(sb, histogram, dimension, "histogram.png");
    }

    private static void writeChart(StringBuilder sb, JFreeChart chart, Dimension dimension, String fileName) throws IOException {
        TempDirUtils.TempDir tempDir = TempDirUtils.createTempDir();
        Object imageFile = "";
        File file = tempDir.createFile(fileName);
        imageFile = "<center><img src=\"file:" + file.getAbsolutePath() + "\"</img></center>";
        ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)chart, (int)dimension.width, (int)dimension.height);
        sb.append((String)imageFile);
    }

    private static String getMessage(String resName) {
        return NbBundle.getMessage(ChartsUtils.class, (String)resName);
    }
}

