/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.freeplane.core.ui.components.OptionalDontShowMeAgainDialog;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.layout.LayoutController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNode;

public class SummaryLevels {
    private static final Filter TRANSPARENT_FILTER = new Filter(null, false, false, false, false, null);
    public static final int NODE_NOT_FOUND = -1;
    public final int[] summaryLevels;
    public final int highestSummaryLevel;
    public final boolean[] sides;
    private final NodeModel parentNode;
    private final NodeModel root;

    public SummaryLevels(NodeModel root, NodeModel parentNode) {
        this(root, parentNode, TRANSPARENT_FILTER, false);
    }

    public static SummaryLevels of(NodeModel root, NodeModel parentNode, Filter filter) {
        return new SummaryLevels(root, parentNode, filter, false);
    }

    public static SummaryLevels ignoringChildNodes(NodeModel root, NodeModel parentNode, Filter filter) {
        return new SummaryLevels(root, parentNode, filter, true);
    }

    private SummaryLevels(NodeModel root, NodeModel parentNode, Filter filter, boolean ignoreChildNodes) {
        this.root = root;
        this.parentNode = parentNode;
        int highestSummaryLevel = 0;
        int childCount = ignoreChildNodes ? 0 : parentNode.getChildCount();
        this.summaryLevels = new int[childCount];
        for (boolean isTopOrLeft : this.sides = SummaryLevels.sidesOf(root, parentNode)) {
            int level = 1;
            boolean useSummaryAsItem = true;
            for (int i = 0; i < childCount; ++i) {
                boolean isItem;
                NodeModel child = parentNode.getChildAt(i);
                if (child.isTopOrLeft(root) != isTopOrLeft) continue;
                boolean bl = isItem = !SummaryNode.isSummaryNode(child) || useSummaryAsItem;
                if (isItem) {
                    if (level > 0) {
                        useSummaryAsItem = true;
                    }
                    level = 0;
                    if (child.hasVisibleContent(filter)) {
                        useSummaryAsItem = false;
                    }
                } else {
                    highestSummaryLevel = Math.max(highestSummaryLevel, ++level);
                }
                this.summaryLevels[i] = level;
            }
        }
        this.highestSummaryLevel = highestSummaryLevel;
    }

    public static boolean[] sidesOf(NodeModel root, NodeModel parentNode) {
        return LayoutController.getController().sidesOf(parentNode, root);
    }

    public Collection<NodeModel> summarizedNodes(NodeModel summaryNode) {
        if (summaryNode.getParentNode() != this.parentNode) {
            return Collections.emptyList();
        }
        int summaryNodeIndex = this.parentNode.getIndex(summaryNode);
        int summaryLevel = this.summaryLevels[summaryNodeIndex];
        if (summaryLevel == 0) {
            return Collections.emptyList();
        }
        ArrayList<NodeModel> arrayList = new ArrayList<NodeModel>();
        for (int i = summaryNodeIndex - 1; i >= 0; --i) {
            int level = this.summaryLevels[i];
            if (level >= summaryLevel) {
                if (this.sides.length != 1 && this.parentNode.getChildAt(i).isTopOrLeft(this.root) != summaryNode.isTopOrLeft(this.root)) continue;
                return arrayList;
            }
            if (level != summaryLevel - 1) continue;
            NodeModel child = this.parentNode.getChildAt(i);
            if (this.sides.length != 1 && child.isTopOrLeft(this.root) != summaryNode.isTopOrLeft(this.root)) continue;
            if (SummaryNode.isFirstGroupNode(child)) {
                if (level > 0) {
                    arrayList.add(child);
                }
                return arrayList;
            }
            arrayList.add(child);
        }
        return arrayList;
    }

    public NodeModel findSummaryNode(int index) {
        int summaryNodeIndex = this.findSummaryNodeIndex(index);
        return this.parentNode.getChildAt(summaryNodeIndex);
    }

    public int findSummaryNodeIndex(int index) {
        int nodeLevel = this.summaryLevels[index];
        boolean leftSide = this.parentNode.getChildAt(index).isTopOrLeft(this.root);
        for (int i = index + 1; i < this.parentNode.getChildCount(); ++i) {
            NodeModel summaryNode;
            int level = this.summaryLevels[i];
            if (level == nodeLevel && SummaryNode.isFirstGroupNode(this.parentNode.getChildAt(i))) {
                return -1;
            }
            if (level <= nodeLevel || (summaryNode = this.parentNode.getChildAt(i)).isTopOrLeft(this.root) != leftSide) continue;
            return i;
        }
        return -1;
    }

    public NodeModel findGroupBeginNode(int index) {
        int groupBeginNodeIndex = this.findGroupBeginNodeIndex(index);
        return this.parentNode.getChildAt(groupBeginNodeIndex);
    }

    public int findGroupBeginNodeIndex(int index) {
        int i;
        if (index < 0) {
            return -1;
        }
        int nodeLevel = this.summaryLevels[index];
        boolean leftSide = this.parentNode.getChildAt(index).isTopOrLeft(this.root);
        for (i = index; i >= 0; --i) {
            int level = this.summaryLevels[i];
            NodeModel groupBeginNode = this.parentNode.getChildAt(i);
            if (groupBeginNode.isTopOrLeft(this.root) != leftSide) continue;
            if (level > nodeLevel) {
                return this.parentNode.nextNodeIndex(this.root, i, leftSide);
            }
            if (level != nodeLevel || !SummaryNode.isFirstGroupNode(groupBeginNode)) continue;
            return i;
        }
        for (i = 0; i <= index; ++i) {
            NodeModel groupBeginNode = this.parentNode.getChildAt(i);
            if (groupBeginNode.isTopOrLeft(this.root) != leftSide || this.summaryLevels[i] != nodeLevel) continue;
            return i;
        }
        return index;
    }

    public boolean canInsertSummaryNode(int start, int end, boolean isTopOrLeft) {
        int summaryLevel = this.summaryLevels[start];
        if (summaryLevel != this.summaryLevels[end]) {
            UITools.errorMessage(TextUtils.getText("summary_not_possible"));
            return false;
        }
        boolean nodesOnOtherSideFound = false;
        for (int i = start + 1; i <= end; ++i) {
            boolean nodeIsOnTheSameSide;
            NodeModel node = this.parentNode.getChildAt(i);
            boolean bl = nodeIsOnTheSameSide = isTopOrLeft == node.isTopOrLeft(this.root);
            if (nodeIsOnTheSameSide && (this.summaryLevels[i] > summaryLevel || this.summaryLevels[i] == summaryLevel && SummaryNode.isFirstGroupNode(node))) {
                UITools.errorMessage(TextUtils.getText("summary_not_possible"));
                return false;
            }
            nodesOnOtherSideFound = nodesOnOtherSideFound || !nodeIsOnTheSameSide;
        }
        if (this.findSummaryNodeIndex(end) != -1) {
            UITools.errorMessage(TextUtils.getText("summary_not_possible"));
            return false;
        }
        return !nodesOnOtherSideFound || OptionalDontShowMeAgainDialog.show("ignoreNodesOnOtherSide", OptionalDontShowMeAgainDialog.MessageType.BOTH_OK_AND_CANCEL_OPTIONS_ARE_STORED) == 0;
    }
}

