/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.core.backend.DefaultObjectFactory;
import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.backend.Options;
import io.cucumber.core.exception.CucumberException;
import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ObjectFactoryServiceLoader {
    private final Supplier<ClassLoader> classLoaderSupplier;
    private final Options options;

    public ObjectFactoryServiceLoader(Supplier<ClassLoader> classLoaderSupplier, Options options) {
        this.classLoaderSupplier = Objects.requireNonNull(classLoaderSupplier);
        this.options = Objects.requireNonNull(options);
    }

    ObjectFactory loadObjectFactory() {
        Class<? extends ObjectFactory> objectFactoryClass = this.options.getObjectFactoryClass();
        ClassLoader classLoader = this.classLoaderSupplier.get();
        ServiceLoader<ObjectFactory> loader = ServiceLoader.load(ObjectFactory.class, classLoader);
        if (objectFactoryClass == null) {
            return ObjectFactoryServiceLoader.loadSingleObjectFactoryOrDefault(loader);
        }
        return ObjectFactoryServiceLoader.loadSelectedObjectFactory(loader, objectFactoryClass);
    }

    private static ObjectFactory loadSingleObjectFactoryOrDefault(ServiceLoader<ObjectFactory> loader) {
        Iterator<ObjectFactory> objectFactories = loader.iterator();
        ObjectFactory objectFactory = null;
        while (objectFactories.hasNext() && (objectFactory = objectFactories.next()) instanceof DefaultObjectFactory) {
        }
        if (objectFactory == null) {
            throw new CucumberException("Could not find any object factory.\n\nCucumber uses SPI to discover object factory implementations.\nThis typically happens when using shaded jars. Make sure\nto merge all SPI definitions in META-INF/services correctly");
        }
        while (objectFactories.hasNext()) {
            ObjectFactory extraObjectFactory = objectFactories.next();
            if (extraObjectFactory instanceof DefaultObjectFactory) continue;
            throw new CucumberException(ObjectFactoryServiceLoader.getMultipleObjectFactoryLogMessage(objectFactory, extraObjectFactory));
        }
        return objectFactory;
    }

    private static ObjectFactory loadSelectedObjectFactory(ServiceLoader<ObjectFactory> loader, Class<? extends ObjectFactory> objectFactoryClass) {
        for (ObjectFactory objectFactory : loader) {
            if (!objectFactoryClass.equals(objectFactory.getClass())) continue;
            return objectFactory;
        }
        throw new CucumberException("Could not find object factory " + objectFactoryClass.getName() + ".\n\nCucumber uses SPI to discover object factory implementations.\nHas the class been registered with SPI and is it available on\nthe classpath?");
    }

    private static String getMultipleObjectFactoryLogMessage(ObjectFactory ... objectFactories) {
        String factoryNames = Stream.of(objectFactories).map(Object::getClass).map(Class::getName).collect(Collectors.joining(", "));
        return "More than one Cucumber ObjectFactory was found on the classpath\n\nFound: " + factoryNames + "\n\nYou may have included, for instance, cucumber-spring AND cucumber-guice as part\nof your dependencies. When this happens, Cucumber can't decide which to use.\nIn order to enjoy dependency injection features, either remove the unnecessary\ndependencies from your classpath or use the `cucumber.object-factory` property\nor `@CucumberOptions(objectFactory=...)` to select one.\n";
    }
}

