/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class LookUpSwitchInstruction
extends SwitchInstruction {
    public int[] cases;

    public LookUpSwitchInstruction() {
    }

    public LookUpSwitchInstruction(byte opcode, int defaultOffset, int[] cases, int[] jumpOffsets) {
        this.opcode = opcode;
        this.defaultOffset = defaultOffset;
        this.cases = cases;
        this.jumpOffsets = jumpOffsets;
    }

    public LookUpSwitchInstruction copy(LookUpSwitchInstruction lookUpSwitchInstruction) {
        this.opcode = lookUpSwitchInstruction.opcode;
        this.defaultOffset = lookUpSwitchInstruction.defaultOffset;
        this.cases = lookUpSwitchInstruction.cases;
        this.jumpOffsets = lookUpSwitchInstruction.jumpOffsets;
        return this;
    }

    @Override
    public Instruction shrink() {
        return this;
    }

    @Override
    protected void readInfo(byte[] code, int offset) {
        offset += -offset & 3;
        this.defaultOffset = LookUpSwitchInstruction.readInt(code, offset);
        int jumpOffsetCount = LookUpSwitchInstruction.readInt(code, offset += 4);
        offset += 4;
        this.cases = new int[jumpOffsetCount];
        this.jumpOffsets = new int[jumpOffsetCount];
        for (int index = 0; index < jumpOffsetCount; ++index) {
            this.cases[index] = LookUpSwitchInstruction.readInt(code, offset);
            this.jumpOffsets[index] = LookUpSwitchInstruction.readInt(code, offset += 4);
            offset += 4;
        }
    }

    @Override
    protected void writeInfo(byte[] code, int offset) {
        while ((offset & 3) != 0) {
            LookUpSwitchInstruction.writeByte(code, offset++, 0);
        }
        LookUpSwitchInstruction.writeInt(code, offset, this.defaultOffset);
        LookUpSwitchInstruction.writeInt(code, offset += 4, this.cases.length);
        offset += 4;
        for (int index = 0; index < this.cases.length; ++index) {
            LookUpSwitchInstruction.writeInt(code, offset, this.cases[index]);
            LookUpSwitchInstruction.writeInt(code, offset += 4, this.jumpOffsets[index]);
            offset += 4;
        }
    }

    @Override
    public int length(int offset) {
        return 1 + (-(offset + 1) & 3) + 8 + this.cases.length * 8;
    }

    @Override
    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitLookUpSwitchInstruction(clazz, method, codeAttribute, offset, this);
    }
}

