/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.NewObjectWizardPanel;
import org.openide.loaders.TemplateWizardIterImpl;
import org.openide.loaders.TemplateWizardIteratorWrapper;
import org.openide.loaders.TemplateWizardPanel1;
import org.openide.loaders.TemplateWizardPanel2;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Union2;
import org.openide.windows.WindowManager;

public class TemplateWizard
extends WizardDescriptor {
    private static final String EA_DESCRIPTION = "templateWizardURL";
    private static final String EA_ITERATOR = "templateWizardIterator";
    @Deprecated
    private static final String EA_DESC_RESOURCE = "templateWizardDescResource";
    private static final String CUSTOM_DESCRIPTION = "instantiatingWizardURL";
    private static final String CUSTOM_ITERATOR = "instantiatingIterator";
    static Dimension PREF_DIM = new Dimension(560, 350);
    private static final Logger LOG = Logger.getLogger(TemplateWizard.class.getName());
    private WizardDescriptor.Panel<WizardDescriptor> templateChooser;
    private WizardDescriptor.Panel<WizardDescriptor> targetChooser;
    private boolean showTargetChooser = true;
    private Iterator targetIterator;
    private TemplateWizardIteratorWrapper iterator;
    private DataObject template;
    private DataFolder templatesFolder;
    private String targetName = null;
    private DataFolder targetDataFolder;
    private boolean titleFormatSet = false;
    private Supplier<DataFolder> targetDataFolderCreator;
    private PropertyChangeListener pcl;
    private Component lastComp;
    private BlockingQueue<Union2<Set<DataObject>, IOException>> newObjects = null;
    private ProgressHandle progressHandle;
    private boolean isInstantiating = false;

    public TemplateWizard() {
        this(new TemplateWizardIteratorWrapper(new TemplateWizardIterImpl()));
    }

    private TemplateWizard(TemplateWizardIteratorWrapper templateWizardIteratorWrapper) {
        super((WizardDescriptor.Iterator)templateWizardIteratorWrapper);
        this.iterator = templateWizardIteratorWrapper;
        this.iterator.initialize(this);
        this.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        this.setTitle(NbBundle.getMessage(TemplateWizard.class, (String)"CTL_TemplateTitle"));
        this.setTitleFormat(new MessageFormat("{0}"));
    }

    protected TemplateWizard(Iterator iterator) {
        this();
        this.iterator.setIterator(iterator, false);
    }

    protected void initialize() {
        if (this.iterator != null) {
            this.iterator.initialize(this);
            this.newObjects = new ArrayBlockingQueue<Union2<Set<DataObject>, IOException>>(1);
        }
        super.initialize();
    }

    final void setTemplateImpl(DataObject dataObject, boolean bl) {
        DataObject dataObject2 = this.template;
        if (this.template != dataObject) {
            this.template = dataObject;
        }
        String string = this.getTitleFormat().format(new Object[]{dataObject.getNodeDelegate().getDisplayName()});
        this.putProperty("NewFileWizard_Title", string);
        if (dataObject2 != this.template) {
            Iterator iterator;
            if (dataObject == null || (iterator = TemplateWizard.getIterator(dataObject)) == null) {
                iterator = this.defaultIterator();
            }
            if (iterator instanceof InstantiatingIteratorBridge) {
                WizardDescriptor.InstantiatingIterator instantiatingIterator = ((InstantiatingIteratorBridge)iterator).getOriginalIterator();
                if (instantiatingIterator instanceof WizardDescriptor.ProgressInstantiatingIterator) {
                    TemplateWizardIteratorWrapper.ProgressInstantiatingIterator progressInstantiatingIterator = new TemplateWizardIteratorWrapper.ProgressInstantiatingIterator(this.iterator.getOriginalIterImpl());
                    this.iterator = progressInstantiatingIterator;
                    this.setPanelsAndSettings((WizardDescriptor.Iterator)progressInstantiatingIterator, (Object)this);
                } else if (instantiatingIterator instanceof WizardDescriptor.BackgroundInstantiatingIterator) {
                    TemplateWizardIteratorWrapper.BackgroundInstantiatingIterator backgroundInstantiatingIterator = new TemplateWizardIteratorWrapper.BackgroundInstantiatingIterator(this.iterator.getOriginalIterImpl());
                    this.iterator = backgroundInstantiatingIterator;
                    this.setPanelsAndSettings((WizardDescriptor.Iterator)backgroundInstantiatingIterator, (Object)this);
                } else if (instantiatingIterator instanceof WizardDescriptor.AsynchronousInstantiatingIterator) {
                    TemplateWizardIteratorWrapper.AsynchronousInstantiatingIterator asynchronousInstantiatingIterator = new TemplateWizardIteratorWrapper.AsynchronousInstantiatingIterator(this.iterator.getOriginalIterImpl());
                    this.iterator = asynchronousInstantiatingIterator;
                    this.setPanelsAndSettings((WizardDescriptor.Iterator)asynchronousInstantiatingIterator, (Object)this);
                }
            }
            this.iterator.setIterator(iterator, bl);
        }
        this.putProperty("NewFileWizard_Title", string);
    }

    public DataObject getTemplate() {
        return this.template;
    }

    public void setTemplate(final DataObject dataObject) {
        if (dataObject != null) {
            Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    TemplateWizard.this.setTemplateImpl(dataObject, true);
                    return null;
                }
            });
        }
    }

    public void setTemplatesFolder(DataFolder dataFolder) {
        this.templatesFolder = dataFolder;
    }

    public DataFolder getTemplatesFolder() {
        FileObject fileObject;
        DataFolder dataFolder = this.templatesFolder;
        if (dataFolder == null && (fileObject = FileUtil.getConfigFile((String)"Templates")) != null && fileObject.isFolder()) {
            return DataFolder.findFolder(fileObject);
        }
        return dataFolder;
    }

    public DataFolder getTargetFolder() throws IOException {
        LOG.log(Level.FINE, "targetFolder={0} for {1}", new Object[]{this.targetDataFolder, this});
        if (this.targetDataFolder == null && this.targetDataFolderCreator != null) {
            this.targetDataFolder = this.targetDataFolderCreator.get();
            LOG.log(Level.FINE, "lazy targetFolder={0} for {1}", new Object[]{this.targetDataFolder, this});
        }
        if (this.targetDataFolder == null) {
            throw new IOException(NbBundle.getMessage(TemplateWizard.class, (String)"ERR_NoFilesystem"));
        }
        return this.targetDataFolder;
    }

    private void reload(DataObject dataObject) {
        Iterator iterator;
        if (dataObject == null || (iterator = TemplateWizard.getIterator(dataObject)) == null) {
            iterator = this.defaultIterator();
        }
        this.iterator.setIterator(iterator, true);
    }

    public void setTargetFolder(DataFolder dataFolder) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "set targetFolder=" + dataFolder + " for " + (Object)((Object)this), new Throwable());
        }
        if (dataFolder == null) {
            this.targetDataFolderCreator = null;
        }
        this.targetDataFolder = dataFolder;
    }

    public void setTargetFolderLazy(Supplier<DataFolder> supplier) {
        this.targetDataFolderCreator = supplier;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String string) {
        this.targetName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardDescriptor.Panel<WizardDescriptor> templateChooser() {
        TemplateWizard templateWizard = this;
        synchronized (templateWizard) {
            if (this.templateChooser == null) {
                this.templateChooser = this.createTemplateChooser();
            }
        }
        return this.templateChooser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardDescriptor.Panel<WizardDescriptor> targetChooser() {
        TemplateWizard templateWizard = this;
        synchronized (templateWizard) {
            if (this.targetChooser == null) {
                this.targetChooser = this.createTargetChooser();
            }
        }
        return this.targetChooser;
    }

    final synchronized Iterator defaultIterator() {
        if (this.targetIterator == null) {
            this.targetIterator = this.createDefaultIterator();
        }
        return this.targetIterator;
    }

    protected WizardDescriptor.Panel<WizardDescriptor> createTemplateChooser() {
        return new TemplateWizardPanel1();
    }

    protected WizardDescriptor.Panel<WizardDescriptor> createTargetChooser() {
        if (this.showTargetChooser) {
            return new TemplateWizardPanel2();
        }
        return new NewObjectWizardPanel();
    }

    protected Iterator createDefaultIterator() {
        return new DefaultIterator();
    }

    public Set<DataObject> instantiate() throws IOException {
        this.showTargetChooser = true;
        return this.instantiateImpl(null, null);
    }

    public Set<DataObject> instantiate(DataObject dataObject) throws IOException {
        this.showTargetChooser = true;
        return this.instantiateImpl(dataObject, null);
    }

    public Set<DataObject> instantiate(DataObject dataObject, DataFolder dataFolder) throws IOException {
        this.showTargetChooser = false;
        return this.instantiateImpl(dataObject, dataFolder);
    }

    private ProgressHandle getProgressHandle() {
        return this.progressHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<DataObject> instantiateNewObjects(ProgressHandle progressHandle) throws IOException {
        Union2 union2;
        this.progressHandle = progressHandle;
        Object object = this.getValue();
        if (object == FINISH_OPTION || object == YES_OPTION || object == OK_OPTION) {
            this.showWaitCursor();
            try {
                union2 = Union2.createFirst(this.handleInstantiate());
            }
            catch (IOException iOException) {
                union2 = Union2.createSecond((Object)iOException);
            }
            finally {
                this.showNormalCursor();
            }
        } else {
            union2 = Union2.createFirst(null);
        }
        if (this.lastComp != null) {
            this.lastComp.removePropertyChangeListener(this.propL());
            this.lastComp = null;
        }
        this.newObjects.clear();
        this.newObjects.add((Union2<Set<DataObject>, IOException>)union2);
        if (union2.hasFirst()) {
            return (Set)union2.first();
        }
        throw (IOException)union2.second();
    }

    private Set<DataObject> instantiateImpl(DataObject dataObject, DataFolder dataFolder) throws IOException {
        Union2<Set<DataObject>, IOException> union2;
        this.showTargetChooser |= dataFolder == null;
        this.targetChooser = null;
        if (dataFolder != null) {
            this.setTargetFolder(dataFolder);
        }
        if (dataObject != null) {
            this.template = null;
            this.setTemplate(dataObject);
            if (this.iterator != null) {
                this.iterator.initialize(this);
            }
        } else if (this.iterator != null) {
            this.iterator.initialize(this);
            this.iterator.first();
        }
        Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                TemplateWizard.this.updateState();
                return null;
            }
        });
        this.setValue(null);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)this);
        if (object == CLOSED_OPTION || object == CANCEL_OPTION) {
            return null;
        }
        try {
            union2 = this.newObjects.take();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
        if (union2.hasFirst()) {
            return (Set)union2.first();
        }
        throw (IOException)union2.second();
    }

    private void showWaitCursor() {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                try {
                    Frame frame = WindowManager.getDefault().getMainWindow();
                    if (frame instanceof JFrame) {
                        Component component = ((JFrame)frame).getGlassPane();
                        component.setVisible(true);
                        component.setCursor(Cursor.getPredefinedCursor(3));
                    }
                }
                catch (NullPointerException nullPointerException) {
                    LOG.log(Level.WARNING, null, nullPointerException);
                }
            }
        });
    }

    private void showNormalCursor() {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                try {
                    Frame frame = WindowManager.getDefault().getMainWindow();
                    if (frame instanceof JFrame) {
                        Component component = ((JFrame)frame).getGlassPane();
                        component.setCursor(null);
                        component.setVisible(false);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    LOG.log(Level.WARNING, null, nullPointerException);
                }
            }
        });
    }

    public void setTitleFormat(MessageFormat messageFormat) {
        this.titleFormatSet = true;
        super.setTitleFormat(messageFormat);
    }

    public MessageFormat getTitleFormat() {
        if (!this.titleFormatSet) {
            this.setTitleFormat(new MessageFormat(NbBundle.getMessage(TemplateWizard.class, (String)"CTL_TemplateTitle")));
        }
        return super.getTitleFormat();
    }

    protected Set<DataObject> handleInstantiate() throws IOException {
        try {
            this.isInstantiating = true;
            Set<DataObject> set = this.iterator.getIterator().instantiate(this);
            return set;
        }
        finally {
            this.isInstantiating = false;
        }
    }

    public static void setDescription(DataObject dataObject, URL uRL) throws IOException {
        dataObject.getPrimaryFile().setAttribute(EA_DESCRIPTION, (Object)uRL);
        dataObject.getPrimaryFile().setAttribute(CUSTOM_DESCRIPTION, (Object)uRL);
    }

    public static URL getDescription(DataObject dataObject) {
        URL uRL = (URL)dataObject.getPrimaryFile().getAttribute(CUSTOM_DESCRIPTION);
        if (uRL != null) {
            return uRL;
        }
        uRL = (URL)dataObject.getPrimaryFile().getAttribute(EA_DESCRIPTION);
        if (uRL != null) {
            return uRL;
        }
        String string = (String)dataObject.getPrimaryFile().getAttribute(EA_DESC_RESOURCE);
        if (string != null) {
            try {
                URL uRL2 = new URL("nbresloc:/" + string);
                try {
                    TemplateWizard.setDescription(dataObject, uRL2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return null;
    }

    @Deprecated
    public static void setDescriptionAsResource(DataObject dataObject, String string) throws IOException {
        if (string != null && string.startsWith("/")) {
            LOG.log(Level.WARNING, "auto-stripping leading slash from resource path in TemplateWizard.setDescriptionAsResource: {0}", string);
            string = string.substring(1);
        }
        dataObject.getPrimaryFile().setAttribute(EA_DESC_RESOURCE, (Object)string);
    }

    @Deprecated
    public static String getDescriptionAsResource(DataObject dataObject) {
        return (String)dataObject.getPrimaryFile().getAttribute(EA_DESC_RESOURCE);
    }

    @Deprecated
    public static void setIterator(DataObject dataObject, Iterator iterator) throws IOException {
        dataObject.getPrimaryFile().setAttribute(CUSTOM_ITERATOR, (Object)iterator);
        dataObject.getPrimaryFile().setAttribute(EA_ITERATOR, (Object)iterator);
    }

    public static Iterator getIterator(DataObject dataObject) {
        Iterator iterator;
        FileObject fileObject = dataObject.getPrimaryFile();
        Object object = fileObject.getAttribute(CUSTOM_ITERATOR);
        if (object == null && (object = fileObject.getAttribute(EA_ITERATOR)) == null && (iterator = fileObject.getParent()) != null) {
            object = iterator.getAttribute(EA_ITERATOR);
        }
        iterator = null;
        if (object instanceof Iterator) {
            iterator = (Iterator)object;
        }
        if (object instanceof WizardDescriptor.InstantiatingIterator) {
            iterator = new InstantiatingIteratorBridge((WizardDescriptor.InstantiatingIterator<WizardDescriptor>)((WizardDescriptor.InstantiatingIterator)object));
        }
        if (iterator != null) {
            return iterator;
        }
        return dataObject.getCookie(Iterator.class);
    }

    static boolean checkCaseInsensitiveName(FileObject fileObject, String string, String string2) {
        Enumeration enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(fileObject2.getExt()) || !string.equalsIgnoreCase(fileObject2.getName())) continue;
            return true;
        }
        return false;
    }

    protected void updateState() {
        assert (EventQueue.isDispatchThread());
        if (this.isInstantiating) {
            return;
        }
        super.updateState();
        if (this.lastComp != null) {
            this.lastComp.removePropertyChangeListener(this.propL());
        }
        this.lastComp = this.iterator.current().getComponent();
        this.lastComp.addPropertyChangeListener(this.propL());
        this.putProperty("WizardPanel_contentSelectedIndex", new Integer(this.getContentSelectedIndex()));
        if (this.getContentData() != null) {
            this.putProperty("WizardPanel_contentData", this.getContentData());
        }
    }

    private String[] getContentData() {
        Object object;
        Component component = this.templateChooser().getComponent();
        if (this.iterator.current() == this.templateChooser()) {
            return (String[])((JComponent)component).getClientProperty("WizardPanel_contentData");
        }
        String[] stringArray = null;
        Component component2 = this.iterator.current().getComponent();
        if (component2 instanceof JComponent && (object = ((JComponent)component2).getClientProperty("WizardPanel_contentData")) instanceof String[]) {
            String[] stringArray2 = (String[])object;
            Object object2 = ((JComponent)component).getClientProperty("WizardPanel_contentData");
            if (object2 instanceof String[]) {
                stringArray = new String[stringArray2.length + 1];
                stringArray[0] = ((String[])object2)[0];
                System.arraycopy(stringArray2, 0, stringArray, 1, stringArray2.length);
            } else {
                stringArray = new String[stringArray2.length];
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            }
        }
        return stringArray;
    }

    private int getContentSelectedIndex() {
        Object object;
        if (this.iterator.current() == this.templateChooser()) {
            return 0;
        }
        Component component = this.iterator.current().getComponent();
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty("WizardPanel_contentSelectedIndex")) instanceof Integer) {
            return (Integer)object + 1;
        }
        return 1;
    }

    private PropertyChangeListener propL() {
        if (this.pcl == null) {
            this.pcl = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("WizardPanel_contentSelectedIndex".equals(propertyChangeEvent.getPropertyName())) {
                        TemplateWizard.this.putProperty("WizardPanel_contentSelectedIndex", new Integer(TemplateWizard.this.getContentSelectedIndex()));
                    } else if ("WizardPanel_contentData".equals(propertyChangeEvent.getPropertyName()) && TemplateWizard.this.getContentData() != null) {
                        TemplateWizard.this.putProperty("WizardPanel_contentData", TemplateWizard.this.getContentData());
                    }
                }
            };
        }
        return this.pcl;
    }

    final TemplateWizardIterImpl getIterImpl() {
        return this.iterator.getOriginalIterImpl();
    }

    private static class InstantiatingIteratorBridge
    implements Iterator {
        private WizardDescriptor.InstantiatingIterator<WizardDescriptor> instantiatingIterator;

        public InstantiatingIteratorBridge(WizardDescriptor.InstantiatingIterator<WizardDescriptor> instantiatingIterator) {
            this.instantiatingIterator = instantiatingIterator;
        }

        private WizardDescriptor.InstantiatingIterator getOriginalIterator() {
            return this.instantiatingIterator;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.instantiatingIterator.addChangeListener(changeListener);
        }

        public WizardDescriptor.Panel<WizardDescriptor> current() {
            return this.instantiatingIterator.current();
        }

        public boolean hasNext() {
            return this.instantiatingIterator.hasNext();
        }

        public boolean hasPrevious() {
            return this.instantiatingIterator.hasPrevious();
        }

        public String name() {
            return this.instantiatingIterator.name();
        }

        public void nextPanel() {
            this.instantiatingIterator.nextPanel();
        }

        public void previousPanel() {
            this.instantiatingIterator.previousPanel();
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.instantiatingIterator.removeChangeListener(changeListener);
        }

        @Override
        public void initialize(TemplateWizard templateWizard) {
            this.instantiatingIterator.initialize((WizardDescriptor)templateWizard);
        }

        @Override
        public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
            Set set;
            if (this.instantiatingIterator instanceof WizardDescriptor.ProgressInstantiatingIterator) {
                assert (templateWizard.getProgressHandle() != null) : "ProgressHandle cannot be null.";
                set = ((WizardDescriptor.ProgressInstantiatingIterator)this.instantiatingIterator).instantiate(templateWizard.getProgressHandle());
            } else {
                set = this.instantiatingIterator.instantiate();
            }
            if (set == null) {
                LOG.log(Level.WARNING, "Wizard iterator of type {0} illegally returned null from the instantiate method", this.instantiatingIterator.getClass().getName());
                return Collections.emptySet();
            }
            LinkedHashSet<DataObject> linkedHashSet = new LinkedHashSet<DataObject>(set.size());
            for (Object e : set) {
                DataObject dataObject;
                assert (e != null) : "Null DataObject provided by " + this.instantiatingIterator;
                if (e instanceof DataObject) {
                    linkedHashSet.add((DataObject)e);
                    continue;
                }
                if (e instanceof FileObject) {
                    dataObject = DataObject.find((FileObject)e);
                    linkedHashSet.add(dataObject);
                    continue;
                }
                if (!(e instanceof Node) || (dataObject = (DataObject)((Node)e).getCookie(DataObject.class)) == null) continue;
                linkedHashSet.add(dataObject);
            }
            return linkedHashSet;
        }

        @Override
        public void uninitialize(TemplateWizard templateWizard) {
            this.instantiatingIterator.uninitialize((WizardDescriptor)templateWizard);
        }
    }

    private final class DefaultIterator
    implements Iterator {
        DefaultIterator() {
        }

        public String name() {
            return "";
        }

        @Override
        public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
            Action action;
            String string = templateWizard.getTargetName();
            DataFolder dataFolder = templateWizard.getTargetFolder();
            DataObject dataObject = templateWizard.getTemplate();
            HashMap hashMap = new HashMap();
            for (Map.Entry node2 : templateWizard.getProperties().entrySet()) {
                hashMap.put("wizard." + (String)node2.getKey(), node2.getValue());
            }
            DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, string, hashMap);
            final Node node = dataObject2.getNodeDelegate();
            Action action2 = node.getPreferredAction();
            if (action2 instanceof ContextAwareAction) {
                action2 = ((ContextAwareAction)action2).createContextAwareInstance(node.getLookup());
            }
            if ((action = action2) != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        action.actionPerformed(new ActionEvent(node, 1001, ""));
                    }
                });
            }
            return Collections.singleton(dataObject2);
        }

        @Override
        public void initialize(TemplateWizard templateWizard) {
        }

        @Override
        public void uninitialize(TemplateWizard templateWizard) {
        }

        public WizardDescriptor.Panel<WizardDescriptor> current() {
            return TemplateWizard.this.targetChooser();
        }

        public boolean hasNext() {
            return false;
        }

        public boolean hasPrevious() {
            return false;
        }

        public void nextPanel() {
            throw new NoSuchElementException();
        }

        public void previousPanel() {
            throw new NoSuchElementException();
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    public static interface Iterator
    extends WizardDescriptor.Iterator<WizardDescriptor>,
    Serializable,
    Node.Cookie {
        public Set<DataObject> instantiate(TemplateWizard var1) throws IOException;

        public void initialize(TemplateWizard var1);

        public void uninitialize(TemplateWizard var1);
    }
}

