/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.FileUserPreferences;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeApplication;
import com.eteks.sweethome3d.model.HomeRecorder;
import com.eteks.sweethome3d.model.InterruptedRecorderException;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.OperatingSystem;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class AutoRecoveryManager {
    private static final int MINIMUM_DELAY_BETWEEN_AUTO_SAVE_OPERATIONS = 30000;
    private static final String RECOVERY_SUB_FOLDER = "recovery";
    private static final String RECOVERED_FILE_EXTENSION = ".recovered";
    private static final String UNRECOVERABLE_FILE_EXTENSION = ".unrecoverable";
    private final HomeApplication application;
    private final List<Home> recoveredHomes = new ArrayList<Home>();
    private final Map<Home, File> autoSavedFiles = new HashMap<Home, File>();
    private final Map<File, FileOutputStream> lockedOutputStreams = new HashMap<File, FileOutputStream>();
    private final ExecutorService autoSaveForRecoveryExecutor;
    private Timer timer;
    private long lastAutoSaveTime;

    public AutoRecoveryManager(HomeApplication homeApplication) throws RecorderException {
        this.application = homeApplication;
        this.autoSaveForRecoveryExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setPriority(1);
                return thread;
            }
        });
        this.readRecoveredHomes();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AutoRecoveryManager.this.autoSaveForRecoveryExecutor.shutdownNow();
            }
        });
        homeApplication.addHomesListener(new CollectionListener<Home>(){

            @Override
            public void collectionChanged(CollectionEvent<Home> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    final Home home = collectionEvent.getItem();
                    AutoRecoveryManager.this.autoSaveForRecoveryExecutor.submit(new Runnable(){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        @Override
                        public void run() {
                            try {
                                File file = (File)this.this$1.AutoRecoveryManager.this.autoSavedFiles.get(home);
                                if (file != null) {
                                    this.this$1.AutoRecoveryManager.this.freeLockedFile(file);
                                    file.delete();
                                    this.this$1.AutoRecoveryManager.this.autoSavedFiles.remove(home);
                                }
                            }
                            catch (RecorderException recorderException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        });
        homeApplication.getUserPreferences().addPropertyChangeListener(UserPreferences.Property.AUTO_SAVE_DELAY_FOR_RECOVERY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AutoRecoveryManager.this.restartTimer();
            }
        });
        this.restartTimer();
    }

    private void readRecoveredHomes() throws RecorderException {
        File file = this.getRecoveryFolder();
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(AutoRecoveryManager.RECOVERED_FILE_EXTENSION);
            }
        });
        if (fileArray != null) {
            Arrays.sort(fileArray, new Comparator<File>(){

                @Override
                public int compare(File file, File file2) {
                    if (file.lastModified() < file2.lastModified()) {
                        return 1;
                    }
                    return -1;
                }
            });
            for (final File file2 : fileArray) {
                if (this.isFileLocked(file2)) continue;
                try {
                    final Home home = this.application.getHomeRecorder().readHome(file2.getPath());
                    if (home.getName() != null && file2.equals(new File(home.getName()))) continue;
                    home.setRecovered(true);
                    home.addPropertyChangeListener(Home.Property.RECOVERED, new PropertyChangeListener(){
                        final /* synthetic */ AutoRecoveryManager this$0;
                        {
                            this.this$0 = autoRecoveryManager;
                        }

                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if (!home.isRecovered()) {
                                file2.delete();
                            }
                        }
                    });
                    this.recoveredHomes.add(home);
                }
                catch (RecorderException recorderException) {
                    recorderException.printStackTrace();
                    file2.renameTo(new File(file, file2.getName().replace(RECOVERED_FILE_EXTENSION, UNRECOVERABLE_FILE_EXTENSION)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFileLocked(File file) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file, true);
            boolean bl = fileOutputStream.getChannel().tryLock() == null;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    return true;
                }
            }
        }
    }

    public void openRecoveredHomes() {
        for (Home home : this.recoveredHomes) {
            boolean bl = false;
            for (Home home2 : this.application.getHomes()) {
                if (home2.getName() == null || !home2.getName().equals(home.getName())) continue;
                home.setName(null);
                this.application.addHome(home);
                bl = true;
                break;
            }
            if (bl) continue;
            this.application.addHome(home);
        }
        this.recoveredHomes.clear();
    }

    private void restartTimer() {
        int n;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if ((n = this.application.getUserPreferences().getAutoSaveDelayForRecovery()) > 0) {
            this.timer = new Timer("autoSaveTimer", true);
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    if (System.currentTimeMillis() - AutoRecoveryManager.this.lastAutoSaveTime > 30000L) {
                        AutoRecoveryManager.this.cloneAndSaveHomes();
                    }
                }
            };
            this.timer.scheduleAtFixedRate(timerTask, n, (long)n);
        }
    }

    private void cloneAndSaveHomes() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    for (final Home home : AutoRecoveryManager.this.application.getHomes()) {
                        final Home home2 = home.clone();
                        final HomeRecorder homeRecorder = AutoRecoveryManager.this.application.getHomeRecorder();
                        AutoRecoveryManager.this.autoSaveForRecoveryExecutor.submit(new Runnable(){
                            final /* synthetic */ 9 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            @Override
                            public void run() {
                                try {
                                    this.this$1.AutoRecoveryManager.this.saveHome(home, home2, homeRecorder);
                                }
                                catch (RecorderException recorderException) {
                                    recorderException.printStackTrace();
                                }
                            }
                        });
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void saveHome(Home home, Home home2, HomeRecorder homeRecorder) throws RecorderException {
        Object object;
        File file = this.autoSavedFiles.get(home);
        if (file == null) {
            object = this.getRecoveryFolder();
            if (!((File)object).exists() && !((File)object).mkdirs()) {
                throw new RecorderException("Can't create folder " + object + " to store recovered files");
            }
            if (home2.getName() != null) {
                String string = new File(home2.getName()).getName();
                file = new File((File)object, string + RECOVERED_FILE_EXTENSION);
                if (file.exists()) {
                    file = new File((File)object, UUID.randomUUID() + "-" + string + RECOVERED_FILE_EXTENSION);
                }
            } else {
                file = new File((File)object, UUID.randomUUID() + RECOVERED_FILE_EXTENSION);
            }
        }
        this.freeLockedFile(file);
        if (home2.isModified()) {
            this.autoSavedFiles.put(home, file);
            try {
                homeRecorder.writeHome(home2, file.getPath());
                object = null;
                try {
                    object = new FileOutputStream(file, true);
                    ((FileOutputStream)object).getChannel().lock();
                    this.lockedOutputStreams.put(file, (FileOutputStream)object);
                }
                catch (OverlappingFileLockException overlappingFileLockException) {
                }
                catch (IOException iOException) {
                    if (object != null) {
                        try {
                            ((FileOutputStream)object).close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    throw new RecorderException("Can't lock saved home", iOException);
                }
            }
            catch (InterruptedRecorderException interruptedRecorderException) {}
        } else {
            file.delete();
            this.autoSavedFiles.remove(home);
        }
        this.lastAutoSaveTime = Math.max(this.lastAutoSaveTime, System.currentTimeMillis());
    }

    private void freeLockedFile(File file) throws RecorderException {
        FileOutputStream fileOutputStream = this.lockedOutputStreams.get(file);
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
                this.lockedOutputStreams.remove(file);
            }
            catch (IOException iOException) {
                throw new RecorderException("Can't close locked stream", iOException);
            }
        }
    }

    private File getRecoveryFolder() throws RecorderException {
        try {
            UserPreferences userPreferences = this.application.getUserPreferences();
            return new File(userPreferences instanceof FileUserPreferences ? ((FileUserPreferences)userPreferences).getApplicationFolder() : OperatingSystem.getDefaultApplicationFolder(), RECOVERY_SUB_FOLDER);
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't retrieve recovered files folder", iOException);
        }
    }
}

