import { CancellationToken, CodeLens } from 'vscode-languageserver';
import { Document } from '../../../lib/documents';
import { LSConfigManager } from '../../../ls-config';
import { CodeLensProvider, FindReferencesProvider, ImplementationProvider } from '../../interfaces';
import { LSAndTSDocResolver } from '../LSAndTSDocResolver';
export declare class CodeLensProviderImpl implements CodeLensProvider {
    private readonly lsAndTsDocResolver;
    private readonly referenceProvider;
    private readonly implementationProvider;
    private readonly configManager;
    constructor(lsAndTsDocResolver: LSAndTSDocResolver, referenceProvider: FindReferencesProvider, implementationProvider: ImplementationProvider, configManager: LSConfigManager);
    getCodeLens(document: Document): Promise<CodeLens[] | null>;
    private anyCodeLensEnabled;
    /**
     * https://github.com/microsoft/vscode/blob/062ba1ed6c2b9ff4819f4f7dad76de3fde0044ab/extensions/typescript-language-features/src/languageFeatures/codeLens/referencesCodeLens.ts#L61
     */
    private extractReferenceLocation;
    private isExported;
    /**
     * https://github.com/microsoft/vscode/blob/062ba1ed6c2b9ff4819f4f7dad76de3fde0044ab/extensions/typescript-language-features/src/languageFeatures/codeLens/implementationsCodeLens.ts#L66
     */
    private extractImplementationLocation;
    private getSymbolRange;
    private walkTree;
    resolveCodeLens(textDocument: Document, codeLensToResolve: CodeLens, cancellationToken?: CancellationToken): Promise<CodeLens>;
    private resolveReferenceCodeLens;
    private resolveImplementationCodeLens;
}
