/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.AbstractMetadataMethod;
import org.firebirdsql.jdbc.metadata.Clause;
import org.firebirdsql.jdbc.metadata.PrivilegeMapping;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;

public final class GetColumnPrivileges
extends AbstractMetadataMethod {
    private static final String COLUMNPRIV = "COLUMNPRIV";
    private static final RowDescriptor ROW_DESCRIPTOR = DbMetadataMediator.newRowDescriptorBuilder(9).at(0).simple(449, 63, "TABLE_CAT", "COLUMNPRIV").addField().at(1).simple(449, 63, "TABLE_SCHEM", "COLUMNPRIV").addField().at(2).simple(448, 63, "TABLE_NAME", "COLUMNPRIV").addField().at(3).simple(448, 63, "COLUMN_NAME", "COLUMNPRIV").addField().at(4).simple(448, 63, "GRANTOR", "COLUMNPRIV").addField().at(5).simple(448, 63, "GRANTEE", "COLUMNPRIV").addField().at(6).simple(448, 31, "PRIVILEGE", "COLUMNPRIV").addField().at(7).simple(448, 3, "IS_GRANTABLE", "COLUMNPRIV").addField().at(8).simple(448, 63, "JB_GRANTEE_TYPE", "COLUMNPRIV").addField().toRowDescriptor();
    private static final String GET_COLUMN_PRIVILEGES_START = "select distinct \n  RF.RDB$RELATION_NAME as TABLE_NAME, \n  RF.RDB$FIELD_NAME as COLUMN_NAME, \n  UP.RDB$GRANTOR as GRANTOR, \n  UP.RDB$USER as GRANTEE, \n  UP.RDB$PRIVILEGE as PRIVILEGE, \n  UP.RDB$GRANT_OPTION as IS_GRANTABLE,\n  T.RDB$TYPE_NAME as JB_GRANTEE_TYPE\nfrom RDB$RELATION_FIELDS RF\ninner join RDB$USER_PRIVILEGES UP\n  on UP.RDB$RELATION_NAME = RF.RDB$RELATION_NAME \n    and (UP.RDB$FIELD_NAME is null or UP.RDB$FIELD_NAME = RF.RDB$FIELD_NAME) \nleft join RDB$TYPES T\n  on T.RDB$FIELD_NAME = 'RDB$OBJECT_TYPE' and T.RDB$TYPE = UP.RDB$USER_TYPE \nwhere UP.RDB$PRIVILEGE in ('A', 'D', 'I', 'R', 'S', 'U')\nand UP.RDB$OBJECT_TYPE in (0, 1)\nand ";
    private static final String GET_COLUMN_PRIVILEGES_END = "\norder by RF.RDB$FIELD_NAME, UP.RDB$PRIVILEGE, UP.RDB$USER";

    GetColumnPrivileges(DbMetadataMediator mediator) {
        super(ROW_DESCRIPTOR, mediator);
    }

    public ResultSet getColumnPrivileges(String table, String columnNamePattern) throws SQLException {
        if (table == null || "".equals(columnNamePattern)) {
            return this.createEmpty();
        }
        Clause tableClause = Clause.equalsClause("RF.RDB$RELATION_NAME", table);
        Clause columnNameClause = new Clause("RF.RDB$FIELD_NAME", columnNamePattern);
        String sql = GET_COLUMN_PRIVILEGES_START + tableClause.getCondition(columnNameClause.hasCondition()) + columnNameClause.getCondition(false) + GET_COLUMN_PRIVILEGES_END;
        DbMetadataMediator.MetadataQuery metadataQuery = new DbMetadataMediator.MetadataQuery(sql, Clause.parameters(tableClause, columnNameClause));
        return this.createMetaDataResultSet(metadataQuery);
    }

    @Override
    RowValue createMetadataRow(ResultSet rs, RowValueBuilder valueBuilder) throws SQLException {
        return valueBuilder.at(0).set(null).at(1).set(null).at(2).setString(rs.getString("TABLE_NAME")).at(3).setString(rs.getString("COLUMN_NAME")).at(4).setString(rs.getString("GRANTOR")).at(5).setString(rs.getString("GRANTEE")).at(6).setString(PrivilegeMapping.mapPrivilege(rs.getString("PRIVILEGE"))).at(7).setString(rs.getBoolean("IS_GRANTABLE") ? "YES" : "NO").at(8).setString(rs.getString("JB_GRANTEE_TYPE")).toRowValue(false);
    }

    public static GetColumnPrivileges create(DbMetadataMediator mediator) {
        return new GetColumnPrivileges(mediator);
    }
}

