/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.firebirdsql.gds.EventHandle;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.wire.AsynchronousChannelListener;
import org.firebirdsql.gds.ng.wire.AsynchronousChannelListenerDispatcher;
import org.firebirdsql.gds.ng.wire.FbWireAsynchronousChannel;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.WireEventHandle;
import org.firebirdsql.jaybird.util.ByteArrayHelper;

public class V10AsynchronousChannel
implements FbWireAsynchronousChannel {
    private static final System.Logger log = System.getLogger(V10AsynchronousChannel.class.getName());
    private static final int EVENT_BUFFER_SIZE = 2048;
    private final AsynchronousChannelListenerDispatcher channelListenerDispatcher = new AsynchronousChannelListenerDispatcher();
    private final ChannelDatabaseListener databaseListener = new ChannelDatabaseListener();
    private final FbWireDatabase database;
    private final ByteBuffer eventBuffer = ByteBuffer.allocate(2048);
    private int auxHandle;
    private SocketChannel socketChannel;
    private final Lock closeLock = new ReentrantLock();

    public V10AsynchronousChannel(FbWireDatabase database) {
        this.database = Objects.requireNonNull(database, "database");
        database.addWeakDatabaseListener(this.databaseListener);
    }

    protected final LockCloseable withLock() {
        return this.database.withLock();
    }

    @Override
    public void connect(String hostName, int portNumber, int auxHandle) throws SQLException {
        if (this.isConnected()) {
            throw FbExceptionBuilder.toNonTransientException(337248345);
        }
        this.auxHandle = auxHandle;
        try {
            this.socketChannel = SocketChannel.open();
            this.socketChannel.socket().setTcpNoDelay(true);
            InetSocketAddress socketAddress = new InetSocketAddress(hostName, portNumber);
            this.socketChannel.connect(socketAddress);
            this.socketChannel.configureBlocking(false);
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            if (!this.isConnected()) {
                return;
            }
            if (!this.closeLock.tryLock()) {
                return;
            }
            try {
                if (!this.isConnected()) {
                    return;
                }
                this.channelListenerDispatcher.channelClosing(this);
                this.socketChannel.close();
            }
            catch (IOException ex) {
                throw FbExceptionBuilder.forException(337248268).cause(ex).toSQLException();
            }
            finally {
                this.socketChannel = null;
                this.closeLock.unlock();
            }
        }
        finally {
            this.database.removeDatabaseListener(this.databaseListener);
        }
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel != null && this.socketChannel.isConnected();
    }

    @Override
    public void addChannelListener(AsynchronousChannelListener listener) {
        this.channelListenerDispatcher.addListener(listener);
    }

    @Override
    public void removeChannelListener(AsynchronousChannelListener listener) {
        this.channelListenerDispatcher.removeListener(listener);
    }

    @Override
    public SocketChannel getSocketChannel() throws SQLException {
        if (!this.isConnected()) {
            throw FbExceptionBuilder.toNonTransientException(337248346);
        }
        return this.socketChannel;
    }

    @Override
    public ByteBuffer getEventBuffer() {
        return this.eventBuffer;
    }

    @Override
    public void processEventData() {
        this.eventBuffer.flip();
        try {
            V10AsynchronousChannel.traceLogEventBuffer(this.eventBuffer);
            this.processBuffer();
            this.eventBuffer.compact();
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.ERROR, "SQLException processing event data", (Throwable)e);
        }
        catch (Exception e) {
            log.log(System.Logger.Level.ERROR, "Unexpected exception processing events", (Throwable)e);
        }
    }

    private void processBuffer() throws SQLException {
        block5: while (this.eventBuffer.remaining() >= 4) {
            this.eventBuffer.mark();
            int operation = this.eventBuffer.getInt();
            switch (operation) {
                case 71: {
                    continue block5;
                }
                case 2: 
                case 6: {
                    this.close();
                    return;
                }
                case 52: {
                    if (this.processSingleEvent()) continue block5;
                    log.log(System.Logger.Level.DEBUG, "Could not process entire event, resetting position for next channel read");
                    this.eventBuffer.reset();
                    return;
                }
            }
            log.log(System.Logger.Level.ERROR, "Unexpected event operation received: {0}, position {1}, limit {2}", operation, this.eventBuffer.position(), this.eventBuffer.limit());
        }
    }

    @Override
    public void queueEvent(EventHandle eventHandle) throws SQLException {
        WireEventHandle wireEventHandle = V10AsynchronousChannel.requireWireEventHandle(eventHandle);
        int localId = wireEventHandle.assignNewLocalId();
        this.addChannelListener(wireEventHandle);
        try (LockCloseable ignored = this.withLock();){
            try {
                log.log(System.Logger.Level.TRACE, "Queue event: {0}", wireEventHandle);
                XdrOutputStream dbXdrOut = this.database.getXdrStreamAccess().getXdrOut();
                dbXdrOut.writeInt(48);
                dbXdrOut.writeInt(this.auxHandle);
                dbXdrOut.writeBuffer(wireEventHandle.toByteArray());
                dbXdrOut.writeLong(0L);
                dbXdrOut.writeInt(localId);
                dbXdrOut.flush();
            }
            catch (IOException e) {
                throw FbExceptionBuilder.ioWriteError(e);
            }
            try {
                GenericResponse response = this.database.readGenericResponse(null);
                wireEventHandle.setEventId(response.objectHandle());
            }
            catch (IOException e) {
                throw FbExceptionBuilder.ioWriteError(e);
            }
        }
    }

    private static WireEventHandle requireWireEventHandle(EventHandle eventHandle) throws SQLException {
        if (eventHandle instanceof WireEventHandle) {
            WireEventHandle wireEventHandle = (WireEventHandle)eventHandle;
            return wireEventHandle;
        }
        throw FbExceptionBuilder.forNonTransientException(337248325).messageParameter((Object)eventHandle.getClass()).toSQLException();
    }

    @Override
    public void cancelEvent(EventHandle eventHandle) throws SQLException {
        WireEventHandle wireEventHandle = V10AsynchronousChannel.requireWireEventHandle(eventHandle);
        this.removeChannelListener(wireEventHandle);
        try (LockCloseable ignored = this.withLock();){
            try {
                XdrOutputStream dbXdrOut = this.database.getXdrStreamAccess().getXdrOut();
                dbXdrOut.writeInt(49);
                dbXdrOut.writeInt(0);
                dbXdrOut.writeInt(wireEventHandle.getLocalId());
                dbXdrOut.flush();
            }
            catch (IOException e) {
                throw FbExceptionBuilder.ioWriteError(e);
            }
            try {
                this.database.readGenericResponse(null);
            }
            catch (IOException e) {
                throw FbExceptionBuilder.ioReadError(e);
            }
        }
    }

    private boolean processSingleEvent() {
        if (this.eventBuffer.remaining() < 20) {
            return false;
        }
        try {
            this.eventBuffer.getInt();
            int bufferLength = this.eventBuffer.getInt();
            int padding = 4 - bufferLength & 3;
            if (this.eventBuffer.remaining() < bufferLength + padding + 12) {
                return false;
            }
            byte[] buffer = new byte[bufferLength];
            this.eventBuffer.get(buffer);
            this.eventBuffer.position(this.eventBuffer.position() + padding);
            int eventCount = 0;
            if (bufferLength > 4) {
                eventCount = VaxEncoding.iscVaxInteger(buffer, bufferLength - 4, 4);
            }
            this.eventBuffer.getLong();
            int eventId = this.eventBuffer.getInt();
            log.log(System.Logger.Level.TRACE, "Received event id {0}, eventCount {1}", eventId, eventCount);
            this.channelListenerDispatcher.eventReceived(this, new AsynchronousChannelListener.Event(eventId, eventCount));
            return true;
        }
        catch (BufferUnderflowException ex) {
            return false;
        }
    }

    private static void traceLogEventBuffer(ByteBuffer eventBuffer) {
        if (log.isLoggable(System.Logger.Level.TRACE)) {
            if (eventBuffer.hasArray()) {
                log.log(System.Logger.Level.TRACE, String.valueOf(eventBuffer) + ": " + ByteArrayHelper.toHexString(eventBuffer.array()).substring(0, 2 * eventBuffer.limit()));
            } else {
                log.log(System.Logger.Level.TRACE, eventBuffer.toString());
            }
        }
    }

    private final class ChannelDatabaseListener
    implements DatabaseListener {
        private ChannelDatabaseListener() {
        }

        @Override
        public void detached(FbDatabase database) {
            try {
                V10AsynchronousChannel.this.close();
            }
            catch (Exception ex) {
                log.log(System.Logger.Level.ERROR, "Exception closing asynchronous channel in response to a FbDatabase detached event", (Throwable)ex);
            }
        }
    }
}

