/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleMultiPhaseArgs {
    int action;
    int nsites;
    Vector dbLinks;
    Vector xids;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    public OracleMultiPhaseArgs() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$9, null, new Object[0]);
            }
            this.action = 0;
            this.nsites = 0;
            this.dbLinks = null;
            this.xids = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$9, null);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$9, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleMultiPhaseArgs(int _action, int _nsites, Vector _xids, Vector _dbLinks) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$10, null, _action, _nsites, _xids, _dbLinks);
            }
            this.action = 0;
            this.nsites = 0;
            this.dbLinks = null;
            this.xids = null;
            if (_nsites <= 1) {
                this.action = 0;
                this.nsites = 0;
                this.dbLinks = null;
                this.xids = null;
                if (bl) {
                    this.debug($$$loggerRef$$$10, Level.FINEST, $$$methodRef$$$10, "OracleMultiPhaseArgs(_, _nsites, _, _): _nsites <= 1");
                }
            } else if (_xids.isEmpty() || _dbLinks.isEmpty() || _dbLinks.size() != _nsites || _xids.size() != 3 * _nsites) {
                if (bl) {
                    this.debug($$$loggerRef$$$10, Level.FINEST, $$$methodRef$$$10, "OracleMultiPhaseArgs(_, _, _, _): invalid parameters");
                }
            } else {
                this.action = _action;
                this.nsites = _nsites;
                this.xids = _xids;
                this.dbLinks = _dbLinks;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$10, null);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleMultiPhaseArgs(byte[] inBytes) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$11, null, new Object[]{inBytes});
            }
            this.action = 0;
            this.nsites = 0;
            this.dbLinks = null;
            this.xids = null;
            if (bl) {
                this.debug($$$loggerRef$$$11, Level.FINEST, $$$methodRef$$$11, "OracleMultiPhaseArgs(inBytes.length = " + inBytes.length + ")");
            }
            ByteArrayInputStream byteArrayIS = new ByteArrayInputStream(inBytes);
            DataInputStream dataIS = new DataInputStream(byteArrayIS);
            this.xids = new Vector();
            this.dbLinks = new Vector();
            try {
                this.action = dataIS.readInt();
                this.nsites = dataIS.readInt();
                int fmtid = dataIS.readInt();
                int gtridLen = dataIS.readInt();
                byte[] gtrid = new byte[gtridLen];
                int gtridRead = dataIS.read(gtrid, 0, gtridLen);
                for (int i2 = 0; i2 < this.nsites; ++i2) {
                    int bqualLen = dataIS.readInt();
                    byte[] bqual = new byte[bqualLen];
                    int bqualRead = dataIS.read(bqual, 0, bqualLen);
                    this.xids.addElement(fmtid);
                    this.xids.addElement(gtrid);
                    this.xids.addElement(bqual);
                    String dblink = dataIS.readUTF();
                    this.dbLinks.addElement(dblink);
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    this.printMPArgs();
                }
                catch (Throwable throwable) {
                    OracleLog.recursiveExit();
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$11, null, throwable2);
                    }
                    throw throwable2;
                }
                OracleLog.recursiveExit();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$11, null, throwable3);
            }
            throw throwable;
        }
    }

    public byte[] toByteArray() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$0, this, new Object[0]);
            }
            byte[] byArray = this.toByteArrayOS().toByteArray();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$0, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$0, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream toByteArrayOS() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$1, this, new Object[0]);
            }
            byte[] gtridCommon = null;
            int fmtidCommon = 0;
            ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
            DataOutputStream dataOS = new DataOutputStream(byteArrayOS);
            try {
                dataOS.writeInt(this.action);
                dataOS.writeInt(this.nsites);
                for (int i2 = 0; i2 < this.nsites; ++i2) {
                    String dblink = (String)this.dbLinks.elementAt(i2);
                    int fmtid = (Integer)this.xids.elementAt(i2 * 3);
                    byte[] gtrid = (byte[])this.xids.elementAt(i2 * 3 + 1);
                    byte[] bqual = (byte[])this.xids.elementAt(i2 * 3 + 2);
                    if (i2 == 0) {
                        fmtidCommon = fmtid;
                        gtridCommon = gtrid;
                        dataOS.writeInt(fmtid);
                        dataOS.writeInt(gtrid.length);
                        dataOS.write(gtrid, 0, gtrid.length);
                    }
                    dataOS.writeInt(bqual.length);
                    dataOS.write(bqual, 0, bqual.length);
                    dataOS.writeUTF(dblink);
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    this.printMPArgs();
                }
                catch (Throwable throwable) {
                    OracleLog.recursiveExit();
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$1, this, throwable2);
                    }
                    throw throwable2;
                }
                OracleLog.recursiveExit();
            }
            ByteArrayOutputStream byteArrayOutputStream = byteArrayOS;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$1, this, byteArrayOutputStream);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$1, this, null);
            }
            return byteArrayOutputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$1, this, throwable3);
            }
            throw throwable;
        }
    }

    public int getAction() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$2, this, new Object[0]);
            }
            int n2 = this.action;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$2, this, n2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$2, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getnsite() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$3, this, new Object[0]);
            }
            int n2 = this.nsites;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$3, this, n2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$3, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    public Vector getdbLinks() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$4, this, new Object[0]);
            }
            Vector vector = this.dbLinks;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$4, this, vector);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$4, this, null);
            }
            return vector;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    public Vector getXids() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$5, this, new Object[0]);
            }
            Vector vector = this.xids;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$5, this, vector);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$5, this, null);
            }
            return vector;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    public void printMPArgs() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$6, this, new Object[0]);
            }
            if (bl) {
                this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "-------printMPArgs entry-------");
            }
            if (bl) {
                this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "  action = " + this.action);
            }
            if (bl) {
                this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "  nsites = " + this.nsites);
            }
            for (int i2 = 0; i2 < this.nsites; ++i2) {
                String dblink = (String)this.dbLinks.elementAt(i2);
                int fmtid = (Integer)this.xids.elementAt(i2 * 3);
                byte[] gtrid = (byte[])this.xids.elementAt(i2 * 3 + 1);
                byte[] bqual = (byte[])this.xids.elementAt(i2 * 3 + 2);
                if (bl) {
                    this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "  fmtid  [" + i2 + "] = " + fmtid);
                }
                if (bl) {
                    this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "  gtrid  [" + i2 + "] = ");
                }
                this.printByteArray(gtrid);
                if (bl) {
                    this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "  bqual  [" + i2 + "] = ");
                }
                this.printByteArray(bqual);
                if (!bl) continue;
                this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "  dblink [" + i2 + "] = " + dblink);
            }
            if (bl) {
                this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "-------printMPArgs return-------");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void printByteArray(byte[] byArray) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void bArray;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$7, this, new Object[]{byArray});
            }
            StringBuffer _buf = new StringBuffer();
            for (int i2 = 0; i2 < ((void)bArray).length; ++i2) {
                _buf.append((int)bArray[i2] + " ");
            }
            if (bl) {
                this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "         " + _buf.toString());
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    private static Logger logger() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$8, null, new Object[0]);
            }
            if (LOGGER == null) {
                LOGGER = Logger.getLogger("oracle.jdbc.xa");
            }
            Logger logger = LOGGER;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$8, null, logger);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$8, null, null);
            }
            return logger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleMultiPhaseArgs.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$11 = OracleMultiPhaseArgs.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleMultiPhaseArgs.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Vector.class, Vector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleMultiPhaseArgs.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleMultiPhaseArgs.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleMultiPhaseArgs.class.getDeclaredMethod("printByteArray", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleMultiPhaseArgs.class.getDeclaredMethod("printMPArgs", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleMultiPhaseArgs.class.getDeclaredMethod("getXids", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleMultiPhaseArgs.class.getDeclaredMethod("getdbLinks", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleMultiPhaseArgs.class.getDeclaredMethod("getnsite", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleMultiPhaseArgs.class.getDeclaredMethod("getAction", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleMultiPhaseArgs.class.getDeclaredMethod("toByteArrayOS", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleMultiPhaseArgs.class.getDeclaredMethod("toByteArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.OracleMultiPhaseArgs"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

