/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.modules.StructModuleBuiltins;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.struct.PStruct;
import com.oracle.graal.python.builtins.objects.struct.StructBuiltins;
import com.oracle.graal.python.builtins.objects.struct.StructBuiltinsFactory;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TruffleWeakReference;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@GeneratedBy(value=StructModuleBuiltins.class)
public final class StructModuleBuiltinsFactory {
    private static final LibraryFactory<PythonBufferAccessLibrary> PYTHON_BUFFER_ACCESS_LIBRARY_ = LibraryFactory.resolve(PythonBufferAccessLibrary.class);

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(PackNodeFactory.getInstance(), PackIntoNodeFactory.getInstance(), UnpackNodeFactory.getInstance(), IterUnpackNodeFactory.getInstance(), UnpackFromNodeFactory.getInstance(), CalcSizeNodeFactory.getInstance(), ClearCacheNodeFactory.getInstance());
    }

    @GeneratedBy(value=StructModuleBuiltins.PackNode.class)
    static final class PackNodeFactory
    implements NodeFactory<StructModuleBuiltins.PackNode> {
        private static final PackNodeFactory PACK_NODE_FACTORY_INSTANCE = new PackNodeFactory();

        private PackNodeFactory() {
        }

        public Class<StructModuleBuiltins.PackNode> getNodeClass() {
            return StructModuleBuiltins.PackNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        public StructModuleBuiltins.PackNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return PackNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<StructModuleBuiltins.PackNode> getInstance() {
            return PACK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StructModuleBuiltins.PackNode create(ReadArgumentNode[] arguments) {
            return new PackNodeGen(arguments);
        }

        @GeneratedBy(value=StructModuleBuiltins.PackNode.class)
        static final class PackNodeGen
        extends StructModuleBuiltins.PackNode {
            private static final InlineSupport.StateField STATE_0_PackNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final StructModuleBuiltins.GetStructNode INLINED_GET_STRUCT_NODE_ = GetStructNodeGen.inline(InlineSupport.InlineTarget.create(StructModuleBuiltins.GetStructNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_PackNode_UPDATER.subUpdater(1, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getStructNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getStructNode__field2_", Node.class)}));
            @Node.Child
            private ReadArgumentNode arguments0_;
            @Node.Child
            private ReadArgumentNode arguments1_;
            @Node.Child
            private ReadArgumentNode arguments2_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private StructBuiltins.ConstructStructNode constructStructNode_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getStructNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getStructNode__field2_;
            @Node.Child
            private StructBuiltins.StructPackNode structPackNode_;

            private PackNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                if ((state_0 & 1) != 0 && arguments0Value_ instanceof PythonModule) {
                    PythonModule arguments0Value__ = (PythonModule)arguments0Value_;
                    if (arguments2Value_ instanceof Object[]) {
                        StructBuiltins.StructPackNode structPackNode__;
                        Object[] arguments2Value__ = (Object[])arguments2Value_;
                        StructBuiltins.ConstructStructNode constructStructNode__ = this.constructStructNode_;
                        if (constructStructNode__ != null && (structPackNode__ = this.structPackNode_) != null) {
                            PackNodeGen inliningTarget__ = this;
                            return StructModuleBuiltins.PackNode.pack(frameValue, arguments0Value__, arguments1Value_, arguments2Value__, inliningTarget__, constructStructNode__, INLINED_GET_STRUCT_NODE_, structPackNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                int state_0 = this.state_0_;
                PackNodeGen inliningTarget__ = null;
                if (arguments0Value instanceof PythonModule) {
                    PythonModule arguments0Value_ = (PythonModule)arguments0Value;
                    if (arguments2Value instanceof Object[]) {
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        inliningTarget__ = this;
                        StructBuiltins.ConstructStructNode constructStructNode__ = (StructBuiltins.ConstructStructNode)this.insert(StructBuiltinsFactory.ConstructStructNodeFactory.create());
                        Objects.requireNonNull(constructStructNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.constructStructNode_ = constructStructNode__;
                        StructBuiltins.StructPackNode structPackNode__ = (StructBuiltins.StructPackNode)this.insert(StructBuiltinsFactory.StructPackNodeFactory.create());
                        Objects.requireNonNull(structPackNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.structPackNode_ = structPackNode__;
                        this.state_0_ = state_0 |= 1;
                        return StructModuleBuiltins.PackNode.pack(frameValue, arguments0Value_, arguments1Value, arguments2Value_, inliningTarget__, constructStructNode__, INLINED_GET_STRUCT_NODE_, structPackNode__);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
            }
        }
    }

    @GeneratedBy(value=StructModuleBuiltins.PackIntoNode.class)
    static final class PackIntoNodeFactory
    implements NodeFactory<StructModuleBuiltins.PackIntoNode> {
        private static final PackIntoNodeFactory PACK_INTO_NODE_FACTORY_INSTANCE = new PackIntoNodeFactory();

        private PackIntoNodeFactory() {
        }

        public Class<StructModuleBuiltins.PackIntoNode> getNodeClass() {
            return StructModuleBuiltins.PackIntoNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        public StructModuleBuiltins.PackIntoNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return PackIntoNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<StructModuleBuiltins.PackIntoNode> getInstance() {
            return PACK_INTO_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StructModuleBuiltins.PackIntoNode create(ReadArgumentNode[] arguments) {
            return new PackIntoNodeGen(arguments);
        }

        @GeneratedBy(value=StructModuleBuiltins.PackIntoNode.class)
        static final class PackIntoNodeGen
        extends StructModuleBuiltins.PackIntoNode {
            private static final InlineSupport.StateField STATE_0_PackIntoNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final StructModuleBuiltins.GetStructNode INLINED_GET_STRUCT_NODE_ = GetStructNodeGen.inline(InlineSupport.InlineTarget.create(StructModuleBuiltins.GetStructNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_PackIntoNode_UPDATER.subUpdater(1, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getStructNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getStructNode__field2_", Node.class)}));
            @Node.Child
            private ReadArgumentNode arguments0_;
            @Node.Child
            private ReadArgumentNode arguments1_;
            @Node.Child
            private ReadArgumentNode arguments2_;
            @Node.Child
            private ReadArgumentNode arguments3_;
            @Node.Child
            private ReadArgumentNode arguments4_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private StructBuiltins.ConstructStructNode constructStructNode_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getStructNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getStructNode__field2_;
            @Node.Child
            private StructBuiltins.StructPackIntoNode structPackNode_;

            private PackIntoNodeGen(ReadArgumentNode[] arguments) {
                ReadArgumentNode[] arguments_ = arguments != null ? this.createCasts(arguments) : null;
                this.arguments0_ = arguments_ != null && 0 < arguments_.length ? arguments_[0] : null;
                this.arguments1_ = arguments_ != null && 1 < arguments_.length ? arguments_[1] : null;
                this.arguments2_ = arguments_ != null && 2 < arguments_.length ? arguments_[2] : null;
                this.arguments3_ = arguments_ != null && 3 < arguments_.length ? arguments_[3] : null;
                this.arguments4_ = arguments_ != null && 4 < arguments_.length ? arguments_[4] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                Object arguments3Value_ = this.arguments3_.execute(frameValue);
                Object arguments4Value_ = this.arguments4_.execute(frameValue);
                if ((state_0 & 1) != 0 && arguments0Value_ instanceof PythonModule) {
                    PythonModule arguments0Value__ = (PythonModule)arguments0Value_;
                    if (arguments3Value_ instanceof Integer) {
                        int arguments3Value__ = (Integer)arguments3Value_;
                        if (arguments4Value_ instanceof Object[]) {
                            StructBuiltins.StructPackIntoNode structPackNode__;
                            Object[] arguments4Value__ = (Object[])arguments4Value_;
                            StructBuiltins.ConstructStructNode constructStructNode__ = this.constructStructNode_;
                            if (constructStructNode__ != null && (structPackNode__ = this.structPackNode_) != null) {
                                PackIntoNodeGen inliningTarget__ = this;
                                return StructModuleBuiltins.PackIntoNode.packInto(frameValue, arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value__, arguments4Value__, inliningTarget__, constructStructNode__, INLINED_GET_STRUCT_NODE_, structPackNode__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, arguments4Value_);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                int state_0 = this.state_0_;
                PackIntoNodeGen inliningTarget__ = null;
                if (arguments0Value instanceof PythonModule) {
                    PythonModule arguments0Value_ = (PythonModule)arguments0Value;
                    if (arguments3Value instanceof Integer) {
                        int arguments3Value_ = (Integer)arguments3Value;
                        if (arguments4Value instanceof Object[]) {
                            Object[] arguments4Value_ = (Object[])arguments4Value;
                            inliningTarget__ = this;
                            StructBuiltins.ConstructStructNode constructStructNode__ = (StructBuiltins.ConstructStructNode)this.insert(StructBuiltinsFactory.ConstructStructNodeFactory.create());
                            Objects.requireNonNull(constructStructNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            VarHandle.storeStoreFence();
                            this.constructStructNode_ = constructStructNode__;
                            StructBuiltins.StructPackIntoNode structPackNode__ = (StructBuiltins.StructPackIntoNode)this.insert(StructBuiltins.StructPackIntoNode.create());
                            Objects.requireNonNull(structPackNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            VarHandle.storeStoreFence();
                            this.structPackNode_ = structPackNode__;
                            this.state_0_ = state_0 |= 1;
                            return StructModuleBuiltins.PackIntoNode.packInto(frameValue, arguments0Value_, arguments1Value, arguments2Value, arguments3Value_, arguments4Value_, inliningTarget__, constructStructNode__, INLINED_GET_STRUCT_NODE_, structPackNode__);
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_, this.arguments4_}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value});
            }
        }
    }

    @GeneratedBy(value=StructModuleBuiltins.UnpackNode.class)
    static final class UnpackNodeFactory
    implements NodeFactory<StructModuleBuiltins.UnpackNode> {
        private static final UnpackNodeFactory UNPACK_NODE_FACTORY_INSTANCE = new UnpackNodeFactory();

        private UnpackNodeFactory() {
        }

        public Class<StructModuleBuiltins.UnpackNode> getNodeClass() {
            return StructModuleBuiltins.UnpackNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public StructModuleBuiltins.UnpackNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return UnpackNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<StructModuleBuiltins.UnpackNode> getInstance() {
            return UNPACK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StructModuleBuiltins.UnpackNode create() {
            return new UnpackNodeGen();
        }

        @GeneratedBy(value=StructModuleBuiltins.UnpackNode.class)
        static final class UnpackNodeGen
        extends StructModuleBuiltins.UnpackNode {
            private static final InlineSupport.StateField STATE_0_UnpackNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final StructModuleBuiltins.GetStructNode INLINED_GET_STRUCT_NODE_ = GetStructNodeGen.inline(InlineSupport.InlineTarget.create(StructModuleBuiltins.GetStructNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UnpackNode_UPDATER.subUpdater(1, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getStructNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getStructNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getStructNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getStructNode__field2_;
            @Node.Child
            private StructBuiltins.ConstructStructNode constructStructNode_;
            @Node.Child
            private StructBuiltins.StructUnpackNode structUnpackNode_;

            private UnpackNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && arg0Value instanceof PythonModule) {
                    StructBuiltins.StructUnpackNode structUnpackNode__;
                    PythonModule arg0Value_ = (PythonModule)arg0Value;
                    StructBuiltins.ConstructStructNode constructStructNode__ = this.constructStructNode_;
                    if (constructStructNode__ != null && (structUnpackNode__ = this.structUnpackNode_) != null) {
                        UnpackNodeGen inliningTarget__ = this;
                        return StructModuleBuiltins.UnpackNode.unpack(frameValue, arg0Value_, arg1Value, arg2Value, inliningTarget__, INLINED_GET_STRUCT_NODE_, constructStructNode__, structUnpackNode__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                UnpackNodeGen inliningTarget__ = null;
                if (arg0Value instanceof PythonModule) {
                    PythonModule arg0Value_ = (PythonModule)arg0Value;
                    inliningTarget__ = this;
                    StructBuiltins.ConstructStructNode constructStructNode__ = (StructBuiltins.ConstructStructNode)this.insert(StructBuiltinsFactory.ConstructStructNodeFactory.create());
                    Objects.requireNonNull(constructStructNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.constructStructNode_ = constructStructNode__;
                    StructBuiltins.StructUnpackNode structUnpackNode__ = (StructBuiltins.StructUnpackNode)this.insert(StructBuiltinsFactory.StructUnpackNodeFactory.create());
                    Objects.requireNonNull(structUnpackNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.structUnpackNode_ = structUnpackNode__;
                    this.state_0_ = state_0 |= 1;
                    return StructModuleBuiltins.UnpackNode.unpack(frameValue, arg0Value_, arg1Value, arg2Value, inliningTarget__, INLINED_GET_STRUCT_NODE_, constructStructNode__, structUnpackNode__);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value});
            }
        }
    }

    @GeneratedBy(value=StructModuleBuiltins.IterUnpackNode.class)
    static final class IterUnpackNodeFactory
    implements NodeFactory<StructModuleBuiltins.IterUnpackNode> {
        private static final IterUnpackNodeFactory ITER_UNPACK_NODE_FACTORY_INSTANCE = new IterUnpackNodeFactory();

        private IterUnpackNodeFactory() {
        }

        public Class<StructModuleBuiltins.IterUnpackNode> getNodeClass() {
            return StructModuleBuiltins.IterUnpackNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public StructModuleBuiltins.IterUnpackNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return IterUnpackNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<StructModuleBuiltins.IterUnpackNode> getInstance() {
            return ITER_UNPACK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StructModuleBuiltins.IterUnpackNode create() {
            return new IterUnpackNodeGen();
        }

        @GeneratedBy(value=StructModuleBuiltins.IterUnpackNode.class)
        static final class IterUnpackNodeGen
        extends StructModuleBuiltins.IterUnpackNode {
            private static final InlineSupport.StateField STATE_0_IterUnpackNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final StructModuleBuiltins.GetStructNode INLINED_GET_STRUCT_NODE_ = GetStructNodeGen.inline(InlineSupport.InlineTarget.create(StructModuleBuiltins.GetStructNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_IterUnpackNode_UPDATER.subUpdater(1, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getStructNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getStructNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private StructBuiltins.ConstructStructNode constructStructNode_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getStructNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getStructNode__field2_;
            @Node.Child
            private StructBuiltins.StructIterUnpackNode iterUnpackNode_;

            private IterUnpackNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && arg0Value instanceof PythonModule) {
                    StructBuiltins.StructIterUnpackNode iterUnpackNode__;
                    PythonModule arg0Value_ = (PythonModule)arg0Value;
                    StructBuiltins.ConstructStructNode constructStructNode__ = this.constructStructNode_;
                    if (constructStructNode__ != null && (iterUnpackNode__ = this.iterUnpackNode_) != null) {
                        IterUnpackNodeGen inliningTarget__ = this;
                        return StructModuleBuiltins.IterUnpackNode.iterUnpack(frameValue, arg0Value_, arg1Value, arg2Value, inliningTarget__, constructStructNode__, INLINED_GET_STRUCT_NODE_, iterUnpackNode__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                IterUnpackNodeGen inliningTarget__ = null;
                if (arg0Value instanceof PythonModule) {
                    PythonModule arg0Value_ = (PythonModule)arg0Value;
                    inliningTarget__ = this;
                    StructBuiltins.ConstructStructNode constructStructNode__ = (StructBuiltins.ConstructStructNode)this.insert(StructBuiltinsFactory.ConstructStructNodeFactory.create());
                    Objects.requireNonNull(constructStructNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.constructStructNode_ = constructStructNode__;
                    StructBuiltins.StructIterUnpackNode iterUnpackNode__ = (StructBuiltins.StructIterUnpackNode)this.insert(StructBuiltinsFactory.StructIterUnpackNodeFactory.create());
                    Objects.requireNonNull(iterUnpackNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.iterUnpackNode_ = iterUnpackNode__;
                    this.state_0_ = state_0 |= 1;
                    return StructModuleBuiltins.IterUnpackNode.iterUnpack(frameValue, arg0Value_, arg1Value, arg2Value, inliningTarget__, constructStructNode__, INLINED_GET_STRUCT_NODE_, iterUnpackNode__);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value});
            }
        }
    }

    @GeneratedBy(value=StructModuleBuiltins.UnpackFromNode.class)
    static final class UnpackFromNodeFactory
    implements NodeFactory<StructModuleBuiltins.UnpackFromNode> {
        private static final UnpackFromNodeFactory UNPACK_FROM_NODE_FACTORY_INSTANCE = new UnpackFromNodeFactory();

        private UnpackFromNodeFactory() {
        }

        public Class<StructModuleBuiltins.UnpackFromNode> getNodeClass() {
            return StructModuleBuiltins.UnpackFromNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public StructModuleBuiltins.UnpackFromNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return UnpackFromNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<StructModuleBuiltins.UnpackFromNode> getInstance() {
            return UNPACK_FROM_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StructModuleBuiltins.UnpackFromNode create() {
            return new UnpackFromNodeGen();
        }

        @GeneratedBy(value=StructModuleBuiltins.UnpackFromNode.class)
        static final class UnpackFromNodeGen
        extends StructModuleBuiltins.UnpackFromNode {
            private static final InlineSupport.StateField STATE_0_UnpackFromNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final StructModuleBuiltins.GetStructNode INLINED_GET_STRUCT_NODE_ = GetStructNodeGen.inline(InlineSupport.InlineTarget.create(StructModuleBuiltins.GetStructNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UnpackFromNode_UPDATER.subUpdater(1, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getStructNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getStructNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private StructBuiltins.ConstructStructNode constructStructNode_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getStructNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getStructNode__field2_;
            @Node.Child
            private StructBuiltins.StructUnpackFromNode structUnpackNode_;

            private UnpackFromNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value, Object arg3Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && arg0Value instanceof PythonModule) {
                    PythonModule arg0Value_ = (PythonModule)arg0Value;
                    if (arg3Value instanceof Integer) {
                        StructBuiltins.StructUnpackFromNode structUnpackNode__;
                        int arg3Value_ = (Integer)arg3Value;
                        StructBuiltins.ConstructStructNode constructStructNode__ = this.constructStructNode_;
                        if (constructStructNode__ != null && (structUnpackNode__ = this.structUnpackNode_) != null) {
                            UnpackFromNodeGen inliningTarget__ = this;
                            return StructModuleBuiltins.UnpackFromNode.unpackFrom(frameValue, arg0Value_, arg1Value, arg2Value, arg3Value_, inliningTarget__, constructStructNode__, INLINED_GET_STRUCT_NODE_, structUnpackNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value, Object arg3Value) {
                int state_0 = this.state_0_;
                UnpackFromNodeGen inliningTarget__ = null;
                if (arg0Value instanceof PythonModule) {
                    PythonModule arg0Value_ = (PythonModule)arg0Value;
                    if (arg3Value instanceof Integer) {
                        int arg3Value_ = (Integer)arg3Value;
                        inliningTarget__ = this;
                        StructBuiltins.ConstructStructNode constructStructNode__ = (StructBuiltins.ConstructStructNode)this.insert(StructBuiltinsFactory.ConstructStructNodeFactory.create());
                        Objects.requireNonNull(constructStructNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.constructStructNode_ = constructStructNode__;
                        StructBuiltins.StructUnpackFromNode structUnpackNode__ = (StructBuiltins.StructUnpackFromNode)this.insert(StructBuiltinsFactory.StructUnpackFromNodeFactory.create());
                        Objects.requireNonNull(structUnpackNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.structUnpackNode_ = structUnpackNode__;
                        this.state_0_ = state_0 |= 1;
                        return StructModuleBuiltins.UnpackFromNode.unpackFrom(frameValue, arg0Value_, arg1Value, arg2Value, arg3Value_, inliningTarget__, constructStructNode__, INLINED_GET_STRUCT_NODE_, structUnpackNode__);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
            }
        }
    }

    @GeneratedBy(value=StructModuleBuiltins.CalcSizeNode.class)
    static final class CalcSizeNodeFactory
    implements NodeFactory<StructModuleBuiltins.CalcSizeNode> {
        private static final CalcSizeNodeFactory CALC_SIZE_NODE_FACTORY_INSTANCE = new CalcSizeNodeFactory();

        private CalcSizeNodeFactory() {
        }

        public Class<StructModuleBuiltins.CalcSizeNode> getNodeClass() {
            return StructModuleBuiltins.CalcSizeNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public StructModuleBuiltins.CalcSizeNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return CalcSizeNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<StructModuleBuiltins.CalcSizeNode> getInstance() {
            return CALC_SIZE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StructModuleBuiltins.CalcSizeNode create() {
            return new CalcSizeNodeGen();
        }

        @GeneratedBy(value=StructModuleBuiltins.CalcSizeNode.class)
        static final class CalcSizeNodeGen
        extends StructModuleBuiltins.CalcSizeNode {
            private static final InlineSupport.StateField STATE_0_CalcSizeNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final StructModuleBuiltins.GetStructNode INLINED_GET_STRUCT_NODE_ = GetStructNodeGen.inline(InlineSupport.InlineTarget.create(StructModuleBuiltins.GetStructNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_CalcSizeNode_UPDATER.subUpdater(1, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getStructNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getStructNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private StructBuiltins.ConstructStructNode constructStructNode_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getStructNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getStructNode__field2_;

            private CalcSizeNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && arg0Value instanceof PythonModule) {
                    PythonModule arg0Value_ = (PythonModule)arg0Value;
                    StructBuiltins.ConstructStructNode constructStructNode__ = this.constructStructNode_;
                    if (constructStructNode__ != null) {
                        CalcSizeNodeGen inliningTarget__ = this;
                        return StructModuleBuiltins.CalcSizeNode.calcSize(arg0Value_, arg1Value, inliningTarget__, constructStructNode__, INLINED_GET_STRUCT_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                CalcSizeNodeGen inliningTarget__ = null;
                if (arg0Value instanceof PythonModule) {
                    PythonModule arg0Value_ = (PythonModule)arg0Value;
                    inliningTarget__ = this;
                    StructBuiltins.ConstructStructNode constructStructNode__ = (StructBuiltins.ConstructStructNode)this.insert(StructBuiltinsFactory.ConstructStructNodeFactory.create());
                    Objects.requireNonNull(constructStructNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.constructStructNode_ = constructStructNode__;
                    this.state_0_ = state_0 |= 1;
                    return StructModuleBuiltins.CalcSizeNode.calcSize(arg0Value_, arg1Value, inliningTarget__, constructStructNode__, INLINED_GET_STRUCT_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value});
            }
        }
    }

    @GeneratedBy(value=StructModuleBuiltins.ClearCacheNode.class)
    static final class ClearCacheNodeFactory
    implements NodeFactory<StructModuleBuiltins.ClearCacheNode> {
        private static final ClearCacheNodeFactory CLEAR_CACHE_NODE_FACTORY_INSTANCE = new ClearCacheNodeFactory();

        private ClearCacheNodeFactory() {
        }

        public Class<StructModuleBuiltins.ClearCacheNode> getNodeClass() {
            return StructModuleBuiltins.ClearCacheNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public StructModuleBuiltins.ClearCacheNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ClearCacheNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<StructModuleBuiltins.ClearCacheNode> getInstance() {
            return CLEAR_CACHE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StructModuleBuiltins.ClearCacheNode create() {
            return new ClearCacheNodeGen();
        }

        @GeneratedBy(value=StructModuleBuiltins.ClearCacheNode.class)
        static final class ClearCacheNodeGen
        extends StructModuleBuiltins.ClearCacheNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ClearCacheNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 && arg0Value instanceof PythonModule) {
                    PythonModule arg0Value_ = (PythonModule)arg0Value;
                    return this.clearCache(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PythonModule) {
                    PythonModule arg0Value_ = (PythonModule)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.clearCache(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }

    @GeneratedBy(value=StructModuleBuiltins.GetStructNode.class)
    static final class GetStructNodeGen {
        GetStructNodeGen() {
        }

        @NeverDefault
        public static StructModuleBuiltins.GetStructNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=3, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=StructModuleBuiltins.GetStructNode.class)
        @DenyReplace
        private static final class Inlined
        extends StructModuleBuiltins.GetStructNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<CachedStringData> cachedString_cache;
            private final InlineSupport.ReferenceField<CachedBytesData> cachedBytes_cache;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(StructModuleBuiltins.GetStructNode.class));
                this.state_0_ = target.getState(0, 3);
                this.cachedString_cache = target.getReference(1, CachedStringData.class);
                this.cachedBytes_cache = target.getReference(2, CachedBytesData.class);
            }

            @Override
            PStruct execute(Node arg0Value, PythonModule arg1Value, Object arg2Value, StructBuiltins.ConstructStructNode arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    Object arg2Value_;
                    if ((state_0 & 1) != 0 && arg2Value instanceof TruffleString) {
                        arg2Value_ = (TruffleString)arg2Value;
                        CachedStringData s0_ = (CachedStringData)((Object)this.cachedString_cache.get(arg0Value));
                        if (s0_ != null) {
                            PStruct cachedStruct__;
                            assert (DSLSupport.assertIdempotence((boolean)this.isSingleContext()));
                            if (this.eq((TruffleString)arg2Value_, s0_.cachedFormat_, s0_.eqNode_) && (cachedStruct__ = (PStruct)s0_.weakCachedStructGen__.get()) != null) {
                                return StructModuleBuiltins.GetStructNode.doCachedString(arg1Value, arg2Value_, arg3Value, s0_.cachedFormat_, s0_.eqNode_, cachedStruct__);
                            }
                        }
                    }
                    if ((state_0 & 4) != 0 && arg2Value instanceof PBytes) {
                        arg2Value_ = (PBytes)arg2Value;
                        CachedBytesData s1_ = (CachedBytesData)((Object)this.cachedBytes_cache.get(arg0Value));
                        if (s1_ != null && s1_.bufferLib_.accepts(arg2Value_)) {
                            PStruct cachedStruct__1;
                            assert (DSLSupport.assertIdempotence((boolean)this.isSingleContext()));
                            if (Arrays.equals(s1_.bufferLib_.getCopiedByteArray(arg2Value_), s1_.cachedFormat_) && (cachedStruct__1 = (PStruct)s1_.weakCachedStructGen__.get()) != null) {
                                return StructModuleBuiltins.GetStructNode.doCachedBytes(arg1Value, (PBytes)arg2Value_, arg3Value, s1_.bufferLib_, s1_.cachedFormat_, cachedStruct__1);
                            }
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        return StructModuleBuiltins.GetStructNode.doGeneric(arg1Value, arg2Value, arg3Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private PStruct executeAndSpecialize(Node arg0Value, PythonModule arg1Value, Object arg2Value, StructBuiltins.ConstructStructNode arg3Value) {
                block15: {
                    CachedBytesData s1_;
                    PStruct cachedStruct__1;
                    Object arg2Value_;
                    block14: {
                        CachedBytesData s1_original;
                        int state_0 = this.state_0_.get(arg0Value);
                        PStruct cachedStruct__ = null;
                        if ((state_0 & 2) == 0 && arg2Value instanceof TruffleString) {
                            CachedStringData s0_;
                            block13: {
                                CachedStringData s0_original;
                                arg2Value_ = (TruffleString)arg2Value;
                                do {
                                    TruffleWeakReference weakCachedStructGen___;
                                    TruffleString.EqualNode eqNode__;
                                    Object cachedFormat__;
                                    int count0_ = 0;
                                    s0_original = s0_ = (CachedStringData)((Object)this.cachedString_cache.getVolatile(arg0Value));
                                    if (s0_ != null) {
                                        assert (DSLSupport.assertIdempotence((boolean)this.isSingleContext()));
                                        if (!this.eq((TruffleString)arg2Value_, s0_.cachedFormat_, s0_.eqNode_) || (cachedStruct__ = (PStruct)s0_.weakCachedStructGen__.get()) == null) {
                                            ++count0_;
                                            s0_ = null;
                                        }
                                    }
                                    if (s0_ != null || count0_ >= true || !this.isSingleContext() || !this.eq((TruffleString)arg2Value_, (TruffleString)(cachedFormat__ = arg2Value_), eqNode__ = (TruffleString.EqualNode)arg0Value.insert((Node)TruffleString.EqualNode.create())) || (cachedStruct__ = (PStruct)(weakCachedStructGen___ = new TruffleWeakReference((Object)this.getStructInternal(arg1Value, arg2Value_, arg3Value))).get()) == null) break block13;
                                    s0_ = (CachedStringData)arg0Value.insert((Node)new CachedStringData());
                                    s0_.weakCachedStructGen__ = weakCachedStructGen___;
                                    s0_.cachedFormat_ = cachedFormat__;
                                    Objects.requireNonNull((TruffleString.EqualNode)s0_.insert((Node)eqNode__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.eqNode_ = eqNode__;
                                } while (!this.cachedString_cache.compareAndSet(arg0Value, (Object)s0_original, (Object)s0_));
                                this.state_0_.set(arg0Value, state_0 |= 1);
                            }
                            if (s0_ != null) {
                                return StructModuleBuiltins.GetStructNode.doCachedString(arg1Value, arg2Value_, arg3Value, s0_.cachedFormat_, s0_.eqNode_, cachedStruct__);
                            }
                        }
                        cachedStruct__1 = null;
                        if ((state_0 & 2) != 0 || !(arg2Value instanceof PBytes)) break block15;
                        arg2Value_ = (PBytes)arg2Value;
                        do {
                            TruffleWeakReference weakCachedStructGen___1;
                            int count1_;
                            block16: {
                                block17: {
                                    count1_ = 0;
                                    s1_original = s1_ = (CachedBytesData)((Object)this.cachedBytes_cache.getVolatile(arg0Value));
                                    if (s1_ == null) break block16;
                                    if (!s1_.bufferLib_.accepts(arg2Value_)) break block17;
                                    assert (DSLSupport.assertIdempotence((boolean)this.isSingleContext()));
                                    if (Arrays.equals(s1_.bufferLib_.getCopiedByteArray(arg2Value_), s1_.cachedFormat_) && (cachedStruct__1 = (PStruct)s1_.weakCachedStructGen__.get()) != null) break block16;
                                }
                                ++count1_;
                                s1_ = null;
                            }
                            if (s1_ != null || count1_ >= true || !this.isSingleContext()) break block14;
                            PythonBufferAccessLibrary bufferLib__ = (PythonBufferAccessLibrary)arg0Value.insert((Node)((PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.create(arg2Value_)));
                            byte[] cachedFormat__1 = bufferLib__.getCopiedByteArray(arg2Value_);
                            if (!Arrays.equals(bufferLib__.getCopiedByteArray(arg2Value_), cachedFormat__1) || (cachedStruct__1 = (PStruct)(weakCachedStructGen___1 = new TruffleWeakReference((Object)this.getStructInternal(arg1Value, arg2Value_, arg3Value))).get()) == null) break block14;
                            s1_ = (CachedBytesData)arg0Value.insert((Node)new CachedBytesData());
                            s1_.weakCachedStructGen__ = weakCachedStructGen___1;
                            Objects.requireNonNull((PythonBufferAccessLibrary)s1_.insert((Node)bufferLib__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s1_.bufferLib_ = bufferLib__;
                            s1_.cachedFormat_ = cachedFormat__1;
                        } while (!this.cachedBytes_cache.compareAndSet(arg0Value, (Object)s1_original, (Object)s1_));
                        this.state_0_.set(arg0Value, state_0 |= 4);
                    }
                    if (s1_ != null) {
                        return StructModuleBuiltins.GetStructNode.doCachedBytes(arg1Value, (PBytes)arg2Value_, arg3Value, s1_.bufferLib_, s1_.cachedFormat_, cachedStruct__1);
                    }
                }
                this.cachedString_cache.set(arg0Value, null);
                this.cachedBytes_cache.set(arg0Value, null);
                state_0 &= 0xFFFFFFFA;
                this.state_0_.set(arg0Value, state_0 |= 2);
                return StructModuleBuiltins.GetStructNode.doGeneric(arg1Value, arg2Value, arg3Value);
            }
        }

        @GeneratedBy(value=StructModuleBuiltins.GetStructNode.class)
        @DenyReplace
        private static final class CachedBytesData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            TruffleWeakReference<PStruct> weakCachedStructGen__;
            @Node.Child
            PythonBufferAccessLibrary bufferLib_;
            @CompilerDirectives.CompilationFinal(dimensions=1)
            byte[] cachedFormat_;

            CachedBytesData() {
            }
        }

        @GeneratedBy(value=StructModuleBuiltins.GetStructNode.class)
        @DenyReplace
        private static final class CachedStringData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            TruffleWeakReference<PStruct> weakCachedStructGen__;
            @CompilerDirectives.CompilationFinal
            TruffleString cachedFormat_;
            @Node.Child
            TruffleString.EqualNode eqNode_;

            CachedStringData() {
            }
        }
    }
}

