/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.multiprocessing;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.multiprocessing.PSemLock;
import com.oracle.graal.python.builtins.modules.multiprocessing.SemLockBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.multiprocessing.SemLockBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.multiprocessing.SemLockBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.thread.PThread;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PSemLock})
public class SemLockBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = SemLockBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SemLockBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant("SEM_VALUE_MAX", (Object)(PosixConstants.SEM_VALUE_MAX.defined ? PosixConstants.SEM_VALUE_MAX.getValueIfDefined() : Integer.MAX_VALUE));
        super.initialize(core);
    }

    @Builtin(name="_rebuild", parameterNames={"$cls", "handle", "kind", "maxvalue", "name"}, isClassmethod=true)
    @ArgumentsClinic(value={@ArgumentClinic(name="handle", conversion=ArgumentClinic.ClinicConversion.Long), @ArgumentClinic(name="kind", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="maxvalue", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)})
    @GenerateNodeFactory
    static abstract class RebuildNode
    extends PythonClinicBuiltinNode {
        RebuildNode() {
        }

        @Specialization
        static Object rebuild(VirtualFrame frame, Object cls, long origHandle, int kind, int maxValue, TruffleString name, @Bind Node inliningTarget, @Bind(value="getPosixSupport()") PosixSupport posixSupport, @CachedLibrary(value="posixSupport") PosixSupportLibrary posixLib, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            long handle;
            Object posixName = posixLib.createPathFromString(posixSupport, name);
            try {
                handle = posixLib.semOpen(posixSupport, posixName);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PFactory.createSemLock(language, cls, getInstanceShape.execute(cls), handle, kind, maxValue, name);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SemLockBuiltinsClinicProviders.RebuildNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="_after_fork", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AfterForkNode
    extends PythonUnaryBuiltinNode {
        AfterForkNode() {
        }

        @Specialization
        static Object afterFork(PSemLock self) {
            self.setCount(0);
            return PNone.NONE;
        }
    }

    @Builtin(name="_is_zero", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsZeroNode
    extends PythonUnaryBuiltinNode {
        IsZeroNode() {
        }

        @Specialization
        static boolean get(VirtualFrame frame, PSemLock self, @Bind Node inliningTarget, @Bind(value="getPosixSupport()") PosixSupport posixSupport, @CachedLibrary(value="posixSupport") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                try {
                    return posixLib.semGetValue(posixSupport, self.getHandle()) == 0;
                }
                catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                    if (posixLib.semTryWait(posixSupport, self.getHandle())) {
                        posixLib.semPost(posixSupport, self.getHandle());
                        return false;
                    }
                    return true;
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="_get_value", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetValueNode
    extends PythonUnaryBuiltinNode {
        GetValueNode() {
        }

        @Specialization
        int get(VirtualFrame frame, PSemLock self, @Bind Node inliningTarget, @Bind(value="getPosixSupport()") PosixSupport posixSupport, @CachedLibrary(value="posixSupport") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            try {
                int sval = posixLib.semGetValue(posixSupport, self.getHandle());
                if (sval < 0) {
                    sval = 0;
                }
                return sval;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.NotImplementedError);
            }
        }
    }

    @Builtin(name="_is_mine", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsMineNode
    extends PythonUnaryBuiltinNode {
        IsMineNode() {
        }

        @Specialization
        static boolean get(PSemLock self) {
            return self.isMine();
        }
    }

    @Builtin(name="_count", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CountNode
    extends PythonUnaryBuiltinNode {
        CountNode() {
        }

        @Specialization
        static Object get(PSemLock self) {
            return self.getCount();
        }
    }

    @Builtin(name="__exit__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=4)
    @GenerateNodeFactory
    static abstract class ExitNode
    extends PythonQuaternaryBuiltinNode {
        ExitNode() {
        }

        @Specialization
        static Object exit(VirtualFrame frame, PSemLock self, Object type, Object value, Object traceback, @Cached ReleaseNode releaseNode) {
            return releaseNode.execute(frame, self);
        }
    }

    @Builtin(name="__enter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class EnterNode
    extends PythonUnaryBuiltinNode {
        EnterNode() {
        }

        @Specialization
        static Object enter(VirtualFrame frame, PSemLock self, @Cached AcquireNode acquireNode) {
            return acquireNode.execute(frame, self, true, PNone.NO_VALUE);
        }
    }

    @Builtin(name="release", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReleaseNode
    extends PythonUnaryBuiltinNode {
        ReleaseNode() {
        }

        @Specialization
        static PNone release(VirtualFrame frame, PSemLock self, @Bind Node inliningTarget, @Bind(value="getPosixSupport()") PosixSupport posixSupport, @CachedLibrary(value="posixSupport") PosixSupportLibrary posixLib, @Cached PRaiseNode raiseNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            if (self.getKind() == 0) {
                if (!self.isMine()) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.AssertionError, ErrorMessages.ATTEMP_TO_RELEASE_RECURSIVE_LOCK);
                }
                if (self.getCount() > 1) {
                    self.decreaseCount();
                    return PNone.NONE;
                }
            } else {
                try {
                    try {
                        int sval = posixLib.semGetValue(posixSupport, self.getHandle());
                        if (sval >= self.getMaxValue()) {
                            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.SEMAPHORE_RELEASED_TOO_MANY_TIMES);
                        }
                    }
                    catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                        if (self.getMaxValue() == 1 && posixLib.semTryWait(posixSupport, self.getHandle())) {
                            posixLib.semPost(posixSupport, self.getHandle());
                            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.SEMAPHORE_RELEASED_TOO_MANY_TIMES);
                        }
                    }
                }
                catch (PosixSupportLibrary.PosixException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            try {
                posixLib.semPost(posixSupport, self.getHandle());
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            self.decreaseCount();
            return PNone.NONE;
        }
    }

    @Builtin(name="acquire", minNumOfPositionalArgs=1, parameterNames={"$self", "block", "timeout"})
    @ArgumentClinic(name="block", conversion=ArgumentClinic.ClinicConversion.IntToBoolean, defaultValue="true")
    @GenerateNodeFactory
    static abstract class AcquireNode
    extends PythonTernaryClinicBuiltinNode {
        AcquireNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static boolean acquire(VirtualFrame frame, PSemLock self, boolean blocking, Object timeoutObj, @Bind Node inliningTarget, @Bind(value="getPosixSupport()") PosixSupport posixSupport, @CachedLibrary(value="posixSupport") PosixSupportLibrary posixLib, @Cached PyFloatAsDoubleNode asDoubleNode, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            boolean acquired;
            if (self.getKind() == 0 && self.isMine()) {
                self.increaseCount();
                return true;
            }
            boolean hasDeadline = !(timeoutObj instanceof PNone);
            long deadlineNs = 0L;
            if (hasDeadline) {
                double timeout = asDoubleNode.execute(frame, inliningTarget, timeoutObj);
                if (timeout < 0.0) {
                    timeout = 0.0;
                }
                long timeoutNs = (long)(timeout * 1.0E9);
                long nowNs = System.currentTimeMillis() * 1000000L;
                deadlineNs = nowNs + timeoutNs;
            }
            try {
                acquired = posixLib.semTryWait(posixSupport, self.getHandle());
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            if (blocking && !acquired) {
                try {
                    gil.release(true);
                    try {
                        if (hasDeadline) {
                            acquired = posixLib.semTimedWait(posixSupport, self.getHandle(), deadlineNs);
                        } else {
                            posixLib.semWait(posixSupport, self.getHandle());
                            acquired = true;
                        }
                    }
                    finally {
                        gil.acquire();
                    }
                }
                catch (PosixSupportLibrary.PosixException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            if (acquired) {
                self.increaseCount();
                self.setLastThreadId(PThread.getThreadId(Thread.currentThread()));
                return true;
            }
            return false;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SemLockBuiltinsClinicProviders.AcquireNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="maxvalue", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class MaxValueNode
    extends PythonUnaryBuiltinNode {
        MaxValueNode() {
        }

        @Specialization
        static Object get(PSemLock self) {
            return self.getMaxValue();
        }
    }

    @Builtin(name="name", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class NameNode
    extends PythonUnaryBuiltinNode {
        NameNode() {
        }

        @Specialization
        static Object get(PSemLock self) {
            return self.getName();
        }
    }

    @Builtin(name="kind", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class KindNode
    extends PythonUnaryBuiltinNode {
        KindNode() {
        }

        @Specialization
        static Object get(PSemLock self) {
            return self.getKind();
        }
    }

    @Builtin(name="handle", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class HandleNode
    extends PythonUnaryBuiltinNode {
        HandleNode() {
        }

        @Specialization
        static Object get(PSemLock self) {
            return self.getHandle();
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="SemLock", parameterNames={"$cls", "kind", "value", "maxvalue", "name", "unlink"})
    @ArgumentsClinic(value={@ArgumentClinic(name="kind", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="value", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="maxvalue", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="unlink", conversion=ArgumentClinic.ClinicConversion.IntToBoolean)})
    @GenerateNodeFactory
    static abstract class SemLockNode
    extends PythonClinicBuiltinNode {
        SemLockNode() {
        }

        @Specialization
        static PSemLock construct(VirtualFrame frame, Object cls, int kind, int value, int maxValue, TruffleString name, boolean unlink, @Bind Node inliningTarget, @Bind(value="getPosixSupport()") PosixSupport posixSupport, @CachedLibrary(value="posixSupport") PosixSupportLibrary posixLib, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            long handle;
            if (kind != 0 && kind != 1) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.UNRECOGNIZED_KIND);
            }
            Object posixName = posixLib.createPathFromString(posixSupport, name);
            try {
                handle = posixLib.semOpen(posixSupport, posixName, PosixConstants.O_CREAT.value | PosixConstants.O_EXCL.value, 384, value);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            if (unlink) {
                try {
                    posixLib.semUnlink(posixSupport, posixName);
                }
                catch (PosixSupportLibrary.PosixException e) {
                    try {
                        posixLib.semClose(posixSupport, handle);
                    }
                    catch (PosixSupportLibrary.PosixException posixException) {
                        // empty catch block
                    }
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            return PFactory.createSemLock(language, cls, getInstanceShape.execute(cls), handle, kind, maxValue, name);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SemLockBuiltinsClinicProviders.SemLockNodeClinicProviderGen.INSTANCE;
        }
    }
}

