
# 13 "vernac/g_redexpr.mlg"
 
open Procq
open Procq.Prim
open Procq.Constr
open Pvernac.Vernac_

open Util
open Locus
open Genredexpr

let all_with ~head delta =
  let all = [FBeta;FMatch;FFix;FCofix;FZeta;delta] in
  Redops.make_red_flag (if head then FHead :: all else all)

let int_or_var = Entry.make "int_or_var"
let nat_or_var = Entry.make "nat_or_var"
let pattern_occ = Entry.make "pattern_occ"
let unfold_occ = Entry.make "unfold_occ"
let ref_or_pattern_occ = Entry.make "ref_or_pattern_occ"
let occs_nums = Entry.make "occs_nums"
let occs = Entry.make "occs"
let delta_flag = Entry.make "delta_flag"
let strategy_flag = Entry.make "strategy_flag"

# 28 "vernac/g_redexpr.ml"

let _ = let red_flag = Procq.Entry.make "red_flag"
        in
        let () =
  assert (Procq.Entry.is_empty int_or_var) in
  let () =
  Procq.grammar_extend int_or_var
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm identref)))
                            (fun id loc -> 
# 45 "vernac/g_redexpr.mlg"
                           ArgVar id 
# 44 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm integer)))
                           (fun n loc -> 
# 44 "vernac/g_redexpr.mlg"
                          ArgArg n 
# 52 "vernac/g_redexpr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty nat_or_var) in
  let () =
  Procq.grammar_extend nat_or_var
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm identref)))
                            (fun id loc -> 
# 49 "vernac/g_redexpr.mlg"
                           ArgVar id 
# 65 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm natural)))
                           (fun n loc -> 
# 48 "vernac/g_redexpr.mlg"
                          ArgArg n 
# 73 "vernac/g_redexpr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty occs_nums) in
  let () =
  Procq.grammar_extend occs_nums
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("-")))))
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm nat_or_var)))))
                            (fun nl _ loc -> 
# 54 "vernac/g_redexpr.mlg"
                                        AllOccurrencesBut nl 
# 88 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm nat_or_var)))))
                           (fun nl loc -> 
# 53 "vernac/g_redexpr.mlg"
                                   OnlyOccurrences nl 
# 96 "vernac/g_redexpr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty occs) in
  let () =
  Procq.grammar_extend occs
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 57 "vernac/g_redexpr.mlg"
                                                  AllOccurrences 
# 107 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("at")))))
                            ((Procq.Symbol.nterm occs_nums)))
                           (fun occs _ loc -> 
# 57 "vernac/g_redexpr.mlg"
                                    occs 
# 117 "vernac/g_redexpr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty pattern_occ) in
  let () =
  Procq.grammar_extend pattern_occ
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm constr)))
                             ((Procq.Symbol.nterm occs)))
                            (fun nl c loc -> 
# 60 "vernac/g_redexpr.mlg"
                                   (nl,c) 
# 132 "vernac/g_redexpr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ref_or_pattern_occ) in
  let () =
  Procq.grammar_extend ref_or_pattern_occ
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm constr)))
                             ((Procq.Symbol.nterm occs)))
                            (fun nl c loc -> 
# 66 "vernac/g_redexpr.mlg"
                                   nl,Inr c 
# 147 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm smart_global)))
                            ((Procq.Symbol.nterm occs)))
                           (fun nl c loc -> 
# 65 "vernac/g_redexpr.mlg"
                                         nl,Inl c 
# 157 "vernac/g_redexpr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty unfold_occ) in
  let () =
  Procq.grammar_extend unfold_occ
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm smart_global)))
                             ((Procq.Symbol.nterm occs)))
                            (fun nl c loc -> 
# 69 "vernac/g_redexpr.mlg"
                                         (nl,c) 
# 172 "vernac/g_redexpr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty red_flag) in
  let () =
  Procq.grammar_extend red_flag
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("head"))))))
                            (fun _ loc -> 
# 79 "vernac/g_redexpr.mlg"
                          [FHead] 
# 186 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("delta"))))))
                            ((Procq.Symbol.nterm delta_flag)))
                           (fun d _ loc -> 
# 78 "vernac/g_redexpr.mlg"
                                           [d] 
# 197 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("zeta"))))))
                           (fun _ loc -> 
# 77 "vernac/g_redexpr.mlg"
                          [FZeta] 
# 206 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("cofix"))))))
                           (fun _ loc -> 
# 76 "vernac/g_redexpr.mlg"
                           [FCofix] 
# 215 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("fix"))))))
                           (fun _ loc -> 
# 75 "vernac/g_redexpr.mlg"
                         [FFix] 
# 224 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("match"))))))
                           (fun _ loc -> 
# 74 "vernac/g_redexpr.mlg"
                           [FMatch] 
# 233 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("iota"))))))
                           (fun _ loc -> 
# 73 "vernac/g_redexpr.mlg"
                          [FMatch;FFix;FCofix] 
# 242 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("beta"))))))
                           (fun _ loc -> 
# 72 "vernac/g_redexpr.mlg"
                          [FBeta] 
# 251 "vernac/g_redexpr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty delta_flag) in
  let () =
  Procq.grammar_extend delta_flag
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 85 "vernac/g_redexpr.mlg"
             FDeltaBut [] 
# 262 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm smart_global)))))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ idl _ loc -> 
# 84 "vernac/g_redexpr.mlg"
                                                FConst idl 
# 274 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("-")))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm smart_global)))))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ idl _ _ loc -> 
# 83 "vernac/g_redexpr.mlg"
                                                     FDeltaBut idl 
# 288 "vernac/g_redexpr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty strategy_flag) in
  let () =
  Procq.grammar_extend strategy_flag
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.opt (Procq.Symbol.rules 
                              [Procq.Rules.make (Procq.Rule.next_norec
                                                 (Procq.Rule.stop)
                                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                                 ("head"))))))
                                                (fun _ loc -> 
# 90 "vernac/g_redexpr.mlg"
                                    () 
# 306 "vernac/g_redexpr.ml"
)]))))
                             ((Procq.Symbol.nterm delta_flag)))
                            (fun d h loc -> 
# 90 "vernac/g_redexpr.mlg"
                                                                all_with ~head:(Option.has_some h) d 
# 312 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm red_flag)))))
                           (fun s loc -> 
# 89 "vernac/g_redexpr.mlg"
                                Redops.make_red_flag (List.flatten s) 
# 320 "vernac/g_redexpr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty red_expr) in
  let () =
  Procq.grammar_extend red_expr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (None)))))
                            (fun s loc -> 
# 108 "vernac/g_redexpr.mlg"
                       ExtraRedExpr s 
# 333 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("pattern"))))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm pattern_occ)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                           (fun pl _ loc -> 
# 107 "vernac/g_redexpr.mlg"
                                                            Pattern pl 
# 344 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("fold"))))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm constr)))))
                           (fun cl _ loc -> 
# 106 "vernac/g_redexpr.mlg"
                                             Fold cl 
# 355 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("unfold"))))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm unfold_occ)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                           (fun ul _ loc -> 
# 105 "vernac/g_redexpr.mlg"
                                                           Unfold ul 
# 366 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("native_compute"))))))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm ref_or_pattern_occ))))
                           (fun po _ loc -> 
# 104 "vernac/g_redexpr.mlg"
                                                                 CbvNative po 
# 377 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("vm_compute"))))))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm ref_or_pattern_occ))))
                           (fun po _ loc -> 
# 103 "vernac/g_redexpr.mlg"
                                                             CbvVm po 
# 388 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("compute"))))))
                            ((Procq.Symbol.nterm delta_flag)))
                           (fun delta _ loc -> 
# 102 "vernac/g_redexpr.mlg"
                                                 Cbv (all_with ~head:false delta) 
# 399 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("lazy"))))))
                            ((Procq.Symbol.nterm strategy_flag)))
                           (fun s _ loc -> 
# 101 "vernac/g_redexpr.mlg"
                                             Lazy s 
# 410 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("cbn"))))))
                            ((Procq.Symbol.nterm strategy_flag)))
                           (fun s _ loc -> 
# 100 "vernac/g_redexpr.mlg"
                                            Cbn s 
# 421 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("cbv"))))))
                            ((Procq.Symbol.nterm strategy_flag)))
                           (fun s _ loc -> 
# 99 "vernac/g_redexpr.mlg"
                                            Cbv s 
# 432 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("simpl"))))))
                              ((Procq.Symbol.opt (Procq.Symbol.rules 
                              [Procq.Rules.make (Procq.Rule.next_norec
                                                 (Procq.Rule.stop)
                                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                                 ("head"))))))
                                                (fun _ loc -> 
# 97 "vernac/g_redexpr.mlg"
                                                   () 
# 449 "vernac/g_redexpr.ml"
)]))))
                             ((Procq.Symbol.nterm delta_flag)))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm ref_or_pattern_occ))))
                           (fun po d h _ loc -> 
# 98 "vernac/g_redexpr.mlg"
                                                         Simpl (all_with ~head:(Option.has_some h) d,po) 
# 456 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("hnf"))))))
                           (fun _ loc -> 
# 96 "vernac/g_redexpr.mlg"
                         Hnf 
# 465 "vernac/g_redexpr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("red"))))))
                           (fun _ loc -> 
# 95 "vernac/g_redexpr.mlg"
                         Red 
# 474 "vernac/g_redexpr.ml"
)])]))
  in ()

