/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.filter;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.security.OpenSearchSecurityPlugin;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auth.BackendRegistry;
import org.opensearch.security.filter.GrpcRequestChannel;
import org.opensearch.security.ssl.util.SSLRequestHelper;
import org.opensearch.security.support.HTTPHelper;
import org.opensearch.security.user.User;
import org.opensearch.transport.grpc.spi.GrpcInterceptorProvider;

public class SecurityGrpcFilter
implements GrpcInterceptorProvider {
    private static final Logger log = LogManager.getLogger(SecurityGrpcFilter.class);
    private Settings settings;

    public void initNodeSettings(Settings settings) {
        this.settings = settings;
    }

    public List<GrpcInterceptorProvider.OrderedGrpcInterceptor> getOrderedGrpcInterceptors(final ThreadContext threadContext) {
        if (this.settings == null) {
            throw new RuntimeException("SecurityGrpcFilter error: Settings are null");
        }
        if (this.settings.getAsBoolean("plugins.security.disabled", Boolean.valueOf(false)).booleanValue() || this.settings.getAsBoolean("plugins.security.ssl_only", Boolean.valueOf(false)).booleanValue() || !"node".equals(this.settings.get("client.type"))) {
            return List.of();
        }
        return List.of(new GrpcInterceptorProvider.OrderedGrpcInterceptor(){

            public int order() {
                return 0;
            }

            public ServerInterceptor getInterceptor() {
                return new AuthNGrpcInterceptor(threadContext, OpenSearchSecurityPlugin.GuiceHolder.getBackendRegistry(), OpenSearchSecurityPlugin.GuiceHolder.getAuditLog());
            }
        });
    }

    private static class AuthNGrpcInterceptor
    implements ServerInterceptor {
        private final ThreadContext threadContext;
        private final BackendRegistry backendRegistry;
        private final AuditLog auditLog;

        public AuthNGrpcInterceptor(ThreadContext threadContext, BackendRegistry backendRegistry, AuditLog auditLog) {
            this.threadContext = threadContext;
            this.backendRegistry = backendRegistry;
            this.auditLog = auditLog;
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
            return this.handleCall(serverCall, metadata, serverCallHandler);
        }

        private <ReqT, RespT> ServerCall.Listener<ReqT> handleCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
            GrpcRequestChannel requestChannel = new GrpcRequestChannel(serverCall, metadata);
            try {
                if (HTTPHelper.containsBadHeader(requestChannel)) {
                    this.auditLog.logBadHeaders(requestChannel);
                    serverCall.close(Status.PERMISSION_DENIED.withDescription("Illegal security header in gRPC request"), new Metadata());
                    return new ServerCall.Listener<ReqT>(this){};
                }
                if (SSLRequestHelper.containsBadHeader(this.threadContext, "_opendistro_security_")) {
                    this.auditLog.logBadHeaders(requestChannel);
                    serverCall.close(Status.PERMISSION_DENIED.withDescription("Illegal security header in thread context"), new Metadata());
                    return new ServerCall.Listener<ReqT>(this){};
                }
                if (!this.backendRegistry.authenticate(requestChannel)) {
                    if (requestChannel.getQueuedResponse().isPresent()) {
                        serverCall.close(requestChannel.getQueuedResponseGrpcStatus(), new Metadata());
                    } else {
                        serverCall.close(Status.UNAUTHENTICATED, new Metadata());
                    }
                    return new ServerCall.Listener<ReqT>(this){};
                }
                this.threadContext.putTransient("_opendistro_security_origin", (Object)AuditLog.Origin.GRPC.toString());
                if (requestChannel.getQueuedResponse().isPresent()) {
                    serverCall.close(Status.PERMISSION_DENIED, new Metadata());
                    return new ServerCall.Listener<ReqT>(this){};
                }
                User user = (User)this.threadContext.getTransient("_opendistro_security_user");
                if (user != null) {
                    this.auditLog.logSucceededLogin(user.getName(), false, null, requestChannel);
                }
                return serverCallHandler.startCall(serverCall, metadata);
            }
            catch (Exception e) {
                log.error("Unexpected authentication error", (Throwable)e);
                serverCall.close(Status.INTERNAL.withDescription("Unexpected authentication error: " + e.getMessage()), new Metadata());
                return new ServerCall.Listener<ReqT>(this){};
            }
        }
    }
}

