/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.vertx.ext.web.RoutingContext;
import java.util.List;

public class RequestHeaderAttribute
implements ExchangeAttribute {
    private final String requestHeader;

    public RequestHeaderAttribute(String requestHeader) {
        this.requestHeader = requestHeader;
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        List header = exchange.request().headers().getAll(this.requestHeader);
        if (header.isEmpty()) {
            return null;
        }
        if (header.size() == 1) {
            return (String)header.get(0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < header.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append((String)header.get(i));
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        if (newValue == null) {
            exchange.request().headers().remove(this.requestHeader);
        } else {
            exchange.request().headers().set(this.requestHeader, newValue);
        }
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request header";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{i,") && token.endsWith("}")) {
                String headerName = token.substring(4, token.length() - 1);
                return new RequestHeaderAttribute(headerName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

