/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba.endpoints;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.TokenVerifier;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.simple.SimpleHttp;
import org.keycloak.http.simple.SimpleHttpRequest;
import org.keycloak.models.CibaConfig;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuth2DeviceCodeModel;
import org.keycloak.protocol.oidc.grants.ciba.channel.AuthenticationChannelResponse;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.AbstractCibaEndpoint;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.ClientNotificationEndpointRequest;
import org.keycloak.protocol.oidc.grants.device.DeviceGrantType;
import org.keycloak.protocol.oidc.grants.device.endpoints.DeviceEndpoint;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AppAuthManager;

public class BackchannelAuthenticationCallbackEndpoint
extends AbstractCibaEndpoint {
    private static final Logger logger = Logger.getLogger(BackchannelAuthenticationCallbackEndpoint.class);
    private final HttpRequest httpRequest;

    public BackchannelAuthenticationCallbackEndpoint(KeycloakSession session, EventBuilder event) {
        super(session, event);
        this.httpRequest = session.getContext().getHttpRequest();
    }

    @Path(value="/")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response processAuthenticationChannelResult(AuthenticationChannelResponse response) {
        this.event.event(EventType.LOGIN);
        BackchannelAuthCallbackContext ctx = this.verifyAuthenticationRequest(this.getRawBearerToken(this.httpRequest.getHttpHeaders(), response));
        AccessToken bearerToken = ctx.bearerToken;
        OAuth2DeviceCodeModel deviceModel = ctx.deviceModel;
        AuthenticationChannelResponse.Status status = response.getStatus();
        if (status == null) {
            this.event.error("invalid_request");
            throw new ErrorResponseException("invalid_request", "Invalid authentication status", Response.Status.BAD_REQUEST);
        }
        status = this.preApprove(response);
        switch (status) {
            case SUCCEED: {
                this.approveRequest(bearerToken.getId(), response.getAdditionalParams());
                break;
            }
            case CANCELLED: 
            case UNAUTHORIZED: {
                this.denyRequest(bearerToken.getId(), status);
            }
        }
        ClientModel client = this.session.getContext().getClient();
        CibaConfig cibaConfig = this.realm.getCibaPolicy();
        if (cibaConfig.getBackchannelTokenDeliveryMode(client).equals("ping")) {
            this.sendClientNotificationRequest(client, cibaConfig, deviceModel);
        }
        return Response.ok((Object)MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected BackchannelAuthCallbackContext verifyAuthenticationRequest(String rawBearerToken) {
        AccessToken bearerToken;
        if (rawBearerToken == null) {
            throw new ErrorResponseException("invalid_token", "Invalid token", Response.Status.UNAUTHORIZED);
        }
        try {
            bearerToken = (AccessToken)TokenVerifier.createWithoutSignature((JsonWebToken)((AccessToken)this.session.tokens().decode(rawBearerToken, AccessToken.class))).withDefaultChecks().realmUrl(Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName())).checkActive(true).audience(new String[]{Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName())}).verify().getToken();
        }
        catch (Exception e) {
            this.event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "Invalid token", Response.Status.FORBIDDEN);
        }
        OAuth2DeviceCodeModel deviceCode = DeviceEndpoint.getDeviceByUserCode(this.session, this.realm, bearerToken.getId());
        if (deviceCode == null) {
            throw new ErrorResponseException("invalid_token", "Invalid token", Response.Status.FORBIDDEN);
        }
        if (!deviceCode.isPending()) {
            this.cancelRequest(bearerToken.getId());
            throw new ErrorResponseException("invalid_token", "Invalid token", Response.Status.FORBIDDEN);
        }
        ClientModel issuedFor = this.realm.getClientByClientId(bearerToken.getIssuedFor());
        if (issuedFor == null || !issuedFor.isEnabled()) {
            throw new ErrorResponseException("invalid_request", "Invalid token recipient", Response.Status.BAD_REQUEST);
        }
        if (!deviceCode.getClientId().equals(issuedFor.getClientId())) {
            throw new ErrorResponseException("invalid_request", "Token recipient mismatch", Response.Status.BAD_REQUEST);
        }
        this.session.getContext().setClient(issuedFor);
        this.event.client(issuedFor);
        return new BackchannelAuthCallbackContext(bearerToken, deviceCode);
    }

    protected void cancelRequest(String authResultId) {
        OAuth2DeviceCodeModel userCode = DeviceEndpoint.getDeviceByUserCode(this.session, this.realm, authResultId);
        DeviceGrantType.removeDeviceByDeviceCode(this.session, userCode.getDeviceCode());
        DeviceGrantType.removeDeviceByUserCode(this.session, this.realm, authResultId);
    }

    protected AuthenticationChannelResponse.Status preApprove(AuthenticationChannelResponse response) {
        return response.getStatus();
    }

    protected void approveRequest(String authReqId, Map<String, String> additionalParams) {
        DeviceGrantType.approveUserCode(this.session, this.realm, authReqId, "fake", additionalParams);
    }

    protected void denyRequest(String authReqId, AuthenticationChannelResponse.Status status) {
        if (AuthenticationChannelResponse.Status.CANCELLED.equals((Object)status)) {
            this.event.error("not_allowed");
        } else {
            this.event.error("consent_denied");
        }
        DeviceGrantType.denyUserCode(this.session, this.realm, authReqId);
    }

    protected String getRawBearerToken(HttpHeaders httpHeaders, AuthenticationChannelResponse response) {
        AppAuthManager.AuthHeader authHeader = AppAuthManager.extractAuthorizationHeaderTokenOrReturnNull(httpHeaders);
        return authHeader == null ? null : authHeader.getToken();
    }

    protected void sendClientNotificationRequest(ClientModel client, CibaConfig cibaConfig, OAuth2DeviceCodeModel deviceModel) {
        String clientNotificationEndpoint = cibaConfig.getBackchannelClientNotificationEndpoint(client);
        if (clientNotificationEndpoint == null) {
            this.event.error("invalid_request");
            throw new ErrorResponseException("invalid_request", "Client notification endpoint not set for the client with the ping mode", Response.Status.BAD_REQUEST);
        }
        logger.debugf("Sending request to client notification endpoint '%s' for the client '%s'", (Object)clientNotificationEndpoint, (Object)client.getClientId());
        ClientNotificationEndpointRequest clientNotificationRequest = new ClientNotificationEndpointRequest();
        clientNotificationRequest.setAuthReqId(deviceModel.getAuthReqId());
        SimpleHttpRequest simpleHttp = SimpleHttp.create((KeycloakSession)this.session).doPost(clientNotificationEndpoint).header("Content-Type", "application/json").json((Object)clientNotificationRequest).auth(deviceModel.getClientNotificationToken());
        try {
            int notificationResponseStatus = simpleHttp.asStatus();
            logger.tracef("Received status '%d' from request to client notification endpoint '%s' for the client '%s'", notificationResponseStatus, (Object)clientNotificationEndpoint, (Object)client.getClientId());
            if (notificationResponseStatus != 200 && notificationResponseStatus != 204) {
                logger.warnf("Invalid status returned from client notification endpoint '%s' of client '%s'", (Object)clientNotificationEndpoint, (Object)client.getClientId());
                this.event.error("invalid_request");
                throw new ErrorResponseException("invalid_request", "Failed to send request to client notification endpoint", Response.Status.BAD_REQUEST);
            }
        }
        catch (IOException ioe) {
            logger.errorf((Throwable)ioe, "Failed to send request to client notification endpoint '%s' of client '%s'", (Object)clientNotificationEndpoint, (Object)client.getClientId());
            this.event.error("invalid_request");
            throw new ErrorResponseException("invalid_request", "Failed to send request to client notification endpoint", Response.Status.BAD_REQUEST);
        }
    }

    protected static class BackchannelAuthCallbackContext {
        private final AccessToken bearerToken;
        private final OAuth2DeviceCodeModel deviceModel;

        private BackchannelAuthCallbackContext(AccessToken bearerToken, OAuth2DeviceCodeModel deviceModel) {
            this.bearerToken = bearerToken;
            this.deviceModel = deviceModel;
        }
    }
}

