/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.keycloak.protocol.oid4vc.model.DiVpProof;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Proofs {
    @JsonProperty(value="jwt")
    private List<String> jwt;
    @JsonProperty(value="di_vp")
    private List<DiVpProof> diVp;
    @JsonProperty(value="attestation")
    private List<String> attestation;

    public Proofs() {
    }

    public Proofs(List<String> jwt, List<DiVpProof> diVp, List<String> attestation) {
        this.jwt = jwt;
        this.diVp = diVp;
        this.attestation = attestation;
    }

    public List<String> getJwt() {
        return this.jwt;
    }

    public Proofs setJwt(List<String> jwt) {
        this.jwt = jwt;
        return this;
    }

    public List<DiVpProof> getDiVp() {
        return this.diVp;
    }

    public Proofs setDiVp(List<DiVpProof> diVp) {
        this.diVp = diVp;
        return this;
    }

    public List<String> getAttestation() {
        return this.attestation;
    }

    public Proofs setAttestation(List<String> attestation) {
        this.attestation = attestation;
        return this;
    }

    @JsonIgnore
    public String getProofType() {
        if (this.jwt != null && !this.jwt.isEmpty()) {
            return "jwt";
        }
        if (this.attestation != null && !this.attestation.isEmpty()) {
            return "attestation";
        }
        return null;
    }

    public Proofs setProofByType(String proofType, String proof) {
        if ("jwt".equals(proofType)) {
            this.setJwt(List.of(proof));
        } else if ("attestation".equals(proofType)) {
            this.setAttestation(List.of(proof));
        }
        return this;
    }

    @JsonIgnore
    public List<String> getAllProofs() {
        ArrayList<String> allProofs = new ArrayList<String>();
        if (this.jwt != null && !this.jwt.isEmpty()) {
            allProofs.addAll(this.jwt);
        } else if (this.attestation != null && !this.attestation.isEmpty()) {
            allProofs.addAll(this.attestation);
        }
        return allProofs;
    }

    @JsonIgnore
    public List<String> getPresentProofTypes() {
        ArrayList<String> presentTypes = new ArrayList<String>();
        if (this.jwt != null && !this.jwt.isEmpty()) {
            presentTypes.add("jwt");
        }
        if (this.attestation != null && !this.attestation.isEmpty()) {
            presentTypes.add("attestation");
        }
        return presentTypes;
    }
}

