/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.utils.StringUtil;

public class TimeClaimNormalizer {
    private static final Logger logger = Logger.getLogger(TimeClaimNormalizer.class);
    private final Strategy strategy;
    private final long randomizeWindowSeconds;
    private final RoundUnit roundUnit;
    public static final long DEFAULT_RANDOMIZE_WINDOW = 86400L;
    public static final Strategy DEFAULT_STRATEGY = Strategy.OFF;
    public static final RoundUnit DEFAULT_ROUND_UNIT = RoundUnit.SECOND;

    public TimeClaimNormalizer(KeycloakSession session) {
        this(session.getContext().getRealm());
    }

    public TimeClaimNormalizer(RealmModel realm) {
        this.strategy = TimeClaimNormalizer.parseStrategy(realm.getAttribute("oid4vci.time.claims.strategy"));
        this.randomizeWindowSeconds = TimeClaimNormalizer.parseRandomizeWindow(realm.getAttribute("oid4vci.time.randomize.window.seconds"));
        this.roundUnit = TimeClaimNormalizer.parseRoundUnit(realm.getAttribute("oid4vci.time.round.unit"));
    }

    TimeClaimNormalizer(Strategy strategy, Long randomizeWindowSeconds, RoundUnit roundUnit) {
        this.strategy = strategy == null ? DEFAULT_STRATEGY : strategy;
        this.randomizeWindowSeconds = randomizeWindowSeconds == null ? 86400L : randomizeWindowSeconds;
        this.roundUnit = roundUnit == null ? DEFAULT_ROUND_UNIT : roundUnit;
    }

    public Instant normalize(Instant original) {
        if (original == null) {
            return null;
        }
        return switch (this.strategy.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.randomize(original);
            case 2 -> this.round(original);
            case 0 -> original;
        };
    }

    private Instant randomize(Instant original) {
        long randomOffset = (long)(Math.random() * (double)(this.randomizeWindowSeconds + 1L));
        return original.minusSeconds(randomOffset);
    }

    private Instant round(Instant original) {
        ZonedDateTime zdt = original.atZone(ZoneOffset.UTC);
        return switch (this.roundUnit.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> zdt.truncatedTo(ChronoUnit.SECONDS).toInstant();
            case 1 -> zdt.truncatedTo(ChronoUnit.MINUTES).toInstant();
            case 2 -> zdt.truncatedTo(ChronoUnit.HOURS).toInstant();
            case 3 -> zdt.toLocalDate().atStartOfDay(ZoneOffset.UTC).toInstant();
        };
    }

    private static Strategy parseStrategy(String value) {
        if (value == null) {
            return DEFAULT_STRATEGY;
        }
        try {
            return Strategy.valueOf(value.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            logger.warnf("Invalid time-claim strategy '%s'. Using default '%s'", (Object)value, (Object)DEFAULT_STRATEGY);
            return DEFAULT_STRATEGY;
        }
    }

    private static long parseRandomizeWindow(String value) {
        if (StringUtil.isBlank((String)value)) {
            return 86400L;
        }
        try {
            long window = Long.parseLong(value.trim());
            if (window <= 0L) {
                logger.warnf("Randomization window is zero or negative (%d), will be using default value", (Object)window);
                return 86400L;
            }
            return window;
        }
        catch (NumberFormatException ex) {
            logger.warnf("Invalid randomize window '%s'. Using default %d seconds", (Object)value, (Object)86400L);
            return 86400L;
        }
    }

    private static RoundUnit parseRoundUnit(String value) {
        if (value == null) {
            return DEFAULT_ROUND_UNIT;
        }
        try {
            return RoundUnit.valueOf(value.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            logger.warnf("Invalid round unit '%s'. Using default '%s'", (Object)value, (Object)DEFAULT_ROUND_UNIT);
            return DEFAULT_ROUND_UNIT;
        }
    }

    public static enum Strategy {
        OFF,
        RANDOMIZE,
        ROUND;

    }

    public static enum RoundUnit {
        SECOND,
        MINUTE,
        HOUR,
        DAY;

    }
}

