/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.impl.Sets;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class DecoratorInfo
extends BeanInfo
implements Comparable<DecoratorInfo> {
    private final InjectionPointInfo delegateInjectionPoint;
    private final Set<Type> decoratedTypes;

    DecoratorInfo(AnnotationTarget target, BeanDeployment beanDeployment, InjectionPointInfo delegateInjectionPoint, Set<Type> decoratedTypes, List<Injection> injections, int priority) {
        super(target, beanDeployment, BuiltinScope.DEPENDENT.getInfo(), Sets.singletonHashSet((Object)Type.create((DotName)target.asClass().name(), (Type.Kind)Type.Kind.CLASS)), new HashSet<AnnotationInstance>(), injections, null, null, false, Collections.emptyList(), null, false, null, priority, null, null);
        this.delegateInjectionPoint = delegateInjectionPoint;
        this.decoratedTypes = decoratedTypes;
    }

    public InjectionPointInfo getDelegateInjectionPoint() {
        return this.delegateInjectionPoint;
    }

    public Type getDelegateType() {
        return this.delegateInjectionPoint.getRequiredType();
    }

    public ClassInfo getDelegateTypeClass() {
        return this.getDeployment().getBeanArchiveIndex().getClassByName(this.getDelegateType().name());
    }

    public Set<AnnotationInstance> getDelegateQualifiers() {
        return this.delegateInjectionPoint.getRequiredQualifiers();
    }

    public Set<Type> getDecoratedTypes() {
        return this.decoratedTypes;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(((AnnotationTarget)this.target.get()).asClass().flags());
    }

    @Override
    public boolean isDecorator() {
        return true;
    }

    @Override
    public String toString() {
        return "DECORATOR bean [decoratedTypes=" + String.valueOf(this.decoratedTypes) + ", target=" + String.valueOf(this.getTarget()) + "]";
    }

    @Override
    public int compareTo(DecoratorInfo other) {
        return this.getTarget().toString().compareTo(other.getTarget().toString());
    }
}

