/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan;

import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;

public record NodeInfo(String nodeName, String siteName) {
    public NodeInfo {
        Objects.requireNonNull(nodeName);
    }

    public static NodeInfo of(EmbeddedCacheManager cacheManager) {
        TransportConfiguration transportConfig = cacheManager.getCacheManagerConfiguration().transport();
        String nodeName = transportConfig.nodeName();
        if (nodeName != null) {
            return new NodeInfo(nodeName, transportConfig.siteId());
        }
        Transport transport = (Transport)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)cacheManager, Transport.class);
        nodeName = transport == null ? "node_" + ThreadLocalRandom.current().nextInt(1000000) : transport.localNodeName();
        return new NodeInfo(nodeName, transportConfig.siteId());
    }

    public String printInfo() {
        return "Node name: %s, Site name: %s".formatted(this.nodeName, this.siteName);
    }
}

