/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.util.ByteList;
import org.jruby.util.RubyDateFormatter;

public class RubyTimeOutputFormatter
extends RubyDateFormatter.Token {
    final ByteList flags;
    final int width;
    public static final RubyTimeOutputFormatter DEFAULT_FORMATTER = new RubyTimeOutputFormatter(ByteList.EMPTY_BYTELIST, 0);
    private static final int MAX_DIGITS = 19;
    private static final int SMALLBUF = 10000;

    public RubyTimeOutputFormatter(ByteList flags2, int width) {
        super(RubyDateFormatter.Format.FORMAT_OUTPUT, null);
        this.flags = flags2;
        this.width = width;
        this.data = this;
    }

    public int getWidth(int defaultWidth) {
        if (this.flags.indexOf(45) != -1) {
            return 0;
        }
        return this.width != 0 ? this.width : defaultWidth;
    }

    public char getPadder(char defaultPadder) {
        int padder = defaultPadder;
        block5: for (int i2 = 0; i2 < this.flags.length(); ++i2) {
            switch (this.flags.charAt(i2)) {
                case '_': {
                    padder = 32;
                    continue block5;
                }
                case '0': {
                    padder = 48;
                    continue block5;
                }
                case '-': {
                    padder = 0;
                }
            }
        }
        return (char)padder;
    }

    public void format(ByteList out, long value2, RubyDateFormatter.FieldType type2) {
        int width = this.getWidth(type2.defaultWidth);
        char padder = this.getPadder(type2.defaultPadder);
        RubyTimeOutputFormatter.formatNumber(out, value2, width, padder);
    }

    public void format(ByteList out, CharSequence sequence) {
        int width = this.getWidth(0);
        char padder = this.getPadder(' ');
        block4: for (int i2 = 0; i2 < this.flags.length(); ++i2) {
            switch (this.flags.charAt(i2)) {
                case '^': {
                    sequence = sequence.toString().toUpperCase();
                    continue block4;
                }
                case '#': {
                    char last2 = sequence.charAt(sequence.length() - 1);
                    sequence = Character.isLowerCase(last2) ? sequence.toString().toUpperCase() : sequence.toString().toLowerCase();
                }
            }
        }
        RubyTimeOutputFormatter.padding(out, sequence.length(), width, padder);
        if (sequence instanceof ByteList) {
            out.append((ByteList)sequence);
        } else {
            out.append(sequence.toString().getBytes());
        }
    }

    static void outputLong(ByteList out, int length2, long value2) {
        out.ensure(out.length() + length2);
        if (value2 < 0L) {
            out.append(45);
            --length2;
            value2 = -value2;
        } else if (value2 == 0L) {
            out.append(48);
            return;
        }
        byte[] unsafe = out.unsafeBytes();
        int begin2 = out.getBegin() + out.realSize() - 1;
        for (int i2 = begin2 + length2; i2 > begin2; --i2) {
            unsafe[i2] = (byte)(48L + value2 % 10L);
            value2 /= 10L;
        }
        out.setRealSize(out.realSize() + length2);
    }

    static int longSize(long number) {
        return number < 0L ? RubyTimeOutputFormatter.longSizeInner(-number) + 1 : RubyTimeOutputFormatter.longSizeInner(number);
    }

    static int longSizeInner(long number) {
        long largerNumber = 10L;
        int digits2 = 1;
        while (digits2 < 19) {
            if (number < largerNumber) {
                return digits2;
            }
            ++digits2;
            largerNumber *= 10L;
        }
        return 19;
    }

    static void formatNumber(ByteList out, long value2, int width, char padder) {
        if (value2 >= 0L || padder != '0') {
            int size2 = RubyTimeOutputFormatter.longSize(value2);
            RubyTimeOutputFormatter.padding(out, size2, width, padder);
            RubyTimeOutputFormatter.outputLong(out, size2, value2);
        } else {
            int size3 = RubyTimeOutputFormatter.longSize(-value2);
            out.append(45);
            RubyTimeOutputFormatter.padding(out, size3, width - 1, padder);
            RubyTimeOutputFormatter.outputLong(out, size3, -value2);
        }
    }

    static void formatSignedNumber(ByteList out, long value2, long second2, int width, char padder) {
        if (padder == '0') {
            if (value2 == 0L) {
                out.append(value2 == 0L && second2 < 0L ? 45 : 43);
                RubyTimeOutputFormatter.padding(out, 0, width - 1, padder);
            } else if (value2 > 0L) {
                String num = Long.toString(value2);
                out.append(43);
                RubyTimeOutputFormatter.padding(out, num.length(), width - 1, padder);
                out.append(num.getBytes());
            } else {
                String num = Long.toString(-value2);
                out.append(45);
                RubyTimeOutputFormatter.padding(out, num.length(), width - 1, padder);
                out.append(num.getBytes());
            }
        } else {
            String num = Long.toString(value2);
            if (value2 == 0L) {
                out.append(value2 == 0L && second2 < 0L ? 45 : 43);
            } else if (value2 > 0L) {
                RubyTimeOutputFormatter.padding(out, num.length(), width - 1, padder);
                out.append(43);
            } else {
                RubyTimeOutputFormatter.padding(out, num.length(), width, padder);
            }
            out.append(num.getBytes());
        }
    }

    private static void padding(ByteList out, int len, int width, char padder) {
        if (len >= width) {
            return;
        }
        if (width > 10000) {
            throw new IndexOutOfBoundsException("padding width " + width + " too large");
        }
        for (int i2 = len; i2 < width; ++i2) {
            out.append(padder);
        }
    }

    @Override
    public String toString() {
        return "RTOF - flags: " + String.valueOf(this.flags) + ", width: " + this.width;
    }
}

