/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

The Image class for SimpleITK.


This Image class can represent 2D, 3D, and 4D images. The pixel types may be a
scalar, a multi-component vector or a run-length-encoded (RLE)
"label". The dimension, pixel type and size is specified at
construction.

A fundamental concept of ITK images is that they occupy physical space
where the image is defined by an origin, spacing, and direction cosine
matrix. The attributes are taken into consideration when doing most
operations on an image. A meta-data dictionary is also associated with
the image, which may contain additional fields from reading but these
attributes are not propagated by image filters.

The SimpleITK Image provides a single facade interface to several ITK image types.
Internally, the SimpleITK Image maintains a pointer to the ITK image class, and performs reference
counting and lazy copying. This means that deep copying of an image
including it's buffer is delayed until the image is modified. This
removes the need to use pointers to SimpleITK Image class, as copying and returning by value do not unnecessarily
duplicate the data.


See:
 itk::Image itk::VectorImage itk::LabelMap itk::ImageBase


C++ includes: sitkImage.h
*/
public class Image {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected Image(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Image obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(Image obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::Image::~Image()
*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_Image(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /** Return a Buffer object for the Image's buffer.
   *
   * If the image's pixel component type is available in Java, then the return object
   * is the appropriate derived object from the Buffer class.
   */
  public java.nio.Buffer getBufferAsBuffer()
    {
      java.nio.ByteBuffer b = getBufferAsByteBuffer();
      if (getPixelID() == PixelIDValueEnum.sitkInt16 ||
          getPixelID() == PixelIDValueEnum.sitkVectorInt16)
        {
          return b.asShortBuffer();
        }
      if (getPixelID() == PixelIDValueEnum.sitkUInt16 ||
          getPixelID() == PixelIDValueEnum.sitkVectorUInt16)
        {
          return b.asCharBuffer();
        }
      if (getPixelID() == PixelIDValueEnum.sitkInt32 ||
          getPixelID() == PixelIDValueEnum.sitkVectorInt32)
        {
          return b.asIntBuffer();
        }
      if (getPixelID() == PixelIDValueEnum.sitkFloat32 ||
          getPixelID() == PixelIDValueEnum.sitkComplexFloat32 ||
          getPixelID() == PixelIDValueEnum.sitkVectorFloat32)
        {
          return b.asFloatBuffer();
        }
      if (getPixelID() == PixelIDValueEnum.sitkFloat64 ||
          getPixelID() == PixelIDValueEnum.sitkComplexFloat64 ||
          getPixelID() == PixelIDValueEnum.sitkVectorFloat64)
        {
          return b.asDoubleBuffer();
        }
       // sitkInt8 and sitkVectorInt8 are returned as ByteBuffer too.
       return b;
    }

  /**
itk::simple::Image::Image(Image &amp;&amp;img) noexcept

Move constructor and assignment.




Parameters:

img:
After the operation img is valid only for destructing and assignment;
all other operations have undefined behavior.



*/
public  Image() {
    this(SimpleITKJNI.new_Image__SWIG_0(), true);
  }

  /**
itk::simple::Image::Image(Image &amp;&amp;img) noexcept

Move constructor and assignment.




Parameters:

img:
After the operation img is valid only for destructing and assignment;
all other operations have undefined behavior.



*/
public  Image(Image img) {
    this(SimpleITKJNI.new_Image__SWIG_1(Image.getCPtr(img), img), true);
  }

  /**
itk::simple::Image::Image(Image &amp;&amp;img) noexcept

Move constructor and assignment.




Parameters:

img:
After the operation img is valid only for destructing and assignment;
all other operations have undefined behavior.



*/
public  Image(long width, long height, PixelIDValueEnum valueEnum) {
    this(SimpleITKJNI.new_Image__SWIG_2(width, height, valueEnum.swigValue()), true);
  }

  /**
itk::simple::Image::Image(Image &amp;&amp;img) noexcept

Move constructor and assignment.




Parameters:

img:
After the operation img is valid only for destructing and assignment;
all other operations have undefined behavior.



*/
public  Image(long width, long height, long depth, PixelIDValueEnum valueEnum) {
    this(SimpleITKJNI.new_Image__SWIG_3(width, height, depth, valueEnum.swigValue()), true);
  }

  /**
itk::simple::Image::Image(Image &amp;&amp;img) noexcept

Move constructor and assignment.




Parameters:

img:
After the operation img is valid only for destructing and assignment;
all other operations have undefined behavior.



*/
public  Image(VectorUInt32 size, PixelIDValueEnum valueEnum, long numberOfComponents) {
    this(SimpleITKJNI.new_Image__SWIG_4(VectorUInt32.getCPtr(size), size, valueEnum.swigValue(), numberOfComponents), true);
  }

  /**
itk::simple::Image::Image(Image &amp;&amp;img) noexcept

Move constructor and assignment.




Parameters:

img:
After the operation img is valid only for destructing and assignment;
all other operations have undefined behavior.



*/
public  Image(VectorUInt32 size, PixelIDValueEnum valueEnum) {
    this(SimpleITKJNI.new_Image__SWIG_5(VectorUInt32.getCPtr(size), size, valueEnum.swigValue()), true);
  }

  public SWIGTYPE_p_itk__DataObject getITKBase() {
    long cPtr = SimpleITKJNI.Image_getITKBase__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new SWIGTYPE_p_itk__DataObject(cPtr, false);
  }

  /**
PixelIDValueEnum itk::simple::Image::GetPixelID() const

Get the pixel type

The pixel type is set at construction type and can not be manually
changed, unless by assignment. The value may be -1 or "Unknown".

*/
public  PixelIDValueEnum getPixelID() {
    return PixelIDValueEnum.swigToEnum(SimpleITKJNI.Image_getPixelID(swigCPtr, this));
  }

  /**
PixelIDValueType itk::simple::Image::GetPixelIDValue() const
*/
public  int getPixelIDValue() {
    return SimpleITKJNI.Image_getPixelIDValue(swigCPtr, this);
  }

  /**
std::string itk::simple::Image::GetPixelIDTypeAsString() const

Return the pixel type as a human readable string value.

*/
public  String getPixelIDTypeAsString() {
    return SimpleITKJNI.Image_getPixelIDTypeAsString(swigCPtr, this);
  }

  /**
unsigned int itk::simple::Image::GetDimension() const

Get the number of physical dimensions.

Only the spatial dimensions are considered here. These are the
dimensions the origin, spacing and direction cosine matrix are
applicable to. This does not include the pixels' vector index as a
dimension.

*/
public  long getDimension() {
    return SimpleITKJNI.Image_getDimension(swigCPtr, this);
  }

  /**
unsigned int itk::simple::Image::GetNumberOfComponentsPerPixel() const

Get the number of components for each pixel.


For images with scalar or complex pixel types this method returns one.
For images with a vector pixel type the method returns the number of
vector components per pixel.

*/
public  long getNumberOfComponentsPerPixel() {
    return SimpleITKJNI.Image_getNumberOfComponentsPerPixel(swigCPtr, this);
  }

  /**
uint64_t itk::simple::Image::GetNumberOfPixels() const

Get the number of pixels in the image.


To calculate the total number of values stored continuously for the
image's buffer, the NumberOfPixels should be multiplied by
NumberOfComponentsPerPixel in order to account for multiple component
images.

*/
public  java.math.BigInteger getNumberOfPixels() {
    return SimpleITKJNI.Image_getNumberOfPixels(swigCPtr, this);
  }

  /**
unsigned int itk::simple::Image::GetSizeOfPixelComponent() const

Get the number of bytes per component of a pixel.


Returns the sizeof the pixel component type.

*/
public  long getSizeOfPixelComponent() {
    return SimpleITKJNI.Image_getSizeOfPixelComponent(swigCPtr, this);
  }

  public VectorDouble getOrigin() {
    return new VectorDouble(SimpleITKJNI.Image_getOrigin(swigCPtr, this), true);
  }

  public void setOrigin(VectorDouble origin) {
    SimpleITKJNI.Image_setOrigin(swigCPtr, this, VectorDouble.getCPtr(origin), origin);
  }

  public VectorDouble getSpacing() {
    return new VectorDouble(SimpleITKJNI.Image_getSpacing(swigCPtr, this), true);
  }

  public void setSpacing(VectorDouble spacing) {
    SimpleITKJNI.Image_setSpacing(swigCPtr, this, VectorDouble.getCPtr(spacing), spacing);
  }

  public VectorDouble getDirection() {
    return new VectorDouble(SimpleITKJNI.Image_getDirection(swigCPtr, this), true);
  }

  public void setDirection(VectorDouble direction) {
    SimpleITKJNI.Image_setDirection(swigCPtr, this, VectorDouble.getCPtr(direction), direction);
  }

  /**
std::vector&lt;double&gt; itk::simple::Image::TransformIndexToPhysicalPoint(const std::vector&lt; int64_t &gt; &amp;index) const

Transform index to physical point

*/
public  VectorDouble transformIndexToPhysicalPoint(VectorInt64 index) {
    return new VectorDouble(SimpleITKJNI.Image_transformIndexToPhysicalPoint(swigCPtr, this, VectorInt64.getCPtr(index), index), true);
  }

  /**
std::vector&lt;int64_t&gt; itk::simple::Image::TransformPhysicalPointToIndex(const std::vector&lt; double &gt; &amp;point) const

Transform physical point to index

*/
public  VectorInt64 transformPhysicalPointToIndex(VectorDouble point) {
    return new VectorInt64(SimpleITKJNI.Image_transformPhysicalPointToIndex(swigCPtr, this, VectorDouble.getCPtr(point), point), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::Image::TransformPhysicalPointToContinuousIndex(const std::vector&lt; double &gt; &amp;point) const

Transform physical point to continuous index

*/
public  VectorDouble transformPhysicalPointToContinuousIndex(VectorDouble point) {
    return new VectorDouble(SimpleITKJNI.Image_transformPhysicalPointToContinuousIndex(swigCPtr, this, VectorDouble.getCPtr(point), point), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::Image::TransformContinuousIndexToPhysicalPoint(const std::vector&lt; double &gt; &amp;index) const

Transform continuous index to physical point

*/
public  VectorDouble transformContinuousIndexToPhysicalPoint(VectorDouble index) {
    return new VectorDouble(SimpleITKJNI.Image_transformContinuousIndexToPhysicalPoint(swigCPtr, this, VectorDouble.getCPtr(index), index), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::Image::EvaluateAtContinuousIndex(const std::vector&lt; double &gt; &amp;index, InterpolatorEnum
interp=sitkLinear) const

Interpolate pixel value at a continuous index.


This method is not supported for Label pixel types.

The valid range of continuous index is [-0.5, size-0.5] for each
dimension. An exception is thrown if index is out of bounds.



Parameters:

index:
The continuous index must be at least the length of the image
dimension.

interp:
The interpolation type to use, only sitkNearest and sitkLinear are
supported for Vector and Complex pixel types.


All supported pixel types are returned as an array, where complex
numbers are returned with the real followed by the complex component.


*/
public  VectorDouble evaluateAtContinuousIndex(VectorDouble index, InterpolatorEnum interp) {
    return new VectorDouble(SimpleITKJNI.Image_evaluateAtContinuousIndex__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(index), index, interp.swigValue()), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::Image::EvaluateAtContinuousIndex(const std::vector&lt; double &gt; &amp;index, InterpolatorEnum
interp=sitkLinear) const

Interpolate pixel value at a continuous index.


This method is not supported for Label pixel types.

The valid range of continuous index is [-0.5, size-0.5] for each
dimension. An exception is thrown if index is out of bounds.



Parameters:

index:
The continuous index must be at least the length of the image
dimension.

interp:
The interpolation type to use, only sitkNearest and sitkLinear are
supported for Vector and Complex pixel types.


All supported pixel types are returned as an array, where complex
numbers are returned with the real followed by the complex component.


*/
public  VectorDouble evaluateAtContinuousIndex(VectorDouble index) {
    return new VectorDouble(SimpleITKJNI.Image_evaluateAtContinuousIndex__SWIG_1(swigCPtr, this, VectorDouble.getCPtr(index), index), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::Image::EvaluateAtPhysicalPoint(const std::vector&lt; double &gt; &amp;point, InterpolatorEnum
interp=sitkLinear) const

Interpolate pixel value at a physical point.

This method is not supported for Label pixel types.

An exception is thrown if the point is out of the defined region for
the image.



Parameters:

point:
The physical point at which the interpolation is computed.

interp:
The interpolation type to use, only sitkNearest and sitkLinear are
supported for Vector and Complex pixel types.


All supported pixel types are returned as an array, where complex
numbers are returned with the real followed by the complex component.


*/
public  VectorDouble evaluateAtPhysicalPoint(VectorDouble point, InterpolatorEnum interp) {
    return new VectorDouble(SimpleITKJNI.Image_evaluateAtPhysicalPoint__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(point), point, interp.swigValue()), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::Image::EvaluateAtPhysicalPoint(const std::vector&lt; double &gt; &amp;point, InterpolatorEnum
interp=sitkLinear) const

Interpolate pixel value at a physical point.

This method is not supported for Label pixel types.

An exception is thrown if the point is out of the defined region for
the image.



Parameters:

point:
The physical point at which the interpolation is computed.

interp:
The interpolation type to use, only sitkNearest and sitkLinear are
supported for Vector and Complex pixel types.


All supported pixel types are returned as an array, where complex
numbers are returned with the real followed by the complex component.


*/
public  VectorDouble evaluateAtPhysicalPoint(VectorDouble point) {
    return new VectorDouble(SimpleITKJNI.Image_evaluateAtPhysicalPoint__SWIG_1(swigCPtr, this, VectorDouble.getCPtr(point), point), true);
  }

  /**
bool itk::simple::Image::IsCongruentImageGeometry(const Image &amp;otherImage, double coordinateTolerance, double
directionTolerance) const

Checks whether the images' pixels at the same index occupy the same
physical space.

Compares the origin, spacing, and direction for equality within
provided tolerances. There is no check for matching regions in between
the images.

If The dimensions of the images do not match, false is returned.

*/
public  boolean isCongruentImageGeometry(Image otherImage, double coordinateTolerance, double directionTolerance) {
    return SimpleITKJNI.Image_isCongruentImageGeometry(swigCPtr, this, Image.getCPtr(otherImage), otherImage, coordinateTolerance, directionTolerance);
  }

  /**
bool itk::simple::Image::IsSameImageGeometryAs(const Image &amp;otherImage, double=DefaultImageCoordinateTolerance,
double=DefaultImageDirectionTolerance) const

Check whether the images have the same grid in physical space.

Compares largest possible regions for equality, and the origin,
spacing, and direction cosines for equality within provided
tolerances.

If the dimensions of the images do not match, false is returned.

*/
public  boolean isSameImageGeometryAs(Image otherImage, double arg1, double arg2) {
    return SimpleITKJNI.Image_isSameImageGeometryAs__SWIG_0(swigCPtr, this, Image.getCPtr(otherImage), otherImage, arg1, arg2);
  }

  /**
bool itk::simple::Image::IsSameImageGeometryAs(const Image &amp;otherImage, double=DefaultImageCoordinateTolerance,
double=DefaultImageDirectionTolerance) const

Check whether the images have the same grid in physical space.

Compares largest possible regions for equality, and the origin,
spacing, and direction cosines for equality within provided
tolerances.

If the dimensions of the images do not match, false is returned.

*/
public  boolean isSameImageGeometryAs(Image otherImage, double arg1) {
    return SimpleITKJNI.Image_isSameImageGeometryAs__SWIG_1(swigCPtr, this, Image.getCPtr(otherImage), otherImage, arg1);
  }

  /**
bool itk::simple::Image::IsSameImageGeometryAs(const Image &amp;otherImage, double=DefaultImageCoordinateTolerance,
double=DefaultImageDirectionTolerance) const

Check whether the images have the same grid in physical space.

Compares largest possible regions for equality, and the origin,
spacing, and direction cosines for equality within provided
tolerances.

If the dimensions of the images do not match, false is returned.

*/
public  boolean isSameImageGeometryAs(Image otherImage) {
    return SimpleITKJNI.Image_isSameImageGeometryAs__SWIG_2(swigCPtr, this, Image.getCPtr(otherImage), otherImage);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::Image::GetSize() const

Get the number of pixels the Image is in each dimension as a std::vector. The size of the vector is
equal to the number of dimensions for the image.

*/
public  VectorUInt32 getSize() {
    return new VectorUInt32(SimpleITKJNI.Image_getSize(swigCPtr, this), true);
  }

  /**
unsigned int itk::simple::Image::GetWidth() const

Get the number of pixels the Image is in the first dimension

*/
public  long getWidth() {
    return SimpleITKJNI.Image_getWidth(swigCPtr, this);
  }

  /**
unsigned int itk::simple::Image::GetHeight() const

Get the number of pixels the Image is in the second dimension

*/
public  long getHeight() {
    return SimpleITKJNI.Image_getHeight(swigCPtr, this);
  }

  /**
unsigned int itk::simple::Image::GetDepth() const

Get the number of pixels the Image is in the third dimension or 0 if the Image is only 2D

*/
public  long getDepth() {
    return SimpleITKJNI.Image_getDepth(swigCPtr, this);
  }

  /**
void itk::simple::Image::CopyInformation(const Image &amp;srcImage)

Copy common meta-data from an image to this one.


Copies the Origin, Spacing, and Direction from the source image to
this image. The meta-data dictionary is not copied.

It is required for the source Image's dimension and size to match, this image's attributes, otherwise an
exception will be generated.

*/
public  void copyInformation(Image srcImage) {
    SimpleITKJNI.Image_copyInformation(swigCPtr, this, Image.getCPtr(srcImage), srcImage);
  }

  /**
std::vector&lt;std::string&gt; itk::simple::Image::GetMetaDataKeys() const

get a vector of keys in from the meta-data dictionary


Returns a vector of keys to the key/value entries in the image's meta-
data dictionary. Iterate through with these keys to get the values.

*/
public  VectorString getMetaDataKeys() {
    return new VectorString(SimpleITKJNI.Image_getMetaDataKeys(swigCPtr, this), true);
  }

  /**
bool itk::simple::Image::HasMetaDataKey(const std::string &amp;key) const

Query the meta-data dictionary for the existence of a key.

*/
public  boolean hasMetaDataKey(String key) {
    return SimpleITKJNI.Image_hasMetaDataKey(swigCPtr, this, key);
  }

  /**
std::string itk::simple::Image::GetMetaData(const std::string &amp;key) const

Get the value of a meta-data dictionary entry as a string.


If the key is not in the dictionary then an exception is thrown.

string types in the dictionary are returned as their native strings.
Other types are printed to string before returning.

*/
public  String getMetaData(String key) {
    return SimpleITKJNI.Image_getMetaData(swigCPtr, this, key);
  }

  /**
void itk::simple::Image::SetMetaData(const std::string &amp;key, const std::string &amp;value)

Set an entry in the meta-data dictionary.


Replaces or creates an entry in the image's meta-data dictionary.

*/
public  void setMetaData(String key, String value) {
    SimpleITKJNI.Image_setMetaData(swigCPtr, this, key, value);
  }

  /**
bool itk::simple::Image::EraseMetaData(const std::string &amp;key)

Remove an entry from the meta-data dictionary.


Returns true, when the value exists in the dictionary and is removed,
false otherwise.

*/
public  boolean eraseMetaData(String key) {
    return SimpleITKJNI.Image_eraseMetaData(swigCPtr, this, key);
  }

  /**
std::string itk::simple::Image::ToString() const
*/
public  String toString() {
    return SimpleITKJNI.Image_toString(swigCPtr, this);
  }

  /**
Image itk::simple::Image::ToVectorImage(bool inPlace=true)

Convert the first dimension to the components for image with vector
pixel type.


This method will convert a scalar image to a vector image with the
number of components equal to the size of the first dimension. If the
image is already a vector image then the image is returned.

The components of the direction cosine matrix for the first dimension
must be the identity matrix, or else an exception is thrown.

An exception is thrown if the image is 2D or if the pixel type is a
label or complex pixel type.



Parameters:

inPlace:
If true then the image is made unique and converted in place updating
this image, otherwise a copy of the image is made and returned.


See:
 ToScalarImage


*/
public  Image toVectorImage(boolean inPlace) {
    return new Image(SimpleITKJNI.Image_toVectorImage__SWIG_0(swigCPtr, this, inPlace), true);
  }

  /**
Image itk::simple::Image::ToVectorImage(bool inPlace=true)

Convert the first dimension to the components for image with vector
pixel type.


This method will convert a scalar image to a vector image with the
number of components equal to the size of the first dimension. If the
image is already a vector image then the image is returned.

The components of the direction cosine matrix for the first dimension
must be the identity matrix, or else an exception is thrown.

An exception is thrown if the image is 2D or if the pixel type is a
label or complex pixel type.



Parameters:

inPlace:
If true then the image is made unique and converted in place updating
this image, otherwise a copy of the image is made and returned.


See:
 ToScalarImage


*/
public  Image toVectorImage() {
    return new Image(SimpleITKJNI.Image_toVectorImage__SWIG_1(swigCPtr, this), true);
  }

  /**
Image itk::simple::Image::ToScalarImage(bool inPlace=true)

Convert a image of vector pixel type to a scalar image with N+1
dimensions.


This method will convert a vector image to a scalar image with the
size of the first dimension equal to the number of components. If the
image is already a scalar image then the image is returned.

For the additional dimension the origin is set to zero, the spacing to
one, and the new components of the direction cosine to the identity
matrix.

An exception is thrown if the image is has SITK_MAX_DIMENSION
dimensions or if the pixel type is a label or complex pixel type.



Parameters:

inPlace:
If true then the image is made unique and converted in place updating
this image, otherwise a copy of the image is made and returned.


See:
 ToVectorImage


*/
public  Image toScalarImage(boolean inPlace) {
    return new Image(SimpleITKJNI.Image_toScalarImage__SWIG_0(swigCPtr, this, inPlace), true);
  }

  /**
Image itk::simple::Image::ToScalarImage(bool inPlace=true)

Convert a image of vector pixel type to a scalar image with N+1
dimensions.


This method will convert a vector image to a scalar image with the
size of the first dimension equal to the number of components. If the
image is already a scalar image then the image is returned.

For the additional dimension the origin is set to zero, the spacing to
one, and the new components of the direction cosine to the identity
matrix.

An exception is thrown if the image is has SITK_MAX_DIMENSION
dimensions or if the pixel type is a label or complex pixel type.



Parameters:

inPlace:
If true then the image is made unique and converted in place updating
this image, otherwise a copy of the image is made and returned.


See:
 ToVectorImage


*/
public  Image toScalarImage() {
    return new Image(SimpleITKJNI.Image_toScalarImage__SWIG_1(swigCPtr, this), true);
  }

  public byte getPixelAsInt8(VectorUInt32 idx) {
    return SimpleITKJNI.Image_getPixelAsInt8(swigCPtr, this, VectorUInt32.getCPtr(idx), idx);
  }

  public short getPixelAsUInt8(VectorUInt32 idx) {
    return SimpleITKJNI.Image_getPixelAsUInt8(swigCPtr, this, VectorUInt32.getCPtr(idx), idx);
  }

  public short getPixelAsInt16(VectorUInt32 idx) {
    return SimpleITKJNI.Image_getPixelAsInt16(swigCPtr, this, VectorUInt32.getCPtr(idx), idx);
  }

  public int getPixelAsUInt16(VectorUInt32 idx) {
    return SimpleITKJNI.Image_getPixelAsUInt16(swigCPtr, this, VectorUInt32.getCPtr(idx), idx);
  }

  public int getPixelAsInt32(VectorUInt32 idx) {
    return SimpleITKJNI.Image_getPixelAsInt32(swigCPtr, this, VectorUInt32.getCPtr(idx), idx);
  }

  public long getPixelAsUInt32(VectorUInt32 idx) {
    return SimpleITKJNI.Image_getPixelAsUInt32(swigCPtr, this, VectorUInt32.getCPtr(idx), idx);
  }

  public long getPixelAsInt64(VectorUInt32 idx) {
    return SimpleITKJNI.Image_getPixelAsInt64(swigCPtr, this, VectorUInt32.getCPtr(idx), idx);
  }

  public java.math.BigInteger getPixelAsUInt64(VectorUInt32 idx) {
    return SimpleITKJNI.Image_getPixelAsUInt64(swigCPtr, this, VectorUInt32.getCPtr(idx), idx);
  }

  public float getPixelAsFloat(VectorUInt32 idx) {
    return SimpleITKJNI.Image_getPixelAsFloat(swigCPtr, this, VectorUInt32.getCPtr(idx), idx);
  }

  public double getPixelAsDouble(VectorUInt32 idx) {
    return SimpleITKJNI.Image_getPixelAsDouble(swigCPtr, this, VectorUInt32.getCPtr(idx), idx);
  }

  public VectorInt8 getPixelAsVectorInt8(VectorUInt32 idx) {
    return new VectorInt8(SimpleITKJNI.Image_getPixelAsVectorInt8(swigCPtr, this, VectorUInt32.getCPtr(idx), idx), true);
  }

  public VectorUInt8 getPixelAsVectorUInt8(VectorUInt32 idx) {
    return new VectorUInt8(SimpleITKJNI.Image_getPixelAsVectorUInt8(swigCPtr, this, VectorUInt32.getCPtr(idx), idx), true);
  }

  public VectorInt16 getPixelAsVectorInt16(VectorUInt32 idx) {
    return new VectorInt16(SimpleITKJNI.Image_getPixelAsVectorInt16(swigCPtr, this, VectorUInt32.getCPtr(idx), idx), true);
  }

  public VectorUInt16 getPixelAsVectorUInt16(VectorUInt32 idx) {
    return new VectorUInt16(SimpleITKJNI.Image_getPixelAsVectorUInt16(swigCPtr, this, VectorUInt32.getCPtr(idx), idx), true);
  }

  public VectorInt32 getPixelAsVectorInt32(VectorUInt32 idx) {
    return new VectorInt32(SimpleITKJNI.Image_getPixelAsVectorInt32(swigCPtr, this, VectorUInt32.getCPtr(idx), idx), true);
  }

  public VectorUInt32 getPixelAsVectorUInt32(VectorUInt32 idx) {
    return new VectorUInt32(SimpleITKJNI.Image_getPixelAsVectorUInt32(swigCPtr, this, VectorUInt32.getCPtr(idx), idx), true);
  }

  public VectorInt64 getPixelAsVectorInt64(VectorUInt32 idx) {
    return new VectorInt64(SimpleITKJNI.Image_getPixelAsVectorInt64(swigCPtr, this, VectorUInt32.getCPtr(idx), idx), true);
  }

  public VectorUInt64 getPixelAsVectorUInt64(VectorUInt32 idx) {
    return new VectorUInt64(SimpleITKJNI.Image_getPixelAsVectorUInt64(swigCPtr, this, VectorUInt32.getCPtr(idx), idx), true);
  }

  public VectorFloat getPixelAsVectorFloat32(VectorUInt32 idx) {
    return new VectorFloat(SimpleITKJNI.Image_getPixelAsVectorFloat32(swigCPtr, this, VectorUInt32.getCPtr(idx), idx), true);
  }

  public VectorDouble getPixelAsVectorFloat64(VectorUInt32 idx) {
    return new VectorDouble(SimpleITKJNI.Image_getPixelAsVectorFloat64(swigCPtr, this, VectorUInt32.getCPtr(idx), idx), true);
  }

  public SWIGTYPE_p_std__complexT_float_t getPixelAsComplexFloat32(VectorUInt32 idx) {
    return new SWIGTYPE_p_std__complexT_float_t(SimpleITKJNI.Image_getPixelAsComplexFloat32(swigCPtr, this, VectorUInt32.getCPtr(idx), idx), true);
  }

  public SWIGTYPE_p_std__complexT_double_t getPixelAsComplexFloat64(VectorUInt32 idx) {
    return new SWIGTYPE_p_std__complexT_double_t(SimpleITKJNI.Image_getPixelAsComplexFloat64(swigCPtr, this, VectorUInt32.getCPtr(idx), idx), true);
  }

  public void setPixelAsInt8(VectorUInt32 idx, byte v) {
    SimpleITKJNI.Image_setPixelAsInt8(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, v);
  }

  public void setPixelAsUInt8(VectorUInt32 idx, short v) {
    SimpleITKJNI.Image_setPixelAsUInt8(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, v);
  }

  public void setPixelAsInt16(VectorUInt32 idx, short v) {
    SimpleITKJNI.Image_setPixelAsInt16(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, v);
  }

  public void setPixelAsUInt16(VectorUInt32 idx, int v) {
    SimpleITKJNI.Image_setPixelAsUInt16(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, v);
  }

  public void setPixelAsInt32(VectorUInt32 idx, int v) {
    SimpleITKJNI.Image_setPixelAsInt32(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, v);
  }

  public void setPixelAsUInt32(VectorUInt32 idx, long v) {
    SimpleITKJNI.Image_setPixelAsUInt32(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, v);
  }

  public void setPixelAsInt64(VectorUInt32 idx, long v) {
    SimpleITKJNI.Image_setPixelAsInt64(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, v);
  }

  public void setPixelAsUInt64(VectorUInt32 idx, java.math.BigInteger v) {
    SimpleITKJNI.Image_setPixelAsUInt64(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, v);
  }

  public void setPixelAsFloat(VectorUInt32 idx, float v) {
    SimpleITKJNI.Image_setPixelAsFloat(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, v);
  }

  public void setPixelAsDouble(VectorUInt32 idx, double v) {
    SimpleITKJNI.Image_setPixelAsDouble(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, v);
  }

  public void setPixelAsVectorInt8(VectorUInt32 idx, VectorInt8 v) {
    SimpleITKJNI.Image_setPixelAsVectorInt8(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, VectorInt8.getCPtr(v), v);
  }

  public void setPixelAsVectorUInt8(VectorUInt32 idx, VectorUInt8 v) {
    SimpleITKJNI.Image_setPixelAsVectorUInt8(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, VectorUInt8.getCPtr(v), v);
  }

  public void setPixelAsVectorInt16(VectorUInt32 idx, VectorInt16 v) {
    SimpleITKJNI.Image_setPixelAsVectorInt16(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, VectorInt16.getCPtr(v), v);
  }

  public void setPixelAsVectorUInt16(VectorUInt32 idx, VectorUInt16 v) {
    SimpleITKJNI.Image_setPixelAsVectorUInt16(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, VectorUInt16.getCPtr(v), v);
  }

  public void setPixelAsVectorInt32(VectorUInt32 idx, VectorInt32 v) {
    SimpleITKJNI.Image_setPixelAsVectorInt32(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, VectorInt32.getCPtr(v), v);
  }

  public void setPixelAsVectorUInt32(VectorUInt32 idx, VectorUInt32 v) {
    SimpleITKJNI.Image_setPixelAsVectorUInt32(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, VectorUInt32.getCPtr(v), v);
  }

  public void setPixelAsVectorInt64(VectorUInt32 idx, VectorInt64 v) {
    SimpleITKJNI.Image_setPixelAsVectorInt64(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, VectorInt64.getCPtr(v), v);
  }

  public void setPixelAsVectorUInt64(VectorUInt32 idx, VectorUInt64 v) {
    SimpleITKJNI.Image_setPixelAsVectorUInt64(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, VectorUInt64.getCPtr(v), v);
  }

  public void setPixelAsVectorFloat32(VectorUInt32 idx, VectorFloat v) {
    SimpleITKJNI.Image_setPixelAsVectorFloat32(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, VectorFloat.getCPtr(v), v);
  }

  public void setPixelAsVectorFloat64(VectorUInt32 idx, VectorDouble v) {
    SimpleITKJNI.Image_setPixelAsVectorFloat64(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, VectorDouble.getCPtr(v), v);
  }

  public void setPixelAsComplexFloat32(VectorUInt32 idx, SWIGTYPE_p_std__complexT_float_t v) {
    SimpleITKJNI.Image_setPixelAsComplexFloat32(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, SWIGTYPE_p_std__complexT_float_t.getCPtr(v));
  }

  public void setPixelAsComplexFloat64(VectorUInt32 idx, SWIGTYPE_p_std__complexT_double_t v) {
    SimpleITKJNI.Image_setPixelAsComplexFloat64(swigCPtr, this, VectorUInt32.getCPtr(idx), idx, SWIGTYPE_p_std__complexT_double_t.getCPtr(v));
  }

  public java.nio.ByteBuffer getBufferAsByteBuffer() {
  return SimpleITKJNI.Image_getBufferAsByteBuffer(swigCPtr, this);
}

  /**
void itk::simple::Image::MakeUnique()

Performs actually coping if needed to make object unique.


The Image class by default performs lazy coping and assignment. This method
make sure that coping actually happens to the itk::Image pointed to is only pointed to by this object.

*/
public  void makeUnique() {
    SimpleITKJNI.Image_makeUnique(swigCPtr, this);
  }

  /**
bool itk::simple::Image::IsUnique() const

Returns true if no other SimpleITK Image object refers to the same internal data structure.

*/
public  boolean isUnique() {
    return SimpleITKJNI.Image_isUnique(swigCPtr, this);
  }

  public long getBufferAsNativePointer() {
    return SimpleITKJNI.Image_getBufferAsNativePointer(swigCPtr, this);
  }

  public final static double DefaultImageCoordinateTolerance = SimpleITKJNI.Image_DefaultImageCoordinateTolerance_get();
  public final static double DefaultImageDirectionTolerance = SimpleITKJNI.Image_DefaultImageDirectionTolerance_get();
}
