/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.scheduler;

public class BasicFPSAnimator
extends Thread {
    protected final Runnable runnable;
    protected final Object worldLock;
    protected final Object lock = new Object();
    protected long startTime;
    protected long delay;
    protected boolean animating = true;

    public BasicFPSAnimator(Runnable runnable, Object worldLock, String name, float fps) {
        super(name);
        this.worldLock = worldLock;
        this.runnable = runnable;
        this.setDaemon(true);
        this.setFps(fps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.animating) {
            long timeout;
            this.startTime = System.currentTimeMillis();
            Object object = this.worldLock;
            synchronized (object) {
                this.runnable.run();
            }
            while ((timeout = this.delay - System.currentTimeMillis() + this.startTime) > 0L) {
                Object object2 = this.lock;
                synchronized (object2) {
                    try {
                        this.lock.wait(timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFps(float fps) {
        this.delay = (long)(1000.0f / fps);
        Object object = this.lock;
        synchronized (object) {
            this.startTime = 0L;
            this.lock.notify();
        }
    }

    public final void shutdown() {
        this.animating = false;
    }

    public final boolean isAnimating() {
        return this.animating;
    }
}

