/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.service.tool.ToolExecutionResult;
import java.util.Objects;

public class ToolExecution {
    private final ToolExecutionRequest request;
    private final ToolExecutionResult result;

    private ToolExecution(Builder builder) {
        this.request = (ToolExecutionRequest)ValidationUtils.ensureNotNull((Object)builder.request, (String)"request");
        this.result = (ToolExecutionResult)ValidationUtils.ensureNotNull((Object)builder.result, (String)"result");
    }

    public ToolExecutionRequest request() {
        return this.request;
    }

    public String result() {
        return this.result.resultText();
    }

    public Object resultObject() {
        return this.result.result();
    }

    public boolean hasFailed() {
        return this.result.isError();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ToolExecution that = (ToolExecution)object;
        return Objects.equals(this.request, that.request) && Objects.equals(this.result, that.result);
    }

    public int hashCode() {
        return Objects.hash(this.request, this.result);
    }

    public String toString() {
        return "ToolExecution{request=" + String.valueOf(this.request) + ", result=" + String.valueOf(this.result) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ToolExecutionRequest request;
        private ToolExecutionResult result;

        private Builder() {
        }

        public Builder request(ToolExecutionRequest request) {
            this.request = request;
            return this;
        }

        public Builder result(ToolExecutionResult result) {
            this.result = result;
            return this;
        }

        @Deprecated(since="1.5.0")
        public Builder result(String result) {
            this.result = ToolExecutionResult.builder().resultText(result).build();
            return this;
        }

        public ToolExecution build() {
            return new ToolExecution(this);
        }
    }
}

