/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.title;

import java.io.Serializable;
import java.util.ArrayList;
import net.infonode.docking.AbstractTabWindow;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.View;
import net.infonode.docking.title.DockingWindowTitleProvider;

public class LengthLimitedDockingWindowTitleProvider
implements DockingWindowTitleProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private int maxLength;

    public LengthLimitedDockingWindowTitleProvider(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public String getTitle(DockingWindow window) {
        ArrayList viewTitles = new ArrayList();
        ArrayList viewPrimary = new ArrayList();
        this.getViews(window, viewTitles, viewPrimary, true);
        int length = 0;
        int i = 0;
        while (i < viewTitles.size()) {
            if (((Boolean)viewPrimary.get(i)).booleanValue()) {
                length += ((String)viewTitles.get(i)).length();
            }
            ++i;
        }
        StringBuffer title = new StringBuffer(40);
        int count = 0;
        int i2 = 0;
        while (i2 < viewTitles.size() && title.length() < this.maxLength) {
            boolean primary = (Boolean)viewPrimary.get(i2);
            if (primary || length < this.maxLength) {
                if (title.length() > 0) {
                    title.append(", ");
                }
                title.append((String)viewTitles.get(i2));
                ++count;
                if (!primary) {
                    length += ((String)viewTitles.get(i2)).length();
                }
            }
            ++i2;
        }
        if (count < viewTitles.size()) {
            title.append(", ...");
        }
        return title.toString();
    }

    private void getViews(DockingWindow window, ArrayList viewTitles, ArrayList viewPrimary, boolean primary) {
        if (window == null) {
            return;
        }
        if (window instanceof View) {
            viewTitles.add(((View)window).getViewProperties().getTitle());
            viewPrimary.add(primary);
        } else if (window instanceof AbstractTabWindow) {
            DockingWindow selected = ((AbstractTabWindow)window).getSelectedWindow();
            int i = 0;
            while (i < window.getChildWindowCount()) {
                this.getViews(window.getChildWindow(i), viewTitles, viewPrimary, selected == window.getChildWindow(i) && primary);
                ++i;
            }
        } else {
            int i = 0;
            while (i < window.getChildWindowCount()) {
                this.getViews(window.getChildWindow(i), viewTitles, viewPrimary, primary);
                ++i;
            }
        }
    }
}

