/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.WeakHashMap;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.IEncrypter;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MapClipboardController;

public class EncryptionModel
implements IExtension {
    private static final WeakHashMap<NodeModel, List<NodeModel>> hiddenChildren = new WeakHashMap();
    private String encryptedContent;
    private IEncrypter mEncrypter;
    private final NodeModel node;

    public static EncryptionModel getModel(NodeModel node) {
        return node.getExtension(EncryptionModel.class);
    }

    public EncryptionModel(NodeModel node, IEncrypter encrypter) {
        this.node = node;
        this.mEncrypter = encrypter;
        this.encryptedContent = null;
    }

    public EncryptionModel(NodeModel node, String encryptedContent) {
        this.node = node;
        this.encryptedContent = encryptedContent;
        this.mEncrypter = null;
    }

    private boolean checkAndSetEncrypter(IEncrypter encrypter) {
        String decryptedNode = this.decryptXml(this.encryptedContent, encrypter);
        if (decryptedNode != null) {
            this.mEncrypter = encrypter;
            return true;
        }
        return false;
    }

    public boolean decrypt(MapController mapController, IEncrypter encrypter) {
        if (this.encryptedContent == null) {
            throw new IllegalStateException("No encrypted content");
        }
        if (!this.checkAndSetEncrypter(encrypter)) {
            return false;
        }
        if (!hiddenChildren.containsKey(this.node)) {
            try {
                String childXml = this.decryptXml(this.encryptedContent, encrypter);
                String[] childs = childXml.split("<nodeseparator>");
                for (int i = 0; i < childs.length; ++i) {
                    String string = childs[i];
                    if (string.length() == 0) continue;
                    this.pasteXML(string, this.node, mapController);
                    hiddenChildren.put(this.node, this.node.getChildrenInternal());
                }
            }
            catch (Exception e) {
                LogUtils.severe(e);
            }
        }
        return true;
    }

    private String decryptXml(String encryptedString, IEncrypter encrypter) {
        String decrypted = encrypter.decrypt(encryptedString);
        return decrypted;
    }

    private String encryptXml(StringBuffer childXml) {
        if (this.mEncrypter == null) {
            throw new IllegalStateException("Cannot encrypt: encrypter is null");
        }
        try {
            return this.mEncrypter.encrypt(childXml.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't encrypt the node", e);
        }
    }

    private String encrypt(MapWriter mapWriter, List<NodeModel> childNodes) {
        try {
            StringWriter sWriter = new StringWriter();
            ListIterator<NodeModel> i = childNodes.listIterator();
            while (i.hasNext()) {
                NodeModel child = (NodeModel)i.next();
                mapWriter.writeNodeAsXml(sWriter, child, MapWriter.Mode.FILE, MapClipboardController.CopiedNodeSet.ALL_NODES, true, false);
                if (!i.hasNext()) continue;
                sWriter.write("<nodeseparator>");
            }
            StringBuffer childXml = sWriter.getBuffer();
            String encryptedContent = this.encryptXml(childXml);
            return encryptedContent;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected", e);
        }
    }

    public String calculateEncryptedContent(MapWriter mapWriter) {
        if (this.encryptedContent == null) {
            try {
                return this.encrypt(mapWriter, this.node.getChildrenInternal());
            }
            catch (Exception e) {
                LogUtils.severe(e);
            }
        }
        return this.encryptedContent;
    }

    public boolean isAccessible() {
        return this.encryptedContent == null;
    }

    public boolean isLocked() {
        return this.encryptedContent != null;
    }

    public String getEncryptedContent() {
        return this.encryptedContent;
    }

    private void pasteXML(String pasted, NodeModel target, MapController mapController) {
        try {
            NodeModel node = mapController.getMapReader().createNodeTreeFromXml(target.getMap(), (Reader)new StringReader(pasted), MapWriter.Mode.FILE);
            mapController.insertNodeIntoWithoutUndo(node, target, target.getChildCount());
        }
        catch (Exception ee) {
            LogUtils.severe(ee);
        }
    }

    public void setEncrypter(IEncrypter encrypter) {
        if (this.mEncrypter != null) {
            this.mEncrypter.destroy();
        }
        this.mEncrypter = encrypter;
    }

    public synchronized void unlock() {
        this.node.setChildrenInternal(hiddenChildren.remove(this.node));
        this.encryptedContent = null;
    }

    public synchronized void lock(MapWriter mapWriter) {
        List<NodeModel> childNodes = this.node.getChildrenInternal();
        String encryptedContent = this.encrypt(mapWriter, childNodes);
        if (encryptedContent != null) {
            this.encryptedContent = encryptedContent;
            List<NodeModel> oldContent = hiddenChildren.put(this.node, childNodes);
            this.node.setChildrenInternal(Collections.emptyList());
            if (oldContent != null) {
                LogUtils.severe("Hidden children replaced");
            }
        }
    }

    public void destroy() {
        if (this.mEncrypter != null) {
            this.mEncrypter.destroy();
            this.mEncrypter = null;
        }
    }
}

