/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.exec;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.ui.actions.exec.SQLNativeExecutorDescriptor;

public class SQLNativeExecutorRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.sql.executors";
    private static final String TAG_EXECUTOR = "executor";
    private static SQLNativeExecutorRegistry instance;
    private final List<SQLNativeExecutorDescriptor> executors = new ArrayList<SQLNativeExecutorDescriptor>();

    private SQLNativeExecutorRegistry() {
    }

    @NotNull
    public static synchronized SQLNativeExecutorRegistry getInstance() {
        if (instance == null) {
            instance = new SQLNativeExecutorRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private void loadExtensions(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        for (IConfigurationElement viewElement : extElements = registry.getConfigurationElementsFor(EXTENSION_ID)) {
            if (!viewElement.getName().equals(TAG_EXECUTOR)) continue;
            this.executors.add(new SQLNativeExecutorDescriptor(viewElement));
        }
    }

    @NotNull
    public List<SQLNativeExecutorDescriptor> getExecutors() {
        return new ArrayList<SQLNativeExecutorDescriptor>(this.executors);
    }

    @Nullable
    public SQLNativeExecutorDescriptor getExecutorDescriptor(@NotNull DBPDataSourceContainer container) {
        DBPDataSourceProviderDescriptor provider;
        for (DBPDataSourceProviderDescriptor pd = provider = container.getDriver().getProviderDescriptor(); pd != null; pd = pd.getParentProvider()) {
            for (SQLNativeExecutorDescriptor executor : this.executors) {
                if (!executor.getDataSourceId().equals(pd.getId())) continue;
                return executor;
            }
        }
        return null;
    }
}

