/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.convert.impl;

import java.util.Map;
import org.jkiss.dbeaver.ui.editors.sql.convert.impl.SourceCodeSQLConverter;
import org.jkiss.utils.CommonUtils;

public class JavaSQLConverter
extends SourceCodeSQLConverter {
    public static final String OPTION_USE_STRING_BUILDER = "use-string-builder";

    @Override
    protected void convertSourceLines(StringBuilder result, String[] sourceLines, String lineDelimiter, Map<String, Object> options) {
        boolean useStringBuilder = CommonUtils.toBoolean((Object)options.get(OPTION_USE_STRING_BUILDER));
        if (useStringBuilder) {
            result.append("StringBuilder query = new StringBuilder();\n");
        }
        int i = 0;
        while (i < sourceLines.length) {
            String escapedLine = CommonUtils.escapeJavaString((String)sourceLines[i]);
            if (useStringBuilder) {
                result.append("query.append(\"").append(escapedLine).append(lineDelimiter).append("\");\n");
            } else {
                result.append('\"').append(escapedLine).append(lineDelimiter).append('\"');
                if (i < sourceLines.length - 1) {
                    result.append(" + \n");
                } else {
                    result.append(";");
                }
            }
            ++i;
        }
    }
}

