/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.generator;

import java.util.List;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.generator.SQLGeneratorResultSet;

public class SQLGeneratorSelectManyFromData
extends SQLGeneratorResultSet {
    @Override
    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, IResultSetController object) {
        boolean bl;
        List<DBDAttributeBinding> keyAttributes = this.getKeyAttributes(monitor, object);
        sql.append("SELECT ");
        boolean hasAttr = false;
        for (DBSAttributeBase dBSAttributeBase : this.getAllAttributes(monitor, object)) {
            if (hasAttr) {
                sql.append(", ");
            }
            sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSAttributeBase, (DBPEvaluationContext)DBPEvaluationContext.DML));
            hasAttr = true;
        }
        sql.append(this.getLineSeparator()).append("FROM ").append(this.getEntityName(this.getSingleEntity()));
        sql.append(this.getLineSeparator()).append("WHERE ");
        boolean bl2 = bl = keyAttributes.size() > 1;
        if (bl) {
            sql.append("(");
        }
        hasAttr = false;
        for (DBDAttributeBinding binding : keyAttributes) {
            if (hasAttr) {
                sql.append(",");
            }
            sql.append(DBUtils.getObjectFullName((DBPNamedObject)binding.getAttribute(), (DBPEvaluationContext)DBPEvaluationContext.DML));
            hasAttr = true;
        }
        if (bl) {
            sql.append(")");
        }
        sql.append(" IN (");
        if (bl) {
            sql.append("\n");
        }
        List<ResultSetRow> selectedRows = this.getSelectedRows();
        int i = 0;
        while (i < selectedRows.size()) {
            ResultSetRow firstRow = selectedRows.get(i);
            if (bl) {
                sql.append("(");
            }
            hasAttr = false;
            for (DBDAttributeBinding binding : keyAttributes) {
                if (hasAttr) {
                    sql.append(",");
                }
                this.appendAttributeValue(this.getController(), sql, binding, firstRow, true);
                hasAttr = true;
            }
            if (bl) {
                sql.append(")");
            }
            if (i < selectedRows.size() - 1) {
                sql.append(",");
            }
            if (bl) {
                sql.append("\n");
            }
            ++i;
        }
        sql.append(");\n");
    }
}

