/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.version;

import java.util.Collections;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.version.PluginVersionRequest;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public class DefaultPluginVersionRequest
implements PluginVersionRequest {
    private String groupId;
    private String artifactId;
    private Model pom;
    private List<RemoteRepository> repositories = Collections.emptyList();
    private RepositorySystemSession session;

    public DefaultPluginVersionRequest() {
    }

    public DefaultPluginVersionRequest(Plugin plugin, MavenSession session2) {
        this.setGroupId(plugin.getGroupId());
        this.setArtifactId(plugin.getArtifactId());
        this.setRepositorySession(session2.getRepositorySession());
        MavenProject project2 = session2.getCurrentProject();
        if (project2 != null) {
            this.setRepositories((List)project2.getRemotePluginRepositories());
        }
    }

    public DefaultPluginVersionRequest(Plugin plugin, RepositorySystemSession session2, List<RemoteRepository> repositories) {
        this.setGroupId(plugin.getGroupId());
        this.setArtifactId(plugin.getArtifactId());
        this.setRepositorySession(session2);
        this.setRepositories((List)repositories);
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public DefaultPluginVersionRequest setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public DefaultPluginVersionRequest setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    @Override
    public Model getPom() {
        return this.pom;
    }

    @Override
    public DefaultPluginVersionRequest setPom(Model pom2) {
        this.pom = pom2;
        return this;
    }

    @Override
    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    @Override
    public DefaultPluginVersionRequest setRepositories(List<RemoteRepository> repositories) {
        this.repositories = repositories != null ? Collections.unmodifiableList(repositories) : Collections.emptyList();
        return this;
    }

    @Override
    public RepositorySystemSession getRepositorySession() {
        return this.session;
    }

    @Override
    public DefaultPluginVersionRequest setRepositorySession(RepositorySystemSession session2) {
        this.session = session2;
        return this;
    }
}

