﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/securityhub/model/AwsWafRegionalRulePredicateListDetails.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p>Provides information about an WAF Regional rule. This rule identifies the web
 * requests that you want to allow, block, or count. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsWafRegionalRuleDetails">AWS
 * API Reference</a></p>
 */
class AwsWafRegionalRuleDetails {
 public:
  AWS_SECURITYHUB_API AwsWafRegionalRuleDetails() = default;
  AWS_SECURITYHUB_API AwsWafRegionalRuleDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API AwsWafRegionalRuleDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A name for the metrics for the rule. </p>
   */
  inline const Aws::String& GetMetricName() const { return m_metricName; }
  inline bool MetricNameHasBeenSet() const { return m_metricNameHasBeenSet; }
  template <typename MetricNameT = Aws::String>
  void SetMetricName(MetricNameT&& value) {
    m_metricNameHasBeenSet = true;
    m_metricName = std::forward<MetricNameT>(value);
  }
  template <typename MetricNameT = Aws::String>
  AwsWafRegionalRuleDetails& WithMetricName(MetricNameT&& value) {
    SetMetricName(std::forward<MetricNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A descriptive name for the rule. </p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  AwsWafRegionalRuleDetails& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the <code>ByteMatchSet</code>, <code>IPSet</code>,
   * <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>,
   * <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, and
   * <code>SizeConstraintSet</code> objects that you want to add to a rule and, for
   * each object, indicates whether you want to negate the settings. </p>
   */
  inline const Aws::Vector<AwsWafRegionalRulePredicateListDetails>& GetPredicateList() const { return m_predicateList; }
  inline bool PredicateListHasBeenSet() const { return m_predicateListHasBeenSet; }
  template <typename PredicateListT = Aws::Vector<AwsWafRegionalRulePredicateListDetails>>
  void SetPredicateList(PredicateListT&& value) {
    m_predicateListHasBeenSet = true;
    m_predicateList = std::forward<PredicateListT>(value);
  }
  template <typename PredicateListT = Aws::Vector<AwsWafRegionalRulePredicateListDetails>>
  AwsWafRegionalRuleDetails& WithPredicateList(PredicateListT&& value) {
    SetPredicateList(std::forward<PredicateListT>(value));
    return *this;
  }
  template <typename PredicateListT = AwsWafRegionalRulePredicateListDetails>
  AwsWafRegionalRuleDetails& AddPredicateList(PredicateListT&& value) {
    m_predicateListHasBeenSet = true;
    m_predicateList.emplace_back(std::forward<PredicateListT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the rule. </p>
   */
  inline const Aws::String& GetRuleId() const { return m_ruleId; }
  inline bool RuleIdHasBeenSet() const { return m_ruleIdHasBeenSet; }
  template <typename RuleIdT = Aws::String>
  void SetRuleId(RuleIdT&& value) {
    m_ruleIdHasBeenSet = true;
    m_ruleId = std::forward<RuleIdT>(value);
  }
  template <typename RuleIdT = Aws::String>
  AwsWafRegionalRuleDetails& WithRuleId(RuleIdT&& value) {
    SetRuleId(std::forward<RuleIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_metricName;

  Aws::String m_name;

  Aws::Vector<AwsWafRegionalRulePredicateListDetails> m_predicateList;

  Aws::String m_ruleId;
  bool m_metricNameHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_predicateListHasBeenSet = false;
  bool m_ruleIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
