﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/autoscaling/AutoScaling_EXPORTS.h>
#include <aws/autoscaling/model/Alarm.h>
#include <aws/autoscaling/model/ResponseMetadata.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace AutoScaling {
namespace Model {
/**
 * <p>Contains the output of PutScalingPolicy.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PolicyARNType">AWS
 * API Reference</a></p>
 */
class PutScalingPolicyResult {
 public:
  AWS_AUTOSCALING_API PutScalingPolicyResult() = default;
  AWS_AUTOSCALING_API PutScalingPolicyResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_AUTOSCALING_API PutScalingPolicyResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the policy.</p>
   */
  inline const Aws::String& GetPolicyARN() const { return m_policyARN; }
  template <typename PolicyARNT = Aws::String>
  void SetPolicyARN(PolicyARNT&& value) {
    m_policyARNHasBeenSet = true;
    m_policyARN = std::forward<PolicyARNT>(value);
  }
  template <typename PolicyARNT = Aws::String>
  PutScalingPolicyResult& WithPolicyARN(PolicyARNT&& value) {
    SetPolicyARN(std::forward<PolicyARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The CloudWatch alarms created for the target tracking scaling policy.</p>
   */
  inline const Aws::Vector<Alarm>& GetAlarms() const { return m_alarms; }
  template <typename AlarmsT = Aws::Vector<Alarm>>
  void SetAlarms(AlarmsT&& value) {
    m_alarmsHasBeenSet = true;
    m_alarms = std::forward<AlarmsT>(value);
  }
  template <typename AlarmsT = Aws::Vector<Alarm>>
  PutScalingPolicyResult& WithAlarms(AlarmsT&& value) {
    SetAlarms(std::forward<AlarmsT>(value));
    return *this;
  }
  template <typename AlarmsT = Alarm>
  PutScalingPolicyResult& AddAlarms(AlarmsT&& value) {
    m_alarmsHasBeenSet = true;
    m_alarms.emplace_back(std::forward<AlarmsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  PutScalingPolicyResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_policyARN;

  Aws::Vector<Alarm> m_alarms;

  ResponseMetadata m_responseMetadata;
  bool m_policyARNHasBeenSet = false;
  bool m_alarmsHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace AutoScaling
}  // namespace Aws
