/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.metrics;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.routing.metrics.RoutingMetric;
import java.util.Iterator;

public class WireLengthMetric
extends RoutingMetric<Double> {
    @Override
    public Double calculate(Cell cell) {
        return this.processNets(cell, 0.0);
    }

    @Override
    protected Double reduce(Double result, ArcInst instance, Network net) {
        double val = instance.getProto() != Generic.tech().unrouted_arc ? instance.getLambdaLength() : 0.0;
        return result + val;
    }

    private Double reduce(Double result, NodeInst instance, Network net) {
        double val = 0.0;
        if (!instance.isCellInstance()) {
            Cell parent = instance.getParent();
            Netlist netlist = parent.getNetlist();
            boolean found = false;
            Iterator<Connection> it = instance.getConnections();
            while (it.hasNext() && !found) {
                Connection con = it.next();
                Layer layer = con.getArc().getProto().getLayer(0);
                PortInst pi = con.getPortInst();
                Network localNet = netlist.getNetwork(pi);
                if (net != localNet) continue;
                Layer.Function.Set functionSet = new Layer.Function.Set(new Layer.Function[0]);
                functionSet.add(layer);
                Poly[] pols = parent.getTechnology().getShapeOfNode(instance, true, false, functionSet);
                if (pols.length == 1) {
                    val = pols[0].getMaxSize();
                }
                found = true;
            }
            if (!found) {
                Iterator<PortInst> itPort = instance.getPortInsts();
                while (itPort.hasNext() && !found) {
                    PortProto pp;
                    PortInst pi = itPort.next();
                    Network localNet = netlist.getNetwork(pi);
                    if (net != localNet || !((pp = pi.getPortProto()) instanceof PrimitivePort)) continue;
                    PrimitivePort ppp = (PrimitivePort)pp;
                    ArcProto a1 = ppp.getConnections()[0];
                    assert (a1.getArcLayers().length == 1);
                    Layer layer = a1.getArcLayers()[0].getLayer();
                    Layer.Function.Set functionSet = new Layer.Function.Set(new Layer.Function[0]);
                    functionSet.add(layer);
                    Poly[] pols = parent.getTechnology().getShapeOfNode(instance, true, false, functionSet);
                    if (pols.length == 1) {
                        val = pols[0].getMaxSize();
                    }
                    found = true;
                }
            }
            assert (found);
        }
        return result + val;
    }

    @Override
    protected Double reduce(Double result, Network net) {
        Iterator<ArcInst> arcIt = net.getArcs();
        while (arcIt.hasNext()) {
            result = this.reduce(result, arcIt.next(), net);
        }
        Iterator<NodeInst> nodeIt = net.getNodes();
        while (nodeIt.hasNext()) {
            result = this.reduce(result, nodeIt.next(), net);
        }
        return result;
    }
}

