/* 
 * Seahorse
 * 
 * Copyright (C) 2008 Stefan Walter
 * 
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *  
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.  
 */

#include "config.h"

#include "seahorse-gconf.h"
#include "seahorse-key.h"

#include "seahorse-pgp-module.h"
#include "seahorse-pgp-keysets.h"

/* -----------------------------------------------------------------------------
 * COMMON KEYSETS 
 */

static void
pgp_signers_gconf_notify (GConfClient *client, guint id, GConfEntry *entry, 
                          SeahorseSet *skset)
{
    /* Default key changed, refresh */
    seahorse_set_refresh (skset);
}

static gboolean 
pgp_signers_match (SeahorseObject *obj, gpointer data)
{
    SeahorseKey *key, *defkey;
    
    if (!SEAHORSE_IS_KEY (obj))
	    return FALSE;
    
    key = SEAHORSE_KEY (obj);
    defkey = seahorse_context_get_default_key (SCTX_APP ());
    
    /* Default key overrides all, and becomes the only signer available*/
    if (defkey && seahorse_key_get_keyid (key) != seahorse_key_get_keyid (defkey))
        return FALSE;
    
    return TRUE;
}

SeahorseSet*     
seahorse_keyset_pgp_signers_new ()
{
    SeahorseObjectPredicate *pred = g_new0(SeahorseObjectPredicate, 1);
    SeahorseSet *skset;
    
    pred->location = SEAHORSE_LOCATION_LOCAL;
    pred->id = SEAHORSE_PGP;
    pred->usage = SEAHORSE_USAGE_PRIVATE_KEY;
    pred->flags = SKEY_FLAG_CAN_SIGN;
    pred->nflags = SKEY_FLAG_EXPIRED | SKEY_FLAG_REVOKED | SKEY_FLAG_DISABLED;
    pred->custom = pgp_signers_match;
    
    skset = seahorse_set_new_full (pred);
    g_object_set_data_full (G_OBJECT (skset), "pgp-signers-predicate", pred, g_free);
    
    seahorse_gconf_notify_lazy (SEAHORSE_DEFAULT_KEY, 
                                (GConfClientNotifyFunc)pgp_signers_gconf_notify, 
                                skset, skset);
    return skset;
}
