package org.gnu.libebook;

import org.gnu.libedataserver.Config;

public abstract class EContactField
{
    static {
        System.loadLibrary("edsjni-" + Config.LIBEBOOK_API_VERSION);
    }

    private String _fieldName;

    protected EContactField(String fieldName)
    {
        _fieldName = fieldName;
    }

    public String getFieldName()
    {
        return _fieldName;
    }

    public String getPrettyName()
    {
        return e_contact_pretty_name(getFieldEnumId());
    }

    public int getFieldEnumId()
    {
        return e_contact_field_id(_fieldName);
    }

    native static private int e_contact_field_id(String fieldName);

    native static private String e_contact_pretty_name(int fieldId);
}