%define WithBonobo 1

%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define  prefix  /usr
%define  sysconfdir	/etc

Summary: the GNOME spreadsheet
Name: 		gnumeric
Version: 	1.1.6
Release: 	%rel
License: 	GPL
Group: 		Applications/Productivity
Source: ftp://ftp.gnome.org/pub/GNOME/sources/gnumeric/gnumeric-%{version}.tar.gz
Url:		http://www.gnome.org/gnumeric
BuildRoot:	/var/tmp/%{name}-%{PACKAGE_VERSION}-root
Docdir: 	%{prefix}/doc

%if %{WithBonobo}
%define bonobover %{version}-bonobo
%else
%define bonobover %{version}
%endif

Requires: gtk+ >= 1.2.7
Requires: gnome-libs >= 1.0.57
Requires: gnome-print >= 0.29
Requires: libglade >= 0.16
Requires: libxml >= 1.8.14
Requires: libole2 >= 0.2.4
Requires: gal >= 0.14
# The help menu requires gnome-help-browser.
Requires: gnome-core
%if %{WithBonobo}
Requires: bonobo >= 1.0.9
%endif

%description
GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System.

This is the Gnumeric, a spreadsheet for GNOME.  It aims to be a drop in
replacement for commercial spreadsheets.  It provides import/export from
MS Excel files and many other formats (csv, latex, xbase, applix).

# Don't even think about it. -- MW
#%package devel
#Summary: Files necessary to develop gnumeric-based applications.
#Group: Development/Libraries

#%description devel
#The gnumeric-devel package includes files necessary to develop gnumeric-based
#applications.

#Install gnumeric-devel if you want to develop programs which will use gnumeric.

%prep
%setup -q

%build
%ifarch alpha
	MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif

%if ! %{WithBonobo}
	MYBONOBO_FLAGS="--without-bonobo"
%endif
if [ ! -f configure ]; then
	CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $MYARCH_FLAGS $MYBONOBO_FLAGS \
		--prefix=%prefix \
		--sysconfdir=%{sysconfdir} \
		--without-gb
else
	CFLAGS="$RPM_OPT_FLAGS" ./configure $MYARCH_FLAGS $MYBONOBO_FLAGS \
		--prefix=%prefix \
		--sysconfdir=%{sysconfdir} \
		--without-gb
fi

if [ "$SMP" != "" ]; then
	make -k -j$SMP "MAKE=make -k -j$SMP"
else
	make -k
fi

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT%{sysconfdir} install
#
# Auto detect the lang files.
#
if [ -f /usr/lib/rpm/find-lang.sh ] ; then
 /usr/lib/rpm/find-lang.sh $RPM_BUILD_ROOT %name
 sed "s:(644, root, root, 755):(444, bin, bin, 555):" %{name}.lang \
 >tmp.lang && mv tmp.lang %{name}.lang
fi


%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang

%defattr (0555, bin, bin)
%{prefix}/bin/gnumeric
%{prefix}/lib/gnumeric/%{bonobover}/plugins/*/*.so
%{prefix}/lib/gnumeric/%{bonobover}/plugins/*/*.py
%{prefix}/lib/gnumericConf.sh

%defattr (0444, bin, bin, 0555)
%doc HACKING AUTHORS ChangeLog NEWS BUGS README COPYING TODO
%{prefix}/lib/gnumeric/%{bonobover}/plugins/*/*.xml
%{prefix}/lib/gnumeric/%{bonobover}/plugins/*/glossary-po-header
%config %{prefix}/share/gnome/apps/Applications/*
%{prefix}/share/gnome/help/gnumeric/C/figures/*
%{prefix}/share/gnome/help/gnumeric/C/*.*
%dir %{prefix}/share/gnumeric
%dir %{prefix}/share/gnumeric/%{bonobover}
%dir %{prefix}/share/gnumeric/%{bonobover}/autoformat-templates
%dir %{prefix}/share/gnumeric/%{bonobover}/autoformat-templates/3D
%dir %{prefix}/share/gnumeric/%{bonobover}/autoformat-templates/Classical
%dir %{prefix}/share/gnumeric/%{bonobover}/autoformat-templates/Colourful
%dir %{prefix}/share/gnumeric/%{bonobover}/autoformat-templates/Financial
%dir %{prefix}/share/gnumeric/%{bonobover}/autoformat-templates/General
%dir %{prefix}/share/gnumeric/%{bonobover}/autoformat-templates/List
%dir %{prefix}/share/gnumeric/%{bonobover}/glade
%dir %{prefix}/share/gnumeric/%{bonobover}/gnome
%dir %{prefix}/share/gnumeric/%{bonobover}/gnome/ui
%dir %{prefix}/share/gnumeric/%{bonobover}/python
%dir %{prefix}/share/gnumeric/%{bonobover}/templates
%{prefix}/share/gnumeric/%{bonobover}/autoformat-templates/3D/*
%{prefix}/share/gnumeric/%{bonobover}/autoformat-templates/Classical/*
%{prefix}/share/gnumeric/%{bonobover}/autoformat-templates/Colourful/*
%{prefix}/share/gnumeric/%{bonobover}/autoformat-templates/Financial/*
%{prefix}/share/gnumeric/%{bonobover}/autoformat-templates/General/*
%{prefix}/share/gnumeric/%{bonobover}/autoformat-templates/List/*
%{prefix}/share/gnumeric/%{bonobover}/glade/*
%{prefix}/share/gnumeric/%{bonobover}/gnome/ui/*
%{prefix}/share/gnumeric/%{bonobover}/idl/*
%{prefix}/share/gnumeric/%{bonobover}/python/*
%{prefix}/share/gnumeric/%{bonobover}/templates/*
#%{prefix}/share/locale/*/LC_MESSAGES/*.mo
%{prefix}/share/mc/templates/*
%{prefix}/share/mime-info/*
%{prefix}/share/oaf/*
%{prefix}/share/pixmaps/gnumeric/*
%{prefix}/share/pixmaps/*.*

# Don't even think about it.  -MW
# Gnumeric is not ready for a devel package yet.  Please wait until we split
# out libgnumeric.
#%files devel
#%defattr (-, bin, bin)
#%{prefix}/lib/gnumericConf.sh
#%{prefix}/share/gnumeric/%{bonobover}/idl/*.idl
# This is really silly.  The .la files are useless for plugins.
##%{prefix}/lib/gnumeric/%{bonobover}/plugins/*/*.la

%changelog
* Sun Nov  4 2001 Jody Goldberg <jgoldberg@home.com>
- bump the libole req

* Wed Oct  9 2001 John Gotts <jgotts@linuxsavvy.com>
- gnome-core added as a requirement because gnumeric requires
  gnome-help-browser.  Also added bonobo >= 1.0.9 as a requirement.

* Wed Sep 12 2001 John Gotts <jgotts@linuxsavvy.com>
- Keep the /usr/share/gnumeric directory structure under RPM revision control.
  %dirs should be used sparingly, but no other package will use this directory
  structure, so it's okay here.

* Thu Jun 28 2001 Jody Goldberg <jgoldberg@home.com>
- bump libxml1 req.

* Wed Jun 27 2001 John Gotts <jgotts@linuxsavvy.com>
- Added the python stuff back; it reappeared in 0.66.
- We're now Bonobo by default!
- Cautiously added a %dir.  %dir gets overused by many RPM's.  Try running
  'rpm -qf /usr/bin' some time.  ;-(

* Wed Jun 27 2001 John Gotts <jgotts@linuxsavvy.com>
- Note that the most important reason for -devel RPM's is to exclude files that
  aren't needed on the majority of systems.  The reason that the "premature"
  and "useless" files were moved to a -devel RPM wasn't to highlight their
  usefulness for software development, it was to facilitate their exclusion
  from the vast majority of installations.  It would be better to not install
  these files in the first place, but spec files should follow the principle of
  least surprise and mirror what a "make install" would do.
- Used some more wildcards for easier maintainability.
- Re-alphabetize.
- gnumericConf.sh shouldn't have its executable bit stripped.
- The python plugin doesn't seem to be getting built by default anymore.

* Tue Jun 26 2001 Jody Goldberg <jgoldberg@home.com>
- load the bonobo ui file from a version specific location

* Sat May 19 2001 Jody Goldberg <jgoldberg@home.com>
- update the gal req

* Tue Apr 01 2001 Jody Goldberg <jgoldberg@home.com>
- remove gnorba file
- rename oaf file
- include category files

* Tue Feb 20 2001 John Gotts <jgotts@linuxsavvy.com>
- Adapted to the recent directory reorganization.  Also alphabetically
  reordered the directories while I was at it.  Someone should figure out why
  we can't package the locale data.

* Tue Feb 13 2001 Jody Goldberg <jgoldberg@home.com>
- Updated version requirements for libglade

* Sat Feb 10 2001 Jody Goldberg <jgoldberg@home.com>
- Updated version requirements for GAL

* Wed Dec 06 2000 Jody Goldberg <jgoldberg@home.com>
- Updated version requirements for GAL

* Tue Nov 14 2000 John Gotts <jgotts@linuxsavvy.com>
- Require GAL 0.2.2 instead of 0.2.2.0.
- Use %{version} instead of at characters surrouding VERSION (it makes a nicer
  generated spec file).
- Created devel package.
- Fixed category to match Red Hat.
- Added the standard mechanism to build from either the tarball or CVS (and
  reindented things following the current practice).

* Thu Nov 09 2000 Jody Goldberg <jgoldberg@home.com>
- Updated version requirements for GAL

* Fri Nov 03 2000 Jody Goldberg <jgoldberg@home.com>
- Updated version requirements for GAL

* Wed Oct 18 2000 John Gotts <jgotts@linuxsavvy.com>
- Added gnumeric.xml, gnome-application-x-gnumeric.png,
  gnome-application-x-xls.png, gnumeric.oafinfo, and gnumericConf.sh. 
- Fixed incorrect idl path.
- Removed an excess blank line.  ;-)

* Sun Oct 01 2000 Almer S. Tigelaar <almer1@dds.nl>
- Make some minor adjustments for the autoformatter

* Thu Sep 28 2000 Jody Goldberg <jgoldberg@home.com>
- Updated version requirements for gnome-print

* Wed Sep 20 2000 Jody Goldberg <jgoldberg@home.com>
- Updated version requirements for glade
- Looks like someone already added gal.

* Wed Sep 20 2000 Kenneth Christiansen <kenneth@gnu.org>
- Made it work with the new autoformatter
- Upped gnome-print to 0.22

* Sat Aug 11 2000 Jody Goldberg <jgoldberg@home.com>
- Updated version requirements for gnome-print

* Sat Jun 21 2000 Jody Goldberg <jgoldberg@home.com>
- Add libole2

* Sat May 20 2000 Jody Goldberg <jgoldberg@home.com>
- Updated version requirements for gnome-print, and libglade.

* Mon May 15 2000 Karl Eichwalder <ke@suse.de>
- Use %{version}, %{name} and %{sysconfdir} more consistently.
- Avoid long lines.

* Thu Mar 29 2000 Kjartan Maraas <kmaraas@online.no>
- Removed gnome-gnumeric-xl.png since it is nowhere to be found.
- Added --without-bonobo and --without-gb.
- Added %define for sysconfdir

* Mon Feb 29 2000 Jody Goldberg <jgoldberg@home.com>
- Updated version requirements for gnome-print, and gnome-libs.

* Sun Jan 30 2000 Gregory McLean <gregm@comstar.net>
- Added in some auto-detect the language files logic (rpm 3.0.xx only)

* Mon Jan 12 2000 Jody Goldberg <jgoldberg@home.com>
- Add depend on gtk+ >= 1.2.2 so that we can get gtk_object_get.

* Mon Jan 03 2000 Gregory McLean <gregm@comstar.net>
- Updated to 0.47

* Mon Dec 20 1999 Jody Goldberg <jgoldberg@home.com>
- Updated the libglade dependancy.
- Remove req for guile.  We can build without it.

* Thu Sep 02 1999 Gregory McLean <gregm@comstar.net>
- Added small fix so glade generated dialogs appear.

* Wed Jul 14 1999 Gregory McLean <gregm@comstar.net>
- Added the gnome-print requirement.
- Updated the file list to try and quiet down the updating.
- added the sysconfdir

* Tue Mar 9  1999 Gregory McLean <gregm@comstar.net>
- Updated the spec file.

* Thu Sep 24 1998 Michael Fulbright <msf@redhat.com>
- Version 0.2
