/* RecordingWriter.c generated by valac 0.12.0, the Vala compiler
 * generated from RecordingWriter.vala, do not modify */

/*
 * Copyright (C) 2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define DVB_IO_TYPE_RECORDING_WRITER (dvb_io_recording_writer_get_type ())
#define DVB_IO_RECORDING_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_RECORDING_WRITER, DVBioRecordingWriter))
#define DVB_IO_RECORDING_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_RECORDING_WRITER, DVBioRecordingWriterClass))
#define DVB_IO_IS_RECORDING_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_RECORDING_WRITER))
#define DVB_IO_IS_RECORDING_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_RECORDING_WRITER))
#define DVB_IO_RECORDING_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_RECORDING_WRITER, DVBioRecordingWriterClass))

typedef struct _DVBioRecordingWriter DVBioRecordingWriter;
typedef struct _DVBioRecordingWriterClass DVBioRecordingWriterClass;
typedef struct _DVBioRecordingWriterPrivate DVBioRecordingWriterPrivate;

#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DVBioRecordingWriter {
	GObject parent_instance;
	DVBioRecordingWriterPrivate * priv;
};

struct _DVBioRecordingWriterClass {
	GObjectClass parent_class;
};

struct _DVBioRecordingWriterPrivate {
	DVBRecording* _rec;
};


static gpointer dvb_io_recording_writer_parent_class = NULL;
static DVBLoggingLogger* dvb_io_recording_writer_log;
static DVBLoggingLogger* dvb_io_recording_writer_log = NULL;

GType dvb_io_recording_writer_get_type (void) G_GNUC_CONST;
GType dvb_recording_get_type (void) G_GNUC_CONST;
#define DVB_IO_RECORDING_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_IO_TYPE_RECORDING_WRITER, DVBioRecordingWriterPrivate))
enum  {
	DVB_IO_RECORDING_WRITER_DUMMY_PROPERTY,
	DVB_IO_RECORDING_WRITER_REC
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBioRecordingWriter* dvb_io_recording_writer_new (DVBRecording* rec);
DVBioRecordingWriter* dvb_io_recording_writer_construct (GType object_type, DVBRecording* rec);
void dvb_io_recording_writer_write (DVBioRecordingWriter* self, GError** error);
DVBRecording* dvb_io_recording_writer_get_rec (DVBioRecordingWriter* self);
GFile* dvb_recording_get_Location (DVBRecording* self);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
gchar* dvb_io_recording_writer_serialize (DVBioRecordingWriter* self, DVBRecording* rec);
guint* dvb_recording_get_start (DVBRecording* self, int* result_length1);
const gchar* dvb_recording_get_Name (DVBRecording* self);
const gchar* dvb_recording_get_Description (DVBRecording* self);
guint32 dvb_recording_get_Id (DVBRecording* self);
const gchar* dvb_recording_get_ChannelName (DVBRecording* self);
gint64 dvb_recording_get_Length (DVBRecording* self);
static void dvb_io_recording_writer_set_rec (DVBioRecordingWriter* self, DVBRecording* value);
static void dvb_io_recording_writer_finalize (GObject* obj);
static void _vala_dvb_io_recording_writer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_io_recording_writer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DVBioRecordingWriter* dvb_io_recording_writer_construct (GType object_type, DVBRecording* rec) {
	DVBioRecordingWriter * self = NULL;
	g_return_val_if_fail (rec != NULL, NULL);
	self = (DVBioRecordingWriter*) g_object_new (object_type, "rec", rec, NULL);
	return self;
}


DVBioRecordingWriter* dvb_io_recording_writer_new (DVBRecording* rec) {
	return dvb_io_recording_writer_construct (DVB_IO_TYPE_RECORDING_WRITER, rec);
}


/**
         * Stores all information of the timer in info.rec
         * in the directory of this.Location
         */
static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	guint8* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = -1;
	_tmp0_ = strlen (self);
	res_length1 = (gint) _tmp0_;
	_tmp1_ = res;
	*result_length1 = res_length1;
	result = _tmp1_;
	return result;
}


void dvb_io_recording_writer_write (DVBioRecordingWriter* self, GError** error) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* parentdir;
	GFile* _tmp2_ = NULL;
	GFile* recfile;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_;
	GFileOutputStream* _tmp6_ = NULL;
	GFileOutputStream* stream;
	gchar* _tmp7_ = NULL;
	gchar* text;
	guint8* _tmp8_ = NULL;
	gint _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_recording_get_Location (self->priv->_rec);
	_tmp1_ = g_file_get_parent (_tmp0_);
	parentdir = _tmp1_;
	_tmp2_ = g_file_get_child (parentdir, "info.rec");
	recfile = _tmp2_;
	_tmp3_ = g_file_get_path (recfile);
	_tmp4_ = _tmp3_;
	dvb_logging_logger_debug (dvb_io_recording_writer_log, "RecordingWriter.vala:44: Saving recording to %s", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = g_file_query_exists (recfile, NULL);
	if (_tmp5_) {
		dvb_logging_logger_debug (dvb_io_recording_writer_log, "RecordingWriter.vala:47: Deleting old info.rec");
		g_file_delete (recfile, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (recfile);
			_g_object_unref0 (parentdir);
			return;
		}
	}
	_tmp6_ = g_file_create (recfile, 0, NULL, &_inner_error_);
	stream = _tmp6_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (recfile);
		_g_object_unref0 (parentdir);
		return;
	}
	_tmp7_ = dvb_io_recording_writer_serialize (self, self->priv->_rec);
	text = _tmp7_;
	_tmp8_ = string_get_data (text, &_tmp9_);
	g_output_stream_write ((GOutputStream*) stream, _tmp8_, (gsize) _tmp9_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (text);
		_g_object_unref0 (stream);
		_g_object_unref0 (recfile);
		_g_object_unref0 (parentdir);
		return;
	}
	g_output_stream_close ((GOutputStream*) stream, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (text);
		_g_object_unref0 (stream);
		_g_object_unref0 (recfile);
		_g_object_unref0 (parentdir);
		return;
	}
	_g_free0 (text);
	_g_object_unref0 (stream);
	_g_object_unref0 (recfile);
	_g_object_unref0 (parentdir);
}


gchar* dvb_io_recording_writer_serialize (DVBioRecordingWriter* self, DVBRecording* rec) {
	gchar* result = NULL;
	gint _tmp0_;
	guint* _tmp1_ = NULL;
	guint* started;
	gint started_length1;
	gint _started_size_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	guint32 _tmp8_;
	const gchar* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gint64 _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (rec != NULL, NULL);
	_tmp1_ = dvb_recording_get_start (rec, &_tmp0_);
	started = _tmp1_;
	started_length1 = _tmp0_;
	_started_size_ = _tmp0_;
	_tmp3_ = dvb_recording_get_Name (rec);
	if (_tmp3_ == NULL) {
		_tmp2_ = "";
	} else {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = dvb_recording_get_Name (rec);
		_tmp2_ = _tmp4_;
	}
	_tmp6_ = dvb_recording_get_Description (rec);
	if (_tmp6_ == NULL) {
		_tmp5_ = "";
	} else {
		const gchar* _tmp7_ = NULL;
		_tmp7_ = dvb_recording_get_Description (rec);
		_tmp5_ = _tmp7_;
	}
	_tmp8_ = dvb_recording_get_Id (rec);
	_tmp9_ = dvb_recording_get_ChannelName (rec);
	_tmp10_ = dvb_recording_get_Location (rec);
	_tmp11_ = g_file_get_path (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = dvb_recording_get_Length (rec);
	_tmp14_ = g_strdup_printf ("%u\n%s\n%s\n%u-%u-%u %u:%u\n%" G_GINT64_FORMAT "\n%s\n%s", _tmp8_, _tmp9_, _tmp12_, started[0], started[1], started[2], started[3], started[4], _tmp13_, _tmp2_, _tmp5_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp12_);
	result = _tmp15_;
	started = (g_free (started), NULL);
	return result;
}


DVBRecording* dvb_io_recording_writer_get_rec (DVBioRecordingWriter* self) {
	DVBRecording* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_rec;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_io_recording_writer_set_rec (DVBioRecordingWriter* self, DVBRecording* value) {
	DVBRecording* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_rec);
	self->priv->_rec = _tmp0_;
	g_object_notify ((GObject *) self, "rec");
}


static void dvb_io_recording_writer_class_init (DVBioRecordingWriterClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_io_recording_writer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBioRecordingWriterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_io_recording_writer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_io_recording_writer_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_io_recording_writer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_RECORDING_WRITER_REC, g_param_spec_object ("rec", "rec", "rec", DVB_TYPE_RECORDING, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_io_recording_writer_log = _tmp1_;
}


static void dvb_io_recording_writer_instance_init (DVBioRecordingWriter * self) {
	self->priv = DVB_IO_RECORDING_WRITER_GET_PRIVATE (self);
}


static void dvb_io_recording_writer_finalize (GObject* obj) {
	DVBioRecordingWriter * self;
	self = DVB_IO_RECORDING_WRITER (obj);
	_g_object_unref0 (self->priv->_rec);
	G_OBJECT_CLASS (dvb_io_recording_writer_parent_class)->finalize (obj);
}


GType dvb_io_recording_writer_get_type (void) {
	static volatile gsize dvb_io_recording_writer_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_io_recording_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBioRecordingWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_io_recording_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBioRecordingWriter), 0, (GInstanceInitFunc) dvb_io_recording_writer_instance_init, NULL };
		GType dvb_io_recording_writer_type_id;
		dvb_io_recording_writer_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBioRecordingWriter", &g_define_type_info, 0);
		g_once_init_leave (&dvb_io_recording_writer_type_id__volatile, dvb_io_recording_writer_type_id);
	}
	return dvb_io_recording_writer_type_id__volatile;
}


static void _vala_dvb_io_recording_writer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBioRecordingWriter * self;
	self = DVB_IO_RECORDING_WRITER (object);
	switch (property_id) {
		case DVB_IO_RECORDING_WRITER_REC:
		g_value_set_object (value, dvb_io_recording_writer_get_rec (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_io_recording_writer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBioRecordingWriter * self;
	self = DVB_IO_RECORDING_WRITER (object);
	switch (property_id) {
		case DVB_IO_RECORDING_WRITER_REC:
		dvb_io_recording_writer_set_rec (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



