/* RecordingReader.c generated by valac 0.12.0, the Vala compiler
 * generated from RecordingReader.vala, do not modify */

/*
 * Copyright (C) 2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <time.h>


#define DVB_IO_TYPE_RECORDING_READER (dvb_io_recording_reader_get_type ())
#define DVB_IO_RECORDING_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReader))
#define DVB_IO_RECORDING_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderClass))
#define DVB_IO_IS_RECORDING_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_RECORDING_READER))
#define DVB_IO_IS_RECORDING_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_RECORDING_READER))
#define DVB_IO_RECORDING_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderClass))

typedef struct _DVBioRecordingReader DVBioRecordingReader;
typedef struct _DVBioRecordingReaderClass DVBioRecordingReaderClass;
typedef struct _DVBioRecordingReaderPrivate DVBioRecordingReaderPrivate;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _DVBioRecordingReader {
	GObject parent_instance;
	DVBioRecordingReaderPrivate * priv;
};

struct _DVBioRecordingReaderClass {
	GObjectClass parent_class;
};

struct _DVBioRecordingReaderPrivate {
	GFile* _directory;
	DVBRecordingsStore* _store;
};


static gpointer dvb_io_recording_reader_parent_class = NULL;
static DVBLoggingLogger* dvb_io_recording_reader_log;
static DVBLoggingLogger* dvb_io_recording_reader_log = NULL;

GType dvb_io_recording_reader_get_type (void) G_GNUC_CONST;
GType dvb_recordings_store_get_type (void) G_GNUC_CONST;
#define DVB_IO_RECORDING_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderPrivate))
enum  {
	DVB_IO_RECORDING_READER_DUMMY_PROPERTY,
	DVB_IO_RECORDING_READER_DIRECTORY,
	DVB_IO_RECORDING_READER_STORE
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_IO_RECORDING_READER_ATTRS G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_NAME
DVBioRecordingReader* dvb_io_recording_reader_new (GFile* recordingsbasedir, DVBRecordingsStore* recstore);
DVBioRecordingReader* dvb_io_recording_reader_construct (GType object_type, GFile* recordingsbasedir, DVBRecordingsStore* recstore);
gboolean dvb_io_recording_reader_load_into (DVBioRecordingReader* self);
GFile* dvb_io_recording_reader_get_directory (DVBioRecordingReader* self);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
static gboolean dvb_io_recording_reader_restore_from_dir (DVBioRecordingReader* self, GFile* recordingsbasedir);
static gboolean dvb_io_recording_reader_is_readable_dir (GFile* directory);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
GType dvb_recording_get_type (void) G_GNUC_CONST;
DVBRecording* dvb_io_recording_reader_deserialize (DVBioRecordingReader* self, GFile* file, GError** error);
DVBRecordingsStore* dvb_io_recording_reader_get_store (DVBioRecordingReader* self);
gboolean dvb_recordings_store_add_and_monitor (DVBRecordingsStore* self, DVBRecording* rec);
DVBRecording* dvb_recording_new (void);
DVBRecording* dvb_recording_construct (GType object_type);
void dvb_recording_set_Id (DVBRecording* self, guint32 value);
void dvb_recording_set_ChannelName (DVBRecording* self, const gchar* value);
void dvb_recording_set_Location (DVBRecording* self, GFile* value);
void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
void dvb_recording_set_StartTime (DVBRecording* self, struct tm* value);
void dvb_recording_set_Length (DVBRecording* self, gint64 value);
void dvb_recording_set_Name (DVBRecording* self, const gchar* value);
void dvb_recording_set_Description (DVBRecording* self, const gchar* value);
static void dvb_io_recording_reader_set_directory (DVBioRecordingReader* self, GFile* value);
static void dvb_io_recording_reader_set_store (DVBioRecordingReader* self, DVBRecordingsStore* value);
static void dvb_io_recording_reader_finalize (GObject* obj);
static void _vala_dvb_io_recording_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_io_recording_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
         * @recordingsbasedir: The directory to search
         */
DVBioRecordingReader* dvb_io_recording_reader_construct (GType object_type, GFile* recordingsbasedir, DVBRecordingsStore* recstore) {
	DVBioRecordingReader * self = NULL;
	g_return_val_if_fail (recordingsbasedir != NULL, NULL);
	g_return_val_if_fail (recstore != NULL, NULL);
	self = (DVBioRecordingReader*) g_object_new (object_type, "directory", recordingsbasedir, "store", recstore, NULL);
	return self;
}


DVBioRecordingReader* dvb_io_recording_reader_new (GFile* recordingsbasedir, DVBRecordingsStore* recstore) {
	return dvb_io_recording_reader_construct (DVB_IO_TYPE_RECORDING_READER, recordingsbasedir, recstore);
}


/**
         * Searches recursively in the given directory
         * for "info.rec" files, restores a new Recording
         * from that file and adds it to itsself.
         */
gboolean dvb_io_recording_reader_load_into (DVBioRecordingReader* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_file_query_exists (self->priv->_directory, NULL);
	if (!_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = g_file_get_path (self->priv->_directory);
		_tmp2_ = _tmp1_;
		dvb_logging_logger_debug (dvb_io_recording_reader_log, "RecordingReader.vala:48: Directory %s does not exist", _tmp2_);
		_g_free0 (_tmp2_);
		result = FALSE;
		return result;
	}
	_tmp3_ = dvb_io_recording_reader_restore_from_dir (self, self->priv->_directory);
	result = _tmp3_;
	return result;
}


static gboolean dvb_io_recording_reader_is_readable_dir (GFile* directory) {
	gboolean result = FALSE;
	GFileInfo* info = NULL;
	GFileInfo* _tmp0_ = NULL;
	GFileInfo* _tmp1_;
	GFileType _tmp2_;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (directory != NULL, FALSE);
	_tmp0_ = g_file_query_info (directory, DVB_IO_RECORDING_READER_ATTRS, 0, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch9_g_error;
	}
	_g_object_unref0 (info);
	info = _tmp1_;
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_io_recording_reader_log, "RecordingReader.vala:60: Could not retrieve attributes: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (info);
		return result;
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp2_ = g_file_info_get_file_type (info);
	if (_tmp2_ != G_FILE_TYPE_DIRECTORY) {
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = g_file_get_path (directory);
		_tmp4_ = _tmp3_;
		dvb_logging_logger_error (dvb_io_recording_reader_log, "RecordingReader.vala:65: %s is not a directory", _tmp4_);
		_g_free0 (_tmp4_);
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	_tmp5_ = g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	if (!_tmp5_) {
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp6_ = g_file_get_path (directory);
		_tmp7_ = _tmp6_;
		dvb_logging_logger_error (dvb_io_recording_reader_log, "RecordingReader.vala:70: Cannot read %s", _tmp7_);
		_g_free0 (_tmp7_);
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (info);
	return result;
}


static gboolean dvb_io_recording_reader_restore_from_dir (DVBioRecordingReader* self, GFile* recordingsbasedir) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GFileEnumerator* files = NULL;
	GFileEnumerator* _tmp1_ = NULL;
	GFileEnumerator* _tmp2_;
	gboolean success;
	GFileInfo* childinfo = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (recordingsbasedir != NULL, FALSE);
	_tmp0_ = dvb_io_recording_reader_is_readable_dir (recordingsbasedir);
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = g_file_enumerate_children (recordingsbasedir, DVB_IO_RECORDING_READER_ATTRS, 0, NULL, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch10_g_error;
	}
	_g_object_unref0 (files);
	files = _tmp2_;
	goto __finally10;
	__catch10_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_io_recording_reader_log, "RecordingReader.vala:86: Could not read directory: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (files);
		return result;
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (files);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	success = TRUE;
	while (TRUE) {
		GFileInfo* _tmp3_ = NULL;
		GFileInfo* _tmp4_;
		guint32 _tmp5_;
		guint32 type;
		const gchar* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GFile* child;
		_tmp3_ = g_file_enumerator_next_file (files, NULL, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (childinfo);
			goto __catch11_g_error;
		}
		_g_object_unref0 (childinfo);
		childinfo = _tmp4_;
		if (!(childinfo != NULL)) {
			break;
		}
		_tmp5_ = g_file_info_get_attribute_uint32 (childinfo, G_FILE_ATTRIBUTE_STANDARD_TYPE);
		type = _tmp5_;
		_tmp6_ = g_file_info_get_name (childinfo);
		_tmp7_ = g_file_get_child (recordingsbasedir, _tmp6_);
		child = _tmp7_;
		switch (type) {
			case G_FILE_TYPE_DIRECTORY:
			{
				dvb_io_recording_reader_restore_from_dir (self, child);
				break;
			}
			case G_FILE_TYPE_REGULAR:
			{
				const gchar* _tmp8_ = NULL;
				_tmp8_ = g_file_info_get_name (childinfo);
				if (g_strcmp0 (_tmp8_, "info.rec") == 0) {
					DVBRecording* rec;
					DVBRecording* _tmp9_ = NULL;
					DVBRecording* _tmp10_;
					rec = NULL;
					_tmp9_ = dvb_io_recording_reader_deserialize (self, child, &_inner_error_);
					_tmp10_ = _tmp9_;
					if (_inner_error_ != NULL) {
						goto __catch12_g_error;
					}
					_g_object_unref0 (rec);
					rec = _tmp10_;
					goto __finally12;
					__catch12_g_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						dvb_logging_logger_error (dvb_io_recording_reader_log, "RecordingReader.vala:111: Could not deserialize recording: %s", e->message);
						_g_error_free0 (e);
					}
					__finally12:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (rec);
						_g_object_unref0 (child);
						_g_object_unref0 (childinfo);
						goto __catch11_g_error;
					}
					if (rec != NULL) {
						gchar* _tmp11_ = NULL;
						gchar* _tmp12_;
						_tmp11_ = g_file_get_path (child);
						_tmp12_ = _tmp11_;
						dvb_logging_logger_debug (dvb_io_recording_reader_log, "RecordingReader.vala:116: Restored recording from %s", _tmp12_);
						_g_free0 (_tmp12_);
						dvb_recordings_store_add_and_monitor (self->priv->_store, rec);
					}
					_g_object_unref0 (rec);
				}
				break;
			}
			default:
			break;
		}
		_g_object_unref0 (child);
	}
	_g_object_unref0 (childinfo);
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_io_recording_reader_log, "RecordingReader.vala:127: %s", e->message);
		success = FALSE;
		_g_error_free0 (e);
	}
	__finally11:
	g_file_enumerator_close (files, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch13_g_error;
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_io_recording_reader_log, "RecordingReader.vala:133: Could not close file: %s", e->message);
		success = FALSE;
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (files);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (_inner_error_ != NULL) {
		_g_object_unref0 (files);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = success;
	_g_object_unref0 (files);
	return result;
}


DVBRecording* dvb_io_recording_reader_deserialize (DVBioRecordingReader* self, GFile* file, GError** error) {
	DVBRecording* result = NULL;
	GFileInputStream* _tmp0_ = NULL;
	GFileInputStream* _tmp1_;
	GFileInputStream* _tmp2_;
	GDataInputStream* _tmp3_ = NULL;
	GDataInputStream* _tmp4_;
	GDataInputStream* reader;
	gchar* line;
	gsize len = 0UL;
	gint line_number;
	DVBRecording* _tmp5_ = NULL;
	DVBRecording* rec;
	GString* _tmp6_ = NULL;
	GString* description;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_file_read (file, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp2_ = _tmp1_;
	_tmp3_ = g_data_input_stream_new ((GInputStream*) _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	reader = _tmp4_;
	line = NULL;
	line_number = 0;
	_tmp5_ = dvb_recording_new ();
	rec = _tmp5_;
	_tmp6_ = g_string_new ("");
	description = _tmp6_;
	while (TRUE) {
		gsize _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp8_ = g_data_input_stream_read_line (reader, &_tmp7_, NULL, &_inner_error_);
		len = _tmp7_;
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (description);
			_g_object_unref0 (rec);
			_g_free0 (line);
			_g_object_unref0 (reader);
			return NULL;
		}
		_g_free0 (line);
		line = _tmp9_;
		if (!(line != NULL)) {
			break;
		}
		switch (line_number) {
			case 0:
			{
				gint _tmp10_;
				_tmp10_ = atoi (line);
				dvb_recording_set_Id (rec, (guint32) _tmp10_);
				break;
			}
			case 1:
			{
				dvb_recording_set_ChannelName (rec, line);
				break;
			}
			case 2:
			{
				GFile* _tmp11_ = NULL;
				if (len == 0) {
					_g_object_unref0 (_tmp11_);
					_tmp11_ = NULL;
				} else {
					GFile* _tmp12_ = NULL;
					_tmp12_ = g_file_new_for_path (line);
					_g_object_unref0 (_tmp11_);
					_tmp11_ = _tmp12_;
				}
				dvb_recording_set_Location (rec, _tmp11_);
				_g_object_unref0 (_tmp11_);
				break;
			}
			case 3:
			{
				{
					gint year;
					gint month;
					gint day;
					gint hour;
					gint minute;
					gboolean _tmp13_ = FALSE;
					gboolean _tmp14_ = FALSE;
					gboolean _tmp15_ = FALSE;
					gboolean _tmp16_ = FALSE;
					year = 0;
					month = 0;
					day = 0;
					hour = 0;
					minute = 0;
					sscanf (line, "%d-%d-%d %d:%d", &year, &month, &day, &hour, &minute);
					if (year >= 1900) {
						_tmp16_ = month >= 1;
					} else {
						_tmp16_ = FALSE;
					}
					if (_tmp16_) {
						_tmp15_ = day >= 1;
					} else {
						_tmp15_ = FALSE;
					}
					if (_tmp15_) {
						_tmp14_ = hour >= 0;
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						_tmp13_ = minute >= 0;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						struct tm _tmp17_ = {0};
						struct tm _tmp18_ = {0};
						dvb_utils_create_time (year, month, day, hour, minute, 0, &_tmp17_);
						_tmp18_ = _tmp17_;
						dvb_recording_set_StartTime (rec, &_tmp18_);
					}
					break;
				}
			}
			case 4:
			{
				gint _tmp19_;
				_tmp19_ = atoi (line);
				dvb_recording_set_Length (rec, (gint64) _tmp19_);
				break;
			}
			case 5:
			{
				const gchar* _tmp20_ = NULL;
				if (len == 0) {
					_tmp20_ = NULL;
				} else {
					_tmp20_ = line;
				}
				dvb_recording_set_Name (rec, _tmp20_);
				break;
			}
			default:
			{
				g_string_append (description, line);
				break;
			}
		}
		line_number++;
	}
	g_input_stream_close ((GInputStream*) reader, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (description);
		_g_object_unref0 (rec);
		_g_free0 (line);
		_g_object_unref0 (reader);
		return NULL;
	}
	dvb_recording_set_Description (rec, description->str);
	result = rec;
	_g_string_free0 (description);
	_g_free0 (line);
	_g_object_unref0 (reader);
	return result;
}


GFile* dvb_io_recording_reader_get_directory (DVBioRecordingReader* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_directory;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_io_recording_reader_set_directory (DVBioRecordingReader* self, GFile* value) {
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_directory);
	self->priv->_directory = _tmp0_;
	g_object_notify ((GObject *) self, "directory");
}


DVBRecordingsStore* dvb_io_recording_reader_get_store (DVBioRecordingReader* self) {
	DVBRecordingsStore* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_store;
	return result;
}


static void dvb_io_recording_reader_set_store (DVBioRecordingReader* self, DVBRecordingsStore* value) {
	DVBRecordingsStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_store);
	self->priv->_store = _tmp0_;
	g_object_notify ((GObject *) self, "store");
}


static void dvb_io_recording_reader_class_init (DVBioRecordingReaderClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_io_recording_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBioRecordingReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_io_recording_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_io_recording_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_io_recording_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_RECORDING_READER_DIRECTORY, g_param_spec_object ("directory", "directory", "directory", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_RECORDING_READER_STORE, g_param_spec_object ("store", "store", "store", DVB_TYPE_RECORDINGS_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_io_recording_reader_log = _tmp1_;
}


static void dvb_io_recording_reader_instance_init (DVBioRecordingReader * self) {
	self->priv = DVB_IO_RECORDING_READER_GET_PRIVATE (self);
}


static void dvb_io_recording_reader_finalize (GObject* obj) {
	DVBioRecordingReader * self;
	self = DVB_IO_RECORDING_READER (obj);
	_g_object_unref0 (self->priv->_directory);
	_g_object_unref0 (self->priv->_store);
	G_OBJECT_CLASS (dvb_io_recording_reader_parent_class)->finalize (obj);
}


GType dvb_io_recording_reader_get_type (void) {
	static volatile gsize dvb_io_recording_reader_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_io_recording_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBioRecordingReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_io_recording_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBioRecordingReader), 0, (GInstanceInitFunc) dvb_io_recording_reader_instance_init, NULL };
		GType dvb_io_recording_reader_type_id;
		dvb_io_recording_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBioRecordingReader", &g_define_type_info, 0);
		g_once_init_leave (&dvb_io_recording_reader_type_id__volatile, dvb_io_recording_reader_type_id);
	}
	return dvb_io_recording_reader_type_id__volatile;
}


static void _vala_dvb_io_recording_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBioRecordingReader * self;
	self = DVB_IO_RECORDING_READER (object);
	switch (property_id) {
		case DVB_IO_RECORDING_READER_DIRECTORY:
		g_value_set_object (value, dvb_io_recording_reader_get_directory (self));
		break;
		case DVB_IO_RECORDING_READER_STORE:
		g_value_set_object (value, dvb_io_recording_reader_get_store (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_io_recording_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBioRecordingReader * self;
	self = DVB_IO_RECORDING_READER (object);
	switch (property_id) {
		case DVB_IO_RECORDING_READER_DIRECTORY:
		dvb_io_recording_reader_set_directory (self, g_value_get_object (value));
		break;
		case DVB_IO_RECORDING_READER_STORE:
		dvb_io_recording_reader_set_store (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



