/* SatelliteChannel.c generated by valac 0.12.0, the Vala compiler
 * generated from SatelliteChannel.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>


#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
typedef struct _DVBChannelPrivate DVBChannelPrivate;

#define DVB_TYPE_SATELLITE_CHANNEL (dvb_satellite_channel_get_type ())
#define DVB_SATELLITE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannel))
#define DVB_SATELLITE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannelClass))
#define DVB_IS_SATELLITE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SATELLITE_CHANNEL))
#define DVB_IS_SATELLITE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SATELLITE_CHANNEL))
#define DVB_SATELLITE_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannelClass))

typedef struct _DVBSatelliteChannel DVBSatelliteChannel;
typedef struct _DVBSatelliteChannelClass DVBSatelliteChannelClass;
typedef struct _DVBSatelliteChannelPrivate DVBSatelliteChannelPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DVBChannel {
	GObject parent_instance;
	DVBChannelPrivate * priv;
};

struct _DVBChannelClass {
	GObjectClass parent_class;
	gboolean (*is_valid) (DVBChannel* self);
	gboolean (*on_same_transport_stream) (DVBChannel* self, DVBChannel* channel);
	gboolean (*equals) (DVBChannel* self, DVBChannel* channel);
	void (*setup_dvb_source) (DVBChannel* self, GstElement* source);
	gchar* (*to_string) (DVBChannel* self);
};

struct _DVBSatelliteChannel {
	DVBChannel parent_instance;
	DVBSatelliteChannelPrivate * priv;
};

struct _DVBSatelliteChannelClass {
	DVBChannelClass parent_class;
};

struct _DVBSatelliteChannelPrivate {
	gchar* _Polarization;
	guint _SymbolRate;
	gint _DiseqcSource;
};


static gpointer dvb_satellite_channel_parent_class = NULL;

GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_satellite_channel_get_type (void) G_GNUC_CONST;
#define DVB_SATELLITE_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannelPrivate))
enum  {
	DVB_SATELLITE_CHANNEL_DUMMY_PROPERTY,
	DVB_SATELLITE_CHANNEL_POLARIZATION,
	DVB_SATELLITE_CHANNEL_SYMBOL_RATE,
	DVB_SATELLITE_CHANNEL_DISEQC_SOURCE
};
DVBSatelliteChannel* dvb_satellite_channel_new (guint group_id);
DVBSatelliteChannel* dvb_satellite_channel_construct (GType object_type, guint group_id);
DVBChannel* dvb_channel_construct (GType object_type, guint group_id);
DVBSatelliteChannel* dvb_satellite_channel_new_without_schedule (void);
DVBSatelliteChannel* dvb_satellite_channel_construct_without_schedule (GType object_type);
DVBChannel* dvb_channel_construct_without_schedule (GType object_type);
static gboolean dvb_satellite_channel_real_is_valid (DVBChannel* base);
gboolean dvb_channel_is_valid (DVBChannel* self);
guint dvb_satellite_channel_get_SymbolRate (DVBSatelliteChannel* self);
const gchar* dvb_satellite_channel_get_Polarization (DVBSatelliteChannel* self);
static void dvb_satellite_channel_real_setup_dvb_source (DVBChannel* base, GstElement* source);
guint dvb_channel_get_Frequency (DVBChannel* self);
gint dvb_satellite_channel_get_DiseqcSource (DVBSatelliteChannel* self);
static gchar* dvb_satellite_channel_real_to_string (DVBChannel* base);
const gchar* dvb_channel_get_Name (DVBChannel* self);
guint dvb_channel_get_VideoPID (DVBChannel* self);
gchar* dvb_channel_get_audio_pids_string (DVBChannel* self);
guint dvb_channel_get_Sid (DVBChannel* self);
void dvb_satellite_channel_set_Polarization (DVBSatelliteChannel* self, const gchar* value);
void dvb_satellite_channel_set_SymbolRate (DVBSatelliteChannel* self, guint value);
void dvb_satellite_channel_set_DiseqcSource (DVBSatelliteChannel* self, gint value);
static void dvb_satellite_channel_finalize (GObject* obj);
static void _vala_dvb_satellite_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_satellite_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DVBSatelliteChannel* dvb_satellite_channel_construct (GType object_type, guint group_id) {
	DVBSatelliteChannel * self = NULL;
	self = (DVBSatelliteChannel*) dvb_channel_construct (object_type, group_id);
	return self;
}


DVBSatelliteChannel* dvb_satellite_channel_new (guint group_id) {
	return dvb_satellite_channel_construct (DVB_TYPE_SATELLITE_CHANNEL, group_id);
}


DVBSatelliteChannel* dvb_satellite_channel_construct_without_schedule (GType object_type) {
	DVBSatelliteChannel * self = NULL;
	self = (DVBSatelliteChannel*) dvb_channel_construct_without_schedule (object_type);
	return self;
}


DVBSatelliteChannel* dvb_satellite_channel_new_without_schedule (void) {
	return dvb_satellite_channel_construct_without_schedule (DVB_TYPE_SATELLITE_CHANNEL);
}


static gboolean dvb_satellite_channel_real_is_valid (DVBChannel* base) {
	DVBSatelliteChannel * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	self = (DVBSatelliteChannel*) base;
	_tmp2_ = DVB_CHANNEL_CLASS (dvb_satellite_channel_parent_class)->is_valid (DVB_CHANNEL (self));
	if (_tmp2_) {
		_tmp1_ = self->priv->_SymbolRate != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp3_ = FALSE;
		if (g_strcmp0 (self->priv->_Polarization, "v") == 0) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = g_strcmp0 (self->priv->_Polarization, "h") == 0;
		}
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void dvb_satellite_channel_real_setup_dvb_source (DVBChannel* base, GstElement* source) {
	DVBSatelliteChannel * self;
	guint _tmp0_;
	self = (DVBSatelliteChannel*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = dvb_channel_get_Frequency ((DVBChannel*) self);
	g_object_set ((GObject*) source, "frequency", _tmp0_, NULL);
	g_object_set ((GObject*) source, "polarity", self->priv->_Polarization, NULL);
	g_object_set ((GObject*) source, "symbol-rate", self->priv->_SymbolRate, NULL);
	g_object_set ((GObject*) source, "diseqc-source", self->priv->_DiseqcSource, NULL);
}


static gchar* dvb_satellite_channel_real_to_string (DVBChannel* base) {
	DVBSatelliteChannel * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	guint _tmp1_;
	guint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	guint _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	self = (DVBSatelliteChannel*) base;
	_tmp0_ = dvb_channel_get_Name (DVB_CHANNEL (self));
	_tmp1_ = dvb_channel_get_Frequency (DVB_CHANNEL (self));
	_tmp2_ = dvb_channel_get_VideoPID (DVB_CHANNEL (self));
	_tmp3_ = dvb_channel_get_audio_pids_string (DVB_CHANNEL (self));
	_tmp4_ = _tmp3_;
	_tmp5_ = dvb_channel_get_Sid (DVB_CHANNEL (self));
	_tmp6_ = g_strdup_printf ("%s:%u:%s:%d:%u:%u:%s:%u", _tmp0_, _tmp1_, self->priv->_Polarization, self->priv->_DiseqcSource, self->priv->_SymbolRate, _tmp2_, _tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp4_);
	result = _tmp7_;
	return result;
}


const gchar* dvb_satellite_channel_get_Polarization (DVBSatelliteChannel* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Polarization;
	return result;
}


void dvb_satellite_channel_set_Polarization (DVBSatelliteChannel* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_Polarization);
	self->priv->_Polarization = _tmp0_;
	g_object_notify ((GObject *) self, "Polarization");
}


guint dvb_satellite_channel_get_SymbolRate (DVBSatelliteChannel* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_SymbolRate;
	return result;
}


void dvb_satellite_channel_set_SymbolRate (DVBSatelliteChannel* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_SymbolRate = value;
	g_object_notify ((GObject *) self, "SymbolRate");
}


gint dvb_satellite_channel_get_DiseqcSource (DVBSatelliteChannel* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_DiseqcSource;
	return result;
}


void dvb_satellite_channel_set_DiseqcSource (DVBSatelliteChannel* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_DiseqcSource = value;
	g_object_notify ((GObject *) self, "DiseqcSource");
}


static void dvb_satellite_channel_class_init (DVBSatelliteChannelClass * klass) {
	dvb_satellite_channel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBSatelliteChannelPrivate));
	DVB_CHANNEL_CLASS (klass)->is_valid = dvb_satellite_channel_real_is_valid;
	DVB_CHANNEL_CLASS (klass)->setup_dvb_source = dvb_satellite_channel_real_setup_dvb_source;
	DVB_CHANNEL_CLASS (klass)->to_string = dvb_satellite_channel_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_satellite_channel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_satellite_channel_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_satellite_channel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SATELLITE_CHANNEL_POLARIZATION, g_param_spec_string ("Polarization", "Polarization", "Polarization", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SATELLITE_CHANNEL_SYMBOL_RATE, g_param_spec_uint ("SymbolRate", "SymbolRate", "SymbolRate", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SATELLITE_CHANNEL_DISEQC_SOURCE, g_param_spec_int ("DiseqcSource", "DiseqcSource", "DiseqcSource", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_satellite_channel_instance_init (DVBSatelliteChannel * self) {
	self->priv = DVB_SATELLITE_CHANNEL_GET_PRIVATE (self);
}


static void dvb_satellite_channel_finalize (GObject* obj) {
	DVBSatelliteChannel * self;
	self = DVB_SATELLITE_CHANNEL (obj);
	_g_free0 (self->priv->_Polarization);
	G_OBJECT_CLASS (dvb_satellite_channel_parent_class)->finalize (obj);
}


GType dvb_satellite_channel_get_type (void) {
	static volatile gsize dvb_satellite_channel_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_satellite_channel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBSatelliteChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_satellite_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBSatelliteChannel), 0, (GInstanceInitFunc) dvb_satellite_channel_instance_init, NULL };
		GType dvb_satellite_channel_type_id;
		dvb_satellite_channel_type_id = g_type_register_static (DVB_TYPE_CHANNEL, "DVBSatelliteChannel", &g_define_type_info, 0);
		g_once_init_leave (&dvb_satellite_channel_type_id__volatile, dvb_satellite_channel_type_id);
	}
	return dvb_satellite_channel_type_id__volatile;
}


static void _vala_dvb_satellite_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBSatelliteChannel * self;
	self = DVB_SATELLITE_CHANNEL (object);
	switch (property_id) {
		case DVB_SATELLITE_CHANNEL_POLARIZATION:
		g_value_set_string (value, dvb_satellite_channel_get_Polarization (self));
		break;
		case DVB_SATELLITE_CHANNEL_SYMBOL_RATE:
		g_value_set_uint (value, dvb_satellite_channel_get_SymbolRate (self));
		break;
		case DVB_SATELLITE_CHANNEL_DISEQC_SOURCE:
		g_value_set_int (value, dvb_satellite_channel_get_DiseqcSource (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_satellite_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBSatelliteChannel * self;
	self = DVB_SATELLITE_CHANNEL (object);
	switch (property_id) {
		case DVB_SATELLITE_CHANNEL_POLARIZATION:
		dvb_satellite_channel_set_Polarization (self, g_value_get_string (value));
		break;
		case DVB_SATELLITE_CHANNEL_SYMBOL_RATE:
		dvb_satellite_channel_set_SymbolRate (self, g_value_get_uint (value));
		break;
		case DVB_SATELLITE_CHANNEL_DISEQC_SOURCE:
		dvb_satellite_channel_set_DiseqcSource (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



