/* ChannelListReader.c generated by valac 0.12.0, the Vala compiler
 * generated from ChannelListReader.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define DVB_IO_TYPE_CHANNEL_LIST_READER (dvb_io_channel_list_reader_get_type ())
#define DVB_IO_CHANNEL_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReader))
#define DVB_IO_CHANNEL_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReaderClass))
#define DVB_IO_IS_CHANNEL_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER))
#define DVB_IO_IS_CHANNEL_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_CHANNEL_LIST_READER))
#define DVB_IO_CHANNEL_LIST_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReaderClass))

typedef struct _DVBioChannelListReader DVBioChannelListReader;
typedef struct _DVBioChannelListReaderClass DVBioChannelListReaderClass;
typedef struct _DVBioChannelListReaderPrivate DVBioChannelListReaderPrivate;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_TERRESTRIAL_CHANNEL (dvb_terrestrial_channel_get_type ())
#define DVB_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannel))
#define DVB_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))
#define DVB_IS_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_IS_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_TERRESTRIAL_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))

typedef struct _DVBTerrestrialChannel DVBTerrestrialChannel;
typedef struct _DVBTerrestrialChannelClass DVBTerrestrialChannelClass;

#define DVB_TYPE_SATELLITE_CHANNEL (dvb_satellite_channel_get_type ())
#define DVB_SATELLITE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannel))
#define DVB_SATELLITE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannelClass))
#define DVB_IS_SATELLITE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SATELLITE_CHANNEL))
#define DVB_IS_SATELLITE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SATELLITE_CHANNEL))
#define DVB_SATELLITE_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannelClass))

typedef struct _DVBSatelliteChannel DVBSatelliteChannel;
typedef struct _DVBSatelliteChannelClass DVBSatelliteChannelClass;

#define DVB_TYPE_CABLE_CHANNEL (dvb_cable_channel_get_type ())
#define DVB_CABLE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CABLE_CHANNEL, DVBCableChannel))
#define DVB_CABLE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelClass))
#define DVB_IS_CABLE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CABLE_CHANNEL))
#define DVB_IS_CABLE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CABLE_CHANNEL))
#define DVB_CABLE_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelClass))

typedef struct _DVBCableChannel DVBCableChannel;
typedef struct _DVBCableChannelClass DVBCableChannelClass;

#define DVB_TYPE_DVB_SRC_INVERSION (dvb_dvb_src_inversion_get_type ())

#define DVB_TYPE_DVB_SRC_BANDWIDTH (dvb_dvb_src_bandwidth_get_type ())

#define DVB_TYPE_DVB_SRC_CODE_RATE (dvb_dvb_src_code_rate_get_type ())

#define DVB_TYPE_DVB_SRC_MODULATION (dvb_dvb_src_modulation_get_type ())

#define DVB_TYPE_DVB_SRC_TRANSMISSION_MODE (dvb_dvb_src_transmission_mode_get_type ())

#define DVB_TYPE_DVB_SRC_GUARD (dvb_dvb_src_guard_get_type ())

#define DVB_TYPE_DVB_SRC_HIERARCHY (dvb_dvb_src_hierarchy_get_type ())

struct _DVBioChannelListReader {
	GObject parent_instance;
	DVBioChannelListReaderPrivate * priv;
};

struct _DVBioChannelListReaderClass {
	GObjectClass parent_class;
};

typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_DVB_T,
	DVB_ADAPTER_TYPE_DVB_S,
	DVB_ADAPTER_TYPE_DVB_C
} DVBAdapterType;

struct _DVBioChannelListReaderPrivate {
	DVBChannelList* _channels;
	DVBAdapterType _Type;
};

typedef enum  {
	DVB_DVB_SRC_INVERSION_INVERSION_OFF,
	DVB_DVB_SRC_INVERSION_INVERSION_ON,
	DVB_DVB_SRC_INVERSION_INVERSION_AUTO
} DVBDvbSrcInversion;

typedef enum  {
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO
} DVBDvbSrcBandwidth;

typedef enum  {
	DVB_DVB_SRC_CODE_RATE_FEC_NONE,
	DVB_DVB_SRC_CODE_RATE_FEC_1_2,
	DVB_DVB_SRC_CODE_RATE_FEC_2_3,
	DVB_DVB_SRC_CODE_RATE_FEC_3_4,
	DVB_DVB_SRC_CODE_RATE_FEC_4_5,
	DVB_DVB_SRC_CODE_RATE_FEC_5_6,
	DVB_DVB_SRC_CODE_RATE_FEC_6_7,
	DVB_DVB_SRC_CODE_RATE_FEC_7_8,
	DVB_DVB_SRC_CODE_RATE_FEC_8_9,
	DVB_DVB_SRC_CODE_RATE_FEC_AUTO
} DVBDvbSrcCodeRate;

typedef enum  {
	DVB_DVB_SRC_MODULATION_QPSK,
	DVB_DVB_SRC_MODULATION_QAM_16,
	DVB_DVB_SRC_MODULATION_QAM_32,
	DVB_DVB_SRC_MODULATION_QAM_64,
	DVB_DVB_SRC_MODULATION_QAM_128,
	DVB_DVB_SRC_MODULATION_QAM_256,
	DVB_DVB_SRC_MODULATION_QAM_AUTO
} DVBDvbSrcModulation;

typedef enum  {
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO
} DVBDvbSrcTransmissionMode;

typedef enum  {
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO
} DVBDvbSrcGuard;

typedef enum  {
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_1,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_2,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_4,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO
} DVBDvbSrcHierarchy;


static gpointer dvb_io_channel_list_reader_parent_class = NULL;
static DVBLoggingLogger* dvb_io_channel_list_reader_log;
static DVBLoggingLogger* dvb_io_channel_list_reader_log = NULL;

GType dvb_io_channel_list_reader_get_type (void) G_GNUC_CONST;
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
#define DVB_IO_CHANNEL_LIST_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReaderPrivate))
enum  {
	DVB_IO_CHANNEL_LIST_READER_DUMMY_PROPERTY,
	DVB_IO_CHANNEL_LIST_READER_CHANNELS,
	DVB_IO_CHANNEL_LIST_READER_TYPE
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBioChannelListReader* dvb_io_channel_list_reader_new (DVBChannelList* channels, DVBAdapterType type);
DVBioChannelListReader* dvb_io_channel_list_reader_construct (GType object_type, DVBChannelList* channels, DVBAdapterType type);
void dvb_io_channel_list_reader_read_into (DVBioChannelListReader* self, GError** error);
DVBChannelList* dvb_io_channel_list_reader_get_channels (DVBioChannelListReader* self);
GFile* dvb_channel_list_get_channels_file (DVBChannelList* self);
GType dvb_channel_get_type (void) G_GNUC_CONST;
static DVBChannel* dvb_io_channel_list_reader_parse_line (DVBioChannelListReader* self, const gchar* line);
void dvb_channel_list_add (DVBChannelList* self, DVBChannel* channel);
DVBAdapterType dvb_io_channel_list_reader_get_Type (DVBioChannelListReader* self);
GType dvb_terrestrial_channel_get_type (void) G_GNUC_CONST;
static DVBTerrestrialChannel* dvb_io_channel_list_reader_parse_terrestrial_channel (DVBioChannelListReader* self, const gchar* line);
GType dvb_satellite_channel_get_type (void) G_GNUC_CONST;
static DVBSatelliteChannel* dvb_io_channel_list_reader_parse_satellite_channel (DVBioChannelListReader* self, const gchar* line);
GType dvb_cable_channel_get_type (void) G_GNUC_CONST;
static DVBCableChannel* dvb_io_channel_list_reader_parse_cable_channel (DVBioChannelListReader* self, const gchar* line);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_channel_is_valid (DVBChannel* self);
guint dvb_channel_list_get_GroupId (DVBChannelList* self);
void dvb_channel_set_GroupId (DVBChannel* self, guint value);
gchar* dvb_channel_to_string (DVBChannel* self);
DVBTerrestrialChannel* dvb_terrestrial_channel_new (void);
DVBTerrestrialChannel* dvb_terrestrial_channel_construct (GType object_type);
void dvb_channel_set_Name (DVBChannel* self, const gchar* value);
void dvb_channel_set_Frequency (DVBChannel* self, guint value);
static gboolean dvb_io_channel_list_reader_get_value_with_prefix (GType enumtype, const gchar* name, const gchar* prefix, gint* val);
GType dvb_dvb_src_inversion_get_type (void) G_GNUC_CONST;
void dvb_terrestrial_channel_set_Inversion (DVBTerrestrialChannel* self, DVBDvbSrcInversion value);
GType dvb_dvb_src_bandwidth_get_type (void) G_GNUC_CONST;
void dvb_terrestrial_channel_set_Bandwidth (DVBTerrestrialChannel* self, DVBDvbSrcBandwidth value);
GType dvb_dvb_src_code_rate_get_type (void) G_GNUC_CONST;
void dvb_terrestrial_channel_set_CodeRateHP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value);
void dvb_terrestrial_channel_set_CodeRateLP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value);
GType dvb_dvb_src_modulation_get_type (void) G_GNUC_CONST;
void dvb_terrestrial_channel_set_Constellation (DVBTerrestrialChannel* self, DVBDvbSrcModulation value);
GType dvb_dvb_src_transmission_mode_get_type (void) G_GNUC_CONST;
void dvb_terrestrial_channel_set_TransmissionMode (DVBTerrestrialChannel* self, DVBDvbSrcTransmissionMode value);
GType dvb_dvb_src_guard_get_type (void) G_GNUC_CONST;
void dvb_terrestrial_channel_set_GuardInterval (DVBTerrestrialChannel* self, DVBDvbSrcGuard value);
GType dvb_dvb_src_hierarchy_get_type (void) G_GNUC_CONST;
void dvb_terrestrial_channel_set_Hierarchy (DVBTerrestrialChannel* self, DVBDvbSrcHierarchy value);
void dvb_channel_set_VideoPID (DVBChannel* self, guint value);
GeeList* dvb_channel_get_AudioPIDs (DVBChannel* self);
void dvb_channel_set_Sid (DVBChannel* self, guint value);
DVBSatelliteChannel* dvb_satellite_channel_new (void);
DVBSatelliteChannel* dvb_satellite_channel_construct (GType object_type);
void dvb_satellite_channel_set_Polarization (DVBSatelliteChannel* self, const gchar* value);
void dvb_satellite_channel_set_DiseqcSource (DVBSatelliteChannel* self, gint value);
void dvb_satellite_channel_set_SymbolRate (DVBSatelliteChannel* self, guint value);
DVBCableChannel* dvb_cable_channel_new (void);
DVBCableChannel* dvb_cable_channel_construct (GType object_type);
void dvb_cable_channel_set_Inversion (DVBCableChannel* self, DVBDvbSrcInversion value);
void dvb_cable_channel_set_SymbolRate (DVBCableChannel* self, guint value);
void dvb_cable_channel_set_CodeRate (DVBCableChannel* self, DVBDvbSrcCodeRate value);
void dvb_cable_channel_set_Modulation (DVBCableChannel* self, DVBDvbSrcModulation value);
gboolean dvb_utils_get_value_by_name_from_enum (GType enumtype, const gchar* name, gint* evalue);
static void dvb_io_channel_list_reader_set_channels (DVBioChannelListReader* self, DVBChannelList* value);
static void dvb_io_channel_list_reader_set_Type (DVBioChannelListReader* self, DVBAdapterType value);
static void dvb_io_channel_list_reader_finalize (GObject* obj);
static void _vala_dvb_io_channel_list_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_io_channel_list_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


DVBioChannelListReader* dvb_io_channel_list_reader_construct (GType object_type, DVBChannelList* channels, DVBAdapterType type) {
	DVBioChannelListReader * self = NULL;
	g_return_val_if_fail (channels != NULL, NULL);
	self = (DVBioChannelListReader*) g_object_new (object_type, "channels", channels, "Type", type, NULL);
	return self;
}


DVBioChannelListReader* dvb_io_channel_list_reader_new (DVBChannelList* channels, DVBAdapterType type) {
	return dvb_io_channel_list_reader_construct (DVB_IO_TYPE_CHANNEL_LIST_READER, channels, type);
}


void dvb_io_channel_list_reader_read_into (DVBioChannelListReader* self, GError** error) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileInputStream* _tmp2_ = NULL;
	GFileInputStream* _tmp3_;
	GFileInputStream* _tmp4_;
	GDataInputStream* _tmp5_ = NULL;
	GDataInputStream* _tmp6_;
	GDataInputStream* reader;
	gchar* line;
	gsize len = 0UL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_channel_list_get_channels_file (self->priv->_channels);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = dvb_channel_list_get_channels_file (self->priv->_channels);
	_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp4_ = _tmp3_;
	_tmp5_ = g_data_input_stream_new ((GInputStream*) _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	reader = _tmp6_;
	line = NULL;
	while (TRUE) {
		gsize _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp8_ = g_data_input_stream_read_line (reader, &_tmp7_, NULL, &_inner_error_);
		len = _tmp7_;
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			_g_object_unref0 (reader);
			return;
		}
		_g_free0 (line);
		line = _tmp9_;
		if (!(line != NULL)) {
			break;
		}
		if (len > 0) {
			DVBChannel* _tmp10_ = NULL;
			DVBChannel* c;
			_tmp10_ = dvb_io_channel_list_reader_parse_line (self, line);
			c = _tmp10_;
			if (c != NULL) {
				dvb_channel_list_add (self->priv->_channels, c);
			} else {
				g_warning ("ChannelListReader.vala:50: Could not parse channel");
			}
			_g_object_unref0 (c);
		}
	}
	g_input_stream_close ((GInputStream*) reader, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (line);
		_g_object_unref0 (reader);
		return;
	}
	_g_free0 (line);
	_g_object_unref0 (reader);
}


static DVBChannel* dvb_io_channel_list_reader_parse_line (DVBioChannelListReader* self, const gchar* line) {
	DVBChannel* result = NULL;
	DVBChannel* c;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	c = NULL;
	switch (self->priv->_Type) {
		case DVB_ADAPTER_TYPE_DVB_T:
		{
			DVBTerrestrialChannel* _tmp0_ = NULL;
			_tmp0_ = dvb_io_channel_list_reader_parse_terrestrial_channel (self, line);
			_g_object_unref0 (c);
			c = (DVBChannel*) _tmp0_;
			break;
		}
		case DVB_ADAPTER_TYPE_DVB_S:
		{
			DVBSatelliteChannel* _tmp1_ = NULL;
			_tmp1_ = dvb_io_channel_list_reader_parse_satellite_channel (self, line);
			_g_object_unref0 (c);
			c = (DVBChannel*) _tmp1_;
			break;
		}
		case DVB_ADAPTER_TYPE_DVB_C:
		{
			DVBCableChannel* _tmp2_ = NULL;
			_tmp2_ = dvb_io_channel_list_reader_parse_cable_channel (self, line);
			_g_object_unref0 (c);
			c = (DVBChannel*) _tmp2_;
			break;
		}
		default:
		{
			dvb_logging_logger_error (dvb_io_channel_list_reader_log, "ChannelListReader.vala:72: Unknown adapter type");
			break;
		}
	}
	if (c != NULL) {
		gboolean _tmp4_;
		_tmp4_ = dvb_channel_is_valid (c);
		_tmp3_ = _tmp4_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		guint _tmp5_;
		_tmp5_ = dvb_channel_list_get_GroupId (self->priv->_channels);
		dvb_channel_set_GroupId (c, _tmp5_);
		result = c;
		return result;
	} else {
		gchar* _tmp6_ = NULL;
		gchar* _tmp9_;
		gchar* val;
		if (c == NULL) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("(null)");
			_g_free0 (_tmp6_);
			_tmp6_ = _tmp7_;
		} else {
			gchar* _tmp8_ = NULL;
			_tmp8_ = dvb_channel_to_string (c);
			_g_free0 (_tmp6_);
			_tmp6_ = _tmp8_;
		}
		_tmp9_ = g_strdup (_tmp6_);
		val = _tmp9_;
		g_warning ("ChannelListReader.vala:81: Channel is not valid: %s", val);
		result = NULL;
		_g_free0 (val);
		_g_free0 (_tmp6_);
		_g_object_unref0 (c);
		return result;
	}
	_g_object_unref0 (c);
}


/**
         * @line: The line to parse
         * @returns: #TerrestrialChannel representing that line
         * 
         * A line looks like
         * Das Erste:212500000:INVERSION_AUTO:BANDWIDTH_7_MHZ:FEC_3_4:FEC_1_2:QAM_16:TRANSMISSION_MODE_8K:GUARD_INTERVAL_1_4:HIERARCHY_NONE:513:514:32
         */
static DVBTerrestrialChannel* dvb_io_channel_list_reader_parse_terrestrial_channel (DVBioChannelListReader* self, const gchar* line) {
	DVBTerrestrialChannel* result = NULL;
	DVBTerrestrialChannel* _tmp0_ = NULL;
	DVBTerrestrialChannel* channel;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** fields;
	gint fields_length1;
	gint _fields_size_;
	gint i;
	gchar* val = NULL;
	gboolean failed;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = dvb_terrestrial_channel_new ();
	channel = _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (line, ":", 0);
	fields = _tmp2_;
	fields_length1 = _vala_array_length (_tmp1_);
	_fields_size_ = _vala_array_length (_tmp1_);
	i = 0;
	failed = FALSE;
	while (TRUE) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (fields[i]);
		_g_free0 (val);
		val = _tmp3_;
		if (!(val != NULL)) {
			break;
		}
		if (i == 0) {
			gboolean _tmp4_;
			_tmp4_ = g_utf8_validate (val, (gssize) (-1), NULL);
			if (_tmp4_) {
				dvb_channel_set_Name ((DVBChannel*) channel, val);
			} else {
				g_warning ("ChannelListReader.vala:106: Bad UTF-8 encoded channel name");
				dvb_channel_set_Name ((DVBChannel*) channel, "Bad encoding");
			}
		} else {
			if (i == 1) {
				gint _tmp5_;
				_tmp5_ = atoi (val);
				dvb_channel_set_Frequency ((DVBChannel*) channel, (guint) _tmp5_);
			} else {
				if (i == 2) {
					gint eval = 0;
					gint _tmp6_;
					gboolean _tmp7_;
					_tmp7_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_INVERSION, val, "DVB_DVB_SRC_INVERSION_", &_tmp6_);
					eval = _tmp6_;
					if (_tmp7_) {
						dvb_terrestrial_channel_set_Inversion (channel, (DVBDvbSrcInversion) eval);
					} else {
						failed = TRUE;
						break;
					}
				} else {
					if (i == 3) {
						gint eval = 0;
						gint _tmp8_;
						gboolean _tmp9_;
						_tmp9_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_BANDWIDTH, val, "DVB_DVB_SRC_BANDWIDTH_", &_tmp8_);
						eval = _tmp8_;
						if (_tmp9_) {
							dvb_terrestrial_channel_set_Bandwidth (channel, (DVBDvbSrcBandwidth) eval);
						} else {
							failed = TRUE;
							break;
						}
					} else {
						if (i == 4) {
							gint eval = 0;
							gint _tmp10_;
							gboolean _tmp11_;
							_tmp11_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, val, "DVB_DVB_SRC_CODE_RATE_", &_tmp10_);
							eval = _tmp10_;
							if (_tmp11_) {
								dvb_terrestrial_channel_set_CodeRateHP (channel, (DVBDvbSrcCodeRate) eval);
							} else {
								failed = TRUE;
								break;
							}
						} else {
							if (i == 5) {
								gint eval = 0;
								gint _tmp12_;
								gboolean _tmp13_;
								_tmp13_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, val, "DVB_DVB_SRC_CODE_RATE_", &_tmp12_);
								eval = _tmp12_;
								if (_tmp13_) {
									dvb_terrestrial_channel_set_CodeRateLP (channel, (DVBDvbSrcCodeRate) eval);
								} else {
									failed = TRUE;
									break;
								}
							} else {
								if (i == 6) {
									gint eval = 0;
									gint _tmp14_;
									gboolean _tmp15_;
									_tmp15_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_MODULATION, val, "DVB_DVB_SRC_MODULATION_", &_tmp14_);
									eval = _tmp14_;
									if (_tmp15_) {
										dvb_terrestrial_channel_set_Constellation (channel, (DVBDvbSrcModulation) eval);
									} else {
										failed = TRUE;
										break;
									}
								} else {
									if (i == 7) {
										gint eval = 0;
										gint _tmp16_;
										gboolean _tmp17_;
										_tmp17_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_TRANSMISSION_MODE, val, "DVB_DVB_SRC_TRANSMISSION_MODE_", &_tmp16_);
										eval = _tmp16_;
										if (_tmp17_) {
											dvb_terrestrial_channel_set_TransmissionMode (channel, (DVBDvbSrcTransmissionMode) eval);
										} else {
											failed = TRUE;
											break;
										}
									} else {
										if (i == 8) {
											gint eval = 0;
											gint _tmp18_;
											gboolean _tmp19_;
											_tmp19_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_GUARD, val, "DVB_DVB_SRC_GUARD_", &_tmp18_);
											eval = _tmp18_;
											if (_tmp19_) {
												dvb_terrestrial_channel_set_GuardInterval (channel, (DVBDvbSrcGuard) eval);
											} else {
												failed = TRUE;
												break;
											}
										} else {
											if (i == 9) {
												gint eval = 0;
												gint _tmp20_;
												gboolean _tmp21_;
												_tmp21_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_HIERARCHY, val, "DVB_DVB_SRC_HIERARCHY_", &_tmp20_);
												eval = _tmp20_;
												if (_tmp21_) {
													dvb_terrestrial_channel_set_Hierarchy (channel, (DVBDvbSrcHierarchy) eval);
												} else {
													failed = TRUE;
													break;
												}
											} else {
												if (i == 10) {
													gint _tmp22_;
													_tmp22_ = atoi (val);
													dvb_channel_set_VideoPID ((DVBChannel*) channel, (guint) _tmp22_);
												} else {
													if (i == 11) {
														GeeList* _tmp23_ = NULL;
														gint _tmp24_;
														_tmp23_ = dvb_channel_get_AudioPIDs ((DVBChannel*) channel);
														_tmp24_ = atoi (val);
														gee_collection_add ((GeeCollection*) _tmp23_, GUINT_TO_POINTER ((guint) _tmp24_));
													} else {
														if (i == 12) {
															gint _tmp25_;
															_tmp25_ = atoi (val);
															dvb_channel_set_Sid ((DVBChannel*) channel, (guint) _tmp25_);
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		i++;
	}
	if (failed) {
		result = NULL;
		_g_free0 (val);
		fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (channel);
		return result;
	} else {
		result = channel;
		_g_free0 (val);
		fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_g_free0 (val);
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (channel);
}


/**
         *
         * A line looks like
         * Das Erste:11836:h:0:27500:101:102:28106
         */
static DVBSatelliteChannel* dvb_io_channel_list_reader_parse_satellite_channel (DVBioChannelListReader* self, const gchar* line) {
	DVBSatelliteChannel* result = NULL;
	DVBSatelliteChannel* _tmp0_ = NULL;
	DVBSatelliteChannel* channel;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** fields;
	gint fields_length1;
	gint _fields_size_;
	gint i;
	gchar* val = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = dvb_satellite_channel_new ();
	channel = _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (line, ":", 0);
	fields = _tmp2_;
	fields_length1 = _vala_array_length (_tmp1_);
	_fields_size_ = _vala_array_length (_tmp1_);
	i = 0;
	while (TRUE) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (fields[i]);
		_g_free0 (val);
		val = _tmp3_;
		if (!(val != NULL)) {
			break;
		}
		if (i == 0) {
			gboolean _tmp4_;
			_tmp4_ = g_utf8_validate (val, (gssize) (-1), NULL);
			if (_tmp4_) {
				dvb_channel_set_Name ((DVBChannel*) channel, val);
			} else {
				g_warning ("ChannelListReader.vala:215: Bad UTF-8 encoded channel name");
				dvb_channel_set_Name ((DVBChannel*) channel, "Bad encoding");
			}
		} else {
			if (i == 1) {
				gint _tmp5_;
				_tmp5_ = atoi (val);
				dvb_channel_set_Frequency ((DVBChannel*) channel, (guint) (_tmp5_ * 1000));
			} else {
				if (i == 2) {
					dvb_satellite_channel_set_Polarization (channel, val);
				} else {
					if (i == 3) {
						gint _tmp6_;
						_tmp6_ = atoi (val);
						dvb_satellite_channel_set_DiseqcSource (channel, _tmp6_);
					} else {
						if (i == 4) {
							gint _tmp7_;
							_tmp7_ = atoi (val);
							dvb_satellite_channel_set_SymbolRate (channel, (guint) _tmp7_);
						} else {
							if (i == 5) {
								gint _tmp8_;
								_tmp8_ = atoi (val);
								dvb_channel_set_VideoPID ((DVBChannel*) channel, (guint) _tmp8_);
							} else {
								if (i == 6) {
									GeeList* _tmp9_ = NULL;
									gint _tmp10_;
									_tmp9_ = dvb_channel_get_AudioPIDs ((DVBChannel*) channel);
									_tmp10_ = atoi (val);
									gee_collection_add ((GeeCollection*) _tmp9_, GUINT_TO_POINTER ((guint) _tmp10_));
								} else {
									if (i == 7) {
										gint _tmp11_;
										_tmp11_ = atoi (val);
										dvb_channel_set_Sid ((DVBChannel*) channel, (guint) _tmp11_);
									}
								}
							}
						}
					}
				}
			}
		}
		i++;
	}
	result = channel;
	_g_free0 (val);
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


/**
         *
         * line looks like
         * ProSieben:330000000:INVERSION_AUTO:6900000:FEC_NONE:QAM_64:255:256:898
         */
static DVBCableChannel* dvb_io_channel_list_reader_parse_cable_channel (DVBioChannelListReader* self, const gchar* line) {
	DVBCableChannel* result = NULL;
	DVBCableChannel* _tmp0_ = NULL;
	DVBCableChannel* channel;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** fields;
	gint fields_length1;
	gint _fields_size_;
	gint i;
	gchar* val = NULL;
	gboolean failed;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = dvb_cable_channel_new ();
	channel = _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (line, ":", 0);
	fields = _tmp2_;
	fields_length1 = _vala_array_length (_tmp1_);
	_fields_size_ = _vala_array_length (_tmp1_);
	i = 0;
	failed = FALSE;
	while (TRUE) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (fields[i]);
		_g_free0 (val);
		val = _tmp3_;
		if (!(val != NULL)) {
			break;
		}
		if (i == 0) {
			gboolean _tmp4_;
			_tmp4_ = g_utf8_validate (val, (gssize) (-1), NULL);
			if (_tmp4_) {
				dvb_channel_set_Name ((DVBChannel*) channel, val);
			} else {
				g_warning ("ChannelListReader.vala:261: Bad UTF-8 encoded channel name");
				dvb_channel_set_Name ((DVBChannel*) channel, "Bad encoding");
			}
		} else {
			if (i == 1) {
				gint _tmp5_;
				_tmp5_ = atoi (val);
				dvb_channel_set_Frequency ((DVBChannel*) channel, (guint) _tmp5_);
			} else {
				if (i == 2) {
					gint eval = 0;
					gint _tmp6_;
					gboolean _tmp7_;
					_tmp7_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_INVERSION, val, "DVB_DVB_SRC_INVERSION_", &_tmp6_);
					eval = _tmp6_;
					if (_tmp7_) {
						dvb_cable_channel_set_Inversion (channel, (DVBDvbSrcInversion) eval);
					} else {
						failed = TRUE;
						break;
					}
				} else {
					if (i == 3) {
						gint _tmp8_;
						_tmp8_ = atoi (val);
						dvb_cable_channel_set_SymbolRate (channel, (guint) (_tmp8_ / 1000));
					} else {
						if (i == 4) {
							gint eval = 0;
							gint _tmp9_;
							gboolean _tmp10_;
							_tmp10_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, val, "DVB_DVB_SRC_CODE_RATE_", &_tmp9_);
							eval = _tmp9_;
							if (_tmp10_) {
								dvb_cable_channel_set_CodeRate (channel, (DVBDvbSrcCodeRate) eval);
							} else {
								failed = TRUE;
								break;
							}
						} else {
							if (i == 5) {
								gint eval = 0;
								gint _tmp11_;
								gboolean _tmp12_;
								_tmp12_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_MODULATION, val, "DVB_DVB_SRC_MODULATION_", &_tmp11_);
								eval = _tmp11_;
								if (_tmp12_) {
									dvb_cable_channel_set_Modulation (channel, (DVBDvbSrcModulation) eval);
								} else {
									failed = TRUE;
									break;
								}
							} else {
								if (i == 6) {
									gint _tmp13_;
									_tmp13_ = atoi (val);
									dvb_channel_set_VideoPID ((DVBChannel*) channel, (guint) _tmp13_);
								} else {
									if (i == 7) {
										GeeList* _tmp14_ = NULL;
										gint _tmp15_;
										_tmp14_ = dvb_channel_get_AudioPIDs ((DVBChannel*) channel);
										_tmp15_ = atoi (val);
										gee_collection_add ((GeeCollection*) _tmp14_, GUINT_TO_POINTER ((guint) _tmp15_));
									} else {
										if (i == 8) {
											gint _tmp16_;
											_tmp16_ = atoi (val);
											dvb_channel_set_Sid ((DVBChannel*) channel, (guint) _tmp16_);
										}
									}
								}
							}
						}
					}
				}
			}
		}
		i++;
	}
	if (failed) {
		result = NULL;
		_g_free0 (val);
		fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (channel);
		return result;
	} else {
		result = channel;
		_g_free0 (val);
		fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_g_free0 (val);
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (channel);
}


static gboolean dvb_io_channel_list_reader_get_value_with_prefix (GType enumtype, const gchar* name, const gchar* prefix, gint* val) {
	gint _val = 0;
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (prefix != NULL, FALSE);
	_tmp0_ = g_strconcat (prefix, name, NULL);
	_tmp1_ = _tmp0_;
	_tmp3_ = dvb_utils_get_value_by_name_from_enum (enumtype, _tmp1_, &_tmp2_);
	_val = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp1_);
	result = _tmp4_;
	if (val) {
		*val = _val;
	}
	return result;
}


DVBChannelList* dvb_io_channel_list_reader_get_channels (DVBioChannelListReader* self) {
	DVBChannelList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_channels;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_io_channel_list_reader_set_channels (DVBioChannelListReader* self, DVBChannelList* value) {
	DVBChannelList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_channels);
	self->priv->_channels = _tmp0_;
	g_object_notify ((GObject *) self, "channels");
}


DVBAdapterType dvb_io_channel_list_reader_get_Type (DVBioChannelListReader* self) {
	DVBAdapterType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_Type;
	return result;
}


static void dvb_io_channel_list_reader_set_Type (DVBioChannelListReader* self, DVBAdapterType value) {
	g_return_if_fail (self != NULL);
	self->priv->_Type = value;
	g_object_notify ((GObject *) self, "Type");
}


static void dvb_io_channel_list_reader_class_init (DVBioChannelListReaderClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_io_channel_list_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBioChannelListReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_io_channel_list_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_io_channel_list_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_io_channel_list_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_CHANNEL_LIST_READER_CHANNELS, g_param_spec_object ("channels", "channels", "channels", DVB_TYPE_CHANNEL_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_CHANNEL_LIST_READER_TYPE, g_param_spec_enum ("Type", "Type", "Type", DVB_TYPE_ADAPTER_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_io_channel_list_reader_log = _tmp1_;
}


static void dvb_io_channel_list_reader_instance_init (DVBioChannelListReader * self) {
	self->priv = DVB_IO_CHANNEL_LIST_READER_GET_PRIVATE (self);
}


static void dvb_io_channel_list_reader_finalize (GObject* obj) {
	DVBioChannelListReader * self;
	self = DVB_IO_CHANNEL_LIST_READER (obj);
	_g_object_unref0 (self->priv->_channels);
	G_OBJECT_CLASS (dvb_io_channel_list_reader_parent_class)->finalize (obj);
}


GType dvb_io_channel_list_reader_get_type (void) {
	static volatile gsize dvb_io_channel_list_reader_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_io_channel_list_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBioChannelListReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_io_channel_list_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBioChannelListReader), 0, (GInstanceInitFunc) dvb_io_channel_list_reader_instance_init, NULL };
		GType dvb_io_channel_list_reader_type_id;
		dvb_io_channel_list_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBioChannelListReader", &g_define_type_info, 0);
		g_once_init_leave (&dvb_io_channel_list_reader_type_id__volatile, dvb_io_channel_list_reader_type_id);
	}
	return dvb_io_channel_list_reader_type_id__volatile;
}


static void _vala_dvb_io_channel_list_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBioChannelListReader * self;
	self = DVB_IO_CHANNEL_LIST_READER (object);
	switch (property_id) {
		case DVB_IO_CHANNEL_LIST_READER_CHANNELS:
		g_value_set_object (value, dvb_io_channel_list_reader_get_channels (self));
		break;
		case DVB_IO_CHANNEL_LIST_READER_TYPE:
		g_value_set_enum (value, dvb_io_channel_list_reader_get_Type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_io_channel_list_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBioChannelListReader * self;
	self = DVB_IO_CHANNEL_LIST_READER (object);
	switch (property_id) {
		case DVB_IO_CHANNEL_LIST_READER_CHANNELS:
		dvb_io_channel_list_reader_set_channels (self, g_value_get_object (value));
		break;
		case DVB_IO_CHANNEL_LIST_READER_TYPE:
		dvb_io_channel_list_reader_set_Type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



