/* Schedule.c generated by valac 0.12.0, the Vala compiler
 * generated from Schedule.vala, do not modify */

/*
 * Copyright (C) 2008-2011 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <time.h>


#define DVB_TYPE_ID_BUS_SCHEDULE (dvb_id_bus_schedule_get_type ())
#define DVB_ID_BUS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCHEDULE, DVBIDBusSchedule))
#define DVB_IS_ID_BUS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCHEDULE))
#define DVB_ID_BUS_SCHEDULE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCHEDULE, DVBIDBusScheduleIface))

typedef struct _DVBIDBusSchedule DVBIDBusSchedule;
typedef struct _DVBIDBusScheduleIface DVBIDBusScheduleIface;

#define DVB_TYPE_ID_BUS_SCHEDULE_PROXY (dvb_id_bus_schedule_proxy_get_type ())

#define DVB_TYPE_EVENT_INFO (dvb_event_info_get_type ())
typedef struct _DVBEventInfo DVBEventInfo;

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;
typedef struct _DVBSchedulePrivate DVBSchedulePrivate;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_DATABASE_TYPE_EPG_STORE (dvb_database_epg_store_get_type ())
#define DVB_DATABASE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStore))
#define DVB_DATABASE_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_EPG_STORE))
#define DVB_DATABASE_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStoreIface))

typedef struct _DVBdatabaseEPGStore DVBdatabaseEPGStore;
typedef struct _DVBdatabaseEPGStoreIface DVBdatabaseEPGStoreIface;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;

#define DVB_TYPE_EVENT_STORAGE (dvb_event_storage_get_type ())
#define DVB_EVENT_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT_STORAGE, DVBEventStorage))
#define DVB_EVENT_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT_STORAGE, DVBEventStorageClass))
#define DVB_IS_EVENT_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT_STORAGE))
#define DVB_IS_EVENT_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT_STORAGE))
#define DVB_EVENT_STORAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT_STORAGE, DVBEventStorageClass))

typedef struct _DVBEventStorage DVBEventStorage;
typedef struct _DVBEventStorageClass DVBEventStorageClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))
typedef struct _DvbScheduleRestoreData DvbScheduleRestoreData;

#define DVB_TYPE_EVENT_ELEMENT (dvb_event_element_get_type ())
#define DVB_EVENT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT_ELEMENT, DVBEventElement))
#define DVB_EVENT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT_ELEMENT, DVBEventElementClass))
#define DVB_IS_EVENT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT_ELEMENT))
#define DVB_IS_EVENT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT_ELEMENT))
#define DVB_EVENT_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT_ELEMENT, DVBEventElementClass))

typedef struct _DVBEventElement DVBEventElement;
typedef struct _DVBEventElementClass DVBEventElementClass;
typedef struct _DVBEventElementPrivate DVBEventElementPrivate;

#define DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE (dvb_database_sqlite_sqlite_database_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabase))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))

typedef struct _DVBdatabasesqliteSqliteDatabase DVBdatabasesqliteSqliteDatabase;
typedef struct _DVBdatabasesqliteSqliteDatabaseClass DVBdatabasesqliteSqliteDatabaseClass;
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DVBEventInfo {
	guint32 id;
	guint32 next;
	gchar* name;
	guint duration;
	gchar* short_description;
};

struct _DVBIDBusScheduleIface {
	GTypeInterface parent_iface;
	guint32* (*GetAllEvents) (DVBIDBusSchedule* self, int* result_length1, GError** error);
	DVBEventInfo* (*GetAllEventInfos) (DVBIDBusSchedule* self, int* result_length1, GError** error);
	gboolean (*GetInformations) (DVBIDBusSchedule* self, guint32 event_id, DVBEventInfo* event_info, GError** error);
	guint32 (*NowPlaying) (DVBIDBusSchedule* self, GError** error);
	guint32 (*Next) (DVBIDBusSchedule* self, guint32 event_id, GError** error);
	gboolean (*GetName) (DVBIDBusSchedule* self, guint32 event_id, gchar** name, GError** error);
	gboolean (*GetShortDescription) (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error);
	gboolean (*GetExtendedDescription) (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error);
	gboolean (*GetDuration) (DVBIDBusSchedule* self, guint32 event_id, guint* duration, GError** error);
	gboolean (*GetLocalStartTime) (DVBIDBusSchedule* self, guint32 event_id, guint** start_time, int* start_time_length1, GError** error);
	gboolean (*GetLocalStartTimestamp) (DVBIDBusSchedule* self, guint32 event_id, gint64* timestamp, GError** error);
	gboolean (*IsRunning) (DVBIDBusSchedule* self, guint32 event_id, gboolean* running, GError** error);
	gboolean (*IsScrambled) (DVBIDBusSchedule* self, guint32 event_id, gboolean* scrambled, GError** error);
};

struct _DVBSchedule {
	GObject parent_instance;
	DVBSchedulePrivate * priv;
};

struct _DVBScheduleClass {
	GObjectClass parent_class;
};

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	DVBEvent* (*get_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_older_than) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	gboolean (*contains_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	GeeList* (*get_events) (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_of_group) (DVBdatabaseEPGStore* self, guint group_id, GError** error);
};

struct _DVBSchedulePrivate {
	DVBChannel* _channel;
	DVBdatabaseEPGStore* epgstore;
	DVBEventStorage* events;
	GStaticRecMutex __lock_events;
};

struct _DvbScheduleRestoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DVBSchedule* self;
	GeeList* levents;
	guint _tmp0_;
	guint _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	GError * e1;
	gint newest_expired;
	DVBEvent* event;
	gint i;
	gboolean _tmp4_;
	gint _tmp5_;
	gpointer _tmp6_;
	gboolean _tmp7_;
	gpointer _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	GError * e2;
	guint _tmp11_;
	GError * _inner_error_;
};

struct _DVBEventElement {
	GObject parent_instance;
	DVBEventElementPrivate * priv;
	guint id;
	time_t starttime;
};

struct _DVBEventElementClass {
	GObjectClass parent_class;
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	gchar* name;
	gchar* description;
	gchar* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};


static gpointer dvb_schedule_parent_class = NULL;
static DVBLoggingLogger* dvb_schedule_log;
static DVBLoggingLogger* dvb_schedule_log = NULL;
static GStaticRecMutex dvb_schedule_mutex;
static GStaticRecMutex dvb_schedule_mutex = {0};
static DVBIDBusScheduleIface* dvb_schedule_dvb_id_bus_schedule_parent_iface = NULL;

GType dvb_id_bus_schedule_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_schedule_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_event_info_get_type (void) G_GNUC_CONST;
DVBEventInfo* dvb_event_info_dup (const DVBEventInfo* self);
void dvb_event_info_free (DVBEventInfo* self);
void dvb_event_info_copy (const DVBEventInfo* self, DVBEventInfo* dest);
void dvb_event_info_destroy (DVBEventInfo* self);
GType dvb_id_bus_schedule_get_type (void) G_GNUC_CONST;
GType dvb_schedule_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
GType dvb_database_epg_store_get_type (void) G_GNUC_CONST;
GType dvb_event_storage_get_type (void) G_GNUC_CONST;
#define DVB_SCHEDULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCHEDULE, DVBSchedulePrivate))
enum  {
	DVB_SCHEDULE_DUMMY_PROPERTY,
	DVB_SCHEDULE_CHANNEL
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_SCHEDULE_MATCH_THRESHOLD 100
#define DVB_SCHEDULE_MIN_EVENT_OVERLAP 0.5
static void dvb_schedule_restore_data_free (gpointer _data);
void dvb_schedule_restore (DVBSchedule* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void dvb_schedule_restore_finish (DVBSchedule* self, GAsyncResult* _res_);
static gboolean dvb_schedule_restore_co (DvbScheduleRestoreData* data);
GeeList* dvb_database_epg_store_get_events (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
DVBChannel* dvb_schedule_get_channel (DVBSchedule* self);
guint dvb_channel_get_Sid (DVBChannel* self);
guint dvb_channel_get_GroupId (DVBChannel* self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_event_has_expired (DVBEvent* self);
void dvb_event_storage_insert (DVBEventStorage* self, DVBEvent* event);
gboolean dvb_database_epg_store_remove_events_older_than (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
DVBSchedule* dvb_schedule_new (DVBChannel* channel);
DVBSchedule* dvb_schedule_construct (GType object_type, DVBChannel* channel);
void dvb_schedule_remove_expired_events (DVBSchedule* self);
gint dvb_event_storage_get_size (DVBEventStorage* self);
GType dvb_event_element_get_type (void) G_GNUC_CONST;
DVBEventElement* dvb_event_storage_get (DVBEventStorage* self, gint index);
DVBEvent* dvb_schedule_get_event (DVBSchedule* self, guint event_id);
const gchar* dvb_channel_get_Name (DVBChannel* self);
void dvb_event_storage_remove_range (DVBEventStorage* self, gint start, gint end);
DVBEvent* dvb_database_epg_store_get_event (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
void dvb_schedule_add (DVBSchedule* self, DVBEvent* event);
static void dvb_schedule_store_event (DVBSchedule* self, DVBEvent* event, GError** error);
void dvb_schedule_add_all (DVBSchedule* self, GeeCollection* new_events);
GType dvb_database_sqlite_sqlite_database_get_type (void) G_GNUC_CONST;
void dvb_database_sqlite_sqlite_database_begin_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
void dvb_database_sqlite_sqlite_database_end_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
static GeeList* dvb_schedule_get_overlapping_events (DVBSchedule* self, DVBEvent* event);
static gint dvb_schedule_match_events (DVBSchedule* self, GeeList* events, DVBEvent* ref_event);
void dvb_event_storage_remove_all (DVBEventStorage* self, GeeList* events);
gboolean dvb_database_epg_store_add_or_update_event (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
gboolean dvb_event_storage_contains_event_with_id (DVBEventStorage* self, guint event_id);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
GeeList* dvb_event_storage_get_overlapping_events (DVBEventStorage* self, DVBEvent* event);
gdouble dvb_event_get_overlap_percentage (DVBEvent* self, DVBEvent* other);
time_t dvb_event_get_start_timestamp (DVBEvent* self);
time_t dvb_event_get_end_timestamp (DVBEvent* self);
glong dvb_utils_strdiff (const gchar* a, const gchar* b, glong* unmatched);
gboolean dvb_schedule_contains (DVBSchedule* self, guint event_id);
DVBEvent* dvb_schedule_get_running_event (DVBSchedule* self);
gboolean dvb_event_is_running (DVBEvent* self);
DVBEvent* dvb_schedule_get_event_around (DVBSchedule* self, struct tm* start, guint duration);
static guint32* dvb_schedule_real_GetAllEvents (DVBIDBusSchedule* base, int* result_length1, GError** error);
static DVBEventInfo* dvb_schedule_real_GetAllEventInfos (DVBIDBusSchedule* base, int* result_length1, GError** error);
static void dvb_schedule_event_to_event_info (DVBEvent* event, DVBEventInfo* result);
static void _vala_DVBEventInfo_array_free (DVBEventInfo* array, gint array_length);
static gboolean dvb_schedule_real_GetInformations (DVBIDBusSchedule* base, guint32 event_id, DVBEventInfo* event_info, GError** error);
DVBEventElement* dvb_event_storage_get_by_id (DVBEventStorage* self, guint event_id);
DVBEventElement* dvb_event_storage_next (DVBEventStorage* self, DVBEventElement* element);
static guint32 dvb_schedule_real_NowPlaying (DVBIDBusSchedule* base, GError** error);
static guint32 dvb_schedule_real_Next (DVBIDBusSchedule* base, guint32 event_id, GError** error);
static gboolean dvb_schedule_real_GetName (DVBIDBusSchedule* base, guint32 event_id, gchar** name, GError** error);
static DVBEvent* dvb_schedule_get_extended_event_by_id (DVBSchedule* self, guint event_id);
static gboolean dvb_schedule_real_GetShortDescription (DVBIDBusSchedule* base, guint32 event_id, gchar** description, GError** error);
static gboolean dvb_schedule_real_GetExtendedDescription (DVBIDBusSchedule* base, guint32 event_id, gchar** description, GError** error);
static gboolean dvb_schedule_real_GetDuration (DVBIDBusSchedule* base, guint32 event_id, guint* duration, GError** error);
static gboolean dvb_schedule_real_GetLocalStartTime (DVBIDBusSchedule* base, guint32 event_id, guint** start_time, int* start_time_length1, GError** error);
void dvb_event_get_local_start_time (DVBEvent* self, struct tm* result);
static guint* dvb_schedule_to_time_array (struct tm* local_time, int* result_length1);
static gboolean dvb_schedule_real_GetLocalStartTimestamp (DVBIDBusSchedule* base, guint32 event_id, gint64* timestamp, GError** error);
static gboolean dvb_schedule_real_IsRunning (DVBIDBusSchedule* base, guint32 event_id, gboolean* running, GError** error);
static gboolean dvb_schedule_real_IsScrambled (DVBIDBusSchedule* base, guint32 event_id, gboolean* scrambled, GError** error);
static void dvb_schedule_set_channel (DVBSchedule* self, DVBChannel* value);
static GObject * dvb_schedule_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
DVBEventStorage* dvb_event_storage_new (void);
DVBEventStorage* dvb_event_storage_construct (GType object_type);
DVBdatabaseEPGStore* dvb_factory_get_epg_store (void);
static void dvb_schedule_finalize (GObject* obj);
static void _vala_dvb_schedule_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_schedule_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void dvb_schedule_restore_data_free (gpointer _data) {
	DvbScheduleRestoreData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DvbScheduleRestoreData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_schedule_restore (DVBSchedule* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DvbScheduleRestoreData* _data_;
	_data_ = g_slice_new0 (DvbScheduleRestoreData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, dvb_schedule_restore);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, dvb_schedule_restore_data_free);
	_data_->self = _g_object_ref0 (self);
	dvb_schedule_restore_co (_data_);
}


void dvb_schedule_restore_finish (DVBSchedule* self, GAsyncResult* _res_) {
	DvbScheduleRestoreData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean dvb_schedule_restore_co (DvbScheduleRestoreData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = dvb_channel_get_Sid (data->self->priv->_channel);
	data->_tmp1_ = dvb_channel_get_GroupId (data->self->priv->_channel);
	data->_tmp2_ = NULL;
	data->_tmp2_ = dvb_database_epg_store_get_events (data->self->priv->epgstore, data->_tmp0_, data->_tmp1_, &data->_inner_error_);
	data->_tmp3_ = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch157_dvb_database_sql_error;
		}
		_g_object_unref0 (data->levents);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->levents);
	data->levents = data->_tmp3_;
	goto __finally157;
	__catch157_dvb_database_sql_error:
	{
		data->e1 = data->_inner_error_;
		data->_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_schedule_log, "Schedule.vala:56: %s", data->e1->message);
		_g_error_free0 (data->e1);
		_g_object_unref0 (data->levents);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally157:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->levents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->newest_expired = -1;
	{
		data->i = 0;
		{
			data->_tmp4_ = TRUE;
			while (TRUE) {
				if (!data->_tmp4_) {
					data->i++;
				}
				data->_tmp4_ = FALSE;
				data->_tmp5_ = gee_collection_get_size ((GeeCollection*) data->levents);
				if (!(data->i < data->_tmp5_)) {
					break;
				}
				data->_tmp6_ = NULL;
				data->_tmp6_ = gee_list_get (data->levents, data->i);
				_dvb_event_unref0 (data->event);
				data->event = (DVBEvent*) data->_tmp6_;
				data->_tmp7_ = dvb_event_has_expired (data->event);
				if (data->_tmp7_) {
					data->newest_expired = data->i;
				} else {
					dvb_event_storage_insert (data->self->priv->events, data->event);
				}
			}
		}
	}
	if (data->newest_expired != (-1)) {
		data->_tmp8_ = NULL;
		data->_tmp8_ = gee_list_get (data->levents, data->newest_expired);
		_dvb_event_unref0 (data->event);
		data->event = (DVBEvent*) data->_tmp8_;
		data->_tmp9_ = dvb_channel_get_Sid (data->self->priv->_channel);
		data->_tmp10_ = dvb_channel_get_GroupId (data->self->priv->_channel);
		dvb_database_epg_store_remove_events_older_than (data->self->priv->epgstore, data->event, data->_tmp9_, data->_tmp10_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch158_dvb_database_sql_error;
			}
			_dvb_event_unref0 (data->event);
			_g_object_unref0 (data->levents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		goto __finally158;
		__catch158_dvb_database_sql_error:
		{
			data->e2 = data->_inner_error_;
			data->_inner_error_ = NULL;
			dvb_logging_logger_error (dvb_schedule_log, "Schedule.vala:78: %s", data->e2->message);
			_g_error_free0 (data->e2);
			_dvb_event_unref0 (data->event);
			_g_object_unref0 (data->levents);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		__finally158:
		if (data->_inner_error_ != NULL) {
			_dvb_event_unref0 (data->event);
			_g_object_unref0 (data->levents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp11_ = dvb_channel_get_Sid (data->self->priv->_channel);
	dvb_logging_logger_debug (dvb_schedule_log, "Schedule.vala:83: Finished restoring EPG events for channel %u", data->_tmp11_);
	_dvb_event_unref0 (data->event);
	_g_object_unref0 (data->levents);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


DVBSchedule* dvb_schedule_construct (GType object_type, DVBChannel* channel) {
	DVBSchedule * self = NULL;
	g_return_val_if_fail (channel != NULL, NULL);
	self = (DVBSchedule*) g_object_new (object_type, "channel", channel, NULL);
	return self;
}


DVBSchedule* dvb_schedule_new (DVBChannel* channel) {
	return dvb_schedule_construct (DVB_TYPE_SCHEDULE, channel);
}


void dvb_schedule_remove_expired_events (DVBSchedule* self) {
	gint last_expired;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	last_expired = -1;
	{
		const gchar* _tmp6_ = NULL;
		guint _tmp7_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp0_;
				_tmp0_ = TRUE;
				while (TRUE) {
					gint _tmp1_;
					DVBEventElement* _tmp2_ = NULL;
					DVBEventElement* element;
					DVBEvent* _tmp3_ = NULL;
					DVBEvent* e;
					gboolean _tmp4_ = FALSE;
					if (!_tmp0_) {
						i++;
					}
					_tmp0_ = FALSE;
					_tmp1_ = dvb_event_storage_get_size (self->priv->events);
					if (!(i < _tmp1_)) {
						break;
					}
					_tmp2_ = dvb_event_storage_get (self->priv->events, i);
					element = _tmp2_;
					_tmp3_ = dvb_schedule_get_event (self, element->id);
					e = _tmp3_;
					if (e != NULL) {
						gboolean _tmp5_;
						_tmp5_ = dvb_event_has_expired (e);
						_tmp4_ = _tmp5_;
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						last_expired = i;
					} else {
						_dvb_event_unref0 (e);
						_g_object_unref0 (element);
						break;
					}
					_dvb_event_unref0 (e);
					_g_object_unref0 (element);
				}
			}
		}
		_tmp6_ = dvb_channel_get_Name (self->priv->_channel);
		_tmp7_ = dvb_channel_get_Sid (self->priv->_channel);
		dvb_logging_logger_debug (dvb_schedule_log, "Schedule.vala:106: Removing expired events of channel %s (%u)", _tmp6_, _tmp7_);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					DVBEventElement* _tmp9_ = NULL;
					DVBEventElement* element;
					DVBEvent* _tmp10_ = NULL;
					DVBEvent* event;
					guint _tmp11_;
					guint _tmp12_;
					if (!_tmp8_) {
						i++;
					}
					_tmp8_ = FALSE;
					if (!(i <= last_expired)) {
						break;
					}
					_tmp9_ = dvb_event_storage_get (self->priv->events, i);
					element = _tmp9_;
					_tmp10_ = dvb_schedule_get_event (self, element->id);
					event = _tmp10_;
					_tmp11_ = dvb_channel_get_Sid (self->priv->_channel);
					_tmp12_ = dvb_channel_get_GroupId (self->priv->_channel);
					dvb_database_epg_store_remove_events_older_than (self->priv->epgstore, event, _tmp11_, _tmp12_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
							goto __catch160_dvb_database_sql_error;
						}
						_dvb_event_unref0 (event);
						_g_object_unref0 (element);
						g_static_rec_mutex_unlock (&self->priv->__lock_events);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					goto __finally160;
					__catch160_dvb_database_sql_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						dvb_logging_logger_error (dvb_schedule_log, "Schedule.vala:116: %s", e->message);
						_g_error_free0 (e);
					}
					__finally160:
					if (_inner_error_ != NULL) {
						_dvb_event_unref0 (event);
						_g_object_unref0 (element);
						_dvb_event_unref0 (event);
						_g_object_unref0 (element);
						g_static_rec_mutex_unlock (&self->priv->__lock_events);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_dvb_event_unref0 (event);
					_g_object_unref0 (element);
				}
			}
		}
		if (last_expired > (-1)) {
			dvb_event_storage_remove_range (self->priv->events, 0, last_expired);
		}
		__finally159:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


DVBEvent* dvb_schedule_get_event (DVBSchedule* self, guint event_id) {
	DVBEvent* result = NULL;
	guint _tmp0_;
	guint _tmp1_;
	DVBEvent* _tmp2_ = NULL;
	DVBEvent* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_channel_get_Sid (self->priv->_channel);
	_tmp1_ = dvb_channel_get_GroupId (self->priv->_channel);
	_tmp2_ = dvb_database_epg_store_get_event (self->priv->epgstore, event_id, _tmp0_, _tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch161_dvb_database_sql_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp3_;
	return result;
	goto __finally161;
	__catch161_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_schedule_log, "Schedule.vala:131: %s", e->message);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally161:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


/**
         * When an event with the same id already exists, it's replaced
         */
void dvb_schedule_add (DVBSchedule* self, DVBEvent* event) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = dvb_event_has_expired (event);
	if (_tmp0_) {
		return;
	}
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		dvb_schedule_store_event (self, event, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch163_dvb_database_sql_error;
			}
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		goto __finally163;
		__catch163_dvb_database_sql_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			dvb_logging_logger_error (dvb_schedule_log, "Schedule.vala:146: %s", e->message);
			_g_error_free0 (e);
		}
		__finally163:
		if (_inner_error_ != NULL) {
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		__finally162:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_schedule_add_all (DVBSchedule* self, GeeCollection* new_events) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_events != NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		g_static_rec_mutex_lock (&dvb_schedule_mutex);
		dvb_database_sqlite_sqlite_database_begin_transaction (DVB_DATABASE_SQLITE_SQLITE_DATABASE (self->priv->epgstore), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch165_dvb_database_sql_error;
			}
			g_static_rec_mutex_unlock (&dvb_schedule_mutex);
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		{
			GeeIterator* _tmp0_ = NULL;
			GeeIterator* _event_it;
			_tmp0_ = gee_iterable_iterator ((GeeIterable*) new_events);
			_event_it = _tmp0_;
			while (TRUE) {
				gboolean _tmp1_;
				gpointer _tmp2_ = NULL;
				DVBEvent* event;
				gboolean _tmp3_;
				_tmp1_ = gee_iterator_next (_event_it);
				if (!_tmp1_) {
					break;
				}
				_tmp2_ = gee_iterator_get (_event_it);
				event = (DVBEvent*) _tmp2_;
				_tmp3_ = dvb_event_has_expired (event);
				if (!_tmp3_) {
					dvb_schedule_store_event (self, event, &_inner_error_);
					if (_inner_error_ != NULL) {
						_dvb_event_unref0 (event);
						_g_object_unref0 (_event_it);
						if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
							goto __catch165_dvb_database_sql_error;
						}
						_dvb_event_unref0 (event);
						_g_object_unref0 (_event_it);
						g_static_rec_mutex_unlock (&dvb_schedule_mutex);
						g_static_rec_mutex_unlock (&self->priv->__lock_events);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_dvb_event_unref0 (event);
			}
			_g_object_unref0 (_event_it);
		}
		dvb_database_sqlite_sqlite_database_end_transaction (DVB_DATABASE_SQLITE_SQLITE_DATABASE (self->priv->epgstore), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch165_dvb_database_sql_error;
			}
			g_static_rec_mutex_unlock (&dvb_schedule_mutex);
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		goto __finally165;
		__catch165_dvb_database_sql_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			dvb_logging_logger_error (dvb_schedule_log, "Schedule.vala:164: %s", e->message);
			_g_error_free0 (e);
		}
		__finally165:
		g_static_rec_mutex_unlock (&dvb_schedule_mutex);
		if (_inner_error_ != NULL) {
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		__finally164:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void dvb_schedule_store_event (DVBSchedule* self, DVBEvent* event, GError** error) {
	GeeList* _tmp0_ = NULL;
	GeeList* overlap;
	gint _tmp1_;
	gint s;
	guint _tmp2_;
	guint _tmp3_;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = dvb_schedule_get_overlapping_events (self, event);
	overlap = _tmp0_;
	_tmp1_ = dvb_schedule_match_events (self, overlap, event);
	s = _tmp1_;
	if (s > DVB_SCHEDULE_MATCH_THRESHOLD) {
		dvb_event_storage_remove_all (self->priv->events, overlap);
	}
	_tmp2_ = dvb_channel_get_Sid (self->priv->_channel);
	_tmp3_ = dvb_channel_get_GroupId (self->priv->_channel);
	dvb_database_epg_store_add_or_update_event (self->priv->epgstore, event, _tmp2_, _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (overlap);
			return;
		} else {
			_g_object_unref0 (overlap);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = dvb_event_storage_contains_event_with_id (self->priv->events, event->id);
	if (!_tmp4_) {
		dvb_event_storage_insert (self->priv->events, event);
	}
	_g_object_unref0 (overlap);
}


static GeeList* dvb_schedule_get_overlapping_events (DVBSchedule* self, DVBEvent* event) {
	GeeList* result = NULL;
	GeeList* _tmp0_ = NULL;
	GeeList* elements;
	GeeArrayList* _tmp1_ = NULL;
	GeeList* overlap;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event != NULL, NULL);
	_tmp0_ = dvb_event_storage_get_overlapping_events (self->priv->events, event);
	elements = _tmp0_;
	_tmp1_ = gee_array_list_new (DVB_TYPE_EVENT, (GBoxedCopyFunc) dvb_event_ref, dvb_event_unref, NULL);
	overlap = (GeeList*) _tmp1_;
	{
		GeeList* _tmp2_;
		GeeList* _data_list;
		gint _tmp3_;
		gint _data_size;
		gint _data_index;
		_tmp2_ = _g_object_ref0 (elements);
		_data_list = _tmp2_;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _data_list);
		_data_size = _tmp3_;
		_data_index = -1;
		while (TRUE) {
			gpointer _tmp4_ = NULL;
			DVBEventElement* data;
			DVBEvent* _tmp5_ = NULL;
			DVBEvent* e;
			gboolean _tmp6_ = FALSE;
			_data_index = _data_index + 1;
			if (!(_data_index < _data_size)) {
				break;
			}
			_tmp4_ = gee_list_get (_data_list, _data_index);
			data = (DVBEventElement*) _tmp4_;
			_tmp5_ = dvb_schedule_get_event (self, data->id);
			e = _tmp5_;
			if (e != NULL) {
				gdouble _tmp7_;
				_tmp7_ = dvb_event_get_overlap_percentage (e, event);
				_tmp6_ = _tmp7_ >= DVB_SCHEDULE_MIN_EVENT_OVERLAP;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				gee_collection_add ((GeeCollection*) overlap, e);
			}
			_dvb_event_unref0 (e);
			_g_object_unref0 (data);
		}
		_g_object_unref0 (_data_list);
	}
	result = overlap;
	_g_object_unref0 (elements);
	return result;
}


static gint dvb_schedule_match_events (DVBSchedule* self, GeeList* events, DVBEvent* ref_event) {
	gint result = 0;
	time_t _tmp0_;
	time_t ref_start;
	time_t _tmp1_;
	time_t ref_end;
	gdouble max_score;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (events != NULL, 0);
	g_return_val_if_fail (ref_event != NULL, 0);
	_tmp0_ = dvb_event_get_start_timestamp (ref_event);
	ref_start = _tmp0_;
	_tmp1_ = dvb_event_get_end_timestamp (ref_event);
	ref_end = _tmp1_;
	max_score = (gdouble) 0;
	{
		GeeList* _tmp2_;
		GeeList* _event_list;
		gint _tmp3_;
		gint _event_size;
		gint _event_index;
		_tmp2_ = _g_object_ref0 (events);
		_event_list = _tmp2_;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _event_list);
		_event_size = _tmp3_;
		_event_index = -1;
		while (TRUE) {
			gpointer _tmp4_ = NULL;
			DVBEvent* event;
			gdouble score;
			time_t _tmp5_;
			time_t e_start;
			time_t _tmp6_;
			time_t e_end;
			gdouble _tmp7_;
			gdouble _tmp8_;
			gdouble _tmp9_;
			gboolean _tmp10_ = FALSE;
			_event_index = _event_index + 1;
			if (!(_event_index < _event_size)) {
				break;
			}
			_tmp4_ = gee_list_get (_event_list, _event_index);
			event = (DVBEvent*) _tmp4_;
			score = (gdouble) 0;
			_tmp5_ = dvb_event_get_start_timestamp (event);
			e_start = _tmp5_;
			_tmp6_ = dvb_event_get_end_timestamp (event);
			e_end = _tmp6_;
			_tmp7_ = fabs ((gdouble) (ref_start - e_start));
			score = score + _tmp7_;
			_tmp8_ = fabs ((gdouble) (ref_end - e_end));
			score = score + _tmp8_;
			_tmp9_ = fabs ((gdouble) (ref_event->duration - event->duration));
			score = score + (_tmp9_ / 60.0);
			if (ref_event->name != NULL) {
				_tmp10_ = event->name != NULL;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				glong unmatched = 0L;
				glong _tmp11_;
				glong _tmp12_;
				glong diff;
				_tmp12_ = dvb_utils_strdiff (ref_event->name, event->name, &_tmp11_);
				unmatched = _tmp11_;
				diff = _tmp12_;
				score = score + ((gdouble) (10 * (diff + (5 * unmatched))));
			}
			if (score > max_score) {
				max_score = score;
			}
			_dvb_event_unref0 (event);
		}
		_g_object_unref0 (_event_list);
	}
	result = (gint) max_score;
	return result;
}


gboolean dvb_schedule_contains (DVBSchedule* self, guint event_id) {
	gboolean result = FALSE;
	gboolean val = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, event_id);
		val = _tmp0_;
		__finally166:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = val;
	return result;
}


static gpointer _dvb_event_ref0 (gpointer self) {
	return self ? dvb_event_ref (self) : NULL;
}


DVBEvent* dvb_schedule_get_running_event (DVBSchedule* self) {
	DVBEvent* result = NULL;
	DVBEvent* running_event;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	running_event = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp0_;
			DVBEventStorage* _element_list;
			gint _tmp1_;
			gint _element_size;
			gint _element_index;
			_tmp0_ = _g_object_ref0 (self->priv->events);
			_element_list = _tmp0_;
			_tmp1_ = dvb_event_storage_get_size (_element_list);
			_element_size = _tmp1_;
			_element_index = -1;
			while (TRUE) {
				DVBEventElement* _tmp2_ = NULL;
				DVBEventElement* element;
				DVBEvent* _tmp3_ = NULL;
				DVBEvent* event;
				gboolean _tmp4_ = FALSE;
				_element_index = _element_index + 1;
				if (!(_element_index < _element_size)) {
					break;
				}
				_tmp2_ = dvb_event_storage_get (_element_list, _element_index);
				element = _tmp2_;
				_tmp3_ = dvb_schedule_get_event (self, element->id);
				event = _tmp3_;
				if (event != NULL) {
					gboolean _tmp5_;
					_tmp5_ = dvb_event_is_running (event);
					_tmp4_ = _tmp5_;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					DVBEvent* _tmp6_;
					_tmp6_ = _dvb_event_ref0 (event);
					_dvb_event_unref0 (running_event);
					running_event = _tmp6_;
					_dvb_event_unref0 (event);
					_g_object_unref0 (element);
					break;
				}
				_dvb_event_unref0 (event);
				_g_object_unref0 (element);
			}
			_g_object_unref0 (_element_list);
		}
		__finally167:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			_dvb_event_unref0 (running_event);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = running_event;
	return result;
}


/**
         * @start: local time of event
         * @duration: how long the event is
         * @returns: the event that starts after @start
         * and spans the given time period
         */
static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


DVBEvent* dvb_schedule_get_event_around (DVBSchedule* self, struct tm* start, guint duration) {
	DVBEvent* result = NULL;
	DVBEvent* _result_;
	time_t _tmp0_;
	time_t timer_start;
	time_t timer_end;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = mktime (start);
	timer_start = _tmp0_;
	timer_end = timer_start + (duration * 60);
	{
		time_t last_diff;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		last_diff = (time_t) 0;
		{
			DVBEventStorage* _tmp1_;
			DVBEventStorage* _element_list;
			gint _tmp2_;
			gint _element_size;
			gint _element_index;
			_tmp1_ = _g_object_ref0 (self->priv->events);
			_element_list = _tmp1_;
			_tmp2_ = dvb_event_storage_get_size (_element_list);
			_element_size = _tmp2_;
			_element_index = -1;
			while (TRUE) {
				DVBEventElement* _tmp3_ = NULL;
				DVBEventElement* element;
				struct tm _tmp4_ = {0};
				struct tm _tmp5_ = {0};
				time_t _tmp6_;
				time_t event_start;
				DVBEvent* _tmp7_ = NULL;
				DVBEvent* event;
				time_t event_end;
				time_t _tmp8_ = 0;
				time_t min_end;
				time_t _tmp9_ = 0;
				time_t max_start;
				time_t overlap;
				_element_index = _element_index + 1;
				if (!(_element_index < _element_size)) {
					break;
				}
				_tmp3_ = dvb_event_storage_get (_element_list, _element_index);
				element = _tmp3_;
				g_time_local (element->starttime, &_tmp4_);
				_tmp5_ = _tmp4_;
				_tmp6_ = timegm (&_tmp5_);
				event_start = _tmp6_;
				_tmp7_ = dvb_schedule_get_event (self, element->id);
				event = _tmp7_;
				if (event == NULL) {
					_dvb_event_unref0 (event);
					_g_object_unref0 (element);
					continue;
				}
				event_end = event_start + event->duration;
				if (timer_end < event_end) {
					_tmp8_ = timer_end;
				} else {
					_tmp8_ = event_end;
				}
				min_end = _tmp8_;
				if (timer_start > event_start) {
					_tmp9_ = timer_start;
				} else {
					_tmp9_ = event_start;
				}
				max_start = _tmp9_;
				overlap = min_end - max_start;
				if (last_diff < overlap) {
					DVBEvent* _tmp10_;
					last_diff = overlap;
					_tmp10_ = _dvb_event_ref0 (event);
					_dvb_event_unref0 (_result_);
					_result_ = _tmp10_;
				}
				if (event_start > timer_end) {
					_dvb_event_unref0 (event);
					_g_object_unref0 (element);
					break;
				}
				_dvb_event_unref0 (event);
				_g_object_unref0 (element);
			}
			_g_object_unref0 (_element_list);
		}
		__finally168:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			_dvb_event_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _result_;
	return result;
}


static guint32* dvb_schedule_real_GetAllEvents (DVBIDBusSchedule* base, int* result_length1, GError** error) {
	DVBSchedule * self;
	guint32* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* events;
	gint _tmp7_;
	guint32* _tmp8_ = NULL;
	guint32* event_ids;
	gint event_ids_length1;
	gint _event_ids_size_;
	guint32* _tmp11_;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	_tmp0_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL);
	events = _tmp0_;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp1_;
			DVBEventStorage* _element_list;
			gint _tmp2_;
			gint _element_size;
			gint _element_index;
			_tmp1_ = _g_object_ref0 (self->priv->events);
			_element_list = _tmp1_;
			_tmp2_ = dvb_event_storage_get_size (_element_list);
			_element_size = _tmp2_;
			_element_index = -1;
			while (TRUE) {
				DVBEventElement* _tmp3_ = NULL;
				DVBEventElement* element;
				DVBEvent* _tmp4_ = NULL;
				DVBEvent* event;
				gboolean _tmp5_ = FALSE;
				_element_index = _element_index + 1;
				if (!(_element_index < _element_size)) {
					break;
				}
				_tmp3_ = dvb_event_storage_get (_element_list, _element_index);
				element = _tmp3_;
				_tmp4_ = dvb_schedule_get_event (self, element->id);
				event = _tmp4_;
				if (event == NULL) {
					_tmp5_ = TRUE;
				} else {
					gboolean _tmp6_;
					_tmp6_ = dvb_event_has_expired (event);
					_tmp5_ = _tmp6_;
				}
				if (_tmp5_) {
					_dvb_event_unref0 (event);
					_g_object_unref0 (element);
					continue;
				}
				gee_abstract_collection_add ((GeeAbstractCollection*) events, GUINT_TO_POINTER ((guint32) element->id));
				_dvb_event_unref0 (event);
				_g_object_unref0 (element);
			}
			_g_object_unref0 (_element_list);
		}
		__finally169:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (events);
				return NULL;
			} else {
				_g_object_unref0 (events);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp7_ = gee_collection_get_size ((GeeCollection*) events);
	_tmp8_ = g_new0 (guint32, _tmp7_);
	event_ids = _tmp8_;
	event_ids_length1 = _tmp7_;
	_event_ids_size_ = _tmp7_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gpointer _tmp10_ = NULL;
				if (!_tmp9_) {
					i++;
				}
				_tmp9_ = FALSE;
				if (!(i < event_ids_length1)) {
					break;
				}
				_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) events, i);
				event_ids[i] = GPOINTER_TO_UINT (_tmp10_);
			}
		}
	}
	_tmp11_ = event_ids;
	*result_length1 = event_ids_length1;
	result = _tmp11_;
	_g_object_unref0 (events);
	return result;
}


static void _vala_DVBEventInfo_array_free (DVBEventInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dvb_event_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DVBEventInfo* dvb_schedule_real_GetAllEventInfos (DVBIDBusSchedule* base, int* result_length1, GError** error) {
	DVBSchedule * self;
	DVBEventInfo* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* all_events;
	gint _tmp7_;
	gint n_events;
	DVBEventInfo* _tmp8_ = NULL;
	DVBEventInfo* event_infos;
	gint event_infos_length1;
	gint _event_infos_size_;
	gint i;
	DVBEvent* event;
	DVBEventInfo* _tmp14_;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	_tmp0_ = gee_array_list_new (DVB_TYPE_EVENT, (GBoxedCopyFunc) dvb_event_ref, dvb_event_unref, NULL);
	all_events = _tmp0_;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp1_;
			DVBEventStorage* _element_list;
			gint _tmp2_;
			gint _element_size;
			gint _element_index;
			_tmp1_ = _g_object_ref0 (self->priv->events);
			_element_list = _tmp1_;
			_tmp2_ = dvb_event_storage_get_size (_element_list);
			_element_size = _tmp2_;
			_element_index = -1;
			while (TRUE) {
				DVBEventElement* _tmp3_ = NULL;
				DVBEventElement* element;
				DVBEvent* _tmp4_ = NULL;
				DVBEvent* event;
				gboolean _tmp5_ = FALSE;
				_element_index = _element_index + 1;
				if (!(_element_index < _element_size)) {
					break;
				}
				_tmp3_ = dvb_event_storage_get (_element_list, _element_index);
				element = _tmp3_;
				_tmp4_ = dvb_schedule_get_event (self, element->id);
				event = _tmp4_;
				if (event != NULL) {
					gboolean _tmp6_;
					_tmp6_ = dvb_event_has_expired (event);
					_tmp5_ = !_tmp6_;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					gee_abstract_collection_add ((GeeAbstractCollection*) all_events, event);
				}
				_dvb_event_unref0 (event);
				_g_object_unref0 (element);
			}
			_g_object_unref0 (_element_list);
		}
		__finally170:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (all_events);
				return NULL;
			} else {
				_g_object_unref0 (all_events);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp7_ = gee_collection_get_size ((GeeCollection*) all_events);
	n_events = _tmp7_;
	_tmp8_ = g_new0 (DVBEventInfo, n_events);
	event_infos = _tmp8_;
	event_infos_length1 = n_events;
	_event_infos_size_ = n_events;
	i = 0;
	event = NULL;
	if (n_events > i) {
		gpointer _tmp9_ = NULL;
		_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) all_events, i);
		_dvb_event_unref0 (event);
		event = (DVBEvent*) _tmp9_;
	}
	while (TRUE) {
		DVBEventInfo _tmp10_ = {0};
		DVBEventInfo _tmp11_ = {0};
		DVBEventInfo _tmp12_;
		if (!(event != NULL)) {
			break;
		}
		dvb_schedule_event_to_event_info (event, &_tmp10_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		dvb_event_info_destroy (&event_infos[i]);
		event_infos[i] = _tmp12_;
		if ((i + 1) == n_events) {
			event_infos[i].next = (guint32) 0;
			_dvb_event_unref0 (event);
			event = NULL;
		} else {
			gpointer _tmp13_ = NULL;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) all_events, i + 1);
			_dvb_event_unref0 (event);
			event = (DVBEvent*) _tmp13_;
			event_infos[i].next = (guint32) event->id;
		}
		i++;
	}
	_tmp14_ = event_infos;
	*result_length1 = event_infos_length1;
	result = _tmp14_;
	_dvb_event_unref0 (event);
	_g_object_unref0 (all_events);
	return result;
}


static gboolean dvb_schedule_real_GetInformations (DVBIDBusSchedule* base, guint32 event_id, DVBEventInfo* event_info, GError** error) {
	DVBSchedule * self;
	DVBEventInfo _event_info = {0};
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEventElement* _tmp1_ = NULL;
			DVBEventElement* element;
			DVBEvent* _tmp2_ = NULL;
			DVBEvent* event;
			DVBEventInfo _tmp3_ = {0};
			DVBEventInfo _tmp4_ = {0};
			DVBEventElement* _tmp5_ = NULL;
			DVBEventElement* next_element;
			_tmp1_ = dvb_event_storage_get_by_id (self->priv->events, (guint) event_id);
			element = _tmp1_;
			_tmp2_ = dvb_schedule_get_event (self, element->id);
			event = _tmp2_;
			dvb_schedule_event_to_event_info (event, &_tmp3_);
			_tmp4_ = _tmp3_;
			dvb_event_info_destroy (&_event_info);
			_event_info = _tmp4_;
			_tmp5_ = dvb_event_storage_next (self->priv->events, element);
			next_element = _tmp5_;
			if (next_element == NULL) {
				_event_info.next = (guint32) 0;
			} else {
				DVBEventElement* _tmp6_;
				_tmp6_ = _g_object_ref0 (next_element);
				_g_object_unref0 (element);
				element = _tmp6_;
				_event_info.next = (guint32) element->id;
			}
			ret = TRUE;
			_g_object_unref0 (next_element);
			_dvb_event_unref0 (event);
			_g_object_unref0 (element);
		} else {
			gchar* _tmp7_;
			gchar* _tmp8_;
			_event_info.id = (guint32) 0;
			_tmp7_ = g_strdup ("");
			_g_free0 (_event_info.name);
			_event_info.name = _tmp7_;
			_event_info.duration = (guint) 0;
			_tmp8_ = g_strdup ("");
			_g_free0 (_event_info.short_description);
			_event_info.short_description = _tmp8_;
			_event_info.next = (guint32) 0;
			ret = FALSE;
		}
		__finally171:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (event_info) {
		*event_info = _event_info;
	} else {
		dvb_event_info_destroy (&_event_info);
	}
	return result;
}


static guint32 dvb_schedule_real_NowPlaying (DVBIDBusSchedule* base, GError** error) {
	DVBSchedule * self;
	guint32 result = 0U;
	DVBEvent* _tmp0_ = NULL;
	DVBEvent* event;
	guint _tmp1_ = 0U;
	self = (DVBSchedule*) base;
	_tmp0_ = dvb_schedule_get_running_event (self);
	event = _tmp0_;
	if (event == NULL) {
		_tmp1_ = (guint) 0;
	} else {
		_tmp1_ = event->id;
	}
	result = (guint32) _tmp1_;
	_dvb_event_unref0 (event);
	return result;
}


static guint32 dvb_schedule_real_Next (DVBIDBusSchedule* base, guint32 event_id, GError** error) {
	DVBSchedule * self;
	guint32 result = 0U;
	guint32 next_event;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	next_event = (guint32) 0;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEventElement* _tmp1_ = NULL;
			DVBEventElement* element;
			DVBEventElement* _tmp2_ = NULL;
			DVBEventElement* next;
			_tmp1_ = dvb_event_storage_get_by_id (self->priv->events, (guint) event_id);
			element = _tmp1_;
			_tmp2_ = dvb_event_storage_next (self->priv->events, element);
			next = _tmp2_;
			if (next != NULL) {
				next_event = (guint32) next->id;
			}
			_g_object_unref0 (next);
			_g_object_unref0 (element);
		} else {
			dvb_logging_logger_debug (dvb_schedule_log, "Schedule.vala:390: No event with id %u", (guint) event_id);
		}
		__finally172:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0U;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0U;
			}
		}
	}
	result = next_event;
	return result;
}


static gboolean dvb_schedule_real_GetName (DVBIDBusSchedule* base, guint32 event_id, gchar** name, GError** error) {
	DVBSchedule * self;
	gchar* _name = NULL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEvent* _tmp1_ = NULL;
			DVBEvent* event;
			gboolean _tmp2_ = FALSE;
			_tmp1_ = dvb_schedule_get_extended_event_by_id (self, (guint) event_id);
			event = _tmp1_;
			if (event != NULL) {
				_tmp2_ = event->name != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				gchar* _tmp3_;
				_tmp3_ = g_strdup (event->name);
				_g_free0 (_name);
				_name = _tmp3_;
				ret = TRUE;
			}
			_dvb_event_unref0 (event);
		} else {
			dvb_logging_logger_debug (dvb_schedule_log, "Schedule.vala:408: No event with id %u", (guint) event_id);
		}
		__finally173:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_name);
		_name = _tmp4_;
	}
	result = ret;
	if (name) {
		*name = _name;
	} else {
		_g_free0 (_name);
	}
	return result;
}


static gboolean dvb_schedule_real_GetShortDescription (DVBIDBusSchedule* base, guint32 event_id, gchar** description, GError** error) {
	DVBSchedule * self;
	gchar* _description = NULL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEvent* _tmp1_ = NULL;
			DVBEvent* event;
			gboolean _tmp2_ = FALSE;
			_tmp1_ = dvb_schedule_get_extended_event_by_id (self, (guint) event_id);
			event = _tmp1_;
			if (event != NULL) {
				_tmp2_ = event->description != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				gchar* _tmp3_;
				_tmp3_ = g_strdup (event->description);
				_g_free0 (_description);
				_description = _tmp3_;
				ret = TRUE;
			}
			_dvb_event_unref0 (event);
		} else {
			dvb_logging_logger_debug (dvb_schedule_log, "Schedule.vala:428: No event with id %u", (guint) event_id);
		}
		__finally174:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_description);
		_description = _tmp4_;
	}
	result = ret;
	if (description) {
		*description = _description;
	} else {
		_g_free0 (_description);
	}
	return result;
}


static gboolean dvb_schedule_real_GetExtendedDescription (DVBIDBusSchedule* base, guint32 event_id, gchar** description, GError** error) {
	DVBSchedule * self;
	gchar* _description = NULL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEvent* _tmp1_ = NULL;
			DVBEvent* event;
			gboolean _tmp2_ = FALSE;
			_tmp1_ = dvb_schedule_get_extended_event_by_id (self, (guint) event_id);
			event = _tmp1_;
			if (event != NULL) {
				_tmp2_ = event->extended_description != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				gchar* _tmp3_;
				_tmp3_ = g_strdup (event->extended_description);
				_g_free0 (_description);
				_description = _tmp3_;
				ret = TRUE;
			}
			_dvb_event_unref0 (event);
		} else {
			dvb_logging_logger_debug (dvb_schedule_log, "Schedule.vala:448: No event with id %u", (guint) event_id);
		}
		__finally175:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_description);
		_description = _tmp4_;
	}
	result = ret;
	if (description) {
		*description = _description;
	} else {
		_g_free0 (_description);
	}
	return result;
}


static gboolean dvb_schedule_real_GetDuration (DVBIDBusSchedule* base, guint32 event_id, guint* duration, GError** error) {
	DVBSchedule * self;
	guint _duration = 0U;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEvent* _tmp1_ = NULL;
			DVBEvent* event;
			_tmp1_ = dvb_schedule_get_extended_event_by_id (self, (guint) event_id);
			event = _tmp1_;
			if (event != NULL) {
				_duration = event->duration;
				ret = TRUE;
			}
			_dvb_event_unref0 (event);
		} else {
			dvb_logging_logger_debug (dvb_schedule_log, "Schedule.vala:468: No event with id %u", (guint) event_id);
		}
		__finally176:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (duration) {
		*duration = _duration;
	}
	return result;
}


static gboolean dvb_schedule_real_GetLocalStartTime (DVBIDBusSchedule* base, guint32 event_id, guint** start_time, int* start_time_length1, GError** error) {
	DVBSchedule * self;
	guint* _start_time = NULL;
	int _start_time_length1 = 0;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEvent* _tmp1_ = NULL;
			DVBEvent* event;
			_tmp1_ = dvb_schedule_get_extended_event_by_id (self, (guint) event_id);
			event = _tmp1_;
			if (event != NULL) {
				struct tm _tmp2_ = {0};
				struct tm _tmp3_ = {0};
				struct tm local_time;
				gint _tmp4_;
				guint* _tmp5_ = NULL;
				dvb_event_get_local_start_time (event, &_tmp2_);
				_tmp3_ = _tmp2_;
				local_time = _tmp3_;
				_tmp5_ = dvb_schedule_to_time_array (&local_time, &_tmp4_);
				_start_time = (g_free (_start_time), NULL);
				_start_time = _tmp5_;
				_start_time_length1 = _tmp4_;
				ret = TRUE;
			}
			_dvb_event_unref0 (event);
		} else {
			guint* _tmp6_ = NULL;
			dvb_logging_logger_debug (dvb_schedule_log, "Schedule.vala:489: No event with id %u", (guint) event_id);
			_tmp6_ = g_new0 (guint, 0);
			_start_time = (g_free (_start_time), NULL);
			_start_time = _tmp6_;
			_start_time_length1 = 0;
		}
		__finally177:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		guint* _tmp7_ = NULL;
		_tmp7_ = g_new0 (guint, 0);
		_start_time = (g_free (_start_time), NULL);
		_start_time = _tmp7_;
		_start_time_length1 = 0;
	}
	result = ret;
	if (start_time) {
		*start_time = _start_time;
	} else {
		_start_time = (g_free (_start_time), NULL);
	}
	if (start_time_length1) {
		*start_time_length1 = _start_time_length1;
	}
	return result;
}


static gboolean dvb_schedule_real_GetLocalStartTimestamp (DVBIDBusSchedule* base, guint32 event_id, gint64* timestamp, GError** error) {
	DVBSchedule * self;
	gint64 _timestamp = 0LL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEvent* _tmp1_ = NULL;
			DVBEvent* event;
			_tmp1_ = dvb_schedule_get_extended_event_by_id (self, (guint) event_id);
			event = _tmp1_;
			if (event != NULL) {
				struct tm _tmp2_ = {0};
				struct tm _tmp3_ = {0};
				struct tm local_time;
				time_t _tmp4_;
				dvb_event_get_local_start_time (event, &_tmp2_);
				_tmp3_ = _tmp2_;
				local_time = _tmp3_;
				_tmp4_ = mktime (&local_time);
				_timestamp = (gint64) _tmp4_;
				ret = TRUE;
			}
			_dvb_event_unref0 (event);
		}
		__finally178:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (timestamp) {
		*timestamp = _timestamp;
	}
	return result;
}


static gboolean dvb_schedule_real_IsRunning (DVBIDBusSchedule* base, guint32 event_id, gboolean* running, GError** error) {
	DVBSchedule * self;
	gboolean _running = FALSE;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEvent* _tmp1_ = NULL;
			DVBEvent* event;
			_tmp1_ = dvb_schedule_get_extended_event_by_id (self, (guint) event_id);
			event = _tmp1_;
			if (event != NULL) {
				gboolean _tmp2_;
				_tmp2_ = dvb_event_is_running (event);
				_running = _tmp2_;
				ret = TRUE;
			}
			_dvb_event_unref0 (event);
		} else {
			dvb_logging_logger_debug (dvb_schedule_log, "Schedule.vala:529: No event with id %u", (guint) event_id);
		}
		__finally179:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (running) {
		*running = _running;
	}
	return result;
}


static gboolean dvb_schedule_real_IsScrambled (DVBIDBusSchedule* base, guint32 event_id, gboolean* scrambled, GError** error) {
	DVBSchedule * self;
	gboolean _scrambled = FALSE;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEvent* _tmp1_ = NULL;
			DVBEvent* event;
			_tmp1_ = dvb_schedule_get_extended_event_by_id (self, (guint) event_id);
			event = _tmp1_;
			if (event != NULL) {
				_scrambled = !event->free_ca_mode;
				ret = TRUE;
			}
			_dvb_event_unref0 (event);
		} else {
			dvb_logging_logger_debug (dvb_schedule_log, "Schedule.vala:549: No event with id %u", (guint) event_id);
		}
		__finally180:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (scrambled) {
		*scrambled = _scrambled;
	}
	return result;
}


static DVBEvent* dvb_schedule_get_extended_event_by_id (DVBSchedule* self, guint event_id) {
	DVBEvent* result = NULL;
	DVBEventElement* _tmp0_ = NULL;
	DVBEventElement* element;
	DVBEvent* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_event_storage_get_by_id (self->priv->events, event_id);
	element = _tmp0_;
	_tmp1_ = dvb_schedule_get_event (self, element->id);
	result = _tmp1_;
	_g_object_unref0 (element);
	return result;
}


static guint* dvb_schedule_to_time_array (struct tm* local_time, int* result_length1) {
	guint* result = NULL;
	guint* _tmp0_ = NULL;
	guint* start;
	gint start_length1;
	gint _start_size_;
	guint* _tmp1_;
	_tmp0_ = g_new0 (guint, 6);
	start = _tmp0_;
	start_length1 = 6;
	_start_size_ = 6;
	start[0] = (guint) ((*local_time).tm_year + 1900);
	start[1] = (guint) ((*local_time).tm_mon + 1);
	start[2] = (guint) (*local_time).tm_mday;
	start[3] = (guint) (*local_time).tm_hour;
	start[4] = (guint) (*local_time).tm_min;
	start[5] = (guint) (*local_time).tm_sec;
	_tmp1_ = start;
	*result_length1 = start_length1;
	result = _tmp1_;
	return result;
}


static void dvb_schedule_event_to_event_info (DVBEvent* event, DVBEventInfo* result) {
	DVBEventInfo event_info = {0};
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (event != NULL);
	memset (&event_info, 0, sizeof (DVBEventInfo));
	event_info.id = (guint32) event->id;
	_tmp0_ = g_strdup (event->name);
	_g_free0 (event_info.name);
	event_info.name = _tmp0_;
	event_info.duration = event->duration;
	_tmp1_ = g_strdup (event->description);
	_g_free0 (event_info.short_description);
	event_info.short_description = _tmp1_;
	*result = event_info;
	return;
}


DVBChannel* dvb_schedule_get_channel (DVBSchedule* self) {
	DVBChannel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_channel;
	return result;
}


static void dvb_schedule_set_channel (DVBSchedule* self, DVBChannel* value) {
	g_return_if_fail (self != NULL);
	self->priv->_channel = value;
	g_object_notify ((GObject *) self, "channel");
}


static GObject * dvb_schedule_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBSchedule * self;
	DVBEventStorage* _tmp0_ = NULL;
	DVBdatabaseEPGStore* _tmp1_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_schedule_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_SCHEDULE (obj);
	_tmp0_ = dvb_event_storage_new ();
	_g_object_unref0 (self->priv->events);
	self->priv->events = _tmp0_;
	_tmp1_ = dvb_factory_get_epg_store ();
	_g_object_unref0 (self->priv->epgstore);
	self->priv->epgstore = _tmp1_;
	return obj;
}


static void dvb_schedule_class_init (DVBScheduleClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	GStaticRecMutex _tmp2_ = {0};
	GStaticRecMutex _tmp3_ = {0};
	dvb_schedule_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBSchedulePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_schedule_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_schedule_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_schedule_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_schedule_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCHEDULE_CHANNEL, g_param_spec_object ("channel", "channel", "channel", DVB_TYPE_CHANNEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_schedule_log = _tmp1_;
	g_static_rec_mutex_init (&_tmp2_);
	_tmp3_ = _tmp2_;
	dvb_schedule_mutex = _tmp3_;
}


static void dvb_schedule_dvb_id_bus_schedule_interface_init (DVBIDBusScheduleIface * iface) {
	dvb_schedule_dvb_id_bus_schedule_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetAllEvents = (guint32* (*)(DVBIDBusSchedule* ,int* ,GError**)) dvb_schedule_real_GetAllEvents;
	iface->GetAllEventInfos = (DVBEventInfo* (*)(DVBIDBusSchedule* ,int* ,GError**)) dvb_schedule_real_GetAllEventInfos;
	iface->GetInformations = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,DVBEventInfo* ,GError**)) dvb_schedule_real_GetInformations;
	iface->NowPlaying = (guint32 (*)(DVBIDBusSchedule* ,GError**)) dvb_schedule_real_NowPlaying;
	iface->Next = (guint32 (*)(DVBIDBusSchedule* ,guint32 ,GError**)) dvb_schedule_real_Next;
	iface->GetName = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,gchar** ,GError**)) dvb_schedule_real_GetName;
	iface->GetShortDescription = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,gchar** ,GError**)) dvb_schedule_real_GetShortDescription;
	iface->GetExtendedDescription = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,gchar** ,GError**)) dvb_schedule_real_GetExtendedDescription;
	iface->GetDuration = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,guint* ,GError**)) dvb_schedule_real_GetDuration;
	iface->GetLocalStartTime = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,guint** ,int* ,GError**)) dvb_schedule_real_GetLocalStartTime;
	iface->GetLocalStartTimestamp = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,gint64* ,GError**)) dvb_schedule_real_GetLocalStartTimestamp;
	iface->IsRunning = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,gboolean* ,GError**)) dvb_schedule_real_IsRunning;
	iface->IsScrambled = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,gboolean* ,GError**)) dvb_schedule_real_IsScrambled;
}


static void dvb_schedule_instance_init (DVBSchedule * self) {
	self->priv = DVB_SCHEDULE_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_events);
}


static void dvb_schedule_finalize (GObject* obj) {
	DVBSchedule * self;
	self = DVB_SCHEDULE (obj);
	_g_object_unref0 (self->priv->epgstore);
	g_static_rec_mutex_free (&self->priv->__lock_events);
	_g_object_unref0 (self->priv->events);
	G_OBJECT_CLASS (dvb_schedule_parent_class)->finalize (obj);
}


/**
     * Represents a series of events of a channel
     */
GType dvb_schedule_get_type (void) {
	static volatile gsize dvb_schedule_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_schedule_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScheduleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_schedule_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBSchedule), 0, (GInstanceInitFunc) dvb_schedule_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_schedule_info = { (GInterfaceInitFunc) dvb_schedule_dvb_id_bus_schedule_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_schedule_type_id;
		dvb_schedule_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBSchedule", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_schedule_type_id, DVB_TYPE_ID_BUS_SCHEDULE, &dvb_id_bus_schedule_info);
		g_once_init_leave (&dvb_schedule_type_id__volatile, dvb_schedule_type_id);
	}
	return dvb_schedule_type_id__volatile;
}


static void _vala_dvb_schedule_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBSchedule * self;
	self = DVB_SCHEDULE (object);
	switch (property_id) {
		case DVB_SCHEDULE_CHANNEL:
		g_value_set_object (value, dvb_schedule_get_channel (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_schedule_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBSchedule * self;
	self = DVB_SCHEDULE (object);
	switch (property_id) {
		case DVB_SCHEDULE_CHANNEL:
		dvb_schedule_set_channel (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



