import unittest
from utils import refresh_gui, init_gazpacho
import gtk

app, project = init_gazpacho()

from gazpacho import command

class GtkWindowTest(unittest.TestCase):
        
    def test01Creation(self):
        global app, project
        app.palette.select_widget('Gtk+ Base', 'GtkWindow')
        refresh_gui()
        gwidget = project.get_widget_by_name('window1')
        self.assertEqual(gtk.Window, type(gwidget.widget))

    def test02Property(self):
        global app, project
        gwidget = project.get_widget_by_name('window1')
        prop = gwidget.get_glade_property('title')
        cm = app.get_command_manager()
        cm.set_property(prop, 'Window Title Test')
        refresh_gui()
        self.assertEqual(gwidget.widget.get_title(), 'Window Title Test')

    def test03Saving(self):
        global project
        project.save(__file__+'.glade')
        refresh_gui()
        
    def test04Loading(self):
        global app
        app.open_project(__file__+'.glade')
        refresh_gui()
        
if __name__ == '__main__':
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(GtkWindowTest))
    unittest.TextTestRunner(verbosity=2).run(suite)
