import gtk

from gazpacho.loader import tags
from gazpacho.l10n import _

class Parameter:
    """ The Parameter is a pair of a key and a value. It is used by the
    GladeSetting object. We store in a string the value no matter the type of
    the paramter it is. This adds "extra" information to a GladeProperty that
    we can blindly parse/set/query. The valid parameter keys depend on the type
    of the property
    """

    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value


# utility functions
def adjustment_new(property_class):
    value = 1
    lower = 0
    upper = 999999
    step_increment = 1.0
    page_increment = 10.0
    climb_rate = 1.0

    if property_class.default:
        if isinstance(property_class.default, float):
            step_increment = 0.01
        elif isinstance(property_class.default, int):
            step_increment = 1.0

        value = property_class.default
        page_increment = 10 * step_increment

    lower = get_float(property_class.parameters, "Min", lower)
    upper = get_float(property_class.parameters, "Max", upper)
    step_increment = get_float(property_class.parameters, "StepIncrement",
                               step_increment)
    page_increment = get_float(property_class.parameters, "PageIncrement",
                               page_increment)
    climb_rate = get_float(property_class.parameters, "ClimbRate",
                           climb_rate)
    return gtk.Adjustment(value, lower, upper, step_increment,
                          page_increment, climb_rate)

def get_value(parameters, key, default, value_type):
    l = [value_type(p.value) for p in parameters if p.key == key]
    if l:
        return l[0]
    else:
        return default

def get_integer(parameters, key, default):
    return get_value(parameters, key, default, int)

def get_float(parameters, key, default):
    return get_value(parameters, key, default, float)

def get_string(parameters, key, default):
    return get_value(parameters, key, default, str)

def get_boolean(parameters, key, default):
    l = [p for p in parameters if p.key == key]
    if l:
        value = l[0]
        if value == tags.TRUE:
            return True
        elif value == tags.FALSE:
            return False
        else:
            print _("Invalid boolean parameter *%s* (%s/%s)") % \
                  (value, tags.TRUE, tags.FALSE)
    else:
        return default

def list_new_from_node(xmlnode):
    result = []
    for child in xmlnode.childNodes:
        if child.nodeType == child.ELEMENT_NODE:
            key = child.getAttribute(tags.KEY)
            value = child.getAttribute(tags.VALUE)
            if not key or not value:
                continue
            p = Parameter(key, value)
            result.append(p)

    return result
