# Copyright (C) 2004,2005 by SICEm S.L.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
from gazpacho.loader import tags

def list_new_from_node(xmlnode, pspec):
    result = []
    def_value = 0
    for child in xmlnode.childNodes:
        if child.nodeType == child.ELEMENT_NODE:
            name = child.getAttribute(tags.NAME)
            if not name:
                continue
            child_id = child.getAttribute(tags.ID)
            value = _enum_from_string(child.getAttribute(child_id), pspec)
            # if enum_from_string is not able to find a value for this enum,
            # we will use as value the position of the item in the enum list
            if value == -1:
                value = def_value

            result.append({'name': name, 'id': child_id, 'value': value})
            def_value += 1

    return result

def list_new_from_spec(spec):
    result = []
    enum_class = spec.enum_class
    if enum_class is not None:
        for value, enum in enum_class.__enum_values__.items():
            name = enum.value_nick
            id = enum.value_name
            result.append({'name': name, 'id': id, 'value': value})
    return result

def _enum_from_string(string, pspec):
    if string == '-':
        return 0
    enum_class = pspec.enum_class
    if enum_class is not None:
        for value, enum in enum_class.__enum_values__.items():
            if enum.value_name == string:
                return value

    return -1
