/* plugin.c generated by valac, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Abderrahim Kitouni
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libanjuta/libanjuta.h>
#include <libanjuta/interfaces/libanjuta-interfaces.h>
#include <vala.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>


#define TYPE_VALA_PLUGIN (vala_plugin_get_type ())
#define VALA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_PLUGIN, ValaPlugin))
#define VALA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_PLUGIN, ValaPluginClass))
#define IS_VALA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_PLUGIN))
#define IS_VALA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_PLUGIN))
#define VALA_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_PLUGIN, ValaPluginClass))

typedef struct _ValaPlugin ValaPlugin;
typedef struct _ValaPluginClass ValaPluginClass;
typedef struct _ValaPluginPrivate ValaPluginPrivate;

#define TYPE_BLOCK_LOCATOR (block_locator_get_type ())
#define BLOCK_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK_LOCATOR, BlockLocator))
#define BLOCK_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK_LOCATOR, BlockLocatorClass))
#define IS_BLOCK_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK_LOCATOR))
#define IS_BLOCK_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK_LOCATOR))
#define BLOCK_LOCATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK_LOCATOR, BlockLocatorClass))

typedef struct _BlockLocator BlockLocator;
typedef struct _BlockLocatorClass BlockLocatorClass;

#define TYPE_ANJUTA_REPORT (anjuta_report_get_type ())
#define ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANJUTA_REPORT, AnjutaReport))
#define ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANJUTA_REPORT, AnjutaReportClass))
#define IS_ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANJUTA_REPORT))
#define IS_ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANJUTA_REPORT))
#define ANJUTA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANJUTA_REPORT, AnjutaReportClass))

typedef struct _AnjutaReport AnjutaReport;
typedef struct _AnjutaReportClass AnjutaReportClass;

#define TYPE_VALA_PROVIDER (vala_provider_get_type ())
#define VALA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_PROVIDER, ValaProvider))
#define VALA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_PROVIDER, ValaProviderClass))
#define IS_VALA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_PROVIDER))
#define IS_VALA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_PROVIDER))
#define VALA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_PROVIDER, ValaProviderClass))

typedef struct _ValaProvider ValaProvider;
typedef struct _ValaProviderClass ValaProviderClass;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free_vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_vala_code_node_unref (var), NULL)))

struct _ValaPlugin {
	AnjutaPlugin parent_instance;
	ValaPluginPrivate * priv;
	IAnjutaEditor* current_editor;
};

struct _ValaPluginClass {
	AnjutaPluginClass parent_class;
};

struct _ValaPluginPrivate {
	guint editor_watch_id;
	ValaCodeContext* context;
	GStaticRecMutex __lock_context;
	ValaMap* source_files;
	BlockLocator* locator;
	AnjutaReport* report;
	ValaProvider* provider;
	ValaParser* parser;
	ValaGenieParser* genie_parser;
	ValaSymbolResolver* resolver;
	ValaSemanticAnalyzer* analyzer;
};


static gpointer vala_plugin_parent_class = NULL;
static GType vala_plugin_type_id = 0;

GType vala_plugin_get_type (void) G_GNUC_CONST;
GType vala_plugin_register_type (GTypeModule * module);
GType block_locator_get_type (void) G_GNUC_CONST;
GType block_locator_register_type (GTypeModule * module);
GType anjuta_report_get_type (void) G_GNUC_CONST;
GType anjuta_report_register_type (GTypeModule * module);
GType vala_provider_get_type (void) G_GNUC_CONST;
GType vala_provider_register_type (GTypeModule * module);
#define VALA_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VALA_PLUGIN, ValaPluginPrivate))
enum  {
	VALA_PLUGIN_DUMMY_PROPERTY
};
BlockLocator* block_locator_new (void);
BlockLocator* block_locator_construct (GType object_type);
AnjutaReport* anjuta_report_new (void);
AnjutaReport* anjuta_report_construct (GType object_type);
void anjuta_report_set_docman (AnjutaReport* self, IAnjutaDocumentManager* value);
gboolean add_package (ValaCodeContext* context, const char* pkg);
gboolean anjuta_report_errors_found (AnjutaReport* self);
static void* _lambda0_ (ValaPlugin* self);
static void* __lambda0__gthread_func (gpointer self);
ValaProvider* vala_provider_new (ValaPlugin* plugin);
ValaProvider* vala_provider_construct (GType object_type, ValaPlugin* plugin);
void vala_plugin_editor_value_added (ValaPlugin* self, const char* name, GValue* value);
void vala_plugin_editor_value_removed (ValaPlugin* self, const char* name);
static gboolean vala_plugin_real_activate (AnjutaPlugin* base);
static gboolean vala_plugin_real_deactivate (AnjutaPlugin* base);
void vala_plugin_on_char_added (ValaPlugin* self, IAnjutaEditorTip* editor, GObject* position, gchar ch);
static void _vala_plugin_on_char_added_ianjuta_editor_char_added (IAnjutaEditorTip* _sender, GObject* position, gchar ch, gpointer self);
void anjuta_report_on_hover_over (AnjutaReport* self, IAnjutaEditorHover* editor, GObject* pos);
static void _anjuta_report_on_hover_over_ianjuta_editor_hover_hover_over (IAnjutaEditorHover* _sender, GObject* position, gpointer self);
static void vala_plugin_update_file (ValaPlugin* self, ValaSourceFile* file);
static void _lambda1_ (IAnjutaFileSavable* savable, GObject* gfile, ValaPlugin* self);
static void __lambda1__ianjuta_file_savable_saved (IAnjutaFileSavable* _sender, GObject* file, gpointer self);
void anjuta_report_update_errors (AnjutaReport* self, IAnjutaEditor* editor);
void vala_provider_show_call_tip (ValaProvider* self, IAnjutaEditorTip* editor, const char* to_complete);
ValaBlock* block_locator_locate (BlockLocator* self, ValaSourceFile* file, gint line, gint column);
ValaBlock* vala_plugin_get_current_block (ValaPlugin* self, IAnjutaEditor* editor);
static GList* vala_plugin_symbol_lookup_inherited (ValaPlugin* self, ValaSymbol* sym, const char* name, gboolean prefix_match, gboolean invocation);
GList* vala_plugin_lookup_symbol (ValaPlugin* self, ValaExpression* inner, const char* name, gboolean prefix_match, ValaBlock* block);
static void _g_list_free_vala_code_node_unref (GList* self);
void anjuta_report_clear_error_indicators (AnjutaReport* self);
ValaPlugin* vala_plugin_new (void);
ValaPlugin* vala_plugin_construct (GType object_type);
static void vala_plugin_finalize (GObject* obj);
GType anjuta_glue_register_components (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void* _lambda0_ (ValaPlugin* self) {
	void* result = NULL;
	GError * _inner_error_;
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		{
			ValaReport* _tmp0_;
			AnjutaReport* report;
			ValaParser* _tmp1_;
			ValaGenieParser* _tmp2_;
			ValaSymbolResolver* _tmp3_;
			ValaSemanticAnalyzer* _tmp4_;
			vala_code_context_push (self->priv->context);
			report = _g_object_ref0 ((_tmp0_ = vala_code_context_get_report (self->priv->context), IS_ANJUTA_REPORT (_tmp0_) ? ((AnjutaReport*) _tmp0_) : NULL));
			self->priv->parser = (_tmp1_ = vala_parser_new (), _vala_code_visitor_unref0 (self->priv->parser), _tmp1_);
			self->priv->genie_parser = (_tmp2_ = vala_genie_parser_new (), _vala_code_visitor_unref0 (self->priv->genie_parser), _tmp2_);
			self->priv->resolver = (_tmp3_ = vala_symbol_resolver_new (), _vala_code_visitor_unref0 (self->priv->resolver), _tmp3_);
			self->priv->analyzer = (_tmp4_ = vala_semantic_analyzer_new (), _vala_code_visitor_unref0 (self->priv->analyzer), _tmp4_);
			vala_parser_parse (self->priv->parser, self->priv->context);
			vala_genie_parser_parse (self->priv->genie_parser, self->priv->context);
			if (anjuta_report_errors_found (report)) {
				result = NULL;
				{
					g_static_rec_mutex_unlock (&self->priv->__lock_context);
				}
				_g_object_unref0 (report);
				return result;
			}
			vala_symbol_resolver_resolve (self->priv->resolver, self->priv->context);
			if (anjuta_report_errors_found (report)) {
				result = NULL;
				{
					g_static_rec_mutex_unlock (&self->priv->__lock_context);
				}
				_g_object_unref0 (report);
				return result;
			}
			vala_semantic_analyzer_analyze (self->priv->analyzer, self->priv->context);
			vala_code_context_pop ();
			_g_object_unref0 (report);
		}
		__finally0:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


static void* __lambda0__gthread_func (gpointer self) {
	void* result;
	result = _lambda0_ (self);
	return result;
}


static gboolean vala_plugin_real_activate (AnjutaPlugin* base) {
	ValaPlugin * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	ValaCodeContext* _tmp0_;
	AnjutaReport* _tmp1_;
	AnjutaShell* _tmp3_;
	AnjutaShell* _tmp2_ = NULL;
	GObject* _tmp4_;
	GObject* _tmp5_;
	AnjutaShell* _tmp7_;
	AnjutaShell* _tmp6_ = NULL;
	GObject* _tmp8_;
	GObject* _tmp9_;
	IAnjutaProjectManager* project;
	GList* packages;
	AnjutaShell* _tmp11_;
	AnjutaShell* _tmp10_ = NULL;
	AnjutaStatus* _tmp12_;
	AnjutaStatus* status;
	ValaMap* _tmp13_;
	GList* sources;
	GThreadFunc _tmp32_;
	GDestroyNotify parse_target_destroy_notify = NULL;
	void* parse_target = NULL;
	GThreadFunc parse;
	ValaProvider* _tmp33_;
	self = (ValaPlugin*) base;
	_inner_error_ = NULL;
	self->priv->context = (_tmp0_ = vala_code_context_new (), _vala_code_context_unref0 (self->priv->context), _tmp0_);
	self->priv->report = (_tmp1_ = anjuta_report_new (), _g_object_unref0 (self->priv->report), _tmp1_);
	_tmp5_ = (_tmp4_ = anjuta_shell_get_object (_tmp3_ = (g_object_get ((AnjutaPlugin*) self, "shell", &_tmp2_, NULL), _tmp2_), "IAnjutaDocumentManager", &_inner_error_), _g_object_unref0 (_tmp3_), _tmp4_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	anjuta_report_set_docman (self->priv->report, IANJUTA_DOCUMENT_MANAGER (_tmp5_));
	vala_code_context_set_report (self->priv->context, (ValaReport*) self->priv->report);
	vala_code_context_set_profile (self->priv->context, VALA_PROFILE_GOBJECT);
	_tmp9_ = (_tmp8_ = anjuta_shell_get_object (_tmp7_ = (g_object_get ((AnjutaPlugin*) self, "shell", &_tmp6_, NULL), _tmp6_), "IAnjutaProjectManager", &_inner_error_), _g_object_unref0 (_tmp7_), _tmp8_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	project = _g_object_ref0 (IANJUTA_PROJECT_MANAGER (_tmp9_));
	packages = ianjuta_project_manager_get_packages (project, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	add_package (self->priv->context, "glib-2.0");
	add_package (self->priv->context, "gobject-2.0");
	status = (_tmp12_ = _g_object_ref0 (anjuta_shell_get_status (_tmp11_ = (g_object_get ((AnjutaPlugin*) self, "shell", &_tmp10_, NULL), _tmp10_), &_inner_error_)), _g_object_unref0 (_tmp11_), _tmp12_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	{
		GList* pkg_collection;
		GList* pkg_it;
		pkg_collection = packages;
		for (pkg_it = pkg_collection; pkg_it != NULL; pkg_it = pkg_it->next) {
			char* pkg;
			pkg = g_strdup ((const char*) pkg_it->data);
			{
				if (!add_package (self->priv->context, pkg)) {
					anjuta_status_set (status, "Package %s not found", pkg, NULL);
				}
				_g_free0 (pkg);
			}
		}
	}
	self->priv->source_files = (_tmp13_ = (ValaMap*) vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, VALA_TYPE_SOURCE_FILE, (GBoxedCopyFunc) vala_source_file_ref, vala_source_file_unref, g_str_hash, g_str_equal, g_direct_equal), _vala_collection_object_unref0 (self->priv->source_files), _tmp13_);
	sources = ianjuta_project_manager_get_elements (project, ANJUTA_PROJECT_SOURCE, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (status);
		_g_object_unref0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	{
		GList* src_collection;
		GList* src_it;
		src_collection = sources;
		for (src_it = src_collection; src_it != NULL; src_it = src_it->next) {
			GFile* src;
			src = _g_object_ref0 ((GFile*) src_it->data);
			{
				gboolean _tmp14_ = FALSE;
				char* _tmp15_;
				gboolean _tmp16_;
				if ((_tmp16_ = (_tmp15_ = g_file_get_path (src)) != NULL, _g_free0 (_tmp15_), _tmp16_)) {
					char* _tmp17_;
					_tmp14_ = !vala_map_contains (self->priv->source_files, _tmp17_ = g_file_get_path (src));
					_g_free0 (_tmp17_);
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					gboolean _tmp18_ = FALSE;
					char* _tmp19_;
					gboolean _tmp20_;
					if ((_tmp20_ = g_str_has_suffix (_tmp19_ = g_file_get_basename (src), "vala"), _g_free0 (_tmp19_), _tmp20_)) {
						_tmp18_ = TRUE;
					} else {
						char* _tmp21_;
						_tmp18_ = g_str_has_suffix (_tmp21_ = g_file_get_basename (src), "gs");
						_g_free0 (_tmp21_);
					}
					if (_tmp18_) {
						char* _tmp22_;
						ValaSourceFile* _tmp23_;
						ValaSourceFile* vsrc;
						ValaUnresolvedSymbol* _tmp24_;
						ValaUsingDirective* _tmp25_;
						ValaUsingDirective* ns_ref;
						char* _tmp26_;
						vsrc = (_tmp23_ = vala_source_file_new (self->priv->context, _tmp22_ = g_file_get_path (src), FALSE, NULL), _g_free0 (_tmp22_), _tmp23_);
						vala_code_context_add_source_file (self->priv->context, vsrc);
						ns_ref = (_tmp25_ = vala_using_directive_new ((ValaSymbol*) (_tmp24_ = vala_unresolved_symbol_new (NULL, "GLib", NULL)), NULL), _vala_code_node_unref0 (_tmp24_), _tmp25_);
						vala_source_file_add_using_directive (vsrc, ns_ref);
						vala_namespace_add_using_directive (vala_code_context_get_root (self->priv->context), ns_ref);
						vala_map_set (self->priv->source_files, _tmp26_ = g_file_get_path (src), vsrc);
						_g_free0 (_tmp26_);
						_vala_code_node_unref0 (ns_ref);
						_vala_source_file_unref0 (vsrc);
					} else {
						char* _tmp27_;
						gboolean _tmp28_;
						if ((_tmp28_ = g_str_has_suffix (_tmp27_ = g_file_get_basename (src), "vapi"), _g_free0 (_tmp27_), _tmp28_)) {
							char* _tmp29_;
							ValaSourceFile* _tmp30_;
							ValaSourceFile* vsrc;
							char* _tmp31_;
							vsrc = (_tmp30_ = vala_source_file_new (self->priv->context, _tmp29_ = g_file_get_path (src), TRUE, NULL), _g_free0 (_tmp29_), _tmp30_);
							vala_code_context_add_source_file (self->priv->context, vsrc);
							vala_map_set (self->priv->source_files, _tmp31_ = g_file_get_path (src), vsrc);
							_g_free0 (_tmp31_);
							_vala_source_file_unref0 (vsrc);
						}
					}
				}
				_g_object_unref0 (src);
			}
		}
	}
	parse = (_tmp32_ = __lambda0__gthread_func, parse_target = g_object_ref (self), parse_target_destroy_notify = g_object_unref, _tmp32_);
	{
		g_thread_create (parse, parse_target, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch1_g_thread_error;
			}
			(parse_target_destroy_notify == NULL) ? NULL : (parse_target_destroy_notify (parse_target), NULL);
			parse = NULL;
			parse_target = NULL;
			parse_target_destroy_notify = NULL;
			_g_object_unref0 (status);
			_g_object_unref0 (project);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		g_debug ("plugin.vala:103: Using threads");
	}
	goto __finally1;
	__catch1_g_thread_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			parse (parse_target);
			_g_error_free0 (err);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		(parse_target_destroy_notify == NULL) ? NULL : (parse_target_destroy_notify (parse_target), NULL);
		parse = NULL;
		parse_target = NULL;
		parse_target_destroy_notify = NULL;
		_g_object_unref0 (status);
		_g_object_unref0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	self->priv->provider = (_tmp33_ = vala_provider_new (self), _g_object_unref0 (self->priv->provider), _tmp33_);
	self->priv->editor_watch_id = anjuta_plugin_add_watch ((AnjutaPlugin*) self, "document_manager_current_document", (AnjutaPluginValueAdded) vala_plugin_editor_value_added, (AnjutaPluginValueRemoved) vala_plugin_editor_value_removed, NULL);
	result = TRUE;
	(parse_target_destroy_notify == NULL) ? NULL : (parse_target_destroy_notify (parse_target), NULL);
	parse = NULL;
	parse_target = NULL;
	parse_target_destroy_notify = NULL;
	_g_object_unref0 (status);
	_g_object_unref0 (project);
	return result;
}


static gboolean vala_plugin_real_deactivate (AnjutaPlugin* base) {
	ValaPlugin * self;
	gboolean result = FALSE;
	ValaCodeContext* _tmp0_;
	ValaMap* _tmp1_;
	self = (ValaPlugin*) base;
	anjuta_plugin_remove_watch ((AnjutaPlugin*) self, self->priv->editor_watch_id, TRUE);
	self->priv->context = (_tmp0_ = NULL, _vala_code_context_unref0 (self->priv->context), _tmp0_);
	self->priv->source_files = (_tmp1_ = NULL, _vala_collection_object_unref0 (self->priv->source_files), _tmp1_);
	result = TRUE;
	return result;
}


static void _vala_plugin_on_char_added_ianjuta_editor_char_added (IAnjutaEditorTip* _sender, GObject* position, gchar ch, gpointer self) {
	vala_plugin_on_char_added (self, _sender, position, ch);
}


static void _anjuta_report_on_hover_over_ianjuta_editor_hover_hover_over (IAnjutaEditorHover* _sender, GObject* position, gpointer self) {
	anjuta_report_on_hover_over (self, _sender, position);
}


static void _lambda1_ (IAnjutaFileSavable* savable, GObject* gfile, ValaPlugin* self) {
	GError * _inner_error_;
	GFile* file;
	char* _tmp0_;
	ValaSourceFile* _tmp1_;
	ValaSourceFile* source_file;
	char* contents;
	g_return_if_fail (savable != NULL);
	g_return_if_fail (gfile != NULL);
	_inner_error_ = NULL;
	file = _g_object_ref0 (G_FILE (gfile));
	source_file = (_tmp1_ = (ValaSourceFile*) vala_map_get (self->priv->source_files, _tmp0_ = g_file_get_path (file)), _g_free0 (_tmp0_), _tmp1_);
	contents = NULL;
	{
		char* _tmp3_;
		char* _tmp2_ = NULL;
		g_file_load_contents (file, NULL, &_tmp2_, NULL, NULL, &_inner_error_);
		contents = (_tmp3_ = _tmp2_, _g_free0 (contents), _tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		_vala_source_file_unref0 (source_file);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	vala_source_file_set_content (source_file, contents);
	vala_plugin_update_file (self, source_file);
	_g_free0 (contents);
	_vala_source_file_unref0 (source_file);
	_g_object_unref0 (file);
}


static void __lambda1__ianjuta_file_savable_saved (IAnjutaFileSavable* _sender, GObject* file, gpointer self) {
	_lambda1_ (_sender, file, self);
}


void vala_plugin_editor_value_added (ValaPlugin* self, const char* name, GValue* value) {
	GError * _inner_error_;
	GObject* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_inner_error_ = NULL;
	g_assert (self->current_editor == NULL);
	g_assert (IANJUTA_IS_EDITOR (g_value_get_object (value)));
	self->current_editor = (_tmp0_ = g_value_get_object (value), IANJUTA_IS_EDITOR (_tmp0_) ? ((IAnjutaEditor*) _tmp0_) : NULL);
	if (self->current_editor != NULL) {
		if (IANJUTA_IS_EDITOR_ASSIST (self->current_editor)) {
			IAnjutaEditor* _tmp1_;
			ianjuta_editor_assist_add ((_tmp1_ = self->current_editor, IANJUTA_IS_EDITOR_ASSIST (_tmp1_) ? ((IAnjutaEditorAssist*) _tmp1_) : NULL), (IAnjutaProvider*) self->priv->provider, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (IANJUTA_IS_EDITOR_TIP (self->current_editor)) {
			IAnjutaEditor* _tmp2_;
			g_signal_connect_object ((IAnjutaEditor*) (_tmp2_ = self->current_editor, IANJUTA_IS_EDITOR_TIP (_tmp2_) ? ((IAnjutaEditorTip*) _tmp2_) : NULL), "char-added", (GCallback) _vala_plugin_on_char_added_ianjuta_editor_char_added, self, 0);
		}
		if (IANJUTA_IS_EDITOR_HOVER (self->current_editor)) {
			IAnjutaEditor* _tmp3_;
			g_signal_connect_object ((_tmp3_ = self->current_editor, IANJUTA_IS_EDITOR_HOVER (_tmp3_) ? ((IAnjutaEditorHover*) _tmp3_) : NULL), "hover-over", (GCallback) _anjuta_report_on_hover_over_ianjuta_editor_hover_hover_over, self->priv->report, 0);
		}
		if (IANJUTA_IS_FILE_SAVABLE (self->current_editor)) {
			IAnjutaFileSavable* file_savable;
			file_savable = _g_object_ref0 (IANJUTA_FILE_SAVABLE (self->current_editor));
			g_signal_connect_object (file_savable, "saved", (GCallback) __lambda1__ianjuta_file_savable_saved, self, 0);
			_g_object_unref0 (file_savable);
		}
	}
	anjuta_report_update_errors (self->priv->report, self->current_editor);
}


void vala_plugin_editor_value_removed (ValaPlugin* self, const char* name) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_inner_error_ = NULL;
	if (IANJUTA_IS_EDITOR_ASSIST (self->current_editor)) {
		IAnjutaEditor* _tmp0_;
		ianjuta_editor_assist_remove ((_tmp0_ = self->current_editor, IANJUTA_IS_EDITOR_ASSIST (_tmp0_) ? ((IAnjutaEditorAssist*) _tmp0_) : NULL), (IAnjutaProvider*) self->priv->provider, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (IANJUTA_IS_EDITOR_TIP (self->current_editor)) {
		guint _tmp2_;
		IAnjutaEditor* _tmp1_;
		g_signal_parse_name ("char-added", IANJUTA_TYPE_EDITOR, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((IAnjutaEditor*) (_tmp1_ = self->current_editor, IANJUTA_IS_EDITOR_TIP (_tmp1_) ? ((IAnjutaEditorTip*) _tmp1_) : NULL), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _vala_plugin_on_char_added_ianjuta_editor_char_added, self);
	}
	if (IANJUTA_IS_EDITOR_HOVER (self->current_editor)) {
		guint _tmp4_;
		IAnjutaEditor* _tmp3_;
		g_signal_parse_name ("hover-over", IANJUTA_TYPE_EDITOR_HOVER, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((_tmp3_ = self->current_editor, IANJUTA_IS_EDITOR_HOVER (_tmp3_) ? ((IAnjutaEditorHover*) _tmp3_) : NULL), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _anjuta_report_on_hover_over_ianjuta_editor_hover_hover_over, self->priv->report);
	}
	if (IANJUTA_IS_FILE_SAVABLE (self->current_editor)) {
		g_assert (g_signal_handlers_disconnect_matched (self->current_editor, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self) == 1);
	}
	self->current_editor = NULL;
}


void vala_plugin_on_char_added (ValaPlugin* self, IAnjutaEditorTip* editor, GObject* position, gchar ch) {
	GError * _inner_error_;
	IAnjutaIterable* current_position;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	g_return_if_fail (position != NULL);
	_inner_error_ = NULL;
	current_position = _g_object_ref0 (IANJUTA_ITERABLE (position));
	ianjuta_iterable_next (current_position, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (current_position);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (ch == '(') {
		gint _tmp0_;
		IAnjutaIterable* line_start;
		char* current_text;
		_tmp0_ = ianjuta_editor_get_lineno (self->current_editor, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (current_position);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		line_start = _g_object_ref0 (ianjuta_editor_get_line_begin_position ((IAnjutaEditor*) editor, _tmp0_, &_inner_error_));
		if (_inner_error_ != NULL) {
			_g_object_unref0 (current_position);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		current_text = g_strdup (ianjuta_editor_get_text ((IAnjutaEditor*) editor, line_start, current_position, &_inner_error_));
		if (_inner_error_ != NULL) {
			_g_object_unref0 (line_start);
			_g_object_unref0 (current_position);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		vala_provider_show_call_tip (self->priv->provider, editor, current_text);
		_g_free0 (current_text);
		_g_object_unref0 (line_start);
	} else {
		if (ch == ')') {
			ianjuta_editor_tip_cancel (editor, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (current_position);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_object_unref0 (current_position);
}


ValaBlock* vala_plugin_get_current_block (ValaPlugin* self, IAnjutaEditor* editor) {
	ValaBlock* result = NULL;
	GError * _inner_error_;
	IAnjutaEditor* _tmp0_;
	IAnjutaFile* file;
	GFile* _tmp1_;
	char* path;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (editor != NULL, NULL);
	_inner_error_ = NULL;
	g_return_val_if_fail (IANJUTA_IS_FILE (editor), NULL);
	file = _g_object_ref0 ((_tmp0_ = editor, IANJUTA_IS_FILE (_tmp0_) ? ((IAnjutaFile*) _tmp0_) : NULL));
	_tmp1_ = ianjuta_file_get_file (file, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	path = g_file_get_path (_tmp1_);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		{
			gint _tmp2_;
			gint _tmp3_;
			ValaSourceFile* _tmp4_;
			ValaBlock* _tmp5_;
			if (!vala_map_contains (self->priv->source_files, path)) {
				ValaSourceFile* src;
				src = vala_source_file_new (self->priv->context, path, g_str_has_suffix (path, "vapi"), NULL);
				vala_code_context_add_source_file (self->priv->context, src);
				vala_map_set (self->priv->source_files, path, src);
				vala_plugin_update_file (self, src);
				_vala_source_file_unref0 (src);
			}
			_tmp2_ = ianjuta_editor_get_lineno (editor, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __finally3;
			}
			_tmp3_ = ianjuta_editor_get_column (editor, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __finally3;
			}
			result = (_tmp5_ = block_locator_locate (self->priv->locator, _tmp4_ = (ValaSourceFile*) vala_map_get (self->priv->source_files, path), _tmp2_, _tmp3_), _vala_source_file_unref0 (_tmp4_), _tmp5_);
			{
				g_static_rec_mutex_unlock (&self->priv->__lock_context);
			}
			_g_free0 (path);
			_g_object_unref0 (file);
			return result;
		}
		__finally3:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
		}
		{
			_g_free0 (path);
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_free0 (path);
	_g_object_unref0 (file);
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void _g_list_free_vala_code_node_unref (GList* self) {
	g_list_foreach (self, (GFunc) vala_code_node_unref, NULL);
	g_list_free (self);
}


GList* vala_plugin_lookup_symbol (ValaPlugin* self, ValaExpression* inner, const char* name, gboolean prefix_match, ValaBlock* block) {
	GList* result = NULL;
	GError * _inner_error_;
	GList* matching_symbols;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (block != NULL, NULL);
	_inner_error_ = NULL;
	matching_symbols = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		{
			if (inner == NULL) {
				{
					ValaSymbol* sym;
					sym = _vala_code_node_ref0 (VALA_SYMBOL (block));
					{
						gboolean _tmp0_;
						_tmp0_ = TRUE;
						while (TRUE) {
							if (!_tmp0_) {
								ValaSymbol* _tmp1_;
								sym = (_tmp1_ = _vala_code_node_ref0 (vala_symbol_get_parent_symbol (sym)), _vala_code_node_unref0 (sym), _tmp1_);
							}
							_tmp0_ = FALSE;
							if (!(sym != NULL)) {
								break;
							}
							matching_symbols = g_list_concat (matching_symbols, vala_plugin_symbol_lookup_inherited (self, sym, name, prefix_match, FALSE));
						}
					}
					_vala_code_node_unref0 (sym);
				}
				{
					ValaIterator* _ns_it;
					_ns_it = vala_iterable_iterator ((ValaIterable*) vala_source_file_get_current_using_directives (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) block))));
					while (TRUE) {
						ValaUsingDirective* ns;
						if (!vala_iterator_next (_ns_it)) {
							break;
						}
						ns = (ValaUsingDirective*) vala_iterator_get (_ns_it);
						matching_symbols = g_list_concat (matching_symbols, vala_plugin_symbol_lookup_inherited (self, vala_using_directive_get_namespace_symbol (ns), name, prefix_match, FALSE));
						_vala_code_node_unref0 (ns);
					}
					_vala_collection_object_unref0 (_ns_it);
				}
			} else {
				if (vala_expression_get_symbol_reference (inner) != NULL) {
					matching_symbols = g_list_concat (matching_symbols, vala_plugin_symbol_lookup_inherited (self, vala_expression_get_symbol_reference (inner), name, prefix_match, FALSE));
				} else {
					if (VALA_IS_MEMBER_ACCESS (inner)) {
						ValaMemberAccess* inner_ma;
						GList* matching;
						inner_ma = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (inner));
						matching = vala_plugin_lookup_symbol (self, vala_member_access_get_inner (inner_ma), vala_member_access_get_member_name (inner_ma), FALSE, block);
						if (matching != NULL) {
							matching_symbols = g_list_concat (matching_symbols, vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) matching->data, name, prefix_match, FALSE));
						}
						__g_list_free_vala_code_node_unref0 (matching);
						_vala_code_node_unref0 (inner_ma);
					} else {
						if (VALA_IS_METHOD_CALL (inner)) {
							ValaMethodCall* inner_inv;
							ValaExpression* _tmp2_;
							ValaMemberAccess* inner_ma;
							inner_inv = _vala_code_node_ref0 (VALA_METHOD_CALL (inner));
							inner_ma = _vala_code_node_ref0 ((_tmp2_ = vala_method_call_get_call (inner_inv), VALA_IS_MEMBER_ACCESS (_tmp2_) ? ((ValaMemberAccess*) _tmp2_) : NULL));
							if (inner_ma != NULL) {
								GList* matching;
								matching = vala_plugin_lookup_symbol (self, vala_member_access_get_inner (inner_ma), vala_member_access_get_member_name (inner_ma), FALSE, block);
								if (matching != NULL) {
									matching_symbols = g_list_concat (matching_symbols, vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) matching->data, name, prefix_match, TRUE));
								}
								__g_list_free_vala_code_node_unref0 (matching);
							}
							_vala_code_node_unref0 (inner_ma);
							_vala_code_node_unref0 (inner_inv);
						}
					}
				}
			}
		}
		__finally4:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
		}
		if (_inner_error_ != NULL) {
			__g_list_free_vala_code_node_unref0 (matching_symbols);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = matching_symbols;
	return result;
}


static GList* vala_plugin_symbol_lookup_inherited (ValaPlugin* self, ValaSymbol* sym, const char* name, gboolean prefix_match, gboolean invocation) {
	GList* result = NULL;
	GList* _result_;
	ValaMap* symbol_table;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_result_ = NULL;
	if (sym == NULL) {
		result = _result_;
		return result;
	}
	symbol_table = vala_scope_get_symbol_table (vala_symbol_get_scope (sym));
	if (symbol_table != NULL) {
		{
			ValaSet* _tmp0_;
			ValaIterator* _tmp1_;
			ValaIterator* _key_it;
			_key_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vala_map_get_keys (symbol_table))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
			while (TRUE) {
				char* key;
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				if (!vala_iterator_next (_key_it)) {
					break;
				}
				key = (char*) vala_iterator_get (_key_it);
				if (prefix_match) {
					_tmp3_ = g_str_has_prefix (key, name);
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					_tmp2_ = TRUE;
				} else {
					_tmp2_ = _vala_strcmp0 (key, name) == 0;
				}
				if (_tmp2_) {
					_result_ = g_list_append (_result_, (ValaSymbol*) vala_map_get (symbol_table, key));
				}
				_g_free0 (key);
			}
			_vala_collection_object_unref0 (_key_it);
		}
	}
	if (invocation) {
		_tmp4_ = VALA_IS_METHOD (sym);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaMethod* func;
		func = _vala_code_node_ref0 (VALA_METHOD (sym));
		_result_ = g_list_concat (_result_, vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) vala_data_type_get_data_type (vala_method_get_return_type (func)), name, prefix_match, FALSE));
		_vala_code_node_unref0 (func);
	} else {
		if (VALA_IS_CLASS (sym)) {
			ValaClass* cl;
			cl = _vala_code_node_ref0 (VALA_CLASS (sym));
			{
				ValaList* _tmp5_;
				ValaIterator* _tmp6_;
				ValaIterator* _base_type_it;
				_base_type_it = (_tmp6_ = vala_iterable_iterator ((ValaIterable*) (_tmp5_ = vala_class_get_base_types (cl))), _vala_collection_object_unref0 (_tmp5_), _tmp6_);
				while (TRUE) {
					ValaDataType* base_type;
					if (!vala_iterator_next (_base_type_it)) {
						break;
					}
					base_type = (ValaDataType*) vala_iterator_get (_base_type_it);
					_result_ = g_list_concat (_result_, vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) vala_data_type_get_data_type (base_type), name, prefix_match, FALSE));
					_vala_code_node_unref0 (base_type);
				}
				_vala_collection_object_unref0 (_base_type_it);
			}
			_vala_code_node_unref0 (cl);
		} else {
			if (VALA_IS_STRUCT (sym)) {
				ValaStruct* st;
				st = _vala_code_node_ref0 (VALA_STRUCT (sym));
				_result_ = g_list_concat (_result_, vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) vala_data_type_get_data_type (vala_struct_get_base_type (st)), name, prefix_match, FALSE));
				_vala_code_node_unref0 (st);
			} else {
				if (VALA_IS_INTERFACE (sym)) {
					ValaInterface* iface;
					iface = _vala_code_node_ref0 (VALA_INTERFACE (sym));
					{
						ValaList* _tmp7_;
						ValaIterator* _tmp8_;
						ValaIterator* _prerequisite_it;
						_prerequisite_it = (_tmp8_ = vala_iterable_iterator ((ValaIterable*) (_tmp7_ = vala_interface_get_prerequisites (iface))), _vala_collection_object_unref0 (_tmp7_), _tmp8_);
						while (TRUE) {
							ValaDataType* prerequisite;
							if (!vala_iterator_next (_prerequisite_it)) {
								break;
							}
							prerequisite = (ValaDataType*) vala_iterator_get (_prerequisite_it);
							_result_ = g_list_concat (_result_, vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) vala_data_type_get_data_type (prerequisite), name, prefix_match, FALSE));
							_vala_code_node_unref0 (prerequisite);
						}
						_vala_collection_object_unref0 (_prerequisite_it);
					}
					_vala_code_node_unref0 (iface);
				} else {
					if (VALA_IS_LOCAL_VARIABLE (sym)) {
						ValaLocalVariable* variable;
						variable = _vala_code_node_ref0 (VALA_LOCAL_VARIABLE (sym));
						_result_ = g_list_concat (_result_, vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) vala_data_type_get_data_type (vala_variable_get_variable_type ((ValaVariable*) variable)), name, prefix_match, FALSE));
						_vala_code_node_unref0 (variable);
					} else {
						if (VALA_IS_FIELD (sym)) {
							ValaField* field;
							field = _vala_code_node_ref0 (VALA_FIELD (sym));
							_result_ = g_list_concat (_result_, vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) vala_data_type_get_data_type (vala_variable_get_variable_type ((ValaVariable*) field)), name, prefix_match, FALSE));
							_vala_code_node_unref0 (field);
						} else {
							if (VALA_IS_PROPERTY (sym)) {
								ValaProperty* prop;
								prop = _vala_code_node_ref0 (VALA_PROPERTY (sym));
								_result_ = g_list_concat (_result_, vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) vala_data_type_get_data_type (vala_property_get_property_type (prop)), name, prefix_match, FALSE));
								_vala_code_node_unref0 (prop);
							} else {
								if (VALA_IS_FORMAL_PARAMETER (sym)) {
									ValaFormalParameter* fp;
									fp = _vala_code_node_ref0 (VALA_FORMAL_PARAMETER (sym));
									_result_ = g_list_concat (_result_, vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) vala_data_type_get_data_type (vala_variable_get_variable_type ((ValaVariable*) fp)), name, prefix_match, FALSE));
									_vala_code_node_unref0 (fp);
								}
							}
						}
					}
				}
			}
		}
	}
	result = _result_;
	_vala_collection_object_unref0 (symbol_table);
	return result;
}


static void vala_plugin_update_file (ValaPlugin* self, ValaSourceFile* file) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		{
			ValaArrayList* nodes;
			ValaArrayList* _tmp2_;
			ValaUnresolvedSymbol* _tmp3_;
			ValaUsingDirective* _tmp4_;
			ValaUsingDirective* ns_ref;
			nodes = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
			{
				ValaList* _tmp0_;
				ValaIterator* _tmp1_;
				ValaIterator* _node_it;
				_node_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vala_source_file_get_nodes (file))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
				while (TRUE) {
					ValaCodeNode* node;
					if (!vala_iterator_next (_node_it)) {
						break;
					}
					node = (ValaCodeNode*) vala_iterator_get (_node_it);
					vala_collection_add ((ValaCollection*) nodes, node);
					_vala_code_node_unref0 (node);
				}
				_vala_collection_object_unref0 (_node_it);
			}
			{
				ValaIterator* _node_it;
				_node_it = vala_iterable_iterator ((ValaIterable*) nodes);
				while (TRUE) {
					ValaCodeNode* node;
					if (!vala_iterator_next (_node_it)) {
						break;
					}
					node = (ValaCodeNode*) vala_iterator_get (_node_it);
					vala_source_file_remove_node (file, node);
					if (VALA_IS_SYMBOL (node)) {
						ValaSymbol* sym;
						sym = _vala_code_node_ref0 (VALA_SYMBOL (node));
						if (vala_symbol_get_owner (sym) != NULL) {
							vala_scope_remove (vala_symbol_get_owner (sym), vala_symbol_get_name (sym));
						}
						if (VALA_SYMBOL (vala_code_context_get_entry_point (self->priv->context)) == sym) {
							vala_code_context_set_entry_point (self->priv->context, NULL);
						}
						_vala_code_node_unref0 (sym);
					}
					_vala_code_node_unref0 (node);
				}
				_vala_collection_object_unref0 (_node_it);
			}
			vala_source_file_set_current_using_directives (file, (ValaList*) (_tmp2_ = vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal)));
			_vala_collection_object_unref0 (_tmp2_);
			ns_ref = (_tmp4_ = vala_using_directive_new ((ValaSymbol*) (_tmp3_ = vala_unresolved_symbol_new (NULL, "GLib", NULL)), NULL), _vala_code_node_unref0 (_tmp3_), _tmp4_);
			vala_source_file_add_using_directive (file, ns_ref);
			vala_namespace_add_using_directive (vala_code_context_get_root (self->priv->context), ns_ref);
			anjuta_report_clear_error_indicators (self->priv->report);
			vala_code_context_push (self->priv->context);
			vala_code_visitor_visit_source_file ((ValaCodeVisitor*) self->priv->parser, file);
			vala_code_visitor_visit_source_file ((ValaCodeVisitor*) self->priv->genie_parser, file);
			if (!anjuta_report_errors_found (self->priv->report)) {
				vala_symbol_resolver_resolve (self->priv->resolver, self->priv->context);
				if (!anjuta_report_errors_found (self->priv->report)) {
					vala_code_visitor_visit_source_file ((ValaCodeVisitor*) self->priv->analyzer, file);
				}
			}
			vala_code_context_pop ();
			anjuta_report_update_errors (self->priv->report, self->current_editor);
			_vala_code_node_unref0 (ns_ref);
			_vala_collection_object_unref0 (nodes);
		}
		__finally5:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


ValaPlugin* vala_plugin_construct (GType object_type) {
	ValaPlugin * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


ValaPlugin* vala_plugin_new (void) {
	return vala_plugin_construct (TYPE_VALA_PLUGIN);
}


static void vala_plugin_class_init (ValaPluginClass * klass) {
	vala_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaPluginPrivate));
	ANJUTA_PLUGIN_CLASS (klass)->activate = vala_plugin_real_activate;
	ANJUTA_PLUGIN_CLASS (klass)->deactivate = vala_plugin_real_deactivate;
	G_OBJECT_CLASS (klass)->finalize = vala_plugin_finalize;
}


static void vala_plugin_instance_init (ValaPlugin * self) {
	self->priv = VALA_PLUGIN_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_context);
	self->priv->locator = block_locator_new ();
}


static void vala_plugin_finalize (GObject* obj) {
	ValaPlugin * self;
	self = VALA_PLUGIN (obj);
	g_static_rec_mutex_free (&self->priv->__lock_context);
	_vala_code_context_unref0 (self->priv->context);
	_vala_collection_object_unref0 (self->priv->source_files);
	_vala_code_visitor_unref0 (self->priv->locator);
	_g_object_unref0 (self->priv->report);
	_g_object_unref0 (self->priv->provider);
	_vala_code_visitor_unref0 (self->priv->parser);
	_vala_code_visitor_unref0 (self->priv->genie_parser);
	_vala_code_visitor_unref0 (self->priv->resolver);
	_vala_code_visitor_unref0 (self->priv->analyzer);
	G_OBJECT_CLASS (vala_plugin_parent_class)->finalize (obj);
}


GType vala_plugin_get_type (void) {
	return vala_plugin_type_id;
}


GType vala_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ValaPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPlugin), 0, (GInstanceInitFunc) vala_plugin_instance_init, NULL };
	vala_plugin_type_id = g_type_module_register_type (module, ANJUTA_TYPE_PLUGIN, "ValaPlugin", &g_define_type_info, 0);
	return vala_plugin_type_id;
}


gboolean add_package (ValaCodeContext* context, const char* pkg) {
	gboolean result = FALSE;
	GError * _inner_error_;
	gint _tmp1__length1;
	char** _tmp1_;
	char** _tmp0_ = NULL;
	char* _tmp2_;
	char* package_path;
	ValaSourceFile* _tmp3_;
	char* _tmp5_;
	char* _tmp4_;
	char* _tmp6_;
	char* deps_filename;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	_inner_error_ = NULL;
	if (vala_code_context_has_package (context, pkg)) {
		result = TRUE;
		return result;
	}
	package_path = (_tmp2_ = vala_code_context_get_package_path (context, pkg, (_tmp1_ = (_tmp0_ = g_new0 (char*, 0 + 1), _tmp0_), _tmp1__length1 = 0, _tmp1_), 0), _tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL), _tmp2_);
	if (package_path == NULL) {
		result = FALSE;
		_g_free0 (package_path);
		return result;
	}
	vala_code_context_add_package (context, pkg);
	vala_code_context_add_source_file (context, _tmp3_ = vala_source_file_new (context, package_path, TRUE, NULL));
	_vala_source_file_unref0 (_tmp3_);
	deps_filename = (_tmp6_ = g_build_filename (_tmp4_ = g_path_get_dirname (package_path), _tmp5_ = g_strdup_printf ("%s.deps", pkg), NULL), _g_free0 (_tmp5_), _g_free0 (_tmp4_), _tmp6_);
	if (g_file_test (deps_filename, G_FILE_TEST_EXISTS)) {
		{
			char* deps_content;
			gulong deps_len = 0UL;
			char* _tmp8_;
			char* _tmp7_ = NULL;
			deps_content = NULL;
			g_file_get_contents (deps_filename, &_tmp7_, &deps_len, &_inner_error_);
			deps_content = (_tmp8_ = _tmp7_, _g_free0 (deps_content), _tmp8_);
			if (_inner_error_ != NULL) {
				_g_free0 (deps_content);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch6_g_file_error;
				}
				_g_free0 (deps_content);
				_g_free0 (deps_filename);
				_g_free0 (package_path);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			{
				char** _tmp9_;
				char** dep_collection;
				int dep_collection_length1;
				int dep_it;
				dep_collection = _tmp9_ = g_strsplit (deps_content, "\n", 0);
				dep_collection_length1 = _vala_array_length (_tmp9_);
				for (dep_it = 0; dep_it < _vala_array_length (_tmp9_); dep_it = dep_it + 1) {
					char* dep;
					dep = g_strdup (dep_collection[dep_it]);
					{
						if (_vala_strcmp0 (dep, "") != 0) {
							if (!add_package (context, dep)) {
								char* _tmp10_;
								vala_report_err (vala_code_context_get_report (context), NULL, _tmp10_ = g_strdup_printf ("%s, dependency of %s, not found in specified Vala API directories", dep, pkg));
								_g_free0 (_tmp10_);
							}
						}
						_g_free0 (dep);
					}
				}
				dep_collection = (_vala_array_free (dep_collection, dep_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (deps_content);
		}
		goto __finally6;
		__catch6_g_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				char* _tmp11_;
				vala_report_err (vala_code_context_get_report (context), NULL, _tmp11_ = g_strdup_printf ("Unable to read dependency file: %s", e->message));
				_g_free0 (_tmp11_);
				_g_error_free0 (e);
			}
		}
		__finally6:
		if (_inner_error_ != NULL) {
			_g_free0 (deps_filename);
			_g_free0 (package_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_g_free0 (deps_filename);
	_g_free0 (package_path);
	return result;
}


GType anjuta_glue_register_components (GTypeModule* module) {
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	block_locator_register_type (module);
	vala_plugin_register_type (module);
	vala_provider_register_type (module);
	anjuta_report_register_type (module);
	result = TYPE_VALA_PLUGIN;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




