/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-file.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-file
 * @title: IAnjutaFile
 * @short_description: Implemented by plugins that can open files.
 * @see_also: #IAnjutaFileSavable
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-file.h
 * 
 * Any plugin that can open files should implemented this interface. Along
 * with the 'File Loader::SupportedMimeTypes' property of the plugin in
 * .plugin file, it will be used by the loader to open files of that type.
 */

#include "ianjuta-file.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_file_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-file-quark");
	}
	
	return quark;
}

/**
 * ianjuta_file_get_file:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Returns the file that was opened with ianjuta_file_open().
 *
 * Return value: The last file opened.
 */
GFile*
ianjuta_file_get_file (IAnjutaFile *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_FILE(obj), NULL);
	return IANJUTA_FILE_GET_IFACE (obj)->get_file (obj, err);
}

/* Default implementation */
static GFile*
ianjuta_file_get_file_default (IAnjutaFile *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_file_open:
 * @obj: Self
 * @file: file to open.
 * @err: Error propagation and reporting
 *
 * The implementor opens the given file.
 */
void
ianjuta_file_open (IAnjutaFile *obj, GFile* file, GError **err)
{
	g_return_if_fail (IANJUTA_IS_FILE(obj));
	IANJUTA_FILE_GET_IFACE (obj)->open (obj, file, err);
}

/* Default implementation */
static void
ianjuta_file_open_default (IAnjutaFile *obj, GFile* file, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_file_base_init (IAnjutaFileIface* klass)
{
	static gboolean initialized = FALSE;

	klass->get_file = ianjuta_file_get_file_default;
	klass->open = ianjuta_file_open_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_file_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaFileIface),
			(GBaseInitFunc) ianjuta_file_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaFile", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
