/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debugger.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-debugger
 * @title: IAnjutaDebugger
 * @short_description: Debugger interface
 * @see_also: #IAnjutaDebugManager
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-debugger.h
 *
 * This interface is implemented by debugger backends, by example the gdb
 * backend. It is used by the debug manager plugin which provides the
 * graphical interface and a simple wrapper: #IAnjutaDebugManager.
 *
 * The debugger is in one on these 5 states and emit a signal to the debug
 * manager when it changes. Here is figure showing all transitions and
 * the signal emitted. 
 * <figure id="debugger-states">
 *	<mediaobject>
 *		<imageobject>
 *			<imagedata fileref="debugger-states.png" format="PNG"/>
 *		</imageobject>
 *	</mediaobject>
 * </figure>
 * 
 */

#include "ianjuta-debugger.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_debugger_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-debugger-quark");
	}
	
	return quark;
}

/**
* ianjuta_debugger_abort:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Quit the debugger as fast as possible.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_abort (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->abort (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_abort_default (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_attach:
* @obj: Self
* @pid: pid of the process to debug
* @source_search_directories: List of directories to search for
*			      source files.
* @err: Error propagation and reporting.
* 
* Attach to an already running process.
*
* Returns: TRUE if sucessful, other FALSE.
*/
gboolean
ianjuta_debugger_attach (IAnjutaDebugger *obj, pid_t pid,  const GList* source_search_directories, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->attach (obj, pid, source_search_directories, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_attach_default (IAnjutaDebugger *obj, pid_t pid,  const GList* source_search_directories, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_callback:
* @obj: Self
* @callback: Callback to call
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* All commands are executed asynchronously and give back information
* with callbacks. It is difficult to know when a command is really
* executed. But as all commands are executed in order, you can use
* this command to get a call back when all previous commands have
* been executed.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_callback (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->callback (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_callback_default (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_connect:
* @obj: Self
* @server: remote server
* @args: command line argument of the program
* @terminal: TRUE if the program need a terminal
* @stop: TRUE if program is stopped at the beginning
* @err: Error propagation and reporting
*
* Connect to a remote debugger and run program
*
* Returns: TRUE if sucessfull, otherwise FALSE.
*/
gboolean
ianjuta_debugger_connect (IAnjutaDebugger *obj, const gchar *server,   const gchar *args,   gboolean terminal,   gboolean stop, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->connect (obj, server, args, terminal, stop, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_connect_default (IAnjutaDebugger *obj, const gchar *server,   const gchar *args,   gboolean terminal,   gboolean stop, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_disable_log:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Disable debugger log.
*/
void
ianjuta_debugger_disable_log (IAnjutaDebugger *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DEBUGGER(obj));
	IANJUTA_DEBUGGER_GET_IFACE (obj)->disable_log (obj, err);
}

/* Default implementation */
static void
ianjuta_debugger_disable_log_default (IAnjutaDebugger *obj, GError **err)
{
	g_return_if_reached ();
}

/**
* ianjuta_debugger_enable_log:
* @obj: Self
* @log: MessageView used by log
* @err: Error propagation and reporting.
* 
* Log all debuggers commands, mainly useful for debugging.
*/
void
ianjuta_debugger_enable_log (IAnjutaDebugger *obj, IAnjutaMessageView *log, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DEBUGGER(obj));
	g_return_if_fail ((log == NULL) ||IANJUTA_IS_MESSAGE_VIEW(log));
	IANJUTA_DEBUGGER_GET_IFACE (obj)->enable_log (obj, log, err);
}

/* Default implementation */
static void
ianjuta_debugger_enable_log_default (IAnjutaDebugger *obj, IAnjutaMessageView *log, GError **err)
{
	g_return_if_reached ();
}

/**
* ianjuta_debugger_evaluate:
* @obj: Self
* @name: variable name
* @value: new variable value
* @callback: Callback to call when the variable has been modified
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Change the value of a variable in the current program.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_evaluate (IAnjutaDebugger *obj, const gchar* name,   const gchar* value,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->evaluate (obj, name, value, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_evaluate_default (IAnjutaDebugger *obj, const gchar* name,   const gchar* value,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_exit:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Exit from the currently loaded program.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_exit (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->exit (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_exit_default (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_get_state:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Get the current state of the debugger
*
* Returns: The current debugger state.
*/
IAnjutaDebuggerState
ianjuta_debugger_get_state (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), 0);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->get_state (obj, err);
}

/* Default implementation */
static IAnjutaDebuggerState
ianjuta_debugger_get_state_default (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_reached (0);
}

/**
* ianjuta_debugger_handle_signal:
* @obj: Self
* @name: signal name
* @stop: TRUE if we need to stop signal
* @print: TRUE if we display a message when the signal is emitted
* @ignore: TRUE if we ignore the signal
* @err: Error propagation and reporting.
* 
* It defines how to handle signal received by the program.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_handle_signal (IAnjutaDebugger *obj, const gchar *name,   gboolean stop,   gboolean print,   gboolean ignore, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->handle_signal (obj, name, stop, print, ignore, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_handle_signal_default (IAnjutaDebugger *obj, const gchar *name,   gboolean stop,   gboolean print,   gboolean ignore, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_info_args:
* @obj: Self
* @callback: Callback to call getting a string with all information
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Get some informatin about a current functin arguments.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_info_args (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->info_args (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_info_args_default (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_info_frame:
* @obj: Self
* @frame: frame number, the top frame has the number 0
* @callback: Callback to call getting a string with all information
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Get some information about the one stack frame.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_info_frame (IAnjutaDebugger *obj, guint frame,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->info_frame (obj, frame, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_info_frame_default (IAnjutaDebugger *obj, guint frame,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_info_program:
* @obj: Self
* @callback: Callback to call getting a string with all information
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Get some informatin about a current program.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_info_program (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->info_program (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_info_program_default (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_info_sharedlib:
* @obj: Self
* @callback: Callback to call with list of arguments
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Get information about shared libraries.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_info_sharedlib (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->info_sharedlib (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_info_sharedlib_default (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_info_signal:
* @obj: Self
* @callback: Callback to call with list of arguments
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Get some informatin about a signal
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_info_signal (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->info_signal (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_info_signal_default (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_info_target:
* @obj: Self
* @callback: Callback to call getting a string with all information
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Get back some information about the target
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_info_target (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->info_target (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_info_target_default (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_info_thread:
* @obj: Self
* @thread: thread number
* @callback: Callback to call getting a string with all information
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Get some information about current threads.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_info_thread (IAnjutaDebugger *obj, gint thread,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->info_thread (obj, thread, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_info_thread_default (IAnjutaDebugger *obj, gint thread,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_info_udot:
* @obj: Self
* @callback: Callback to call getting a string with all information
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Get some informatin about OS structures.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_info_udot (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->info_udot (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_info_udot_default (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_info_variables:
* @obj: Self
* @callback: Callback to call getting a string with all information
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Get some informatin about variables.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_info_variables (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->info_variables (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_info_variables_default (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_inspect:
* @obj: Self
* @name: variable name
* @callback: Callback to call with variable value
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Get back the value of the named variable.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_inspect (IAnjutaDebugger *obj, const gchar* name,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->inspect (obj, name, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_inspect_default (IAnjutaDebugger *obj, const gchar* name,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_interrupt:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Interrupt the program currently running.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_interrupt (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->interrupt (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_interrupt_default (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_list_argument:
* @obj: Self
* @callback: Callback to call with list of arguments
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Get the list of arguments
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_list_argument (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->list_argument (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_list_argument_default (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_list_frame:
* @obj: Self
* @callback: Callback to call getting a list of frame
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Get the list of frames.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_list_frame (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->list_frame (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_list_frame_default (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_list_local:
* @obj: Self
* @callback: Callback to call with list of local variable
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Get the list of local variables
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_list_local (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->list_local (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_list_local_default (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_list_register:
* @obj: Self
* @callback: Callback to call getting a list of registers
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Get the list of registers.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_list_register (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->list_register (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_list_register_default (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_list_thread:
* @obj: Self
* @callback: Callback to call getting a list of thread
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Get the list of threads.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_list_thread (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->list_thread (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_list_thread_default (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_load:
* @obj: Self
* @file: filename
* @mime_type: mime type of the file
* @source_search_directories: List of directories to search for
*			      source files.
* @err: Error propagation and reporting.
* 
* Load a program in the debugger.
*
* Returns: TRUE if sucessful, other FALSE.
*/
gboolean
ianjuta_debugger_load (IAnjutaDebugger *obj, const gchar *file,   const gchar *mime_type,  const GList* source_search_directories, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->load (obj, file, mime_type, source_search_directories, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_load_default (IAnjutaDebugger *obj, const gchar *file,   const gchar *mime_type,  const GList* source_search_directories, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_print:
* @obj: Self
* @name: variable name
* @callback: Callback to call with variable value
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Display value of a variable, like inspect.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_print (IAnjutaDebugger *obj, const gchar *variable,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->print (obj, variable, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_print_default (IAnjutaDebugger *obj, const gchar *variable,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_quit:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Quit the debugger, can wait until the debugger is ready.
*
* Returns: TRUE if sucessful, other FALSE.
*/
gboolean
ianjuta_debugger_quit (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->quit (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_quit_default (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_run:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Run the program currently loaded.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_run (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->run (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_run_default (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_run_to:
* @obj: Self
* @file: target file name
* @line: target line in file
* @err: Error propagation and reporting.
* 
* Execute the currently loaded program until it reachs the target
* line.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_run_to (IAnjutaDebugger *obj, const gchar* file,   gint line, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->run_to (obj, file, line, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_run_to_default (IAnjutaDebugger *obj, const gchar* file,   gint line, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_send_command:
* @obj: Self
* @command: command
* @err: Error propagation and reporting.
* 
* Send a command directly to the debugger. Warning, changing the
* debugger states, by sending a run command by example, will
* probably gives some troubles in the debug manager.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_send_command (IAnjutaDebugger *obj, const gchar *command, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->send_command (obj, command, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_send_command_default (IAnjutaDebugger *obj, const gchar *command, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_set_environment:
* @obj: Self
* @env: List environment variable
* @err: Error propagation and reporting
*
* Set environment variable
*
* Returns: TRUE if sucessfull, other FALSE.
*/
gboolean
ianjuta_debugger_set_environment (IAnjutaDebugger *obj, gchar **env, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->set_environment (obj, env, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_set_environment_default (IAnjutaDebugger *obj, gchar **env, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_set_frame:
* @obj: Self
* @frame: frame number 
* @err: Error propagation and reporting.
* 
* Set the current frame.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_set_frame (IAnjutaDebugger *obj, guint frame, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->set_frame (obj, frame, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_set_frame_default (IAnjutaDebugger *obj, guint frame, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_set_thread:
* @obj: Self
* @thread: thread number
* @err: Error propagation and reporting.
* 
* Set the current thread.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_set_thread (IAnjutaDebugger *obj, gint thread, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->set_thread (obj, thread, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_set_thread_default (IAnjutaDebugger *obj, gint thread, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_set_working_directory:
* @obj: Self
* @dir: working program directory
* @err: Error propagation and reporting.
* 
* Set program working directory.
*
* Returns: TRUE if sucessful, other FALSE.
*/
gboolean
ianjuta_debugger_set_working_directory (IAnjutaDebugger *obj, const gchar *dir, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->set_working_directory (obj, dir, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_set_working_directory_default (IAnjutaDebugger *obj, const gchar *dir, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_start:
* @obj: Self
* @args: command line argument of the program
* @terminal: TRUE if the program need a terminal
* @stop: TRUE if program is stopped at the beginning
* @err: Error propagation and reporting.
* 
* Start a loaded program under debugger control.
*
* Returns: TRUE if sucessful, other FALSE.
*/
gboolean
ianjuta_debugger_start (IAnjutaDebugger *obj, const gchar *args,   gboolean terminal,   gboolean stop, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->start (obj, args, terminal, stop, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_start_default (IAnjutaDebugger *obj, const gchar *args,   gboolean terminal,   gboolean stop, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_step_in:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Execute a single C instruction of the program currently loaded.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_step_in (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->step_in (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_step_in_default (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_step_out:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Execute the currently loaded program until it goes out of the
* current procedure.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_step_out (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->step_out (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_step_out_default (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_step_over:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Execute one C instruction, without entering in procedure, of
* the program currently loaded.
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_debugger_step_over (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->step_over (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_step_over_default (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_unload:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Unload a program.
*
* Returns: TRUE if sucessfull, otherwise FALSE.
*/
gboolean
ianjuta_debugger_unload (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->unload (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_unload_default (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_debugger_base_init (IAnjutaDebuggerIface* klass)
{
	static gboolean initialized = FALSE;

	klass->abort = ianjuta_debugger_abort_default;
	klass->attach = ianjuta_debugger_attach_default;
	klass->callback = ianjuta_debugger_callback_default;
	klass->connect = ianjuta_debugger_connect_default;
	klass->disable_log = ianjuta_debugger_disable_log_default;
	klass->enable_log = ianjuta_debugger_enable_log_default;
	klass->evaluate = ianjuta_debugger_evaluate_default;
	klass->exit = ianjuta_debugger_exit_default;
	klass->get_state = ianjuta_debugger_get_state_default;
	klass->handle_signal = ianjuta_debugger_handle_signal_default;
	klass->info_args = ianjuta_debugger_info_args_default;
	klass->info_frame = ianjuta_debugger_info_frame_default;
	klass->info_program = ianjuta_debugger_info_program_default;
	klass->info_sharedlib = ianjuta_debugger_info_sharedlib_default;
	klass->info_signal = ianjuta_debugger_info_signal_default;
	klass->info_target = ianjuta_debugger_info_target_default;
	klass->info_thread = ianjuta_debugger_info_thread_default;
	klass->info_udot = ianjuta_debugger_info_udot_default;
	klass->info_variables = ianjuta_debugger_info_variables_default;
	klass->inspect = ianjuta_debugger_inspect_default;
	klass->interrupt = ianjuta_debugger_interrupt_default;
	klass->list_argument = ianjuta_debugger_list_argument_default;
	klass->list_frame = ianjuta_debugger_list_frame_default;
	klass->list_local = ianjuta_debugger_list_local_default;
	klass->list_register = ianjuta_debugger_list_register_default;
	klass->list_thread = ianjuta_debugger_list_thread_default;
	klass->load = ianjuta_debugger_load_default;
	klass->print = ianjuta_debugger_print_default;
	klass->quit = ianjuta_debugger_quit_default;
	klass->run = ianjuta_debugger_run_default;
	klass->run_to = ianjuta_debugger_run_to_default;
	klass->send_command = ianjuta_debugger_send_command_default;
	klass->set_environment = ianjuta_debugger_set_environment_default;
	klass->set_frame = ianjuta_debugger_set_frame_default;
	klass->set_thread = ianjuta_debugger_set_thread_default;
	klass->set_working_directory = ianjuta_debugger_set_working_directory_default;
	klass->start = ianjuta_debugger_start_default;
	klass->step_in = ianjuta_debugger_step_in_default;
	klass->step_out = ianjuta_debugger_step_out_default;
	klass->step_over = ianjuta_debugger_step_over_default;
	klass->unload = ianjuta_debugger_unload_default;
	
	if (!initialized) {

		/**
		* IAnjutaDebugger::debugger_ready:
		* @obj: Self
		* @state: debugger status
		* 
		* This signal is emitted when the debugger is ready to execute
		* a new command.
		*/
		g_signal_new ("debugger-ready",
			IANJUTA_TYPE_DEBUGGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaDebuggerIface, debugger_ready),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__ENUM,
			G_TYPE_NONE,
			1,
			IANJUTA_TYPE_DEBUGGER_STATE);


		/* Signals */
		/**
		* IAnjutaDebugger::debugger_started:
		* @obj: Self
		* 
		* This signal is emitted when the debugger is started.
		*/
		g_signal_new ("debugger-started",
			IANJUTA_TYPE_DEBUGGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaDebuggerIface, debugger_started),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE,
			0,
			NULL);


		/**
		* IAnjutaDebugger::debugger_stopped:
		* @obj: Self
		* @err: Error propagation and reporting.
		* 
		* This signal is emitted when the debugger is stopped. The error
		* parameters allow to check it has run correctly.
		*/
		g_signal_new ("debugger-stopped",
			IANJUTA_TYPE_DEBUGGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaDebuggerIface, debugger_stopped),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__BOXED,
			G_TYPE_NONE,
			1,
			G_TYPE_ERROR);


		/**
		* IAnjutaDebugger::frame_changed:
		* @obj: Self
		* @frame: frame number
		* @thread: thread number
		* 
		* This signal is emitted when the current frame changes.
		*/
		g_signal_new ("frame-changed",
			IANJUTA_TYPE_DEBUGGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaDebuggerIface, frame_changed),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__UINT_INT,
			G_TYPE_NONE,
			2,
			G_TYPE_UINT,
			G_TYPE_INT);


		/**
		* IAnjutaDebugger::program_exited:
		* @obj: Self
		* 
		* This signal is emitted when the program exits.
		*/
		g_signal_new ("program-exited",
			IANJUTA_TYPE_DEBUGGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaDebuggerIface, program_exited),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE,
			0,
			NULL);


		/**
		* IAnjutaDebugger::program_loaded:
		* @obj: Self
		* 
		* This signal is emitted when a program is loaded.
		*/
		g_signal_new ("program-loaded",
			IANJUTA_TYPE_DEBUGGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaDebuggerIface, program_loaded),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE,
			0,
			NULL);


		/**
		* IAnjutaDebugger::program_moved:
		* @obj: Self
		 	* @pid: process id, 0 when unknown
		* @tid: thread id, 0 when unknown
		* @address: program counter address, 0 when unknown
		* @file: source file where is the program counter, NULL when unknown
		* @line: line number if file name above is not NULL
		* 
		* This signal is emitted when the debugger know the current program 
		* location. Most of the time, after the program has stopped but it
		* could happen even if it is still running.
		*/
		g_signal_new ("program-moved",
			IANJUTA_TYPE_DEBUGGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaDebuggerIface, program_moved),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT_INT_ULONG_STRING_UINT,
			G_TYPE_NONE,
			5,
			G_TYPE_INT,
			G_TYPE_INT,
			G_TYPE_ULONG,
			G_TYPE_STRING,
			G_TYPE_UINT);


		/**
		* IAnjutaDebugger::program_running:
		* @obj: Self
		* 
		* This signal is emitted when the program is running.
		*/
		g_signal_new ("program-running",
			IANJUTA_TYPE_DEBUGGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaDebuggerIface, program_running),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE,
			0,
			NULL);


		/**
		* IAnjutaDebugger::program_stopped:
		* @obj: Self
		* 
		* This signal is emitted when the program is interrupted.
		*/
		g_signal_new ("program-stopped",
			IANJUTA_TYPE_DEBUGGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaDebuggerIface, program_stopped),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE,
			0,
			NULL);


		/**
		* IAnjutaDebugger::sharedlib_event:
		* @obj: Self
		* 
		* This signal is emitted when the program load a new shared
		* library.
		*/
		g_signal_new ("sharedlib-event",
			IANJUTA_TYPE_DEBUGGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaDebuggerIface, sharedlib_event),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE,
			0,
			NULL);


		/**
		* IAnjutaDebugger::signal_received:
		* @obj: Self
		* @name: Signal name
		* @description: Signal description
		* 
		* This signal is emitted when the program received a unix signal.
		*/
		g_signal_new ("signal-received",
			IANJUTA_TYPE_DEBUGGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaDebuggerIface, signal_received),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__STRING_STRING,
			G_TYPE_NONE,
			2,
			G_TYPE_STRING,
			G_TYPE_STRING);


		initialized = TRUE;
	}
}

GType
ianjuta_debugger_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaDebuggerIface),
			(GBaseInitFunc) ianjuta_debugger_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaDebugger", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_debugger_data_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_DEBUGGER_INFORMATION, "IANJUTA_DEBUGGER_INFORMATION", "information" }, 
		{ IANJUTA_DEBUGGER_BREAKPOINT, "IANJUTA_DEBUGGER_BREAKPOINT", "breakpoint" }, 
		{ IANJUTA_DEBUGGER_FRAME, "IANJUTA_DEBUGGER_FRAME", "frame" }, 
		{ IANJUTA_DEBUGGER_VARIABLE, "IANJUTA_DEBUGGER_VARIABLE", "variable" }, 
		{ IANJUTA_DEBUGGER_REGISTER, "IANJUTA_DEBUGGER_REGISTER", "register" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaDebuggerData", values);
	}

	return type;
}

GType
ianjuta_debugger_error_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_DEBUGGER_OK, "IANJUTA_DEBUGGER_OK", "ok" }, 
		{ IANJUTA_DEBUGGER_NOT_READY, "IANJUTA_DEBUGGER_NOT_READY", "not-ready" }, 
		{ IANJUTA_DEBUGGER_NOT_RUNNING, "IANJUTA_DEBUGGER_NOT_RUNNING", "not-running" }, 
		{ IANJUTA_DEBUGGER_NOT_STOPPED, "IANJUTA_DEBUGGER_NOT_STOPPED", "not-stopped" }, 
		{ IANJUTA_DEBUGGER_NOT_LOADED, "IANJUTA_DEBUGGER_NOT_LOADED", "not-loaded" }, 
		{ IANJUTA_DEBUGGER_NOT_STARTED, "IANJUTA_DEBUGGER_NOT_STARTED", "not-started" }, 
		{ IANJUTA_DEBUGGER_NOT_CONNECTED, "IANJUTA_DEBUGGER_NOT_CONNECTED", "not-connected" }, 
		{ IANJUTA_DEBUGGER_NOT_IMPLEMENTED, "IANJUTA_DEBUGGER_NOT_IMPLEMENTED", "not-implemented" }, 
		{ IANJUTA_DEBUGGER_CANCEL, "IANJUTA_DEBUGGER_CANCEL", "cancel" }, 
		{ IANJUTA_DEBUGGER_UNABLE_TO_CREATE_VARIABLE, "IANJUTA_DEBUGGER_UNABLE_TO_CREATE_VARIABLE", "unable-to-create-variable" }, 
		{ IANJUTA_DEBUGGER_UNABLE_TO_ACCESS_MEMORY, "IANJUTA_DEBUGGER_UNABLE_TO_ACCESS_MEMORY", "unable-to-access-memory" }, 
		{ IANJUTA_DEBUGGER_UNABLE_TO_OPEN_FILE, "IANJUTA_DEBUGGER_UNABLE_TO_OPEN_FILE", "unable-to-open-file" }, 
		{ IANJUTA_DEBUGGER_UNSUPPORTED_FILE_TYPE, "IANJUTA_DEBUGGER_UNSUPPORTED_FILE_TYPE", "unsupported-file-type" }, 
		{ IANJUTA_DEBUGGER_UNSUPPORTED_VERSION, "IANJUTA_DEBUGGER_UNSUPPORTED_VERSION", "unsupported-version" }, 
		{ IANJUTA_DEBUGGER_UNABLE_TO_FIND_DEBUGGER, "IANJUTA_DEBUGGER_UNABLE_TO_FIND_DEBUGGER", "unable-to-find-debugger" }, 
		{ IANJUTA_DEBUGGER_ALREADY_DONE, "IANJUTA_DEBUGGER_ALREADY_DONE", "already-done" }, 
		{ IANJUTA_DEBUGGER_PROGRAM_NOT_FOUND, "IANJUTA_DEBUGGER_PROGRAM_NOT_FOUND", "program-not-found" }, 
		{ IANJUTA_DEBUGGER_UNABLE_TO_CONNECT, "IANJUTA_DEBUGGER_UNABLE_TO_CONNECT", "unable-to-connect" }, 
		{ IANJUTA_DEBUGGER_UNKNOWN_ERROR, "IANJUTA_DEBUGGER_UNKNOWN_ERROR", "unknown-error" }, 
		{ IANJUTA_DEBUGGER_OTHER_ERROR, "IANJUTA_DEBUGGER_OTHER_ERROR", "other-error" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaDebuggerError", values);
	}

	return type;
}

GType
ianjuta_debugger_output_type_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_DEBUGGER_OUTPUT, "IANJUTA_DEBUGGER_OUTPUT", "output" }, 
		{ IANJUTA_DEBUGGER_WARNING_OUTPUT, "IANJUTA_DEBUGGER_WARNING_OUTPUT", "warning-output" }, 
		{ IANJUTA_DEBUGGER_ERROR_OUTPUT, "IANJUTA_DEBUGGER_ERROR_OUTPUT", "error-output" }, 
		{ IANJUTA_DEBUGGER_INFO_OUTPUT, "IANJUTA_DEBUGGER_INFO_OUTPUT", "info-output" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaDebuggerOutputType", values);
	}

	return type;
}

GType
ianjuta_debugger_state_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_DEBUGGER_BUSY, "IANJUTA_DEBUGGER_BUSY", "busy" }, 
		{ IANJUTA_DEBUGGER_STOPPED, "IANJUTA_DEBUGGER_STOPPED", "stopped" }, 
		{ IANJUTA_DEBUGGER_STARTED, "IANJUTA_DEBUGGER_STARTED", "started" }, 
		{ IANJUTA_DEBUGGER_PROGRAM_LOADED, "IANJUTA_DEBUGGER_PROGRAM_LOADED", "program-loaded" }, 
		{ IANJUTA_DEBUGGER_PROGRAM_STOPPED, "IANJUTA_DEBUGGER_PROGRAM_STOPPED", "program-stopped" }, 
		{ IANJUTA_DEBUGGER_PROGRAM_RUNNING, "IANJUTA_DEBUGGER_PROGRAM_RUNNING", "program-running" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaDebuggerState", values);
	}

	return type;
}
