/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-message-view.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-message-view
 * @title: IAnjutaMessageView
 * @short_description: A view where messages of different kind can be shown
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-message-view.h
 * 
 */

#include "ianjuta-message-view.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_message_view_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-message-view-quark");
	}
	
	return quark;
}

/**
* ianjuta_message_view_append:
* @obj: Self
* @type: type of the message
* @summary: summary of the message
* @details: details of the message
* @err: Error propagation and reporting.
* 
* Append the message with summary displayed and details displayed as tooltip
*/
void
ianjuta_message_view_append (IAnjutaMessageView *obj, IAnjutaMessageViewType type,   const gchar *summary,   const gchar *details, GError **err)
{
	g_return_if_fail (IANJUTA_IS_MESSAGE_VIEW(obj));
	IANJUTA_MESSAGE_VIEW_GET_IFACE (obj)->append (obj, type, summary, details, err);
}

/* Default implementation */
static void
ianjuta_message_view_append_default (IAnjutaMessageView *obj, IAnjutaMessageViewType type,   const gchar *summary,   const gchar *details, GError **err)
{
	g_return_if_reached ();
}

/**
* ianjuta_message_view_buffer_append:
* @obj: Self
* @text: text to show as message
* @err: Error propagation and reporting.
* 
* Appends the text in buffer. Flushes the buffer where a newline is found.
  * by emiiting buffer_flushed signal. The string is expected to be utf8.
  */
void
ianjuta_message_view_buffer_append (IAnjutaMessageView *obj, const gchar *text, GError **err)
{
	g_return_if_fail (IANJUTA_IS_MESSAGE_VIEW(obj));
	IANJUTA_MESSAGE_VIEW_GET_IFACE (obj)->buffer_append (obj, text, err);
}

/* Default implementation */
static void
ianjuta_message_view_buffer_append_default (IAnjutaMessageView *obj, const gchar *text, GError **err)
{
	g_return_if_reached ();
}

/**
* ianjuta_message_view_clear:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Clear all messages in buffer
*/
void
ianjuta_message_view_clear (IAnjutaMessageView *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_MESSAGE_VIEW(obj));
	IANJUTA_MESSAGE_VIEW_GET_IFACE (obj)->clear (obj, err);
}

/* Default implementation */
static void
ianjuta_message_view_clear_default (IAnjutaMessageView *obj, GError **err)
{
	g_return_if_reached ();
}

/**
* ianjuta_message_view_get_all_messages:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Get a list of all messages. The list has to be freed
*/
GList*
ianjuta_message_view_get_all_messages (IAnjutaMessageView *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_MESSAGE_VIEW(obj), 0);
	return IANJUTA_MESSAGE_VIEW_GET_IFACE (obj)->get_all_messages (obj, err);
}

/* Default implementation */
static GList*
ianjuta_message_view_get_all_messages_default (IAnjutaMessageView *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_message_view_get_current_message:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Get the currently selected message
*/
const gchar*
ianjuta_message_view_get_current_message (IAnjutaMessageView *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_MESSAGE_VIEW(obj), NULL);
	return IANJUTA_MESSAGE_VIEW_GET_IFACE (obj)->get_current_message (obj, err);
}

/* Default implementation */
static const gchar*
ianjuta_message_view_get_current_message_default (IAnjutaMessageView *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_message_view_select_next:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Select next message (of type INFO, WARNING or ERROR)
*/
void
ianjuta_message_view_select_next (IAnjutaMessageView *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_MESSAGE_VIEW(obj));
	IANJUTA_MESSAGE_VIEW_GET_IFACE (obj)->select_next (obj, err);
}

/* Default implementation */
static void
ianjuta_message_view_select_next_default (IAnjutaMessageView *obj, GError **err)
{
	g_return_if_reached ();
}

/**
* ianjuta_message_view_select_previous:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Select previous message
*/
void
ianjuta_message_view_select_previous (IAnjutaMessageView *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_MESSAGE_VIEW(obj));
	IANJUTA_MESSAGE_VIEW_GET_IFACE (obj)->select_previous (obj, err);
}

/* Default implementation */
static void
ianjuta_message_view_select_previous_default (IAnjutaMessageView *obj, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_message_view_base_init (IAnjutaMessageViewIface* klass)
{
	static gboolean initialized = FALSE;

	klass->append = ianjuta_message_view_append_default;
	klass->buffer_append = ianjuta_message_view_buffer_append_default;
	klass->clear = ianjuta_message_view_clear_default;
	klass->get_all_messages = ianjuta_message_view_get_all_messages_default;
	klass->get_current_message = ianjuta_message_view_get_current_message_default;
	klass->select_next = ianjuta_message_view_select_next_default;
	klass->select_previous = ianjuta_message_view_select_previous_default;
	
	if (!initialized) {

		/** 
		* IAnjutaMessageView::buffer-flushed:
		* @obj: Self
		* @line: the current line
		* 
		* Emitted when #ianjuta_message_view_buffer_append found a newline
		*/
		g_signal_new ("buffer-flushed",
			IANJUTA_TYPE_MESSAGE_VIEW,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaMessageViewIface, buffer_flushed),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			1,
			G_TYPE_STRING);


		/**
		* IAnjutaMessageView::message-clicked:
		* @obj: Self
		* @message: text of the clicked message
		*
		* Emitted when the user clicks on a message
		*/
		g_signal_new ("message-clicked",
			IANJUTA_TYPE_MESSAGE_VIEW,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaMessageViewIface, message_clicked),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			1,
			G_TYPE_STRING);


		initialized = TRUE;
	}
}

GType
ianjuta_message_view_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaMessageViewIface),
			(GBaseInitFunc) ianjuta_message_view_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaMessageView", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_message_view_type_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_MESSAGE_VIEW_TYPE_NORMAL, "IANJUTA_MESSAGE_VIEW_TYPE_NORMAL", "type-normal" }, 
		{ IANJUTA_MESSAGE_VIEW_TYPE_INFO, "IANJUTA_MESSAGE_VIEW_TYPE_INFO", "type-info" }, 
		{ IANJUTA_MESSAGE_VIEW_TYPE_WARNING, "IANJUTA_MESSAGE_VIEW_TYPE_WARNING", "type-warning" }, 
		{ IANJUTA_MESSAGE_VIEW_TYPE_ERROR, "IANJUTA_MESSAGE_VIEW_TYPE_ERROR", "type-error" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaMessageViewType", values);
	}

	return type;
}
